/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.RenameRefactorAction;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.refactor.designelement.DVTRefactorDesignElementUtils;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.refactoring.RefactoringConnectView;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameDelegate;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameRefactorInfo;

public class VlogRefactorConnectOutputAction
extends RenameRefactorAction {
    private static final String THE_OPERATION_IS_NOT_ALLOWED_ON_THE_CURRENT_SELECTION_PLEASE_SELECT_AN_INSTANCE_MODULE_OR_A_PORT = "The operation is not allowed on the current selection. Please select a module, instance or port.";

    public VlogRefactorConnectOutputAction(ResourceBundle bundle, String prefix, DVTEditor editor) {
        super(bundle, prefix, editor);
    }

    protected String getUnsupportedElementMessage() {
        return "The operation is unavailable on the current selection (the scope could not be determined). Please select another Verilog Language element name or the same element from another location.";
    }

    protected String getPredefinedElementMessage() {
        return "The operation is not allowed on the current selection (the selected element is predefined). Please select another Verilog Language element.";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DVTRenameRefactorInfo getRefactorinfo(ITextEditor textEditor, IDocument document, int offset) {
        try {
            IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
            if (resouce == null) {
                return null;
            }
            IProject project = resouce.getProject();
            if (project == null) {
                return null;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return null;
            }
            RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, textEditor, document, offset);
            if (namedElementAndScope == null) {
                return null;
            }
            IRfNamedElement namedElement = namedElementAndScope.getIRfNamedElement();
            if (namedElement == null) {
                ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(resouce);
                if (parserPath == null) {
                    return null;
                }
                namedElement = RfBatchUtils.getMacro(rfProject, parserPath, document, offset);
            }
            if (namedElement == null) {
                return null;
            }
            namedElementAndScope.setNamedElement(namedElement);
            return new VlogRenameRefactorInfo(project, namedElementAndScope, textEditor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected DVTRenameDelegate getRefactorDelegate(DVTRenameRefactorInfo refactorInfo) {
        return new VlogRenameDelegate(refactorInfo, false);
    }

    public void popNoPortInputOutput() {
        if (TestHelper.isTestMode()) {
            return;
        }
        RfGUIReferencesUtils.popUpUnsupportedOperation((String)"Cannot connect an input port as output.");
    }

    public boolean isValidElementForRefactoringOperation(DVTRenameRefactorInfo refactorInfo) {
        IRfNamedElement instance;
        IRfNamedElement element = refactorInfo.getElement();
        if (element instanceof IRfPortElement && !((IRfPortElement)element).isOutput()) {
            this.popNoPortInputOutput();
            return false;
        }
        if (DVTRefactorDesignElementUtils.shouldNotShowConnectInEditorActions((IRfNamedElement)element, (IProject)refactorInfo.getProject())) {
            this.popNoPortOrSignalElement();
            return false;
        }
        ElementPath pathFor = DesignPathManager.getInstance().getPathFor(this.dvtEditor, this.dvtEditor.getCursor(), refactorInfo.getElement(), refactorInfo.getScope(), false, false);
        if (pathFor == null) {
            this.popUnelaboratedElementAtCursor();
            return false;
        }
        if (element instanceof IRfPortElement && (instance = DVTRefactorDesignElementUtils.getElementFromSegments((String[])pathFor.getSegments(), (IProject)refactorInfo.getProject())) instanceof IRfInstanceElement && DVTRefactorDesignElementUtils.isPortConnected((IRfPortElement)((IRfPortElement)element), (IRfInstanceElement)((IRfInstanceElement)instance))[0].booleanValue()) {
            this.popPortAlreadyConnected();
            return false;
        }
        return true;
    }

    public void popNoPortOrSignalElement() {
        if (TestHelper.isTestMode()) {
            return;
        }
        RfGUIReferencesUtils.popUpUnsupportedOperation((String)THE_OPERATION_IS_NOT_ALLOWED_ON_THE_CURRENT_SELECTION_PLEASE_SELECT_AN_INSTANCE_MODULE_OR_A_PORT);
    }

    protected void openRenameWizard(DVTRenameRefactorInfo refactorInfo) {
        IRfPortElement srcPort;
        RefactoringConnectView view = (RefactoringConnectView)ViewsUtils.getViewById((String)"ro.amiq.dvt.ui.views.RefactoringConnectView", (boolean)true);
        if (view == null) {
            return;
        }
        IEditorPart activeEditor = Utils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return;
        }
        ElementPath pathFor = DesignPathManager.getInstance().getPathFor(this.dvtEditor, this.dvtEditor.getCursor(), refactorInfo.getElement(), refactorInfo.getScope(), false, false);
        if (pathFor == null) {
            return;
        }
        String[] segments = pathFor.getSegments();
        if (segments == null || segments.length == 0) {
            return;
        }
        IRfPortElement iRfPortElement = srcPort = refactorInfo.getElement() instanceof IRfPortElement ? (IRfPortElement)refactorInfo.getElement() : null;
        if (view.setProject(refactorInfo.getProject())) {
            view.setSrcPath(segments, srcPort);
        }
    }
}

