/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.vlogdt.ui.editor.quickassist.VlogQuickAssistExtractMethodProcessor;

public class VlogRefactorExtractToFunctionAction
extends TextEditorAction {
    public static final String EXTRACT_TO_FUNCTION = "Extract to function";
    public static final String EXTRACT_TO_TASK = "Extract to task";
    protected ITextViewer fViewer;

    public VlogRefactorExtractToFunctionAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null || !(textEditor instanceof DVTEditor)) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        this.fViewer = ((DVTEditor)textEditor).getTextViewer();
        if (this.fViewer.getSelectionProvider() == null) {
            return;
        }
        ISelection selection = this.fViewer.getSelectionProvider().getSelection();
        if (!(selection instanceof ITextSelection)) {
            this.popEmptySelection();
            return;
        }
        String selectionText = ((ITextSelection)selection).getText();
        if (selectionText == null || selectionText.isEmpty()) {
            this.popEmptySelection();
            return;
        }
        VlogQuickAssistExtractMethodProcessor extractMethodProcessor = new VlogQuickAssistExtractMethodProcessor(this.fViewer);
        DVTAbstractQuickAssistProposal[] proposals = extractMethodProcessor.getProposals(false);
        if (proposals == null || proposals.length == 0) {
            this.popUnsupportedElement(selectionText);
            return;
        }
        this.applyProposal((ICompletionProposal[])proposals, document);
    }

    protected void applyProposal(ICompletionProposal[] proposals, IDocument document) {
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            if (proposal.getDisplayString().equals(EXTRACT_TO_FUNCTION)) {
                proposal.apply(document);
            }
            ++n2;
        }
    }

    protected void popEmptySelection() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), VlogRefactorExtractToFunctionAction.EXTRACT_TO_FUNCTION, null, "Cannot perform extract to function on empty selection.\nPlease select a valid SystemVerilog block of actions.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    protected void popUnsupportedElement(final String selectionText) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), VlogRefactorExtractToFunctionAction.EXTRACT_TO_FUNCTION, null, "The operation is unavailable on the current selection: '" + selectionText.replaceAll("\\R", " ") + "'\nPlease select a valid SystemVerilog block of actions.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }
}

