/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfGUIReferencesUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameAcrossDesignHierarchyPreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenamePreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameWizard;
import ro.amiq.dvt.ui.refactor.rename.RenameAcrossHierarchyInfo;
import ro.amiq.dvt.ui.search.PortSignalEnum;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.actions.VlogRenameRefactorAction;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameADHRefactorInfo;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameAcrossDesignHierarchyDelegate;

public class VlogRenameAcrossDesignHierarchyRefactorAction
extends VlogRenameRefactorAction {
    public VlogRenameAcrossDesignHierarchyRefactorAction(ResourceBundle bundle, String prefix, DVTEditor editor) {
        super(bundle, prefix, editor);
        this.setText("Rename Port Across the Design Hierarchy");
    }

    @Override
    protected DVTRenameDelegate getRefactorDelegate(DVTRenameRefactorInfo refactorInfo) {
        return new VlogRenameAcrossDesignHierarchyDelegate(refactorInfo);
    }

    @Override
    public DVTRenamePreferencesPage getPage(DVTRenameRefactorInfo refactorInfo) {
        return new DVTRenameAcrossDesignHierarchyPreferencesPage("Rename Refactoring Across Design Hierarchy Preferences Page", refactorInfo);
    }

    public PortSignalEnum getPortSignalEnum(DVTRenameRefactorInfo refactorInfo) {
        return RfSearchUtils.getPortOrSignalEnum((IRfNamedElement)refactorInfo.getElement(), (IProject)refactorInfo.getProject());
    }

    public void popNoPortOrSignalElement() {
        if (TestHelper.isTestMode()) {
            return;
        }
        RfGUIReferencesUtils.popUpUnsupportedOperation((String)"The operation is not allowed on the current selection. Please select a port or a signal.");
    }

    public boolean hasPortConnections(DVTRenameRefactorInfo refactorInfo) {
        return RfSearchUtils.hasPortConnections((IRfNamedElement)refactorInfo.getElement(), (IProject)refactorInfo.getProject());
    }

    public boolean popUnconnectedPortSignalWarning(PortSignalEnum portSignalEnum) {
        if (TestHelper.isTestMode()) {
            return false;
        }
        return RfGUIReferencesUtils.continueRenameAcrossHierarchyOperation((String)"Signal not connected", (String)"The selected {0} is not connected outside this module.\nDo you want to proceed with a local rename?", (String)portSignalEnum.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected DVTRenameRefactorInfo getRefactorinfo(ITextEditor textEditor, IDocument document, int offset) {
        try {
            IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
            if (resouce == null) {
                return null;
            }
            IProject project = resouce.getProject();
            if (project == null) {
                return null;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return null;
            }
            RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, textEditor, document, offset);
            if (namedElementAndScope == null) {
                return null;
            }
            IRfNamedElement namedElement = namedElementAndScope.getIRfNamedElement();
            if (namedElement == null) {
                ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(resouce);
                if (parserPath == null) {
                    return null;
                }
                namedElement = RfBatchUtils.getMacro(rfProject, parserPath, document, offset);
            }
            if (namedElement == null) {
                return null;
            }
            namedElementAndScope.setNamedElement(namedElement);
            return new VlogRenameADHRefactorInfo(project, namedElementAndScope, textEditor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public boolean isValidElementForRefactoringOperation(DVTRenameRefactorInfo refactorInfo) {
        PortSignalEnum portOrSignalEnum = this.getPortSignalEnum(refactorInfo);
        boolean isPortOrSignal = portOrSignalEnum.matches();
        if (!isPortOrSignal) {
            this.popNoPortOrSignalElement();
            return false;
        }
        boolean hasPortConnections = this.hasPortConnections(refactorInfo);
        boolean shouldContinue = true;
        if (!hasPortConnections) {
            shouldContinue = this.popUnconnectedPortSignalWarning(portOrSignalEnum);
        }
        return shouldContinue;
    }

    public void setInfoForRenameOperation(DVTRenameRefactorInfo refactorInfo, DVTEditor dvtEditor) {
        refactorInfo.setRenameADHInfo(new RenameAcrossHierarchyInfo(RfGUIReferencesUtils.getDesignInstances((DVTEditor)dvtEditor, (IRfScopeElement)refactorInfo.getScope(), (IRfNamedElement)refactorInfo.getElement()), refactorInfo.getNewName(), refactorInfo.getElement()));
    }

    public void testSetInfoForRenameOperation(DVTRenameRefactorInfo refactorInfo, DVTEditor dvtEditor) {
        List testGetDesignInstances = RfGUIReferencesUtils.testGetDesignInstances((DVTEditor)dvtEditor, (DVTRenameRefactorInfo)this.getRefactoringInfo());
        if (testGetDesignInstances == null) {
            return;
        }
        refactorInfo.setRenameADHInfo(new RenameAcrossHierarchyInfo(testGetDesignInstances, refactorInfo.getNewName(), refactorInfo.getElement()));
    }

    public boolean alreadyAnExistingRefactoringSessionInProgress(DVTRenameWizard wizard) {
        wizard.setWindowTitle("Rename Port Across the Design Hierarchy");
        return !RfGUIReferencesUtils.checkAndCancelActiveRADHSession();
    }
}

