/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.ui.refactor.renamefile.VlogRenameFileWizard;

public class VlogRenameFileEditorAction
extends TextEditorAction {
    private static final String ACTION_LABEL = "Rename File";
    private static final String UNSUPPORTED_ELEMENT_TITLE = "Limited Operation";
    private static final String UNSUPPORTED_ELEMENT_MESSAGE = "The operation is unavailable on the current selection. ";
    private DVTEditor editor;
    private IDocument document;
    private IProject project;
    private IFile includingFile;
    private int offset;

    public VlogRenameFileEditorAction(ResourceBundle bundle, String prefix, DVTEditor editor) {
        super(bundle, prefix, (ITextEditor)editor);
        this.setText(ACTION_LABEL);
        this.editor = editor;
    }

    public void run() {
        if (!this.acquirePrerequisites()) {
            this.popUnsupportedOperation();
            return;
        }
        IFile file = null;
        String filePath = DVTDocumentUtils.getIncludedFileName((IDocument)this.document, (int)this.offset);
        if (filePath != null) {
            file = DVTFileUtils.getInstance().findFileInProjectOrIncdirs(filePath, this.project);
            if (file == null) {
                this.popUnsupportedOperation();
                return;
            }
        } else {
            file = this.includingFile;
        }
        VlogRenameFileWizard.open(file);
    }

    private boolean acquirePrerequisites() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return false;
        }
        this.includingFile = this.editor.getCurrentFile();
        if (this.includingFile == null) {
            return false;
        }
        this.project = this.includingFile.getProject();
        if (this.project == null) {
            return false;
        }
        IDocumentProvider documentProvider = this.editor.getDocumentProvider();
        if (documentProvider == null) {
            return false;
        }
        this.document = documentProvider.getDocument((Object)this.editor.getEditorInput());
        if (this.document == null) {
            return false;
        }
        this.offset = this.editor.getCursor();
        return this.offset >= 0;
    }

    private void popUnsupportedOperation() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), VlogRenameFileEditorAction.UNSUPPORTED_ELEMENT_TITLE, null, VlogRenameFileEditorAction.UNSUPPORTED_ELEMENT_MESSAGE, 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }
}

