/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.RenameRefactorAction;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameDelegate;
import ro.amiq.dvt.ui.refactor.rename.DVTRenamePreferencesPage;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameProcessor;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactorInfo;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameRefactoring;
import ro.amiq.dvt.ui.refactor.rename.DVTRenameWizard;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameDelegate;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameProcessor;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameWithFileInfo;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameWithFilePreferencesPage;
import ro.amiq.vlogdt.ui.refactor.rename.VlogRenameWizard;

public class VlogRenameRefactorAction
extends RenameRefactorAction {
    public VlogRenameRefactorAction(ResourceBundle bundle, String prefix, DVTEditor editor) {
        super(bundle, prefix, editor);
    }

    protected String getUnsupportedElementMessage() {
        return "The operation is unavailable on the current selection (the scope could not be determined). Please select another Verilog Language element name or the same element from another location.";
    }

    protected String getPredefinedElementMessage() {
        return "The operation is not allowed on the current selection (the selected element is predefined). Please select another Verilog Language element.";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DVTRenameRefactorInfo getRefactorinfo(ITextEditor textEditor, IDocument document, int offset) {
        try {
            IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
            if (resouce == null) {
                return null;
            }
            IProject project = resouce.getProject();
            if (project == null) {
                return null;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return null;
            }
            RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, textEditor, document, offset);
            if (namedElementAndScope == null) {
                return null;
            }
            IRfNamedElement namedElement = namedElementAndScope.getIRfNamedElement();
            if (namedElement == null) {
                ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(resouce);
                if (parserPath == null) {
                    return null;
                }
                namedElement = RfBatchUtils.getMacro(rfProject, parserPath, document, offset);
            }
            if (namedElement instanceof RfField && ((RfField)namedElement).isEnumRangeGeneratedElement()) {
                namedElement = ((RfField)namedElement).getParentDeclarationNamedElement();
            }
            if (namedElement == null) {
                return null;
            }
            namedElementAndScope.setNamedElement(namedElement);
            return VlogRfReferencesUtils.getRefactorInfo(namedElementAndScope, project, textEditor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected DVTRenameDelegate getRefactorDelegate(DVTRenameRefactorInfo refactorInfo) {
        return new VlogRenameDelegate(refactorInfo, false);
    }

    protected DVTRenameProcessor getRefactorProcessor(DVTRenameDelegate delegate) {
        if (delegate.getRefactorInfo() instanceof VlogRenameWithFileInfo) {
            return new VlogRenameProcessor((VlogRenameDelegate)delegate);
        }
        return super.getRefactorProcessor(delegate);
    }

    protected DVTRenameWizard getRefactorWizard(DVTRenameRefactoring refactoring, DVTRenamePreferencesPage preferencesPage) {
        DVTRenameRefactorInfo refactorInfo = preferencesPage.getRefactorInfo();
        if (refactorInfo instanceof VlogRenameWithFileInfo) {
            return new VlogRenameWizard((Refactoring)refactoring, preferencesPage, (VlogRenameWithFileInfo)refactorInfo);
        }
        return super.getRefactorWizard(refactoring, preferencesPage);
    }

    public DVTRenamePreferencesPage getPage(DVTRenameRefactorInfo refactorInfo) {
        if (refactorInfo instanceof VlogRenameWithFileInfo) {
            return new VlogRenameWithFilePreferencesPage("Rename Refactoring Preferences Page", (VlogRenameWithFileInfo)refactorInfo, this.dvtEditor);
        }
        return super.getPage(refactorInfo);
    }
}

