/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.compare;

import java.lang.reflect.Field;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.team.internal.ui.synchronize.SaveablesCompareEditorInput;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.compare.DVTTextMergeViewer;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.PVlogReadOnlyGFileErrorDialog;
import ro.amiq.vlogdt.ui.editor.compare.PVlogCompareScrollInfo;
import ro.amiq.vlogdt.ui.editor.compare.VlogTextMergeViewer;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class PVlogCompareEditorInput
extends SaveablesCompareEditorInput {
    private IFile gFile;
    private String title;
    private PVlogCompareScrollInfo openCompareScrollInfo;

    public PVlogCompareEditorInput(IFile pFile, IFile gFile, PVlogCompareScrollInfo openCompareScrollInfo) {
        super(null, (ITypedElement)new LocalResourceTypedElement((IResource)pFile), (ITypedElement)new LocalResourceTypedElement((IResource)gFile), DVTUiUtils.getActivePage());
        this.title = this.initTitle(pFile, gFile);
        this.gFile = gFile;
        this.openCompareScrollInfo = openCompareScrollInfo;
    }

    private String initTitle(IFile pFile, IFile gFile) {
        String gFileName;
        String pFileName = pFile.getName();
        if (pFileName.equals(gFileName = gFile.getName())) {
            pFileName = pFile.getFullPath().makeRelative().toOSString();
            gFileName = gFile.getFullPath().makeRelative().toOSString();
        }
        return NLS.bind((String)"Compare (''{0}'' - ''{1}'')", (Object)pFileName, (Object)gFileName);
    }

    public String getTitle() {
        return this.title;
    }

    public Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        Display.getDefault().asyncExec(() -> this.attachReadOnlyGFileVerifyListeners());
        this.scrollToPosition();
        return control;
    }

    private void scrollToPosition() {
        try {
            if (this.openCompareScrollInfo == null) {
                return;
            }
            VlogTextMergeViewer vlogTextMergeViewer = this.findTextMergeViewer();
            if (vlogTextMergeViewer == null) {
                return;
            }
            boolean shouldScrollRightSide = this.shouldScrollRightSide();
            int scrollVirtualLine = vlogTextMergeViewer.realToVirtualPosition(shouldScrollRightSide ? (char)'R' : 'L', this.openCompareScrollInfo.getScrollLine());
            Field field = TextMergeViewer.class.getDeclaredField("fSynchronizedScrolling");
            field.setAccessible(true);
            boolean isSynchronizedScrolling = field.getBoolean((Object)vlogTextMergeViewer);
            if (isSynchronizedScrolling) {
                vlogTextMergeViewer.synchronizedScrollVertical(scrollVirtualLine, scrollVirtualLine);
                return;
            }
            if (shouldScrollRightSide) {
                vlogTextMergeViewer.synchronizedScrollVertical(0, scrollVirtualLine);
            } else {
                vlogTextMergeViewer.synchronizedScrollVertical(scrollVirtualLine, 0);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean shouldScrollRightSide() {
        return this.openCompareScrollInfo.isGFileActive() ^ this.getCompareConfiguration().isMirrored();
    }

    private void attachReadOnlyGFileVerifyListeners() {
        VlogTextMergeViewer vlogTextMergeViewer = this.findTextMergeViewer();
        if (vlogTextMergeViewer == null) {
            return;
        }
        this.attachReadOnlyGFileVerifyListener(vlogTextMergeViewer, true);
        this.attachReadOnlyGFileVerifyListener(vlogTextMergeViewer, false);
    }

    private void attachReadOnlyGFileVerifyListener(VlogTextMergeViewer vlogTextMergeViewer, boolean isRight) {
        SourceViewer sourceViewer = isRight ? vlogTextMergeViewer.getRightSourceViewer() : vlogTextMergeViewer.getLeftSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        StyledText textWidget = sourceViewer.getTextWidget();
        if (textWidget == null) {
            return;
        }
        ReadOnlyGFileVerifyListener verifyListener = new ReadOnlyGFileVerifyListener(isRight);
        textWidget.addVerifyListener((VerifyListener)verifyListener);
        textWidget.addDisposeListener(e -> textWidget.removeVerifyListener(verifyListener));
    }

    private VlogTextMergeViewer findTextMergeViewer() {
        DVTTextMergeViewer dvtTextMergeViewer = DVTTextMergeViewer.get((CompareConfiguration)this.getCompareConfiguration());
        if (!(dvtTextMergeViewer instanceof VlogTextMergeViewer)) {
            return null;
        }
        return (VlogTextMergeViewer)dvtTextMergeViewer;
    }

    private class ReadOnlyGFileVerifyListener
    implements VerifyListener {
        private boolean isRight;

        private ReadOnlyGFileVerifyListener(boolean isRight) {
            this.isRight = isRight;
        }

        public void verifyText(VerifyEvent e) {
            if (!this.validateChange()) {
                e.doit = false;
            }
        }

        private boolean validateChange() {
            boolean isMirrored = PVlogCompareEditorInput.this.getCompareConfiguration().isMirrored();
            if (isMirrored && this.isRight) {
                return true;
            }
            if (!isMirrored && !this.isRight) {
                return true;
            }
            if (PVlogCompareEditorInput.this.gFile.isReadOnly()) {
                return false;
            }
            if (!PrefConst.isPVlogReadOnlyGEditorEnabled()) {
                return true;
            }
            if (!PrefConst.isPVlogCompareErrWhenEditGFileEnabled()) {
                return false;
            }
            boolean[] ok = new boolean[1];
            Display display = PlatformUI.getWorkbench().getDisplay();
            display.syncExec(() -> {
                boolean bl = PVlogReadOnlyGFileErrorDialog.show(PVlogCompareEditorInput.this.gFile, true);
            });
            if (ok[0]) {
                VlogPlugin.getDefault().getPreferenceStore().setValue("editor.treat_g_editor_as_readonly", false);
                return true;
            }
            return false;
        }
    }
}

