/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.compare;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.compare.DVTTextMergeViewer;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.editor.VlogAmsEditor;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.VlogPartitionScanner;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.utils.Utils;

public class VlogTextMergeViewer
extends DVTTextMergeViewer {
    public VlogTextMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
    }

    protected DVTSourceViewerConfiguration createSourceViewerConfiguration() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IEditorPart editor = workbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return new VlogSourceViewerConfiguration(editor instanceof VlogEditor ? (VlogEditor)editor : null, editor instanceof VlogAmsEditor, false);
    }

    protected boolean hasInactiveCodeHighlight() {
        return true;
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new VlogPartitionScanner(), new String[]{"__vlog_sl_comment", "__vlog_ml_comment", "__vlog_escaped_id", "__vlog_literal", "__dftl_partition_content_type"});
        return partitioner;
    }

    protected String getDocumentPartitioning() {
        return "__vlog_partitioning";
    }

    protected int getCompareViewerMaxLines() {
        return PrefConst.getCompareViewerMaxLines();
    }

    public void synchronizedScrollVertical(int lvpos, int rvpos) {
        try {
            Method method = TextMergeViewer.class.getDeclaredMethod("scrollVertical", Integer.TYPE, Integer.TYPE, Integer.TYPE, MergeSourceViewer.class);
            method.setAccessible(true);
            method.invoke((Object)this, 0, lvpos, rvpos, null);
            Field field = TextMergeViewer.class.getDeclaredField("fVScrollBar");
            field.setAccessible(true);
            ScrollBar.class.getMethod("setSelection", Integer.TYPE).invoke(field.get((Object)this), rvpos);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public int getScrollBarPosition() {
        try {
            Field field = TextMergeViewer.class.getDeclaredField("fVScrollBar");
            field.setAccessible(true);
            return (Integer)ScrollBar.class.getMethod("getSelection", new Class[0]).invoke(field.get((Object)this), new Object[0]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public int realToVirtualPosition(char contributor, int vpos) {
        try {
            Method method = TextMergeViewer.class.getDeclaredMethod("realToVirtualPosition", Character.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)this, Character.valueOf(contributor), vpos);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public int virtualToRealPosition(char contributor, int vpos) {
        try {
            Method method = TextMergeViewer.class.getDeclaredMethod("virtualToRealPosition", Character.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return (Integer)method.invoke((Object)this, Character.valueOf(contributor), vpos);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public int getLeftTopIndex() {
        SourceViewer leftSourceViewer = this.getLeftSourceViewer();
        if (leftSourceViewer == null) {
            return -1;
        }
        return leftSourceViewer.getTopIndex();
    }

    public SourceViewer getLeftSourceViewer() {
        try {
            Field field = TextMergeViewer.class.getDeclaredField("fLeft");
            field.setAccessible(true);
            return ((MergeSourceViewer)field.get((Object)this)).getSourceViewer();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public int getRightTopIndex() {
        SourceViewer rightSourceViewer = this.getRightSourceViewer();
        if (rightSourceViewer == null) {
            return -1;
        }
        return rightSourceViewer.getTopIndex();
    }

    public SourceViewer getRightSourceViewer() {
        try {
            Field field = TextMergeViewer.class.getDeclaredField("fRight");
            field.setAccessible(true);
            return ((MergeSourceViewer)field.get((Object)this)).getSourceViewer();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected void handlePropertyChangeEvent(PropertyChangeEvent event) {
        super.handlePropertyChangeEvent(event);
        if ("org.eclipse.compare.SynchronizeScrolling".equals(event.getProperty()) && ((Boolean)event.getNewValue()).booleanValue()) {
            this.refresh();
        }
    }

    protected void addInactiveCodePositions(IRfSingleLangProject rfProject, IDocument document, IResource resource) {
        if (!(rfProject instanceof RfProject)) {
            return;
        }
        RfFileDef fileDef = ((RfProject)rfProject).getFileDefUsingParserPath(DVTFileUtils.getInstance().resource2parser(resource));
        Utils.getInstance().addInactiveCodePositions(document, fileDef);
    }

    protected IPreferenceStore getPreferenceStore() {
        return VlogPlugin.getDefault().getPreferenceStore();
    }
}

