/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.ui.editor.contentassist.ContentAssistAccuracyBenchmark;
import ro.amiq.vlogdt.ui.editor.contentassist.ModuleAccuracyBenchmark;

@ForTestingOrDebuggingOnly
public class AlwaysBlocksInModuleAccuracyBenchmark
extends ModuleAccuracyBenchmark {
    @Override
    public StringBuilder getLog(RfModule module, IProgressMonitor monitor, boolean fullLog, boolean closeEditor) {
        StringBuilder result = new StringBuilder();
        ParserPath moduleParserPath = module.getFile().getParserPath();
        DVTEditor currentDVTEditor = AlwaysBlocksInModuleAccuracyBenchmark.openEditor(moduleParserPath, module.getRfProject().getProject());
        if (currentDVTEditor == null) {
            return result;
        }
        TestHelper.delay((long)2000L);
        List<RfActionBlock> actionBlocks = module.getLocalMembers(RfActionBlock.class);
        if (actionBlocks == null) {
            return result;
        }
        List alwaysBlocks = actionBlocks.stream().filter(RfActionBlock::isAlways).collect(Collectors.toList());
        for (RfActionBlock alwaysBlock : alwaysBlocks) {
            ParserPath fileParserPath;
            AlwaysBlocksInModuleAccuracyBenchmark.checkAndFlush(monitor);
            RfFileDef fileDef = alwaysBlock.getFile();
            if (fileDef == null || (fileParserPath = fileDef.getParserPath()) == null || !fileParserPath.equals((Object)moduleParserPath)) continue;
            ContentAssistAccuracyBenchmark.LogContentAssistHidVisitor visitor = new ContentAssistAccuracyBenchmark.LogContentAssistHidVisitor(currentDVTEditor, moduleParserPath, result, fullLog, this.statistic);
            this.recursivelyVisitBlock(alwaysBlock, visitor);
        }
        if (closeEditor) {
            TestHelper.closeEditorPart((IEditorPart)currentDVTEditor);
        }
        return result;
    }

    public void recursivelyVisitBlock(RfNamedElement namedElement, RfHidVisitor visitor) {
        if (namedElement == null || visitor == null) {
            return;
        }
        RfDefElement declaration = namedElement.getDeclaration();
        if (declaration == null) {
            return;
        }
        RfHidHolder hidHolder = namedElement.getHidHolder();
        if (hidHolder == null) {
            return;
        }
        hidHolder.visitHidObject(namedElement.getRfProject(), visitor);
        Collection<RfDefElement> children = declaration.getChildren();
        if (children == null) {
            return;
        }
        for (RfDefElement child : children) {
            RfNamedElement childNamedElement = child.getNamedElement();
            this.recursivelyVisitBlock(childNamedElement, visitor);
        }
    }
}

