/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.DVTMessageDialogWithCopy;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;
import ro.amiq.vlogdt.test.TestHelper;

@ForTestingOrDebuggingOnly
public abstract class ContentAssistAccuracyBenchmark<T extends IRfNamedElement>
extends AbstractHandler {
    private static final String CSV_SEPARATOR = ",";
    private static final int CONTENT_ASSIST_TRIES = 4;
    protected CABenchmarkStatistic statistic = new CABenchmarkStatistic();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(Display.getDefault().getActiveShell()){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText("DVT Content Assist Accuracy Benchmark");
            }
        };
        try {
            pmd.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    String filename = "/tmp/dvt_content_accuracy_benchmark_" + System.currentTimeMillis() + ".csv";
                    Object enclosingScope = ContentAssistAccuracyBenchmark.this.getCursorEnclosure();
                    if (enclosingScope == null) {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"DVT Content Assist Accuracy Benchmark", (String)ContentAssistAccuracyBenchmark.this.getErrorMessage());
                        return;
                    }
                    try {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (BufferedWriter bw = new BufferedWriter(new FileWriter(new File(filename)));){
                            bw.write(ContentAssistAccuracyBenchmark.getLogCSVHeader());
                            bw.write(ContentAssistAccuracyBenchmark.this.getLog(enclosingScope, monitor, true, false).toString());
                            bw.write(ContentAssistAccuracyBenchmark.this.statistic.getLog().toString());
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    DVTLogger.INSTANCE.logInfo("DVT log file is: " + filename);
                    DVTMessageDialogWithCopy.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Info", (String)("DVT log file is: " + filename));
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new ExecutionException("DVT Content Assist Accuracy Benchmark could not be completed", (Throwable)e);
        }
        return null;
    }

    protected abstract String getErrorMessage();

    public abstract T getCursorEnclosure();

    public abstract StringBuilder getLog(T var1, IProgressMonitor var2, boolean var3, boolean var4);

    protected static void checkAndFlush(IProgressMonitor monitor) {
        if (!TestHelper.isTestMode() && monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            boolean hasMoreToDispatch = false;
            while ((hasMoreToDispatch = Display.getDefault().readAndDispatch()) && !monitor.isCanceled()) {
            }
        }
    }

    protected static DVTEditor openEditor(ParserPath classParserPath, IProject project) {
        IEditorPart editor = null;
        try {
            File classFile = new File(classParserPath.toString());
            URI relativeURI = project.getLocationURI().relativize(classFile.toURI());
            editor = TestHelper.openEclipseFile((IFile)project.getFile(relativeURI.getPath()), (Objection[])new Objection[0]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return editor instanceof DVTEditor ? (DVTEditor)editor : null;
    }

    public static String getLogCSVHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append("Identifier").append(CSV_SEPARATOR).append("Line").append(CSV_SEPARATOR).append("Column").append(CSV_SEPARATOR).append("Distance").append(CSV_SEPARATOR).append("Index").append(CSV_SEPARATOR).append("Class").append(CSV_SEPARATOR).append("Data Type").append(CSV_SEPARATOR).append("Path").append("\n");
        return sb.toString();
    }

    public StringBuilder getStatisticLog() {
        return this.statistic.getLog();
    }

    protected static class CABenchmarkStatistic {
        private Map<String, ClassStatistic> classStatistics = new HashMap<String, ClassStatistic>();
        private int total;
        private int notFound;
        private int found;
        private int score;

        protected CABenchmarkStatistic() {
        }

        public void addEntry(String classType, String dataType, int score, int offset) {
            if (score == -1) {
                this.addNotFound(classType, dataType);
            } else if (score == 0) {
                this.addFoundFirst(classType, dataType, offset);
            } else {
                this.addFoundWithScore(classType, dataType, score);
            }
        }

        private void addNotFound(String classType, String dataType) {
            this.getClassStatistic(classType).addNotFound(dataType);
            ++this.notFound;
            ++this.total;
        }

        private void addFoundFirst(String classType, String dataType, int offset) {
            int count = 4 - offset;
            this.getClassStatistic(classType).addFoundFirst(dataType, count);
            this.found += count;
            this.total += count;
        }

        private void addFoundWithScore(String classType, String dataType, int score) {
            this.getClassStatistic(classType).addFoundWithScore(dataType, score);
            this.score += score;
            ++this.found;
            ++this.total;
        }

        private ClassStatistic getClassStatistic(String classType) {
            ClassStatistic statistic = this.classStatistics.get(classType);
            if (statistic == null) {
                statistic = new ClassStatistic(classType);
                this.classStatistics.put(classType, statistic);
            }
            return statistic;
        }

        private float getAverage() {
            return this.found == 0 ? -1.0f : (float)this.score / (float)this.found;
        }

        public StringBuilder getLog() {
            StringBuilder sb = new StringBuilder();
            float average = this.getAverage();
            sb.append("\n").append("Class Type").append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append("Data Type").append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append("Total").append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append("Not found").append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append("Found").append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append("Score").append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append("Average").append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append("Use %\n").append("Everything").append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.total).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.notFound).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.found).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.score).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(average == -1.0f ? "None found" : Float.valueOf(average)).append("\n");
            this.classStatistics.values().stream().sorted(Comparator.comparing(ClassStatistic::getTotal).reversed()).forEachOrdered(e -> {
                StringBuilder stringBuilder2 = sb.append((CharSequence)e.getLog(this.total));
            });
            return sb;
        }

        private static class ClassStatistic {
            private final String classType;
            private Map<String, DataTypeStatistic> dataTypeStatistics = new HashMap<String, DataTypeStatistic>();
            private int total;
            private int notFound;
            private int found;
            private int score;

            public ClassStatistic(String classType) {
                this.classType = classType;
            }

            private DataTypeStatistic getDataTypeStatistic(String dataType) {
                DataTypeStatistic statistic = this.dataTypeStatistics.get(dataType);
                if (statistic == null) {
                    statistic = new DataTypeStatistic(dataType);
                    this.dataTypeStatistics.put(dataType, statistic);
                }
                return statistic;
            }

            public void addNotFound(String dataType) {
                this.getDataTypeStatistic(dataType).addNotFound();
                ++this.notFound;
                ++this.total;
            }

            public void addFoundFirst(String dataType, int count) {
                this.getDataTypeStatistic(dataType).addFoundFirst(count);
                this.found += count;
                this.total += count;
            }

            public void addFoundWithScore(String dataType, int score) {
                this.getDataTypeStatistic(dataType).addFoundWithScore(score);
                this.score += score;
                ++this.found;
                ++this.total;
            }

            public int getTotal() {
                return this.total;
            }

            public int getNotFound() {
                return this.notFound;
            }

            public int getFound() {
                return this.found;
            }

            public int getScore() {
                return this.score;
            }

            public float getAverage() {
                return this.found == 0 ? -1.0f : (float)this.score / (float)this.found;
            }

            public StringBuilder getLog(int bigTotal) {
                StringBuilder sb = new StringBuilder();
                float average = this.getAverage();
                float usePercentage = (float)this.total * 100.0f / (float)bigTotal;
                sb.append(this.classType).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.total).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.notFound).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.found).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.score).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(average == -1.0f ? "None found" : Float.valueOf(average)).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(usePercentage).append("\n");
                this.dataTypeStatistics.values().stream().sorted(Comparator.comparing(DataTypeStatistic::getTotal).reversed()).forEachOrdered(e -> {
                    StringBuilder stringBuilder2 = sb.append((CharSequence)e.getLog());
                });
                return sb;
            }

            private static class DataTypeStatistic {
                private final String dataType;
                private int total;
                private int notFound;
                private int found;
                private int score;

                public DataTypeStatistic(String dataType) {
                    this.dataType = dataType;
                }

                public void addNotFound() {
                    ++this.notFound;
                    ++this.total;
                }

                public void addFoundFirst(int count) {
                    this.found += count;
                    this.total += count;
                }

                public void addFoundWithScore(int score) {
                    this.score += score;
                    ++this.found;
                    ++this.total;
                }

                public int getTotal() {
                    return this.total;
                }

                public int getNotFound() {
                    return this.notFound;
                }

                public int getFound() {
                    return this.found;
                }

                public int getScore() {
                    return this.score;
                }

                public float getAverage() {
                    return this.found == 0 ? -1.0f : (float)this.score / (float)this.found;
                }

                public StringBuilder getLog() {
                    StringBuilder sb = new StringBuilder();
                    float average = this.getAverage();
                    sb.append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.dataType).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.total).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.notFound).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.found).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.score).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(average == -1.0f ? "None found" : Float.valueOf(average)).append("\n");
                    return sb;
                }
            }
        }
    }

    protected static class LogContentAssistHidVisitor
    extends RfHidVisitor {
        private StyledText styledText;
        private ParserPath classParserPath;
        private StringBuilder sb;
        private boolean fullLog;
        private Set<IRfNamedElement> loggedElements;
        private CABenchmarkStatistic statistic;

        public LogContentAssistHidVisitor(DVTEditor editor, ParserPath parserPath, StringBuilder sb, boolean fullLog, CABenchmarkStatistic statistic) {
            this.styledText = editor.getStyledText();
            this.classParserPath = parserPath;
            this.sb = sb;
            this.fullLog = fullLog;
            this.loggedElements = new HashSet<IRfNamedElement>();
            this.statistic = statistic;
        }

        public boolean visit(RfHid hidObject) {
            HidOccurrence occurrence = hidObject.getOccurrence();
            IRfNamedElement namedElement = hidObject.getElement();
            if (!this.fullLog && this.loggedElements.contains(namedElement)) {
                return true;
            }
            if (!this.fullLog) {
                this.loggedElements.add(namedElement);
            }
            if (occurrence.getVirtualOffset() != -1) {
                return true;
            }
            try {
                DataType dataType;
                int offset = occurrence.getOffset();
                int line = this.styledText.getLineAtOffset(offset);
                int offsetAtLine = this.styledText.getOffsetAtLine(line);
                int column = offset - offsetAtLine;
                String className = namedElement.getClass().getSimpleName();
                String dataTypeName = null;
                if (namedElement instanceof RfAssociatedType && (dataType = ((RfAssociatedType)namedElement).getDataType()) != null) {
                    String rawTypeName = dataType.getType();
                    dataTypeName = rawTypeName == null || rawTypeName.isEmpty() ? "logic" : rawTypeName;
                }
                if (dataTypeName == null) {
                    dataTypeName = "";
                }
                if (dataTypeName.startsWith("enum//")) {
                    dataTypeName = "enum";
                }
                int i = 0;
                while (i < 4) {
                    int score = this.logContentAssistOrder(hidObject.getName(), className, dataTypeName, line, column, i, offset, this.sb);
                    if (score != 0) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {}
            return true;
        }

        private int logContentAssistOrder(String hidName, String classType, String dataType, int line, int column, int distanceFromOffset, int offset, StringBuilder sb) {
            if (hidName.length() < distanceFromOffset) {
                return -1;
            }
            int score = this.getProposalIndex(offset + distanceFromOffset, hidName);
            this.statistic.addEntry(classType, dataType, score, distanceFromOffset);
            sb.append(hidName).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(line + 1).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(column + 1).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(distanceFromOffset).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(score).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(classType).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(dataType).append(ContentAssistAccuracyBenchmark.CSV_SEPARATOR).append(this.classParserPath.toString()).append("\n");
            return score;
        }

        private int getProposalIndex(int offset, String expectedProposal) {
            ICompletionProposal[] proposals = TestHelper.getProposals((int)offset);
            int i = 0;
            while (i < proposals.length) {
                String displayString = proposals[i].getDisplayString();
                if (displayString.startsWith(expectedProposal) && (displayString.length() == expectedProposal.length() || !Character.isJavaIdentifierPart(displayString.charAt(expectedProposal.length())))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

