/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;

public class CustomTemplateProposal
extends TemplateProposal
implements ICompletionProposalExtension4,
ICompletionProposalExtension6 {
    public CustomTemplateProposal(Template template, TemplateContext context, IRegion region, Image image, int relevance) {
        super(template, context, region, image, relevance);
    }

    public CustomTemplateProposal(Template template, TemplateContext context, IRegion region, Image image) {
        super(template, context, region, image);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            if (!(viewer instanceof DVTProjectionViewer)) {
                return;
            }
            DVTFileModificationValidator.validateEdit((ITextViewer)viewer);
            String formattedPattern = TemplatesViewUtils.formatReplacementString(() -> new VlogSourceViewerConfiguration(null, false), (Template)this.getTemplate(), (DVTEditor)((DVTProjectionViewer)viewer).getEditor(), (int)offset);
            this.getTemplate().setPattern(formattedPattern);
            super.apply(viewer, trigger, stateMask, offset);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public StyledString getStyledDisplayString() {
        StyledString displayString = new StyledString(this.getTemplateName());
        String description = this.getTemplate().getDescription();
        if (description != null && !description.isEmpty()) {
            displayString.append(new StyledString(" - " + description, StyledString.QUALIFIER_STYLER));
        }
        return displayString;
    }

    public String getTemplateName() {
        return super.getTemplate().getName();
    }

    public boolean isAutoInsertable() {
        return this.getTemplate().isAutoInsertable();
    }

    public String getAdditionalProposalInfo() {
        String additionalProposalInfo = super.getAdditionalProposalInfo();
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            return additionalProposalInfo.replace("\n", this.getNewLineReplacement());
        }
        if (additionalProposalInfo.trim().isEmpty()) {
            return "";
        }
        return this.getConvertedAdditionalInfo(additionalProposalInfo.replace("<", "&lt;").replace(">", "&gt;"));
    }

    private String getConvertedAdditionalInfo(String additionalProposalInfo) {
        return "<pre class=\"template\">" + additionalProposalInfo + "</pre>";
    }

    private String getNewLineReplacement() {
        return "<br>";
    }
}

