/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.contentassist.DVTTemplateTranslator;

public class DVTDocumentTemplateContext
extends DocumentTemplateContext {
    private boolean disableFormatting;

    public DVTDocumentTemplateContext(TemplateContextType type, IDocument document, int offset, int length) {
        super(type, document, offset, length);
    }

    public DVTDocumentTemplateContext(TemplateContextType type, IDocument document, int offset, int length, boolean disableFormatting) {
        super(type, document, offset, length);
        this.disableFormatting = disableFormatting;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        DVTTemplateTranslator translator = new DVTTemplateTranslator();
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        String bufferString = this.internalComputeProposal(buffer.getString(), buffer.getVariables());
        if (bufferString == null) {
            bufferString = buffer.getString();
        }
        buffer.setContent(bufferString, buffer.getVariables());
        return buffer;
    }

    private String internalComputeProposal(String replacementString, TemplateVariable[] variables) {
        IPreferenceStore store = VlogPlugin.getDefault().getPreferenceStore();
        boolean prevPreserveSLCommentColumnZero = store.getBoolean("format.indent.preserve_sl_comment_column_zero");
        boolean prevVerticalAlignment = store.getBoolean("format.vertical_align");
        String prevVerticalAlignTokens = store.getString("format.vertical_align.tokens");
        boolean prevTrimEmptyLine = store.getBoolean("format.whitespace.trim_whitespace_line");
        store.setValue("format.indent.preserve_sl_comment_column_zero", false);
        store.setValue("format.vertical_align", !this.disableFormatting);
        store.setValue("format.vertical_align.tokens", "(");
        if (this.disableFormatting) {
            store.setValue("format.whitespace.trim_whitespace_line", false);
        }
        String result = this.formatReplacementString(replacementString, variables);
        store.setValue("format.indent.preserve_sl_comment_column_zero", prevPreserveSLCommentColumnZero);
        store.setValue("format.vertical_align", prevVerticalAlignment);
        store.setValue("format.vertical_align.tokens", prevVerticalAlignTokens);
        store.setValue("format.whitespace.trim_whitespace_line", prevTrimEmptyLine);
        return result;
    }

    private String formatReplacementString(String replacementString, TemplateVariable[] variables) {
        try {
            IDocument doc = this.getDocument();
            int offset = this.getCompletionOffset();
            int line = doc.getLineOfOffset(offset);
            String indent = DVTDocumentCommon.getIndentOfLine((IDocument)doc, (int)line, (int)offset);
            if (indent == null) {
                indent = "";
            }
            String trimmedString = this.disableFormatting ? replacementString : replacementString.trim();
            String string = replacementString = this.disableFormatting ? trimmedString : Utils.formatString(() -> {
                VlogSourceViewerConfiguration svc = new VlogSourceViewerConfiguration(null, false);
                svc.setApplyActionListener((offset1, delta) -> {
                    TemplateVariable[] templateVariableArray2 = variables;
                    int n = variables.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TemplateVariable variable = templateVariableArray2[n2];
                        int[] offsets = variable.getOffsets();
                        int i = 0;
                        while (i < offsets.length) {
                            if (offsets[i] >= offset1) {
                                int n3 = i;
                                offsets[n3] = offsets[n3] + delta;
                            }
                            ++i;
                        }
                        ++n2;
                    }
                });
                return svc;
            }, (String)trimmedString, (IDocument)doc, (String)indent, (boolean)false);
            if (this.disableFormatting) {
                return replacementString;
            }
            int trimIndex = this.lTrimIndex(replacementString);
            if (replacementString != null && trimIndex > 0) {
                boolean shouldTrim = true;
                TemplateVariable[] templateVariableArray = variables;
                int n = variables.length;
                int n2 = 0;
                while (n2 < n) {
                    TemplateVariable variable = templateVariableArray[n2];
                    if (!shouldTrim) break;
                    int[] offsets = variable.getOffsets();
                    int i = 0;
                    while (i < offsets.length) {
                        if (offsets[i] - trimIndex < 0) {
                            shouldTrim = false;
                            break;
                        }
                        int n3 = i++;
                        offsets[n3] = offsets[n3] - trimIndex;
                    }
                    ++n2;
                }
                if (shouldTrim) {
                    replacementString = replacementString.substring(trimIndex);
                }
            }
            return replacementString;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private int lTrimIndex(String text) {
        if (text == null) {
            return -1;
        }
        int st = 0;
        while (st < text.length() && text.charAt(st) <= ' ') {
            ++st;
        }
        return st > 0 ? st : 0;
    }
}

