/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableType;

public class DVTTemplateTranslator
extends TemplateTranslator {
    private static final String DVT_FUNCTION_CALL_ARG = "dvt_function_call_arg";
    private static final String IDENTIFIER = "\\$\\$|\\$\\{(.*?)\\}";
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("\\$\\$|\\$\\{(.*?)\\}");

    public String getErrorMessage() {
        return null;
    }

    public TemplateBuffer translate(Template template) throws TemplateException {
        return this.parse(template.getPattern());
    }

    public TemplateBuffer translate(String string) throws TemplateException {
        return this.parse(string);
    }

    private TemplateBuffer parse(String string) throws TemplateException {
        StringBuilder buffer = new StringBuilder(string.length());
        Matcher matcher = ESCAPE_PATTERN.matcher(string);
        ArrayList<VariableDescription> variables = new ArrayList<VariableDescription>();
        int complete = 0;
        while (matcher.find()) {
            buffer.append(string.substring(complete, matcher.start()));
            if ("$$".equals(matcher.group())) {
                buffer.append('$');
            } else {
                String name = matcher.group(1);
                this.updateOrCreateVariable(variables, name, null, buffer.length());
                buffer.append(name.startsWith(DVT_FUNCTION_CALL_ARG) ? name.substring(DVT_FUNCTION_CALL_ARG.length() + 1) : name);
            }
            complete = matcher.end();
        }
        buffer.append(string.substring(complete));
        TemplateVariable[] vars = this.createVariables(variables);
        return new TemplateBuffer(buffer.toString(), vars);
    }

    private void updateOrCreateVariable(List<VariableDescription> variables, String name, TemplateVariableType type, int offset) throws TemplateException {
        VariableDescription varDesc = null;
        if (name.startsWith(DVT_FUNCTION_CALL_ARG)) {
            varDesc = new VariableDescription(name, type);
            variables.add(varDesc);
        } else {
            for (VariableDescription variable : variables) {
                if (!variable.fName.equals(name)) continue;
                variable.fOffsets.add(offset);
                return;
            }
            varDesc = new VariableDescription(name, type);
            variables.add(varDesc);
        }
        varDesc.fOffsets.add(offset);
    }

    private TemplateVariable[] createVariables(List<VariableDescription> variables) {
        TemplateVariable[] result = new TemplateVariable[variables.size()];
        int idx = 0;
        for (VariableDescription desc : variables) {
            TemplateVariable variable;
            int[] offsets = new int[desc.fOffsets.size()];
            int i = 0;
            for (Integer offset : desc.fOffsets) {
                offsets[i] = offset;
                ++i;
            }
            result[idx] = variable = this.createVariable(desc.fName, offsets);
            ++idx;
        }
        return result;
    }

    protected TemplateVariable createVariable(String name, int[] offsets) {
        String type = "";
        String defaultValue = name;
        if (name.startsWith(DVT_FUNCTION_CALL_ARG)) {
            type = DVT_FUNCTION_CALL_ARG;
            defaultValue = name.substring(DVT_FUNCTION_CALL_ARG.length() + 1);
        }
        return new TemplateVariable(type, name, defaultValue, offsets);
    }

    private static final class VariableDescription {
        final List<Integer> fOffsets = new ArrayList<Integer>(5);
        final String fName;

        VariableDescription(String name, TemplateVariableType type) {
            this.fName = name;
        }
    }
}

