/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.ui.editor.contentassist.ClassAccuracyBenchmark;
import ro.amiq.vlogdt.ui.editor.contentassist.ContentAssistAccuracyBenchmark;

@ForTestingOrDebuggingOnly
public class FunctionsInClassAccuracyBenchmark
extends ClassAccuracyBenchmark {
    @Override
    public StringBuilder getLog(RfClass clazz, IProgressMonitor monitor, boolean fullLog, boolean closeEditor) {
        return FunctionsInClassAccuracyBenchmark.logClass(clazz, monitor, fullLog, closeEditor, this.statistic);
    }

    public static StringBuilder logClass(RfClass clazz, IProgressMonitor monitor, boolean fullLog, boolean closeEditor, ContentAssistAccuracyBenchmark.CABenchmarkStatistic statistic) {
        StringBuilder result = new StringBuilder();
        if (clazz.isPredefined()) {
            return result;
        }
        ParserPath classParserPath = clazz.getFile().getParserPath();
        DVTEditor currentDVTEditor = FunctionsInClassAccuracyBenchmark.openEditor(classParserPath, clazz.getRfProject().getProject());
        if (currentDVTEditor == null) {
            return result;
        }
        ArrayList<RfFunction> allMethods = new ArrayList<RfFunction>();
        List<RfFunction> functions = clazz.getLocalFunctions();
        List<RfFunction> tasks = clazz.getLocalTasks();
        if (functions != null) {
            allMethods.addAll(functions);
        }
        if (tasks != null) {
            allMethods.addAll(tasks);
        }
        for (RfFunction function : allMethods) {
            RfHidHolder hidHolder;
            ParserPath fileParserPath;
            FunctionsInClassAccuracyBenchmark.checkAndFlush(monitor);
            RfFileDef fileDef = function.getFile();
            if (fileDef == null || (fileParserPath = fileDef.getParserPath()) == null || !fileParserPath.equals((Object)classParserPath) || (hidHolder = function.getHidHolder()) == null) continue;
            hidHolder.visitHidObject(clazz.getRfProject(), new ContentAssistAccuracyBenchmark.LogContentAssistHidVisitor(currentDVTEditor, classParserPath, result, fullLog, statistic));
        }
        if (closeEditor) {
            TestHelper.closeEditorPart((IEditorPart)currentDVTEditor);
        }
        return result;
    }
}

