/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.editor.contentassist.KeywordProposalCommon;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtil;

public class KeywordProposal
extends KeywordProposalCommon {
    private DVTLinkedPositionProvider fLinkedPositionProvider;
    private TemplateProposal fTemplateProposal;
    private int firstParameterLength;
    private int firstParameterOffset;
    private static final String CATEGORY = "CONTENT_ASSIST_PROPOSAL";

    public KeywordProposal(DVTEditor editor, int replacementOffset, int replacementLength, String displayString) {
        this(editor, replacementOffset, replacementLength, displayString, null);
    }

    public KeywordProposal(DVTEditor editor, int replacementOffset, int replacementLength, String displayString, RfNamedElement namedElement) {
        super(replacementOffset, replacementLength, displayString, namedElement);
        this.fLinkedPositionProvider = new DVTLinkedPositionProvider(editor, new LinkedModeModel(), CATEGORY + this.toString(), false);
    }

    public StyledString getStyledDisplayString() {
        StyledString displayString = new StyledString(this.getDisplayString());
        if (this.fNamedElement == null) {
            return displayString;
        }
        displayString.append(new StyledString(" with additional context", StyledString.QUALIFIER_STYLER));
        return displayString;
    }

    @Override
    public void apply(IDocument document) {
        try {
            if (!this.fUseTemplate) {
                super.apply(document);
                return;
            }
            Region region = new Region(this.fReplacementOffset, this.fReplacementLength);
            TemplateContext context = VlogContentAssistUtil.createDummyContext(document, (IRegion)region);
            Template template = new Template("", this.fReplacementString, "ro.amiq.vlogdt.templates.contextType.unknown", this.fReplacementString, true);
            TemplateBuffer templateBuffer = context.evaluate(template);
            this.fReplacementString = templateBuffer.getString();
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            this.fTemplateProposal = new TemplateProposal(template, context, (IRegion)region, this.getImage(), 1);
            List<IRegion> linkedPositionRegions = this.computeLinkedPositionRegionsFromTemplate(templateBuffer);
            if (linkedPositionRegions == null || linkedPositionRegions.isEmpty() || this.fLinkedPositionProvider == null) {
                return;
            }
            this.fLinkedPositionProvider.setHasPositions(true);
            IRegion firstRegion = null;
            for (IRegion linkedPosRegion : linkedPositionRegions) {
                if (firstRegion == null) {
                    firstRegion = linkedPosRegion;
                }
                this.fLinkedPositionProvider.addSingleLinkedPosition(linkedPosRegion.getOffset(), linkedPosRegion.getLength(), document);
            }
            if (firstRegion != null) {
                this.firstParameterOffset = firstRegion.getOffset();
                this.firstParameterLength = firstRegion.getLength();
            }
            DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, ';', this.fReplacementOffset, "__vlog_partitioning");
            this.fLinkedPositionProvider.enterLinkedMode(document, config);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private List<IRegion> computeLinkedPositionRegionsFromTemplate(TemplateBuffer templateBuffer) {
        ArrayList<IRegion> linkedPositionRegions = new ArrayList<IRegion>();
        TemplateVariable[] templateVariables = templateBuffer.getVariables();
        if (templateVariables == null) {
            return linkedPositionRegions;
        }
        TemplateVariable[] templateVariableArray = templateVariables;
        int n = templateVariables.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateVariable templateVariable = templateVariableArray[n2];
            int[] templateOffsets = templateVariable.getOffsets();
            if (templateOffsets != null) {
                String templateVarName = templateVariable.getName();
                int[] nArray = templateOffsets;
                int n3 = templateOffsets.length;
                int n4 = 0;
                while (n4 < n3) {
                    int offset = nArray[n4];
                    linkedPositionRegions.add((IRegion)new Region(this.fReplacementOffset + offset, templateVarName.length()));
                    ++n4;
                }
            }
            ++n2;
        }
        return linkedPositionRegions;
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this.fTemplateProposal == null || !this.fLinkedPositionProvider.hasPositions()) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }
        return new Point(this.firstParameterOffset, this.firstParameterLength);
    }
}

