/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.contentasisst.IKeywordProposal;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public abstract class KeywordProposalCommon
implements IKeywordProposal,
ICompletionProposal,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    protected RfNamedElement fNamedElement;
    protected String fReplacementString;
    protected int fReplacementOffset;
    protected boolean fUseTemplate;
    private String fSemanticContextInformation;
    protected String fDisplayString;
    protected int fReplacementLength;
    protected int fCursorPosition;
    private DVTTooltipContent fAdditionalProposalInfo;

    protected KeywordProposalCommon(int replacementOffset, int replacementLength, String displayString) {
        this(replacementOffset, replacementLength, displayString, null);
    }

    protected KeywordProposalCommon(int replacementOffset, int replacementLength, String displayString, RfNamedElement namedElement) {
        this.fNamedElement = namedElement;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fDisplayString = displayString;
        this.fReplacementString = String.valueOf(displayString) + " " + this.getSemanticContextInformation();
        this.fCursorPosition = this.fReplacementString.length();
    }

    private String computeAnonimousBlockReplacement() {
        RfActionBlock actionBlock = (RfActionBlock)this.fNamedElement;
        String expression = actionBlock.getExpression();
        if (expression == null) {
            expression = "";
        }
        String beginBlock = "";
        if (actionBlock.isIf()) {
            beginBlock = "if (" + expression + ")";
        } else if (actionBlock.isElse()) {
            beginBlock = "else: !if" + expression.substring(1);
        } else if (actionBlock.isElsIf()) {
            beginBlock = "elsif" + expression;
        } else if (actionBlock.isFor()) {
            beginBlock = "for " + expression;
        } else if (actionBlock.isForEach()) {
            beginBlock = "foreach (" + expression + ")";
        } else if (actionBlock.isWhile()) {
            beginBlock = "while (" + expression + ")";
        } else {
            if (actionBlock.isDoWhile()) {
                this.fUseTemplate = true;
                return "while (${condition});";
            }
            if (actionBlock.isForever()) {
                beginBlock = "forever (" + expression + ")";
            } else if (actionBlock.isRepeat()) {
                beginBlock = "repeat (" + expression + ")";
            } else if (actionBlock.isCaseItem()) {
                beginBlock = "caseitem " + expression;
            } else if (actionBlock.isCasex()) {
                beginBlock = "casex (" + expression + ")";
            } else if (actionBlock.isCasez()) {
                beginBlock = "casex (" + expression + ")";
            } else if (actionBlock.isRandCase()) {
                beginBlock = "randcase (" + expression + ")";
            } else if (actionBlock.isSimpleCase()) {
                beginBlock = "case (" + expression + ")";
            } else if (actionBlock.isInitial()) {
                beginBlock = "initial";
            } else if (actionBlock.isAlways()) {
                beginBlock = "always " + expression;
            }
        }
        return beginBlock.isEmpty() ? "" : "// " + beginBlock;
    }

    public String getSemanticContextInformation() {
        if (this.fSemanticContextInformation != null) {
            return this.fSemanticContextInformation;
        }
        this.fSemanticContextInformation = this.fNamedElement == null ? "" : (this.fNamedElement instanceof RfActionBlock && !(this.fNamedElement instanceof RfNamedActionBlock) ? this.computeAnonimousBlockReplacement() : (this.fNamedElement.getName() != null ? ": " + this.fNamedElement.getName() : ""));
        return this.fSemanticContextInformation;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public String getAdditionalProposalInfo() {
        if (this.fAdditionalProposalInfo == null) {
            this.computeAdditionalProposalInfo();
        }
        String delimiter = this.getTooltipDelimiter();
        String result = String.valueOf(this.fAdditionalProposalInfo.getSignature()) + delimiter + this.fAdditionalProposalInfo.getShallow() + this.fAdditionalProposalInfo.getComment() + this.fAdditionalProposalInfo.getUPFSignature() + this.fAdditionalProposalInfo.getDebugInfo();
        return this.trimIfLimitExceded(result);
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.KEYWORD_OBJ);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.fAdditionalProposalInfo == null) {
            this.computeAdditionalProposalInfo();
        }
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            return this.getAdditionalProposalInfo();
        }
        return this.fAdditionalProposalInfo;
    }

    protected void computeAdditionalProposalInfo() {
        this.fAdditionalProposalInfo = new DVTTooltipContent();
        this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, "Keyword");
        if (this.fNamedElement == null) {
            return;
        }
        String additionalInfo = this.fUseTemplate ? this.fReplacementString.replace("${", "").replace("}", "") : this.fReplacementString;
        this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, String.valueOf(CommentUtils.getInstance().wrapIntoItalic(additionalInfo)) + CommentUtils.getInstance().getNewLine());
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    protected String trimIfLimitExceded(String result) {
        if (result.length() < 300) {
            return result;
        }
        return String.valueOf(result.substring(0, 300)) + "...";
    }

    protected String getTooltipDelimiter() {
        return this.fAdditionalProposalInfo.getSignature().isEmpty() ? "" : CommentUtils.getInstance().getHorizontalLine(CommentUtils.useHtml());
    }
}

