/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTCompletionProposal;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.MethodSignatureUseCase;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClassDef;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFragment;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModport;
import ro.amiq.vlogdt.model.reflection.RfModportFunction;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfNamespaceElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedClass;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedEventType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedScalarType;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroText;
import ro.amiq.vlogdt.r2lparser.R2LDummyElement;
import ro.amiq.vlogdt.r2lparser.R2LExternFunction;
import ro.amiq.vlogdt.r2lparser.R2LFEBaseOperationProposal;
import ro.amiq.vlogdt.r2lparser.R2LFEBaseProposal;
import ro.amiq.vlogdt.r2lparser.R2LFEFieldProposal;
import ro.amiq.vlogdt.r2lparser.R2LGetterSetterWizardElement;
import ro.amiq.vlogdt.r2lparser.R2LNamedArgument;
import ro.amiq.vlogdt.r2lparser.R2LOverrideConstraint;
import ro.amiq.vlogdt.r2lparser.R2LOverrideFunction;
import ro.amiq.vlogdt.r2lparser.R2LOverrideWizardElementCommon;
import ro.amiq.vlogdt.r2lparser.R2LPreprocDirectiveElement;
import ro.amiq.vlogdt.r2lparser.R2LStructAssignmentPattern;
import ro.amiq.vlogdt.r2lparser.R2LUvmOvmFieldEditorElement;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;
import ro.amiq.vlogdt.ui.editor.utils.VlogConstraintUtils;
import ro.amiq.vlogdt.ui.editor.utils.VlogFunctionSignatureUtils;
import ro.amiq.vlogdt.utils.Utils;

public abstract class RFLazyCompletionProposalCommon
implements IDVTCompletionProposal,
ICompletionProposalExtension4,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    protected Object fCandidate;
    protected String fPrefix;
    protected int fOffset;
    protected String fJavaDocComment;
    protected String fReplacementString;
    protected String fDisplayString;
    protected Image fImage;
    protected DVTTooltipContent fAdditionalProposalInfo;
    protected int fReplacementOffset;
    protected int fReplacementLength;
    protected int fCursorPosition;
    protected boolean fAlreadyComputed;
    protected IContextInformation fContextInformation;
    protected ITextViewer fTextViewer;
    protected IDocument fDocument;
    protected boolean fUseTemplate;
    protected boolean fIsImport;
    protected boolean fIsExtern;
    protected boolean fOpenOvmUvmFieldEditor = false;
    protected boolean fOpenOverrideWizardDialog = false;
    protected boolean fOpenGetterSetter = false;
    protected int fRule;
    protected IRfScope fInitialScope;
    protected boolean fTypeCompatibleArgument;
    protected boolean fInsertOptionalArguments;
    protected int firstParameterOffset;
    protected int firstParameterLength;
    protected String functionArguments;
    protected DVTEditor fEditor;
    protected boolean fCandidateHasSemiColon;
    protected boolean isMethodOverride;
    protected boolean isConstraintOverride;
    protected boolean isExternMethodImplementation;
    private int fLine;
    private ParserPath fParserPath;
    private RfTypesResolver fResolver;

    protected RFLazyCompletionProposalCommon(RfTypesResolver resolver, ITextViewer viewer, IDocument document, IRfScope scope, Object candidate, String currentWord, int offset, boolean isImport, boolean isExtern, int rule, boolean typeCompatibleArgument, boolean insertOptionalArguments, IContextInformation contextInformation, int line, ParserPath parserPath) {
        this.fResolver = resolver;
        this.fTextViewer = viewer;
        this.fDocument = document;
        this.fCandidate = candidate;
        this.fPrefix = currentWord;
        this.fOffset = offset;
        this.fIsImport = isImport;
        this.fIsExtern = isExtern;
        this.fInitialScope = scope;
        this.fContextInformation = contextInformation;
        this.fRule = rule;
        this.fTypeCompatibleArgument = typeCompatibleArgument;
        this.fInsertOptionalArguments = insertOptionalArguments;
        this.fLine = line;
        this.fParserPath = parserPath;
    }

    public boolean isNoProposal() {
        return this.fCandidate instanceof R2LDummyElement;
    }

    public String getAdditionalProposalInfo() {
        if (this.fAdditionalProposalInfo == null) {
            this.computeAdditionalProposalInfo();
        }
        String delimiter = this.getTooltipDelimiter();
        String result = String.valueOf(this.fAdditionalProposalInfo.getSignature()) + delimiter + this.fAdditionalProposalInfo.getShallow() + this.fAdditionalProposalInfo.getComment() + this.fAdditionalProposalInfo.getUPFSignature() + this.fAdditionalProposalInfo.getDebugInfo();
        return this.trimIfLimitExceded(result);
    }

    protected String trimIfLimitExceded(String result) {
        if (result.length() < 300) {
            return result;
        }
        return String.valueOf(result.substring(0, 300)) + "...";
    }

    protected String getTooltipDelimiter() {
        return this.fAdditionalProposalInfo.getSignature().isEmpty() ? "" : "<br><br>";
    }

    protected void computeAdditionalProposalInfo() {
        String comment;
        this.fAdditionalProposalInfo = new DVTTooltipContent();
        int lineLength = 40;
        if (this.fCandidate instanceof IRfNamedElement) {
            try {
                comment = RfUtils.getContentAssistProposalText((IRfNamedElement)this.fCandidate, this.fLine, this.fParserPath);
            }
            catch (VlogException vlogException) {
                comment = ((IRfNamedElement)this.fCandidate).getComment();
                comment = this.textWrap(lineLength, comment).toString();
            }
        } else if (this.fCandidate instanceof RfClassDef) {
            try {
                comment = RfUtils.getContentAssistProposalText(((RfClassDef)this.fCandidate).getNamedElement(), this.fLine, this.fParserPath);
            }
            catch (VlogException vlogException) {
                comment = ((RfClassDef)this.fCandidate).getDefComment();
                comment = this.textWrap(lineLength, comment).toString();
            }
        } else {
            return;
        }
        if (this.fCandidate instanceof R2LDummyElement) {
            comment = ((R2LDummyElement)this.fCandidate).getSignature();
            comment = this.textWrap(lineLength, comment).toString();
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, this.partiallyEscapeHTML(this.textWrap(lineLength, this.fDisplayString).toString()));
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, this.textWrap(lineLength, comment).toString());
            return;
        }
        if (this.fCandidate instanceof RfNamespaceElement) {
            comment = ((RfNamespaceElement)this.fCandidate).getComment();
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, this.partiallyEscapeHTML(this.textWrap(lineLength, this.fDisplayString).toString()));
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, this.textWrap(lineLength, comment).toString());
            return;
        }
        if (this.fCandidate instanceof R2LUvmOvmFieldEditorElement || this.fCandidate instanceof R2LOverrideWizardElementCommon || this.fCandidate instanceof R2LGetterSetterWizardElement) {
            RfNamedElement namedElement = (RfNamedElement)this.fCandidate;
            comment = namedElement.getSignature();
            comment = this.textWrap(lineLength, comment).toString();
        }
        if (this.fCandidate instanceof IRfNamedElement) {
            DVTTooltipContent tooltipContent = new DVTTooltipContent();
            try {
                IEditorPart editor = this.fTextViewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)this.fTextViewer).getEditor() : DVTFileUtils.getInstance().getActiveEditor();
                RfUtils.getTooltipFormattedText(new RfWNamedElementAndScope((IRfNamedElement)this.fCandidate, this.fInitialScope), false, (ITextEditor)(editor instanceof AbstractTextEditor ? (AbstractTextEditor)editor : null), tooltipContent);
            }
            catch (VlogException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, tooltipContent.getSignature());
            if (this.fCandidate instanceof R2LFEBaseProposal) {
                this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, ((R2LFEBaseProposal)this.fCandidate).getTooltipComment());
            } else {
                this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, tooltipContent.getComment());
            }
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.PREFERENCE, tooltipContent.getPreference());
        } else {
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, "");
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, comment);
        }
        if (this.isMethodOverride || this.isExternMethodImplementation || this.isConstraintOverride) {
            String currentComment = this.fAdditionalProposalInfo.getComment();
            currentComment = String.valueOf(this.getStringForStyledDisplay()) + CommentUtils.getInstance().getNewLine() + currentComment;
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, currentComment);
        }
    }

    protected void computeBasicAdditionalProposalInfo() {
        String comment;
        this.fAdditionalProposalInfo = new DVTTooltipContent();
        int lineLength = 40;
        if (this.fCandidate instanceof IRfNamedElement) {
            try {
                comment = RfUtils.getContentAssistProposalText((IRfNamedElement)this.fCandidate, this.fLine, this.fParserPath);
            }
            catch (VlogException vlogException) {
                comment = ((IRfNamedElement)this.fCandidate).getComment();
                comment = this.textWrap(lineLength, comment).toString();
            }
        } else if (this.fCandidate instanceof RfClassDef) {
            try {
                comment = RfUtils.getContentAssistProposalText(((RfClassDef)this.fCandidate).getNamedElement(), this.fLine, this.fParserPath);
            }
            catch (VlogException vlogException) {
                comment = ((RfClassDef)this.fCandidate).getDefComment();
                comment = this.textWrap(lineLength, comment).toString();
            }
        } else {
            return;
        }
        if (this.fCandidate instanceof R2LDummyElement) {
            comment = ((R2LDummyElement)this.fCandidate).getSignature();
            comment = this.textWrap(lineLength, comment).toString();
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, this.partiallyEscapeHTML(this.textWrap(lineLength, this.fDisplayString).toString()));
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, this.textWrap(lineLength, comment).toString());
            return;
        }
        if (this.fCandidate instanceof RfNamespaceElement) {
            comment = ((RfNamespaceElement)this.fCandidate).getComment();
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, this.partiallyEscapeHTML(this.textWrap(lineLength, this.fDisplayString).toString()));
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, this.textWrap(lineLength, comment).toString());
            return;
        }
        if (this.fCandidate instanceof R2LUvmOvmFieldEditorElement || this.fCandidate instanceof R2LOverrideWizardElementCommon || this.fCandidate instanceof R2LGetterSetterWizardElement) {
            RfNamedElement namedElement = (RfNamedElement)this.fCandidate;
            comment = namedElement.getSignature();
            comment = this.textWrap(lineLength, comment).toString();
        }
        if (this.fCandidate instanceof IRfNamedElement) {
            DVTTooltipContent tooltipContent = new DVTTooltipContent();
            try {
                IEditorPart editor = this.fTextViewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)this.fTextViewer).getEditor() : DVTFileUtils.getInstance().getActiveEditor();
                RfUtils.getTooltipFormattedText(new RfWNamedElementAndScope((IRfNamedElement)this.fCandidate, this.fInitialScope), false, (ITextEditor)(editor instanceof AbstractTextEditor ? (AbstractTextEditor)editor : null), tooltipContent);
            }
            catch (VlogException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, tooltipContent.getSignature());
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, tooltipContent.getComment());
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.PREFERENCE, tooltipContent.getPreference());
        } else {
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.SIGNATURE, "");
            this.fAdditionalProposalInfo.set(DVTTooltipContent.TooltipContent.COMMENT, comment);
        }
    }

    protected void internalComputeProposal() {
        Point selectedRange;
        RfNamedElement designUnitElement;
        if (this.fAlreadyComputed) {
            return;
        }
        this.fUseTemplate = false;
        this.fAlreadyComputed = true;
        String candidateName = null;
        if (this.fCandidate == null) {
            return;
        }
        this.fReplacementString = this.fPrefix;
        this.fDisplayString = "";
        int cursorOffset = 0;
        IEditorPart editor = this.getEditor();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)editor);
        if (this.fCandidate instanceof IRfNamedElement) {
            candidateName = this.getEscName((IRfNamedElement)this.fCandidate);
            this.fImage = ((IRfNamedElement)this.fCandidate).getImage();
        } else if (this.fCandidate instanceof RfClassDef) {
            candidateName = ((RfClassDef)this.fCandidate).getInfo();
        } else {
            return;
        }
        if (this.fCandidate instanceof R2LDummyElement) {
            this.fReplacementString = "";
            this.fDisplayString = candidateName;
            this.fReplacementOffset = this.fOffset;
            this.fReplacementLength = 0;
            this.fCursorPosition = 0;
            return;
        }
        if (this.fCandidate instanceof RfNamespaceElement) {
            this.fDisplayString = candidateName;
            this.fReplacementString = candidateName;
            this.fReplacementOffset = this.fOffset - this.fPrefix.length();
            this.fReplacementLength = this.fPrefix.length();
            this.fCursorPosition = this.fReplacementString.length();
            return;
        }
        if (this.fCandidate instanceof RfModportFunction && (designUnitElement = ((RfModportFunction)this.fCandidate).getDesignUnitElement(this.fPrefix)) != null) {
            this.fCandidate = designUnitElement;
        }
        if (this.fCandidate instanceof R2LExternFunction) {
            this.isExternMethodImplementation = true;
            this.fCandidate = ((R2LExternFunction)this.fCandidate).getFunction();
            String arguments = ((RfFunction)this.fCandidate).printArguments(RfTypesResolver.create((IRfScopeElement)((RfFunction)this.fCandidate), ((RfFunction)this.fCandidate).getRfProject(), 14), true, null, this.fInsertOptionalArguments, false, true, MethodSignatureUseCase.EXTERN_METHOD_CODE_GENERATION, false);
            String type = ((RfFunction)this.fCandidate).getAssociatedTypeName();
            if (type == null || type.trim().length() == 0) {
                type = "void";
            }
            this.fDisplayString = String.valueOf(this.getEscName((RfFunction)this.fCandidate)) + "(" + arguments + "): " + type;
            try {
                String word;
                VlogWordFinder wordFinder;
                RfNamedElement enclosingScope = ((RfFunction)this.fCandidate).getEnclosingScope();
                String taskOrFunction = ((RfFunction)this.fCandidate).isTask() ? "task" : "function";
                IRegion regionOfPrecedingFunctionKeyword = null;
                int previousCharOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)this.fDocument, (int)(this.fOffset - this.fPrefix.length() - 1), (boolean)false, (String)"__vlog_partitioning", (boolean)false, (boolean)true);
                if (previousCharOffset != -1 && (regionOfPrecedingFunctionKeyword = (wordFinder = VlogWordFinder.getDefault()).getWordAtOffset(this.fDocument, previousCharOffset)) != null && this.fDocument != null && !taskOrFunction.equals(word = this.fDocument.get(regionOfPrecedingFunctionKeyword.getOffset(), regionOfPrecedingFunctionKeyword.getLength()))) {
                    regionOfPrecedingFunctionKeyword = null;
                }
                if (regionOfPrecedingFunctionKeyword != null && this.fDocument != null) {
                    this.fPrefix = this.fDocument.get(regionOfPrecedingFunctionKeyword.getOffset(), this.fOffset - regionOfPrecedingFunctionKeyword.getOffset());
                    this.fReplacementString = VlogFunctionSignatureUtils.createSignatureStub(this.fResolver, enclosingScope, (RfFunction)this.fCandidate, this.fOffset, editor, true, false, true);
                } else {
                    String searchedKeyWord = ((RfFunction)this.fCandidate).isTask() ? "task" : "function";
                    int newPrefixOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, searchedKeyWord, this.fOffset - 100, this.fOffset, false);
                    if (newPrefixOffset <= this.fOffset && this.fDocument != null) {
                        this.fPrefix = this.fDocument.get(newPrefixOffset, this.fOffset - newPrefixOffset);
                        this.fReplacementString = VlogFunctionSignatureUtils.createSignatureStub(this.fResolver, enclosingScope, (RfFunction)this.fCandidate, this.fOffset, editor, true, false, true);
                    }
                }
                this.fUseTemplate = this.fReplacementString.contains("${");
            }
            catch (BadLocationException badLocationException) {}
        } else if (this.fCandidate instanceof R2LOverrideFunction) {
            this.handleOverrideFunction(editor, lineDelimiter);
        } else if (this.fCandidate instanceof R2LOverrideConstraint) {
            this.handleOverrideConstraint(editor, lineDelimiter);
        } else if (this.fCandidate instanceof R2LStructAssignmentPattern) {
            R2LStructAssignmentPattern candidate = (R2LStructAssignmentPattern)this.fCandidate;
            RfStruct structToAssign = candidate.getAssignedStruct();
            boolean multiLine = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.multi_line_assignment_pattern");
            this.fDisplayString = candidateName;
            this.fReplacementString = String.valueOf(R2LStructAssignmentPattern.computeStructFields(structToAssign, multiLine, lineDelimiter)) + ";";
            this.fUseTemplate = this.fReplacementString.contains("${");
            this.fCandidateHasSemiColon = true;
        } else if (this.fCandidate instanceof VlogMacroInfo) {
            Object[] macroArgumentsArray;
            this.fDisplayString = ((VlogMacroInfo)this.fCandidate).getSignature();
            this.fReplacementString = ((VlogMacroInfo)this.fCandidate).getSignature(false, true);
            try {
                String expansion;
                if (((VlogMacroInfo)this.fCandidate).hasReplacement() && ((expansion = ((VlogMacroInfo)this.fCandidate).getReplacement(null, null, this.fLine, this.fParserPath)).contains("\n") || expansion.contains("\r"))) {
                    this.fReplacementString = String.valueOf(this.fReplacementString) + lineDelimiter;
                }
            }
            catch (VlogException vlogException) {}
            this.fUseTemplate = this.fReplacementString.contains("${");
            VlogMacroText macroText = ((VlogMacroInfo)this.fCandidate).getMacroText();
            if (macroText != null && (macroArgumentsArray = macroText.getParameters()) != null && macroArgumentsArray.length != 0) {
                this.functionArguments = DVTStringUtil.join((Object[])macroArgumentsArray, (String)", ");
            }
        } else if (this.fCandidate instanceof RfFragment) {
            this.fReplacementString = ((RfFragment)this.fCandidate).getName();
            this.fDisplayString = ((RfFragment)this.fCandidate).getName();
            this.fUseTemplate = false;
        } else if (this.fCandidate instanceof RfClass) {
            this.fReplacementString = ((RfClass)this.fCandidate).getName();
            this.fDisplayString = ((RfClass)this.fCandidate).getName();
            this.fUseTemplate = this.fReplacementString.contains("${");
        } else if (this.fCandidate instanceof IRfBlockElement) {
            this.fReplacementString = candidateName;
            this.fDisplayString = candidateName;
            IRfBlockElement generateBlock = (IRfBlockElement)this.fCandidate;
            if (generateBlock.isLoopGenerate()) {
                this.fReplacementString = String.valueOf(this.fReplacementString) + "[${i}]";
                this.fUseTemplate = true;
            }
        } else if (this.fCandidate instanceof RfCovergroup || this.fCandidate instanceof RfTypeAlias || this.fCandidate instanceof RfModule || this.fCandidate instanceof RfInterface || this.fCandidate instanceof RfProgram || this.fCandidate instanceof RfChecker || this.fCandidate instanceof RfPrimitive || this.fCandidate instanceof RfActionBlock || this.fCandidate instanceof RfPackage || this.fCandidate instanceof RfClockingBlock || this.fCandidate instanceof RfPropertySequence || this.fCandidate instanceof RfLibrary || this.fCandidate instanceof RfConfiguration || !(this.fCandidate instanceof RfNamedElement)) {
            this.fReplacementString = candidateName;
            this.fDisplayString = candidateName;
        } else if (this.fCandidate instanceof RfPort) {
            String netType = ((RfField)this.fCandidate).getDataType().getNetType() != null ? ((RfField)this.fCandidate).getDataType().getNetType() : ((RfPort)this.fCandidate).implicitNetType();
            String direction = ((RfField)this.fCandidate).getDirectionString();
            this.fReplacementString = candidateName;
            this.fDisplayString = String.valueOf(candidateName) + ": " + (direction.isEmpty() ? "" : String.valueOf(direction) + " ") + (netType == null || netType.isEmpty() ? "" : String.valueOf(netType) + " ") + ((RfPort)this.fCandidate).getAssociatedTypeName(this.fInitialScope, this.fResolver, false, true);
        } else if (this.fCandidate instanceof RfModport) {
            this.fReplacementString = candidateName;
            this.fDisplayString = String.valueOf(candidateName) + ": modport";
        } else if (this.fCandidate instanceof RfConstraint) {
            this.fReplacementString = candidateName;
            this.fDisplayString = String.valueOf(candidateName) + ": constraint";
        } else if (this.fCandidate instanceof RfField) {
            if (((RfField)this.fCandidate).isEnumElement()) {
                IRfNamedElement relativeTo;
                IRfNamedElement element;
                String scopeQualifier;
                this.fReplacementString = candidateName;
                this.fDisplayString = String.valueOf(candidateName) + ": " + ((RfField)this.fCandidate).getAssociatedTypeName(this.fInitialScope, this.fResolver, false, true);
                if (this.fInitialScope instanceof RfActionBlockDef && ((RfActionBlock)((RfActionBlockDef)this.fInitialScope).getNamedElement()).isCase()) {
                    this.fReplacementString = String.valueOf(this.fReplacementString) + " : begin  end";
                    cursorOffset = -4;
                }
                if ((scopeQualifier = RfBatchUtils.getScopeRelativeTo(element = this.fInitialScope instanceof IRfNamedElement ? (IRfNamedElement)this.fInitialScope : (this.fInitialScope instanceof IRfDefElement ? ((IRfDefElement)this.fInitialScope).getNamedElement() : null), relativeTo = (IRfNamedElement)((RfField)this.fCandidate).getEnclosingScope(RfStruct.class), false)) != null && !scopeQualifier.isEmpty()) {
                    String scopePrefix = String.valueOf(scopeQualifier) + "::";
                    boolean shouldInsertScopePrefix = true;
                    Object[] prevCodeCharPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)this.fDocument, (int)(this.fOffset - this.fPrefix.length() - 1), (boolean)false, (String)"__vlog_partitioning");
                    if (prevCodeCharPair != null && prevCodeCharPair.length > 0 && ((Character)prevCodeCharPair[0]).charValue() == ':') {
                        int prevCodeCharOffset = (Integer)prevCodeCharPair[1];
                        int scopeBackwardOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, scopePrefix, Math.max(this.fOffset - 100, 0), prevCodeCharOffset, false);
                        if (scopeBackwardOffset == prevCodeCharOffset - scopePrefix.length()) {
                            shouldInsertScopePrefix = false;
                        }
                    }
                    if (shouldInsertScopePrefix) {
                        this.fReplacementString = String.valueOf(scopePrefix) + this.fReplacementString;
                    }
                }
            } else {
                String assocTypeName = ((RfField)this.fCandidate).isParameterNoDataType() ? "" : ((RfField)this.fCandidate).getAssociatedTypeName(this.fInitialScope, this.fResolver, false, true);
                DataType dataType = ((RfField)this.fCandidate).getDataType();
                String netType = dataType.getNetType() != null ? dataType.getNetType() : ((RfField)this.fCandidate).implicitSpecificNetType();
                String direction = ((RfField)this.fCandidate).isArgument() && !((RfField)this.fCandidate).isLetArgument() ? ((RfField)this.fCandidate).getDirectionString() : "";
                this.fReplacementString = candidateName;
                this.fDisplayString = candidateName;
                if (assocTypeName != null && !assocTypeName.isEmpty()) {
                    this.fDisplayString = String.valueOf(this.fDisplayString) + ": " + (direction.isEmpty() ? "" : String.valueOf(direction) + " ") + (netType != null ? String.valueOf(netType) + " " : "") + assocTypeName.trim();
                }
            }
        } else if (this.fCandidate instanceof R2LNamedArgument) {
            this.fCandidate = ((R2LNamedArgument)this.fCandidate).getField();
            this.fUseTemplate = true;
            this.fReplacementString = String.valueOf(candidateName) + "(${" + ((RfField)this.fCandidate).getAssociatedTypeName(this.fInitialScope, this.fResolver, false, true) + "})";
            this.fDisplayString = String.valueOf(candidateName) + ": " + ((RfField)this.fCandidate).getAssociatedTypeName(this.fInitialScope, this.fResolver, false, true);
        } else if (this.fCandidate instanceof RfFunction) {
            String todoComment = null;
            boolean isTask = ((RfFunction)this.fCandidate).isTask();
            boolean isLet = ((RfFunction)this.fCandidate).isLet();
            todoComment = isTask ? "// TODO Auto-generated task stub" : (((RfFunction)this.fCandidate).isConstructor() ? "// TODO Auto-generated constructor stub" : (isLet ? "// TODO Auto-generated let stub" : "// TODO Auto-generated function stub"));
            String displayArguments = ((RfFunction)this.fCandidate).printArguments(RfTypesResolver.create(this.fResolver), this.fOffset, true, this.fInitialScope, false, true, MethodSignatureUseCase.CONTENT_ASSIST_PROPOSAL, this.fTypeCompatibleArgument, this.fInsertOptionalArguments);
            this.functionArguments = ((RfFunction)this.fCandidate).printArguments(RfTypesResolver.create(this.fResolver), true, this.fInitialScope, false, true, MethodSignatureUseCase.CONTENT_ASSIST_PROPOSAL, false);
            String replacementArguments = ((RfFunction)this.fCandidate).printArguments(RfTypesResolver.create(this.fResolver), this.fOffset, true, this.fInitialScope, false, false, MethodSignatureUseCase.METHOD_CALL, this.fTypeCompatibleArgument, this.fInsertOptionalArguments);
            displayArguments = this.removeTrailingCommas(displayArguments);
            replacementArguments = this.removeTrailingCommas(replacementArguments);
            String type = "";
            if (!(isTask || isLet || (type = ((RfFunction)this.fCandidate).getAssociatedTypeName(this.fInitialScope, this.fResolver, false, true)) != null && !type.isEmpty())) {
                type = "void";
            }
            boolean isSequencePredefinedFunction = false;
            if (displayArguments.isEmpty() && this.fCandidate instanceof RfPredefinedFunction && ((RfFunction)this.fCandidate).getEnclosingScope() instanceof RfPropertySequence && ((RfPropertySequence)((RfFunction)this.fCandidate).getEnclosingScope()).isSequence()) {
                isSequencePredefinedFunction = true;
            }
            this.fDisplayString = isSequencePredefinedFunction ? String.valueOf(candidateName) + (isTask ? "" : ": " + type) : String.valueOf(candidateName) + "(" + displayArguments + ")" + (isTask || isLet ? "" : ": " + type);
            if (this.fIsImport) {
                this.fUseTemplate = false;
                this.fReplacementString = candidateName;
            } else if (this.fIsExtern) {
                this.fReplacementString = isTask ? String.valueOf(candidateName) + "(" + replacementArguments + ")" + ";" + lineDelimiter + "    " + todoComment + lineDelimiter + "    " + lineDelimiter + "endtask" + lineDelimiter : String.valueOf(candidateName) + "(" + replacementArguments + ")" + ";" + lineDelimiter + "    " + todoComment + lineDelimiter + "    " + lineDelimiter + "endfunction" + lineDelimiter;
            } else {
                this.fUseTemplate = replacementArguments.length() > 0;
                String string = this.fReplacementString = this.fUseTemplate ? candidateName.replace("$", this.getEscapedDollarSign()) : candidateName;
                if (!isSequencePredefinedFunction) {
                    this.fReplacementString = String.valueOf(this.fReplacementString) + this.getFunctionArgumentsReplacement(lineDelimiter);
                }
                if (((RfFunction)this.fCandidate).isTask() || ((RfFunction)this.fCandidate).isConstructor() || ((RfFunction)this.fCandidate).isVoid()) {
                    this.fReplacementString = String.valueOf(this.fReplacementString) + ";";
                    this.fCandidateHasSemiColon = true;
                }
            }
        } else if (this.fCandidate instanceof RfPredefinedScalarType) {
            this.fDisplayString = candidateName;
            this.fReplacementString = String.valueOf(candidateName) + " ";
        } else if (this.fCandidate instanceof RfPredefinedEventType) {
            this.fDisplayString = candidateName;
            this.fReplacementString = String.valueOf(candidateName) + " ";
            this.fImage = DVTImages.imageCache.getImage(DVTImages.OUTLINE_PEVENT);
        } else if (this.fCandidate instanceof RfAssertExpect) {
            this.fDisplayString = candidateName;
            this.fReplacementString = String.valueOf(candidateName) + " ";
        } else if (this.fCandidate instanceof R2LUvmOvmFieldEditorElement || this.fCandidate instanceof R2LOverrideWizardElementCommon || this.fCandidate instanceof R2LGetterSetterWizardElement) {
            if (this.fCandidate instanceof R2LUvmOvmFieldEditorElement) {
                this.fOpenOvmUvmFieldEditor = true;
            } else if (this.fCandidate instanceof R2LOverrideWizardElementCommon) {
                this.fOpenOverrideWizardDialog = true;
            } else if (this.fCandidate instanceof R2LGetterSetterWizardElement) {
                this.fOpenGetterSetter = true;
            }
            this.fDisplayString = candidateName;
            this.fReplacementString = this.fPrefix;
        } else if (this.fCandidate instanceof R2LPreprocDirectiveElement) {
            this.fDisplayString = ((R2LPreprocDirectiveElement)this.fCandidate).getSignature();
            this.fReplacementString = ((R2LPreprocDirectiveElement)this.fCandidate).getReplacement();
        } else if (this.fCandidate instanceof R2LFEFieldProposal) {
            R2LFEFieldProposal proposal = (R2LFEFieldProposal)this.fCandidate;
            this.fDisplayString = proposal.getDisplayString();
            this.fReplacementString = proposal.getReplacementString();
            this.fUseTemplate = this.fReplacementString.contains("${");
        }
        this.fReplacementOffset = this.fOffset - this.fPrefix.length();
        this.fReplacementLength = this.fPrefix.length();
        Point point = selectedRange = this.fTextViewer != null ? this.fTextViewer.getSelectedRange() : null;
        if (this.fReplacementLength == 0 && selectedRange != null && selectedRange.x == this.fReplacementOffset) {
            this.fReplacementLength = selectedRange.y;
        }
        if (this.fRule == 177) {
            this.fReplacementString = candidateName;
        }
        if (this.fReplacementString.contains("\nendfunction") || this.fReplacementString.contains("\nendtask") || this.isConstraintOverride) {
            String indent = DVTFileUtils.computeIndent((IDocument)this.fDocument, (int)this.fOffset);
            String pattern = this.fReplacementString;
            String[] lines = pattern.split(lineDelimiter);
            this.fReplacementString = lines[0];
            int i = 1;
            while (i < lines.length) {
                this.fCursorPosition = this.fReplacementString.length();
                this.fReplacementString = String.valueOf(this.fReplacementString) + lineDelimiter + indent + lines[i];
                ++i;
            }
        } else if (this.fCandidate instanceof RfClass && this.fUseTemplate) {
            this.fCursorPosition = this.fDisplayString.length();
        } else if (this.isMethodOverride || this.isExternMethodImplementation || this.isConstraintOverride) {
            String[] lines;
            int distanceToFirstEmptyLine = 0;
            String[] stringArray = lines = this.fReplacementString.split(lineDelimiter);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                distanceToFirstEmptyLine += line.length();
                if (line.trim().isEmpty()) {
                    this.fCursorPosition = cursorOffset + distanceToFirstEmptyLine;
                    break;
                }
                distanceToFirstEmptyLine += lineDelimiter.length();
                ++n2;
            }
            if (distanceToFirstEmptyLine == 0) {
                this.fCursorPosition = this.fReplacementString.length() + cursorOffset;
            }
        } else if (this.fCandidate instanceof R2LFEBaseOperationProposal) {
            R2LFEBaseOperationProposal proposal = (R2LFEBaseOperationProposal)this.fCandidate;
            this.fDisplayString = proposal.getDisplayString();
            this.fReplacementString = proposal.getReplacementString();
            this.fReplacementOffset = proposal.getReplacementOffset();
            this.fReplacementLength = proposal.getReplacementLength();
            this.fUseTemplate = this.fReplacementString.contains("${");
            this.fCursorPosition = proposal.getCursorOffset();
        } else {
            this.fCursorPosition = this.fReplacementString.length() + cursorOffset;
        }
    }

    private void handleOverrideFunction(IEditorPart editor, String lineDelimiter) {
        String type;
        boolean hasMethodKeyword = ((R2LOverrideFunction)this.fCandidate).hasMethodKeyword();
        boolean hasExtern = ((R2LOverrideFunction)this.fCandidate).hasExtern();
        this.fCandidate = ((R2LOverrideFunction)this.fCandidate).getFunction();
        this.isMethodOverride = true;
        RfNamedElement enclosingScope = null;
        if (this.fInitialScope instanceof IRfNamedElement) {
            enclosingScope = (RfNamedElement)this.fInitialScope;
        } else if (this.fInitialScope instanceof IRfDefElement) {
            enclosingScope = (RfNamedElement)((IRfDefElement)this.fInitialScope).getNamedElement();
        }
        String taskOrFunction = ((RfFunction)this.fCandidate).isTask() ? "task" : "function";
        String functionSignature = "";
        boolean addedSpace = false;
        IRegion regionOfPrecedingFunctionKeyword = null;
        try {
            if (hasMethodKeyword) {
                VlogWordFinder wordFinder;
                int previousCharOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)this.fDocument, (int)(this.fOffset - this.fPrefix.length() - 1), (boolean)false, (String)"__vlog_partitioning", (boolean)false, (boolean)true);
                if (previousCharOffset != -1 && (regionOfPrecedingFunctionKeyword = (wordFinder = VlogWordFinder.getDefault()).getWordAtOffset(this.fDocument, previousCharOffset)) != null && this.fDocument != null) {
                    String word = this.fDocument.get(regionOfPrecedingFunctionKeyword.getOffset(), regionOfPrecedingFunctionKeyword.getLength());
                    if (!taskOrFunction.equals(word)) {
                        regionOfPrecedingFunctionKeyword = null;
                    } else {
                        previousCharOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)this.fDocument, (int)(regionOfPrecedingFunctionKeyword.getOffset() - 1), (boolean)false, (String)"__vlog_partitioning", (boolean)false, (boolean)true);
                        if (previousCharOffset != -1) {
                            regionOfPrecedingFunctionKeyword = null;
                        }
                    }
                }
                if (regionOfPrecedingFunctionKeyword != null && this.fDocument != null) {
                    this.fPrefix = this.fDocument.get(regionOfPrecedingFunctionKeyword.getOffset(), this.fOffset - regionOfPrecedingFunctionKeyword.getOffset());
                    functionSignature = VlogFunctionSignatureUtils.createSignatureStub(RfTypesResolver.create((IRfScopeElement)enclosingScope, enclosingScope.getRfProject(), 14), enclosingScope, (RfFunction)this.fCandidate, this.fOffset, editor, true, false, false);
                } else {
                    String searchedKeyWord = ((RfFunction)this.fCandidate).isTask() ? "task" : "function";
                    int newPrefixOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(this.fDocument, searchedKeyWord, this.fOffset - 100, this.fOffset, false) + searchedKeyWord.length();
                    if (newPrefixOffset <= this.fOffset && this.fDocument != null) {
                        this.fPrefix = this.fDocument.get(newPrefixOffset, this.fOffset - newPrefixOffset);
                        functionSignature = " " + VlogFunctionSignatureUtils.createSignatureStub(RfTypesResolver.create((IRfScopeElement)enclosingScope, enclosingScope.getRfProject(), 14), enclosingScope, (RfFunction)this.fCandidate, this.fOffset, editor, false, false, false);
                        addedSpace = true;
                    }
                }
            } else {
                functionSignature = VlogFunctionSignatureUtils.createSignatureStub(RfTypesResolver.create((IRfScopeElement)enclosingScope, enclosingScope.getRfProject(), 14), enclosingScope, (RfFunction)this.fCandidate, this.fOffset, editor, true, false, false);
            }
        }
        catch (BadLocationException badLocationException) {}
        if (functionSignature.contains("${")) {
            this.fUseTemplate = true;
        }
        if ((type = ((RfFunction)this.fCandidate).getAssociatedTypeName()) == null || type.trim().length() == 0) {
            type = "void";
        }
        String displayArguments = ((RfFunction)this.fCandidate).printArguments(this.fResolver, true, null, false, true, MethodSignatureUseCase.CONTENT_ASSIST_PROPOSAL, false);
        this.functionArguments = ((RfFunction)this.fCandidate).printArguments(this.fResolver, true, null, false, true, MethodSignatureUseCase.CONTENT_ASSIST_PROPOSAL, false);
        this.fDisplayString = String.valueOf(this.getEscName((RfFunction)this.fCandidate)) + "(" + displayArguments + "): " + type;
        if (hasExtern) {
            String replacementArguments = ((RfFunction)this.fCandidate).printArguments(this.fResolver, true, null, false, true, MethodSignatureUseCase.METHOD_OVERRIDE_CODE_GENERATION, false);
            this.fReplacementString = String.valueOf(this.getEscName((RfFunction)this.fCandidate)) + "(" + replacementArguments + ")";
            this.fReplacementString = String.valueOf(this.fReplacementString) + ";";
            this.fCandidateHasSemiColon = true;
        } else {
            this.fReplacementString = functionSignature;
        }
        Matcher matcher = DVTStringUtil.JAVADOC.matcher(this.fReplacementString);
        if (matcher.find() && (matcher.start() == 0 || addedSpace && matcher.start() == 1)) {
            String insertOffsetIndent = DVTDocumentUtils.getIndent((int)this.fOffset, (IDocument)this.fDocument);
            this.fJavaDocComment = String.valueOf(DVTStringUtil.mapSplitLines((String)matcher.group(), (String)lineDelimiter, (line, index) -> String.valueOf(insertOffsetIndent) + line)) + lineDelimiter;
            this.fReplacementString = String.valueOf(addedSpace ? " " : "") + this.fReplacementString.substring(matcher.end() + lineDelimiter.length());
        }
    }

    private void handleOverrideConstraint(IEditorPart editor, String lineDelimiter) {
        boolean hasConstraintKeyword = ((R2LOverrideConstraint)this.fCandidate).hasConstraintKeyword();
        boolean hasExtern = ((R2LOverrideConstraint)this.fCandidate).hasExtern();
        boolean isStatic = ((R2LOverrideConstraint)this.fCandidate).isStatic();
        this.fCandidate = ((R2LOverrideConstraint)this.fCandidate).getConstraint();
        this.isConstraintOverride = true;
        RfNamedElement enclosingScope = null;
        if (this.fInitialScope instanceof IRfNamedElement) {
            enclosingScope = (RfNamedElement)this.fInitialScope;
        } else if (this.fInitialScope instanceof IRfDefElement) {
            enclosingScope = (RfNamedElement)((IRfDefElement)this.fInitialScope).getNamedElement();
        }
        String constraintSignature = "";
        try {
            if (hasConstraintKeyword) {
                int previousCharOffset;
                IRegion regionOfPrecedingConstraintKeyword = null;
                VlogWordFinder wordFinder = VlogWordFinder.getDefault();
                int currentOffset = this.fOffset - this.fPrefix.length() - 1;
                do {
                    if ((regionOfPrecedingConstraintKeyword = wordFinder.getWordAtOffset(this.fDocument, previousCharOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)this.fDocument, (int)currentOffset, (boolean)false, (String)"__vlog_partitioning", (boolean)false, (boolean)true))) == null || previousCharOffset == -1) continue;
                    currentOffset = regionOfPrecedingConstraintKeyword.getOffset() - 1;
                } while (previousCharOffset != -1);
                ++currentOffset;
                if (this.fDocument != null) {
                    this.fPrefix = this.fDocument.get(currentOffset, this.fOffset - currentOffset);
                }
            }
            constraintSignature = hasExtern ? VlogConstraintUtils.computeConstraintPrototype(this.fEditor, this.fDocument, (RfConstraint)this.fCandidate, this.fOffset, true, isStatic, false, true) : VlogConstraintUtils.computeOverrideImplementationStub(enclosingScope, (RfConstraint)this.fCandidate, this.fOffset, editor, false, isStatic);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (constraintSignature.contains("${")) {
            this.fUseTemplate = true;
        }
        this.fDisplayString = this.getEscName((RfConstraint)this.fCandidate);
        this.fReplacementString = constraintSignature;
        Matcher matcher = DVTStringUtil.JAVADOC.matcher(this.fReplacementString);
        String insertOffsetIndent = DVTDocumentUtils.getIndent((int)this.fOffset, (IDocument)this.fDocument);
        if (matcher.find() && matcher.start() == 0) {
            this.fJavaDocComment = String.valueOf(DVTStringUtil.mapSplitLines((String)matcher.group(), (String)lineDelimiter, (line, index) -> String.valueOf(insertOffsetIndent) + line)) + lineDelimiter;
            this.fReplacementString = this.fReplacementString.substring(matcher.end() + lineDelimiter.length());
        }
    }

    private String getFunctionArgumentsReplacement(String lineDelimiter) {
        String replacementString = "";
        if (!(this.fCandidate instanceof RfFunction)) {
            return replacementString;
        }
        List<RfField> arguments = ((RfFunction)this.fCandidate).getArgumentsWithPrefix("", 2);
        if (arguments == null || arguments.isEmpty()) {
            return String.valueOf(replacementString) + "()";
        }
        boolean insertNamedArgumentsAsMultiline = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.multi_line_named_arguments");
        boolean insertOrderedArgumentsAsMultiline = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.multi_line_ordered_arguments");
        if (!Utils.isContentAssistInsertNamedArguments()) {
            String argumentsString = ((RfFunction)this.fCandidate).printArguments(this.fResolver, this.fOffset, false, this.fInitialScope, true, false, MethodSignatureUseCase.METHOD_CALL, this.fTypeCompatibleArgument, this.fInsertOptionalArguments);
            if (argumentsString == null) {
                return "()";
            }
            argumentsString = this.removeTrailingCommas(argumentsString);
            if (insertOrderedArgumentsAsMultiline) {
                argumentsString = argumentsString.replaceAll(", ", ", " + lineDelimiter);
            }
            replacementString = argumentsString.isEmpty() ? String.valueOf(replacementString) + "()" : String.valueOf(replacementString) + (insertOrderedArgumentsAsMultiline ? "(" + lineDelimiter : "(") + argumentsString + (insertOrderedArgumentsAsMultiline ? String.valueOf(lineDelimiter) + ")" : ")");
        } else {
            replacementString = String.valueOf(replacementString) + "(";
            if (arguments.size() == 1) {
                boolean hasInitialValue = arguments.get(0).getInitialValue(false) != null;
                String argumentName = arguments.get(0).getName();
                if (argumentName == null) {
                    return "()";
                }
                replacementString = String.valueOf(replacementString) + (!hasInitialValue || this.fInsertOptionalArguments ? "." + argumentName + "(${" + argumentName + "})" : "");
                replacementString = String.valueOf(replacementString) + ")";
            } else {
                Iterator<RfField> it = arguments.iterator();
                while (it.hasNext()) {
                    RfField element = it.next();
                    String elementName = element.getName();
                    if (elementName == null) continue;
                    boolean hasInitialValue = element.getInitialValue(false) != null;
                    String namedArgumentReplacement = insertNamedArgumentsAsMultiline ? String.valueOf(lineDelimiter) + "." + elementName + "(${" + elementName + "})" : "." + elementName + "(${" + elementName + "})";
                    replacementString = String.valueOf(replacementString) + (!hasInitialValue || this.fInsertOptionalArguments ? namedArgumentReplacement : "");
                    if (!it.hasNext() || hasInitialValue && !this.fInsertOptionalArguments) continue;
                    replacementString = String.valueOf(replacementString) + ", ";
                }
                replacementString = this.removeTrailingCommas(replacementString);
                replacementString = String.valueOf(replacementString) + (insertNamedArgumentsAsMultiline ? String.valueOf(lineDelimiter) + ")" : ")");
            }
        }
        return replacementString;
    }

    protected String removeTrailingCommas(String replacementString) {
        if (replacementString.isEmpty() || !replacementString.endsWith(", ")) {
            return replacementString;
        }
        int index = replacementString.length() - 1;
        while (index >= 0 && (replacementString.charAt(index) == ' ' || replacementString.charAt(index) == ',')) {
            --index;
        }
        replacementString = replacementString.substring(0, index + 1);
        return replacementString;
    }

    private String getEscName(IRfNamedElement element) {
        boolean isEscaped = element.isEscaped();
        return isEscaped ? "\\" + element.getName() + " " : element.getName();
    }

    private StringBuilder textWrap(int lineLength, String text) {
        return DVTStringUtil.textWrap((int)lineLength, (String)text);
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    protected String partiallyEscapeHTML(String input) {
        return DVTStringUtil.partiallyEscapeHTML((String)input);
    }

    protected abstract String getEscapedDollarSign();

    protected abstract IEditorPart getEditor();

    protected String isImplementOrOverride() {
        if (this.isMethodOverride) {
            RfFunction function = (RfFunction)this.fCandidate;
            if (function.isPredefined()) {
                if (function.isConstructor()) {
                    return "Implement ";
                }
                RfFunction parentFunction = RfBatchUtils.getParentPredefinedFunction(function, true);
                if (parentFunction == null) {
                    return "Implement ";
                }
                return "Override ";
            }
            if (function.isPure()) {
                return "Implement ";
            }
            if (function.isVirtual() || function.isConstructor()) {
                return "Override ";
            }
        }
        if (this.isExternMethodImplementation) {
            return "Implement ";
        }
        if (this.isConstraintOverride) {
            return "Override ";
        }
        return "";
    }

    protected String getStringForStyledDisplay() {
        if (this.isConstraintOverride) {
            StringBuilder infoString = new StringBuilder();
            infoString.append(this.isImplementOrOverride());
            infoString.append("constraint");
            this.appendClassType((RfConstraint)this.fCandidate, infoString);
            return infoString.toString();
        }
        if (!this.isMethodOverride && !this.isExternMethodImplementation) {
            return "";
        }
        RfFunction function = (RfFunction)this.fCandidate;
        StringBuilder infoString = new StringBuilder();
        infoString.append(this.isImplementOrOverride());
        if (this.isMethodOverride && function.isPredefined()) {
            infoString.append("predefined ");
        } else if (this.isExternMethodImplementation) {
            infoString.append("extern ");
        }
        if (function.isConstructor()) {
            infoString.append("constructor");
        } else if (function.isTask()) {
            infoString.append("task");
        } else {
            infoString.append("function");
        }
        if (!function.isPredefined()) {
            this.appendClassType(function, infoString);
        }
        return infoString.toString();
    }

    private void appendClassType(RfNamedElement element, StringBuilder infoString) {
        HashSet<Class<RfPredefinedClass>> validScopes = new HashSet<Class<RfPredefinedClass>>();
        validScopes.add(RfClass.class);
        validScopes.add(RfSpecializedClass.class);
        validScopes.add(RfPredefinedClass.class);
        RfClass enclosingClass = (RfClass)element.getEnclosingScope(validScopes);
        if (enclosingClass == null) {
            return;
        }
        infoString.append(" from ");
        String classType = enclosingClass.isInterfaceClass() ? "interface class" : "class";
        infoString.append(String.valueOf(classType) + " '" + enclosingClass.getName() + "'");
    }

    protected ParserPath getParserPath() {
        return this.fParserPath;
    }

    public boolean hasOverrideConstraintCandidate() {
        return this.fCandidate instanceof R2LOverrideConstraint;
    }
}

