/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.contentasisst.IRfContentAssistProcessor;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.r2lparser.R2LManager;
import ro.amiq.vlogdt.r2lparser.R2LProposalManager;
import ro.amiq.vlogdt.r2lparser.R2LResultContainer;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.contentassist.RfLazyCompletionProposal;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistProcessorManager;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtilCommon;

public class RfContentAssistProcessor
implements IRfContentAssistProcessor,
IContentAssistProcessor {
    private VlogContentAssistProcessorManager fProcessor;
    public boolean fAllowProposals;

    public RfContentAssistProcessor(VlogContentAssistProcessorManager processor) {
        this.fProcessor = processor;
    }

    public VlogContentAssistProcessorManager getProcessor() {
        return this.fProcessor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals;
        block7: {
            block6: {
                RfProject rfProject;
                block5: {
                    try {
                        rfProject = this.fProcessor.getRfProject();
                        if (rfProject != null) break block5;
                        return null;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return null;
                    }
                }
                if (DVTPlugin.getDefault().collect().c(rfProject.getProject(), "F7376")) break block6;
                return null;
            }
            proposals = this.getProposals(viewer, offset);
            if (proposals != null) break block7;
            return null;
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ICompletionProposal[] getProposals(ITextViewer viewer, int offset) {
        VlogEditor editor = this.fProcessor.getEditor();
        if (editor == null) {
            return null;
        }
        IDocument document = viewer.getDocument();
        try {
            if (this.fProcessor.isCanceled()) {
                return null;
            }
            if (document == null) {
                return null;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)this.fProcessor.getFile());
            if (parserPath == null) {
                return null;
            }
            R2LProposalManager manager = new R2LProposalManager(this.fProcessor.getEditor(), this.fProcessor.getRfProject(), this.fProcessor.getInitialScope(), this.fProcessor.getInstanceScope(), parserPath, document, offset);
            R2LResultContainer container = ((R2LManager)manager).getProposals();
            if (container == null) {
                return null;
            }
            if (this.fProcessor.isCanceled()) {
                return null;
            }
            IRfNamedElement[] allCandidates = container.candidates;
            File[] fileCandidates = container.fileCandidates;
            this.fAllowProposals = container.allowProposals();
            if (this.fProcessor.isCanceled()) {
                return null;
            }
            if (fileCandidates != null) {
                return this.getIncludeProposals(viewer, fileCandidates, offset, container.prefix, false, false);
            }
            if (allCandidates == null || allCandidates.length == 0) {
                return null;
            }
            ArrayList<IRfNamedElement> candidatesWithoutDuplicates = new ArrayList<IRfNamedElement>();
            candidatesWithoutDuplicates.add(allCandidates[0]);
            IRfNamedElement previousCandidate = allCandidates[0];
            int i = 1;
            while (true) {
                if (i >= allCandidates.length) {
                    if (!this.fProcessor.isCanceled()) break;
                    return null;
                }
                if (this.fProcessor.isCanceled()) {
                    return null;
                }
                IRfNamedElement currentCandidate = allCandidates[i];
                if (!currentCandidate.getName().equals(previousCandidate.getName()) || !currentCandidate.getSignature().equals(previousCandidate.getSignature())) {
                    candidatesWithoutDuplicates.add(currentCandidate);
                    previousCandidate = currentCandidate;
                }
                ++i;
            }
            return this.getCompletionProposals(container.resolver, viewer, document, candidatesWithoutDuplicates, container.prefix, offset, container.isImport, container.isExtern, container.rule);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ICompletionProposal[] getStringIncludeProposals(ITextViewer viewer, File[] files, int offset, String prefix, boolean addEndQuotes) {
        return this.getIncludeProposals(viewer, files, offset, prefix, true, addEndQuotes);
    }

    protected ICompletionProposal[] getIncludeProposals(ITextViewer viewer, File[] files, int offset, String prefix, boolean fromStringCotentAssistProcessor, boolean addEndQuotes) {
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        if (prefix == null) {
            prefix = "";
        }
        String replacementStringPrefix = prefix.contains(File.separator) ? prefix.replaceFirst(String.valueOf(File.separator) + "[^" + File.separator + "]*$", File.separator) : "";
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (file == R2LProposalManager.DUMMY_TIMEOUT_FILE) {
                result.add(0, new CompletionProposal(viewer, prefix, offset - prefix.length(), prefix.length(), prefix.length(), DVTImages.imageCache.getImage(DVTImages.INFORMATION), "The time needed for this task exceeds 2000 ms.", null, "For performance reasons, only showing a limited set of results...", false));
            } else if (file == R2LProposalManager.DUMMY_NUMBER_FILE) {
                result.add(0, new CompletionProposal(viewer, prefix, offset - prefix.length(), prefix.length(), prefix.length(), DVTImages.imageCache.getImage(DVTImages.INFORMATION), "Only showing 20 entries per folder.", null, "For performance reasons, only showing a limited set of results...", false));
            } else {
                Image icon;
                String replacementString;
                if (file.isDirectory()) {
                    replacementString = String.valueOf(replacementStringPrefix) + fileName + File.separator;
                    icon = DVTImages.imageCache.getImage(DVTImages.DESC_FOLDER);
                } else {
                    replacementString = String.valueOf(replacementStringPrefix) + fileName + (addEndQuotes ? "\"" : "");
                    if (!fromStringCotentAssistProcessor) {
                        replacementString = "\"" + replacementString + "\"";
                    }
                    icon = DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE);
                }
                result.add(new CompletionProposal(viewer, replacementString, offset - prefix.length(), prefix.length(), replacementString.length(), icon, fileName, null, String.valueOf(file.getAbsolutePath()) + (file.isDirectory() ? "/" : ""), file.isDirectory()));
            }
            ++n2;
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    protected ICompletionProposal[] getCompletionProposals(RfTypesResolver resolver, ITextViewer viewer, IDocument document, ArrayList<IRfNamedElement> candidates, String prefix, int offset, boolean isImport, boolean isExtern, int rule) {
        if (candidates == null) {
            return null;
        }
        boolean typeCompatibleArgument = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.type_compatible_argument");
        boolean insertOptionalArguments = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.insert_optional_arguments");
        RfLazyCompletionProposal[] result = new RfLazyCompletionProposal[candidates.size()];
        IFile file = this.fProcessor.getFile();
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        int line = VlogContentAssistUtilCommon.getLineOfOffset(document, offset);
        int i = 0;
        while (i < candidates.size()) {
            result[i] = new RfLazyCompletionProposal(RfTypesResolver.create(resolver), viewer, document, this.fProcessor.getInitialScope(), candidates.get(i), prefix, offset, isImport, isExtern, rule, typeCompatibleArgument, insertOptionalArguments, null, line, parserPath);
            ++i;
        }
        return result;
    }

    public static final class CompletionProposal
    implements ICompletionProposal,
    ICompletionProposalExtension4 {
        private String fDisplayString;
        private String fReplacementString;
        private int fReplacementOffset;
        private int fReplacementLength;
        private int fCursorPosition;
        private Image fImage;
        private IContextInformation fContextInformation;
        private String fAdditionalProposalInfo;
        private boolean fInvokeAgain;
        private ITextViewer fViewer;

        private CompletionProposal(ITextViewer viewer, String replacementString, int replacementOffset, int replacementLength, int cursorPosition, Image image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, boolean invokeAgain) {
            Assert.isNotNull((Object)replacementString);
            Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
            Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
            Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
            this.fReplacementString = replacementString;
            this.fReplacementOffset = replacementOffset;
            this.fReplacementLength = replacementLength;
            this.fCursorPosition = cursorPosition;
            this.fImage = image;
            this.fDisplayString = displayString;
            this.fContextInformation = contextInformation;
            this.fAdditionalProposalInfo = additionalProposalInfo;
            this.fInvokeAgain = invokeAgain;
            this.fViewer = viewer;
        }

        public void apply(IDocument document) {
            try {
                DVTFileModificationValidator.validateEdit((ITextViewer)this.fViewer);
                document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            }
            catch (CoreException | BadLocationException throwable) {}
            if (this.fInvokeAgain) {
                if (!(this.fViewer instanceof DVTProjectionViewer)) {
                    return;
                }
                UIJob job = new UIJob("CA Trigger"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        ((DVTProjectionViewer)fViewer).doOperation(13);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule(100L);
            }
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }

        public IContextInformation getContextInformation() {
            return this.fContextInformation;
        }

        public Image getImage() {
            return this.fImage;
        }

        public String getDisplayString() {
            if (this.fDisplayString != null) {
                return this.fDisplayString;
            }
            return this.fReplacementString;
        }

        public String getReplacementString() {
            return this.fReplacementString;
        }

        public String getAdditionalProposalInfo() {
            return this.fAdditionalProposalInfo;
        }

        public boolean isAutoInsertable() {
            return true;
        }

        public int getReplacementOffset() {
            return this.fReplacementOffset;
        }

        public int getReplacementLength() {
            return this.fReplacementLength;
        }
    }
}

