/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.VlogModule;
import ro.amiq.vlogdt.model.reflection.RfYVModuleDummy;
import ro.amiq.vlogdt.ui.editor.contentassist.RfLazyAutoInstanceProposalCommon;

public class RfLazyAutoInstanceProposal
extends RfLazyAutoInstanceProposalCommon {
    private StyledString styledDisplayString;

    public RfLazyAutoInstanceProposal(ITextViewer viewer, TemplateContext context, Region region, IRfDesignElement candidate, boolean showLibrary, String replacementString, Image image, boolean dontExpandMacrosInSignalDimensions, IRfScopeElement scope, IContextInformation contextInformation) {
        super(viewer, context, region, candidate, showLibrary, replacementString, image, dontExpandMacrosInSignalDimensions, scope, contextInformation);
        this.styledDisplayString = new StyledString(this.displayString);
        if (showLibrary) {
            this.styledDisplayString.append(new StyledString(" - " + candidate.getEnclosingLibrary().getName(), StyledString.QUALIFIER_STYLER));
        }
    }

    public void apply(IDocument document) {
        try {
            DVTFileModificationValidator.validateEdit((ITextViewer)this.textViewer);
            if (this.candidate instanceof RfYVModuleDummy) {
                this.incrementalCompileCandidate((RfYVModuleDummy)this.candidate);
            }
            this.computeReplacementString(true);
            this.templateProposal = null;
            Template template = new Template("", this.displayString, "ro.amiq.vlogdt.templates.contextType.unknown", this.replacementString, true);
            this.templateProposal = new TemplateProposal(template, this.context, (IRegion)this.region, this.image, 1);
            this.templateProposal.apply(this.textViewer, '\u0000', 0, this.region.getOffset());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected String getNewLineReplacement() {
        return "<br>";
    }

    @Override
    public StyledString getStyledDisplayString() {
        return this.styledDisplayString;
    }

    public void incrementalCompileCandidate(RfYVModuleDummy candidate) {
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.run(true, true, monitor -> {
                monitor.beginTask("Incremental compile candidate ...", -1);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                String fileName = candidate.getDeclarationFile();
                if (fileName == null) {
                    return;
                }
                IPath path = Path.fromOSString((String)fileName);
                IFile iFile = root.getFileForLocation(path);
                this.computeCandidate(candidate, iFile, monitor);
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void computeCandidate(RfYVModuleDummy candidate, IFile file, IProgressMonitor monitor) {
        IVlogModule vlogFile = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule(file);
        if (vlogFile == null) {
            return;
        }
        String unresolvedElement = candidate.getName();
        ((VlogModule)vlogFile).reparse(monitor, unresolvedElement);
    }
}

