/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.ui.editor.contentasisst.IAutoinstanceProposal;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.CharBufferCacher;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogAutoInstanceContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtil;

public abstract class RfLazyAutoInstanceProposalCommon
implements IAutoinstanceProposal,
ICompletionProposal,
ICompletionProposalExtension6 {
    protected String replacementString;
    protected String displayString;
    protected Image image;
    protected int cursorPosition;
    protected IContextInformation contextInformation;
    protected ITextViewer textViewer;
    protected TemplateProposal templateProposal;
    protected IRfDesignElement candidate;
    protected TemplateContext context;
    protected Region region;
    protected boolean dontExpandMacros;
    protected IRfScopeElement scope;
    protected List<BuildConfigProperty> unresolvedLibs;
    protected RfProject rfProject;

    protected RfLazyAutoInstanceProposalCommon(ITextViewer viewer, TemplateContext context, Region region, IRfDesignElement candidate, boolean showLibrary, String replacementString, Image image, boolean dontExpandMacrosInSignalDimensions, IRfScopeElement scope, IContextInformation contextInformation, List<BuildConfigProperty> unresolvedLibs, RfProject rfProject) {
        this(viewer, context, region, candidate, showLibrary, replacementString, image, dontExpandMacrosInSignalDimensions, scope, contextInformation);
        this.unresolvedLibs = unresolvedLibs;
        this.rfProject = rfProject;
    }

    protected RfLazyAutoInstanceProposalCommon(ITextViewer viewer, TemplateContext context, Region region, IRfDesignElement candidate, boolean showLibrary, String replacementString, Image image, boolean dontExpandMacrosInSignalDimensions, IRfScopeElement scope, IContextInformation contextInformation) {
        this.textViewer = viewer;
        this.candidate = candidate;
        this.contextInformation = contextInformation;
        this.replacementString = replacementString;
        this.displayString = VlogContentAssistUtil.getEscName((IRfNamedElement)candidate);
        if (showLibrary) {
            this.displayString = String.valueOf(this.displayString) + " - " + candidate.getEnclosingLibrary().getName();
        }
        this.image = image;
        this.dontExpandMacros = dontExpandMacrosInSignalDimensions;
        this.scope = scope;
        this.cursorPosition = 0;
        this.region = region;
        this.context = context;
    }

    public Point getSelection(IDocument document) {
        if (this.templateProposal == null) {
            return new Point(this.region.getOffset() + this.cursorPosition, 0);
        }
        return this.templateProposal.getSelection(document);
    }

    public IContextInformation getContextInformation() {
        if (this.templateProposal == null) {
            return this.contextInformation;
        }
        return this.templateProposal.getContextInformation();
    }

    public Image getImage() {
        return this.image;
    }

    public String getAdditionalProposalInfo() {
        if (this.replacementString.length() > 1000) {
            return String.valueOf(this.replacementString.substring(0, 600).replace("\n", this.getNewLineReplacement())) + "...";
        }
        return this.replacementString.replace("$$", "$").replace("\n", this.getNewLineReplacement());
    }

    public String getDisplayString() {
        return this.displayString;
    }

    protected abstract String getNewLineReplacement();

    public IRfDesignElement getCandidate() {
        return this.candidate;
    }

    public boolean getDontExpandMacros() {
        return this.dontExpandMacros;
    }

    public StyledString getStyledDisplayString() {
        return new StyledString(this.getDisplayString());
    }

    protected void computeReplacementString(boolean isApply) {
        if (this.dontExpandMacros) {
            try {
                String replacementString = VlogAutoInstanceContentAssistProcessor.newProposal(this.textViewer, this.region.getOffset(), this.candidate, this.dontExpandMacros, this.scope, isApply);
                if (replacementString != null) {
                    this.replacementString = replacementString;
                }
            }
            finally {
                CharBufferCacher.getInstance().clearCache();
            }
        }
    }
}

