/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import antlr.Token;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.VlogModule;
import ro.amiq.vlogdt.model.reflection.RfProject;

public abstract class RfLazyAutoinstanceComputeModulesProposalUtilsCommon {
    public void scanLibraries(IProgressMonitor monitor, RfProject rfProject, String libFileName, int libKind) {
        IPath path = Path.fromOSString((String)libFileName);
        IFile file = this.getFile(path);
        if (libKind == 5) {
            Map<String, Map<Token, Token>> cacheDefinedElements = this.scanLibrary(monitor, file);
            rfProject.addModulesByLibrary(libFileName, libFileName, new TreeSet<String>(cacheDefinedElements.keySet()));
            return;
        }
        Set filesInDirectory = Stream.of(path.toFile().listFiles()).filter(dirFile -> !dirFile.isDirectory()).map(File::getAbsolutePath).collect(Collectors.toSet());
        for (String fileName : filesInDirectory) {
            if (monitor.isCanceled()) break;
            path = Path.fromOSString((String)fileName);
            file = this.getFile(path);
            Map<String, Map<Token, Token>> cacheDefinedElements = this.scanLibrary(monitor, file);
            rfProject.addModulesByLibrary(libFileName, fileName, new TreeSet<String>(cacheDefinedElements.keySet()));
        }
    }

    protected Map<String, Map<Token, Token>> scanLibrary(IProgressMonitor monitor, IFile file) {
        IVlogModule vlogFile = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule(file);
        if (vlogFile == null) {
            return new HashMap<String, Map<Token, Token>>();
        }
        HashMap<String, Map<Token, Token>> cacheDefinedElements = new HashMap<String, Map<Token, Token>>();
        ((VlogModule)vlogFile).reparseLibFile(cacheDefinedElements, monitor);
        return cacheDefinedElements;
    }

    public void computeCandidate(String moduleName, String fileName, IProgressMonitor monitor) {
        if (fileName == null) {
            return;
        }
        IPath path = Path.fromOSString((String)fileName);
        IFile iFile = this.getFile(path);
        this.computeCandidate(moduleName, iFile, monitor);
    }

    private void computeCandidate(String moduleName, IFile file, IProgressMonitor monitor) {
        IVlogModule vlogFile = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule(file);
        if (vlogFile == null) {
            return;
        }
        ((VlogModule)vlogFile).reparse(monitor, moduleName);
    }

    protected abstract IFile getFile(IPath var1);
}

