/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTProposalContextInformation;
import ro.amiq.dvt.ui.editor.DvtContextInformationType;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTExitPolicyConfig;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.dvt.utils.CommentUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FieldEditor;
import ro.amiq.vlogdt.r2lparser.R2LDummyElement;
import ro.amiq.vlogdt.r2lparser.R2LFEBaseOperationProposal;
import ro.amiq.vlogdt.r2lparser.R2LOverrideWizardConstraint;
import ro.amiq.vlogdt.r2lparser.R2LOverrideWizardMethod;
import ro.amiq.vlogdt.r2lparser.R2LUvmOvmFieldEditorElement;
import ro.amiq.vlogdt.r2lparser.strategies.VlogR2LCache;
import ro.amiq.vlogdt.ui.editor.actions.GenerateGetterSetter;
import ro.amiq.vlogdt.ui.editor.actions.OverrideAction;
import ro.amiq.vlogdt.ui.editor.contentassist.RFLazyCompletionProposalCommon;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtil;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtilCommon;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogParameterHintsUtils;

public class RfLazyCompletionProposal
extends RFLazyCompletionProposalCommon {
    private DVTLinkedPositionProvider fLinkedPositionProvider;
    private TemplateProposal fTemplateProposal;
    private static final String CATEGORY = "CONTENT_ASSIST_PROPOSAL";

    public RfLazyCompletionProposal(RfTypesResolver resolver, ITextViewer viewer, IDocument document, IRfScope scope, Object candidate, String currentWord, int offset, boolean isImport, boolean isExtern, int rule, boolean typeCompatibleArgument, boolean insertOptionalArguments, IContextInformation contextInformation, int line, ParserPath parserPath) {
        super(resolver, viewer, document, scope, candidate, currentWord, offset, isImport, isExtern, rule, typeCompatibleArgument, insertOptionalArguments, contextInformation, line, parserPath);
        if (this.fTextViewer instanceof DVTProjectionViewer) {
            this.fEditor = ((DVTProjectionViewer)this.fTextViewer).getEditor();
        } else {
            IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
            if (activeEditor instanceof DVTEditor) {
                this.fEditor = (DVTEditor)activeEditor;
            }
        }
        this.fLinkedPositionProvider = new DVTLinkedPositionProvider(this.fEditor, new LinkedModeModel(), CATEGORY + this.toString(), false);
    }

    public void apply(IDocument document) {
        try {
            IWorkbenchPage page;
            int charOffset;
            Object[] charOffsetPair;
            DVTFileModificationValidator.validateEdit((ITextViewer)this.fTextViewer);
            if (!(this.fPrefix.isEmpty() || this.isMethodOverride || this.isExternMethodImplementation || this.isConstraintOverride || (charOffsetPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)document, (int)this.fOffset, (boolean)false, (String)"__vlog_partitioning")) == null || (charOffset = ((Integer)charOffsetPair[1]).intValue()) >= this.fReplacementOffset + this.fPrefix.length())) {
                this.fReplacementOffset = charOffset - this.fPrefix.length();
            }
            this.fTemplateProposal = null;
            this.internalComputeProposal();
            if (this.fCandidate instanceof R2LDummyElement) {
                return;
            }
            if (this.fOpenOvmUvmFieldEditor) {
                R2LUvmOvmFieldEditorElement r2lUvmOvmFieldEditorElement = (R2LUvmOvmFieldEditorElement)this.fCandidate;
                FEConstants constants = FEConstants.getInstance(r2lUvmOvmFieldEditorElement.getMethodology());
                Shell shell = DVTPlugin.getActiveWorkbenchShell();
                if (shell == null) {
                    return;
                }
                RfProject rfProject = r2lUvmOvmFieldEditorElement.getRfProject();
                RfClass clazz = r2lUvmOvmFieldEditorElement.getRfClass();
                FieldEditor fieldEditor = new FieldEditor(shell, document, (ITextEditor)this.fEditor, this.fCursorPosition, rfProject, clazz, null, constants);
                fieldEditor.open();
                this.fOpenOvmUvmFieldEditor = false;
                return;
            }
            if (this.fOpenGetterSetter) {
                page = DVTPlugin.getActivePage();
                IEditorPart part = page.getActiveEditor();
                if (!(part instanceof AbstractTextEditor)) {
                    return;
                }
                ITextEditor editor = (ITextEditor)part;
                IAction a = editor.getAction("GetterSetter");
                if (a instanceof GenerateGetterSetter) {
                    ((GenerateGetterSetter)a).setReplacementPrefix(this.fPrefix);
                    a.run();
                    this.fCursorPosition = ((GenerateGetterSetter)a).getCursorPosition();
                    ((GenerateGetterSetter)a).setReplacementPrefix("");
                }
                this.fOpenGetterSetter = false;
                return;
            }
            if (this.fOpenOverrideWizardDialog) {
                page = DVTPlugin.getActivePage();
                IEditorPart part = page.getActiveEditor();
                if (!(part instanceof AbstractTextEditor)) {
                    return;
                }
                ITextEditor editor = (ITextEditor)part;
                IAction a = null;
                if (this.fCandidate instanceof R2LOverrideWizardMethod) {
                    a = editor.getAction("OverrideMethods");
                } else if (this.fCandidate instanceof R2LOverrideWizardConstraint) {
                    a = editor.getAction("OverrideConstraints");
                }
                if (a instanceof OverrideAction) {
                    OverrideAction action = (OverrideAction)a;
                    action.setReplacementPrefix(this.fPrefix);
                    action.setLinkedPositionProvider(this.fLinkedPositionProvider);
                    action.run();
                    VlogContentAssistUtilCommon.LinkedPositionResult result = action.getLinkedPositionResult();
                    if (result != null) {
                        IRegion firstLinkedRegion = result.firstLinkedRegion;
                        if (firstLinkedRegion != null) {
                            this.fTemplateProposal = result.templateProposal;
                            this.fLinkedPositionProvider.setHasPositions(true);
                            this.firstParameterOffset = firstLinkedRegion.getOffset();
                            this.firstParameterLength = firstLinkedRegion.getLength();
                            DVTExitPolicyConfig config = new DVTExitPolicyConfig(true, ';', this.firstParameterOffset, "__vlog_partitioning");
                            this.fLinkedPositionProvider.enterLinkedMode(document, config);
                        } else {
                            this.fCursorPosition = result.cursorPosition;
                        }
                    }
                    action.setReplacementPrefix("");
                }
                this.fOpenOverrideWizardDialog = false;
                return;
            }
            int javadocInsertOffset = -1;
            if (this.fJavaDocComment != null && !this.fJavaDocComment.isEmpty() && this.fInitialScope instanceof RfDefElement && (javadocInsertOffset = document.getLineOffset(document.getLineOfOffset(this.fOffset))) >= 0) {
                document.replace(javadocInsertOffset, 0, this.fJavaDocComment);
                this.fReplacementOffset += this.fJavaDocComment.length();
            }
            if (this.fUseTemplate) {
                DVTExitPolicyConfig config;
                boolean disableFormatting = this.isMethodOverride || this.fCandidate instanceof R2LFEBaseOperationProposal || this.isExternMethodImplementation;
                VlogContentAssistUtilCommon.LinkedPositionResult result = new VlogContentAssistUtil.LinkedPositionBuilder().withEditor(this.fEditor).withProvider(this.fLinkedPositionProvider).withReplacementText(this.fReplacementString).withReplacementOffset(this.fReplacementOffset).withReplacementLength(this.fReplacementLength).withDisableFormatting(disableFormatting).build();
                if (result == null) {
                    return;
                }
                IRegion firstLinkedRegion = result.firstLinkedRegion;
                if (firstLinkedRegion == null) {
                    return;
                }
                this.fTemplateProposal = result.templateProposal;
                this.fLinkedPositionProvider.setHasPositions(true);
                this.firstParameterOffset = firstLinkedRegion.getOffset();
                this.firstParameterLength = firstLinkedRegion.getLength();
                if (this.fCandidate instanceof R2LFEBaseOperationProposal) {
                    int destinationLine = document.getLineOfOffset(this.fReplacementOffset) + this.fReplacementString.split(DVTDocumentCommon.getLineDelimiter((IEditorPart)this.fEditor)).length;
                    config = new DVTExitPolicyConfig(false, 0, "__vlog_partitioning");
                    config.setReturnToLine(true);
                    config.setLine(destinationLine);
                } else {
                    char configChar;
                    int configOffset;
                    if (this.isMethodOverride) {
                        configOffset = this.firstParameterOffset;
                        configChar = ';';
                    } else {
                        configOffset = this.fReplacementOffset;
                        configChar = this.fCandidateHasSemiColon ? (char)';' : ')';
                        this.computeContextInformation();
                    }
                    config = new DVTExitPolicyConfig(true, configChar, configOffset, "__vlog_partitioning");
                }
                this.fLinkedPositionProvider.enterLinkedMode(document, config);
                this.attemptCandidateCaching();
                return;
            }
            if (this.fCandidate instanceof RfNamedElement && this.fPrefix.isEmpty() && this.fOffset > 0 && Character.isJavaIdentifierPart(document.getChar(this.fOffset - 1))) {
                this.fReplacementString = " " + this.fReplacementString;
                ++this.fCursorPosition;
            }
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
            this.attemptCandidateCaching();
        }
        catch (CoreException | BadLocationException | BadPositionCategoryException | TemplateException throwable) {}
    }

    private void computeContextInformation() {
        String functionName = "";
        if (this.fCandidate instanceof RfNamedElement) {
            functionName = ((RfNamedElement)this.fCandidate).getName();
        }
        int contextInformationStartOffset = VlogParameterHintsUtils.getInstance().getContextInformationOffset(this.fDocument, this.fReplacementOffset, this.fInitialScope, functionName, this.fEditor, false, true, false);
        int contextInformationEndOffset = VlogParameterHintsUtils.getInstance().getContextInformationOffset(this.fDocument, this.fReplacementOffset, this.fInitialScope, functionName, this.fEditor, true, true, false) - 1;
        if (contextInformationStartOffset >= 0 && contextInformationEndOffset >= 0 && this.functionArguments != null) {
            this.fContextInformation = new DVTProposalContextInformation(DvtContextInformationType.ARGUMENTS_OR_ORDERED_PORT_CONNECTIONS, this.fDisplayString, this.functionArguments, contextInformationStartOffset, contextInformationEndOffset - contextInformationStartOffset, "__vlog_partitioning");
        }
    }

    private boolean attemptCandidateCaching() {
        boolean cacheEnabled = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.use_proposal_caching");
        if (!cacheEnabled) {
            return false;
        }
        if (!(this.fCandidate instanceof RfNamedElement)) {
            return false;
        }
        RfNamedElement namedElement = (RfNamedElement)this.fCandidate;
        RfFileDef file = namedElement.getFile();
        if (file == null) {
            return false;
        }
        ParserPath parserPath = this.getParserPath();
        if (parserPath == null) {
            return false;
        }
        return VlogR2LCache.getInstance().attemptCaching(parserPath, namedElement);
    }

    public Point getSelection(IDocument document) {
        this.internalComputeProposal();
        if (this.fTemplateProposal == null || !this.fLinkedPositionProvider.hasPositions()) {
            return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
        }
        return new Point(this.firstParameterOffset, this.firstParameterLength);
    }

    public IContextInformation getContextInformation() {
        this.internalComputeProposal();
        return this.fContextInformation;
    }

    public Image getImage() {
        this.internalComputeProposal();
        return this.fImage;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        if (this.fAdditionalProposalInfo == null) {
            this.computeAdditionalProposalInfo();
        }
        if (CommentUtils.getInstance().shouldUseOldTooltip()) {
            return this.getAdditionalProposalInfo();
        }
        return this.fAdditionalProposalInfo;
    }

    public String getDisplayString() {
        this.internalComputeProposal();
        if (this.fDisplayString != null) {
            return this.fDisplayString;
        }
        return this.fReplacementString;
    }

    @Override
    protected String getEscapedDollarSign() {
        return "$";
    }

    public StyledString getStyledDisplayString() {
        StyledString displayString = new StyledString(this.getDisplayString());
        String infoString = this.getStringForStyledDisplay();
        if (infoString == null || infoString.isEmpty()) {
            return displayString;
        }
        infoString = " - " + infoString;
        displayString.append(new StyledString(infoString, StyledString.QUALIFIER_STYLER));
        return displayString;
    }

    public Object getCandidate() {
        return this.fCandidate;
    }

    @Override
    protected IEditorPart getEditor() {
        return this.fTextViewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)this.fTextViewer).getEditor() : DVTFileUtils.getInstance().getActiveEditor();
    }
}

