/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.MaxNofItemsReached;
import ro.amiq.dvt.r2lparser.strategies.DVTR2LBaseStrategy;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfCheckerDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfInterfaceDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProgramDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfYVModuleDummy;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;
import ro.amiq.vlogdt.r2lparser.R2LParser;
import ro.amiq.vlogdt.r2lparser.R2LTokenizer;
import ro.amiq.vlogdt.r2lparser.R2LUtils;
import ro.amiq.vlogdt.r2lparser.VlogR2LCompletionProposal;
import ro.amiq.vlogdt.r2lparser.strategies.VlogR2LPrefixStrategy;
import ro.amiq.vlogdt.templates.TemplateEditorUI;
import ro.amiq.vlogdt.ui.editor.contentassist.DVTDocumentTemplateContext;
import ro.amiq.vlogdt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.RfLazyAutoInstanceProposal;
import ro.amiq.vlogdt.ui.editor.contentassist.RfLazyAutoinstanceComputeModulesProposal;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistProcessorManager;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtil;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public abstract class VlogAutoInstanceContentAssistProcessorCommon
extends RfContentAssistProcessor {
    private static final int MAX_NOF_TOTAL_PROPOSALS = 100;
    private static final int STATE_INIT = 0;
    private static final int STATE_FIELD = 1;
    private static final int STATE_SKIP = 2;
    private int matchType;

    public VlogAutoInstanceContentAssistProcessorCommon(VlogContentAssistProcessorManager processor) {
        super(processor);
        boolean ignoreCase = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.ignore_case");
        boolean camelCase = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.camel_case");
        boolean prefixMatch = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.prefix_match");
        this.matchType = (ignoreCase ? 8 : 0) | (camelCase ? 4 : 0) | (prefixMatch || !camelCase ? 2 : 0);
    }

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument document;
        block3: {
            try {
                document = this.getProcessor().getDocument();
                if (document != null) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return this.computeCompletionProposals(viewer, offset, document);
    }

    private ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset, IDocument document) {
        IRfScope scope = this.getProcessor().getInitialScope();
        if (scope == null) {
            return null;
        }
        RfProject rfProject = this.getProcessor().getRfProject();
        if (rfProject == null) {
            return null;
        }
        TreeMap<String, TreeMap<String, TreeSet<String>>> moduleNamesByLibrary = rfProject.getModulesNamesByLibrary();
        List<BuildConfigProperty> libDescriptors = this.getScannedLibraries(rfProject);
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        this.addScanLibrariesProposal(viewer, offset, scope, rfProject, result, libDescriptors, moduleNamesByLibrary);
        String currentWord = this.lastWord(document, offset);
        if (!this.shouldDisplayAutoInstance(currentWord)) {
            return result.toArray(new ICompletionProposal[result.size()]);
        }
        if (currentWord == null || currentWord.length() == 0) {
            currentWord = "";
        }
        if (!this.checkContext(rfProject, scope, offset, document)) {
            return null;
        }
        NullProtectedList<IRfDesignElement> candidates = new NullProtectedList<IRfDesignElement>(true);
        candidates.setMaxNofItems(100);
        try {
            candidates.addAll(rfProject.getInstanceHoldersWithPrefix(rfProject.getLibraries(), currentWord, 1, 100));
            candidates.addAllNoDuplicate(rfProject.getInstanceHoldersWithPrefix(rfProject.getLibraries(), currentWord, this.matchType, 100 - candidates.size()));
            candidates.addAll(scope.getPrimitivesWithPrefix(currentWord, this.matchType));
            List designs = rfProject.getMixedLangProjectParent().getDesignsWithPrefix((IRfSingleLangProject)rfProject, currentWord, this.matchType);
            candidates.addAll(designs);
        }
        catch (MaxNofItemsReached maxNofItemsReached) {}
        ArrayList<VlogR2LCompletionProposal> candidateProposals = new ArrayList<VlogR2LCompletionProposal>();
        for (IRfDesignElement candidate : candidates) {
            if (!this.checkScope(candidate, scope)) continue;
            VlogR2LCompletionProposal proposal = new VlogR2LCompletionProposal((IRfNamedElement)candidate);
            proposal.addStrategy((DVTR2LBaseStrategy)new VlogR2LPrefixStrategy(currentWord));
            proposal.updateRelevance();
            candidateProposals.add(proposal);
        }
        Collections.sort(candidateProposals, R2LUtils.getSorter());
        this.addCandidateProposalsFromLibFiles(scope, currentWord, candidateProposals, moduleNamesByLibrary);
        boolean showLibrary = rfProject.getAllLibraries().size() != 1;
        for (VlogR2LCompletionProposal candidate : candidateProposals) {
            ICompletionProposal proposal = this.createProposal(viewer, offset, (IRfDesignElement)candidate.getCandidate(), showLibrary, scope, libDescriptors, rfProject);
            if (proposal == null) {
                return new ICompletionProposal[0];
            }
            result.add(proposal);
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private boolean checkScope(IRfDesignElement candidate, IRfScope scope) {
        if (candidate.getLanguageKind() != LanguageKind.VLOG) {
            return true;
        }
        if (candidate instanceof RfModule) {
            return scope instanceof RfModuleDef || scope instanceof RfGenerateBlockDef;
        }
        if (candidate instanceof RfInterface) {
            return scope instanceof RfModuleDef || scope instanceof RfInterfaceDef || scope instanceof RfGenerateBlockDef;
        }
        if (candidate instanceof RfChecker) {
            return scope instanceof RfModuleDef || scope instanceof RfInterfaceDef || scope instanceof RfProgramDef || scope instanceof RfCheckerDef || scope instanceof RfGenerateBlockDef || scope instanceof RfActionBlockDef || scope instanceof RfFunctionDef;
        }
        if (candidate instanceof RfProgram) {
            return scope instanceof RfModuleDef || scope instanceof RfInterfaceDef || scope instanceof RfGenerateBlockDef;
        }
        return false;
    }

    private boolean checkContext(RfProject rfProject, IRfScope scope, int offset, IDocument document) {
        AST pAST = this.getAST(rfProject, scope, offset, document);
        if (pAST == null) {
            return true;
        }
        int type = pAST.getType();
        if (type != 165) {
            return false;
        }
        AST firstChildAST = pAST.getFirstChild();
        if (firstChildAST == null) {
            return false;
        }
        return firstChildAST.getType() == 103;
    }

    private AST getAST(RfProject rfProject, IRfScope scope, int offset, IDocument document) {
        ParserPath parserPath;
        int line;
        block4: {
            line = document.getLineOfOffset(offset) + 1;
            parserPath = DVTFileUtils.getInstance().resource2parser((IResource)this.getProcessor().getFile());
            if (parserPath != null) break block4;
            return null;
        }
        try {
            R2LTokenizer lexer = new R2LTokenizer(scope, rfProject, parserPath, document, offset, line, false);
            R2LParser parser = new R2LParser(lexer, rfProject.getProject(), false);
            parser.return_statement_rule();
            if (parser.getAST() == null) {
                parser.rules();
            }
            return parser.getAST();
        }
        catch (RecognitionException | TokenStreamException | BadLocationException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
    }

    private void addScanLibrariesProposal(ITextViewer viewer, int offset, IRfScope scope, RfProject rfProject, ArrayList<ICompletionProposal> result, List<BuildConfigProperty> libDescriptors, TreeMap<String, TreeMap<String, TreeSet<String>>> moduleNamesByLibrary) {
        if (libDescriptors == null) {
            return;
        }
        if (moduleNamesByLibrary == null) {
            ICompletionProposal proposal = this.createProposal(viewer, offset, new RfYVModuleDummy("Scan modules from libraries", false, "", ""), false, scope, libDescriptors, rfProject);
            if (proposal == null) {
                return;
            }
            result.add(proposal);
            return;
        }
        if (libDescriptors.size() <= moduleNamesByLibrary.size()) {
            return;
        }
        List<BuildConfigProperty> unresolvedLibs = libDescriptors.stream().filter(lib -> !moduleNamesByLibrary.containsKey(lib.getValue())).collect(Collectors.toList());
        ICompletionProposal proposal = this.createProposal(viewer, offset, new RfYVModuleDummy("Scan modules from libraries", false, "", ""), false, scope, unresolvedLibs, rfProject);
        if (proposal == null) {
            return;
        }
        result.add(proposal);
    }

    private void addCandidateProposalsFromLibFiles(IRfScope scope, String currentWord, List<VlogR2LCompletionProposal> candidateProposals, TreeMap<String, TreeMap<String, TreeSet<String>>> moduleNamesByLibrary) {
        if (moduleNamesByLibrary == null) {
            return;
        }
        if (!(scope instanceof RfModuleDef) && !(scope instanceof RfGenerateBlockDef)) {
            return;
        }
        RfLibrary enclosingLib = scope instanceof RfDefElement ? ((RfDefElement)scope).getEnclosingLibrary() : null;
        NullProtectedList<RfYVModuleDummy> libCandidates = new NullProtectedList<RfYVModuleDummy>(true);
        block0: for (Map.Entry<String, TreeMap<String, TreeSet<String>>> entry : moduleNamesByLibrary.entrySet()) {
            String library = entry.getKey();
            Map modulesByFile = entry.getValue();
            if (modulesByFile == null) continue;
            boolean shouldBreak = false;
            for (Map.Entry moduleByFile : modulesByFile.entrySet()) {
                if (moduleByFile.getValue() == null) continue;
                for (String module : (TreeSet)moduleByFile.getValue()) {
                    if (libCandidates.size() >= 50) {
                        shouldBreak = true;
                        break;
                    }
                    if (this.isModuleCompiled(module, (String)moduleByFile.getKey(), enclosingLib) || !DVTStringUtil.regionMatches((String)module, (String)currentWord, (int)this.matchType)) continue;
                    libCandidates.add(new RfYVModuleDummy(module, false, library, (String)moduleByFile.getKey()));
                }
                if (shouldBreak) continue block0;
            }
        }
        for (IRfNamedElement iRfNamedElement : libCandidates) {
            VlogR2LCompletionProposal proposal = new VlogR2LCompletionProposal(iRfNamedElement);
            candidateProposals.add(proposal);
        }
    }

    private boolean isModuleCompiled(String module, String analisedLibraryFile, RfLibrary enclosingLib) {
        if (enclosingLib == null) {
            return false;
        }
        RfModule compiledModule = enclosingLib.getModule(module);
        if (compiledModule == null) {
            return false;
        }
        RfDefElement declaration = compiledModule.getDeclaration();
        if (declaration == null) {
            return false;
        }
        RfFileDef defFile = declaration.getDefFile();
        if (defFile == null) {
            return false;
        }
        ParserPath parserPath = defFile.getParserPath();
        if (parserPath == null) {
            return false;
        }
        String declarationPath = parserPath.path;
        return analisedLibraryFile.equals(declarationPath);
    }

    private List<BuildConfigProperty> getScannedLibraries(RfProject rfProject) {
        IFile file = this.getProcessor().getFile();
        if (file == null) {
            return Collections.emptyList();
        }
        IPath absolutePath = file.getLocation();
        if (absolutePath == null) {
            return Collections.emptyList();
        }
        String filePath = absolutePath.toOSString();
        if (filePath == null) {
            return Collections.emptyList();
        }
        Invocation invocation = BuildConfigManager.getInvocation((IProject)rfProject.getProject(), (String)filePath, (int)0, (int)0);
        if (invocation == null) {
            return Collections.emptyList();
        }
        List libDescriptors = BuildConfigManager.getLibs((Invocation)invocation);
        return libDescriptors;
    }

    public ICompletionProposal createProposal(ITextViewer viewer, int offset, IRfDesignElement candidate, boolean showLibrary, IRfScopeElement scope) {
        return this.createProposal(viewer, offset, candidate, showLibrary, scope, null, null);
    }

    public ICompletionProposal createProposal(ITextViewer viewer, int offset, IRfDesignElement candidate, boolean showLibrary, IRfScopeElement scope, List<BuildConfigProperty> unresolvedLibs, RfProject rfProject) {
        IDocument document = viewer.getDocument();
        int instanceOffset = VlogAutoInstanceContentAssistProcessorCommon.getInstanceDocumentOffset(document, offset);
        boolean isScanLibraryProposal = candidate instanceof RfYVModuleDummy && (((RfYVModuleDummy)candidate).getLibrary() == null || ((RfYVModuleDummy)candidate).getLibrary().isEmpty());
        boolean isDummyModuleProposal = candidate instanceof RfYVModuleDummy && ((RfYVModuleDummy)candidate).getLibrary() != null && !((RfYVModuleDummy)candidate).getLibrary().isEmpty();
        Image image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_MODULE_INSTANCE);
        if (isScanLibraryProposal) {
            image = DVTImages.imageCache.getImage(DVTImages.DESC_INFO_TIP);
        } else if (isDummyModuleProposal) {
            image = DVTImages.imageCache.getImage(DVTImages.OUTLINE_DUMMY_MODULE_INSTANCE);
        }
        IPreferenceStore store = VlogPlugin.getDefault().getPreferenceStore();
        String replacementString = this.getReplacementString(viewer, offset, candidate, false, scope, unresolvedLibs);
        if (replacementString == null) {
            return null;
        }
        Region region = new Region(instanceOffset, offset - instanceOffset);
        TemplateContext context = this.createContext(viewer, (IRegion)region);
        if (context == null) {
            return null;
        }
        if (isScanLibraryProposal) {
            return new RfLazyAutoinstanceComputeModulesProposal(viewer, context, region, candidate, false, replacementString.trim(), image, PrefConst.dontExpandMacrosInSignalDimensions(store), scope, null, unresolvedLibs, rfProject);
        }
        boolean isShowLibrary = false;
        if (!(candidate instanceof RfYVModuleDummy)) {
            isShowLibrary = showLibrary;
        }
        return new RfLazyAutoInstanceProposal(viewer, context, region, candidate, isShowLibrary, replacementString.trim(), image, PrefConst.dontExpandMacrosInSignalDimensions(store), scope, null);
    }

    private String getReplacementString(ITextViewer viewer, int offset, IRfDesignElement candidate, boolean dontExpandMacros, IRfScopeElement scope, List<BuildConfigProperty> unresolvedLibs) {
        boolean isScanLibraryProposal;
        StringBuilder replacementString = new StringBuilder();
        boolean bl = isScanLibraryProposal = candidate instanceof RfYVModuleDummy && (((RfYVModuleDummy)candidate).getLibrary() == null || ((RfYVModuleDummy)candidate).getLibrary().isEmpty());
        if (!isScanLibraryProposal) {
            return VlogAutoInstanceContentAssistProcessorCommon.newProposal(viewer, offset, candidate, dontExpandMacros, scope, false);
        }
        IEditorPart editor = viewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)viewer).getEditor() : DVTFileUtils.getInstance().getActiveEditor();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)editor);
        replacementString.append("The following libdirs / libfiles were unused during compilation.").append(lineDelimiter);
        replacementString.append("Scan them now to get a complete list of modules available for instantiation.").append(lineDelimiter);
        replacementString.append(lineDelimiter);
        int index = 1;
        for (BuildConfigProperty lib : unresolvedLibs) {
            if (index >= 10) {
                replacementString.append("... and more.");
                break;
            }
            replacementString.append(lib.getValue()).append(lineDelimiter);
            ++index;
        }
        return replacementString.toString();
    }

    public static String newProposal(ITextViewer viewer, int offset, IRfDesignElement candidate, boolean dontExpandMacros, IRfScopeElement scope, boolean isApply) {
        if (candidate instanceof RfYVModuleDummy && scope instanceof RfDefElement && isApply) {
            RfLibrary lib = ((RfDefElement)scope).getEnclosingLibrary();
            RfModule mod = lib.getModule(candidate.getName());
            if (mod != null) {
                candidate = mod;
            } else {
                File library = new File(((RfYVModuleDummy)candidate).getLibrary());
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "", null, "Unable to compile module '" + candidate.getName() + "' defined in " + (library.isDirectory() ? "libdir " : "libfile: ") + ((RfYVModuleDummy)candidate).getLibrary() + "\n\n\t", 4, new String[]{"Ok"}, 0);
                if (dialog.open() == 0) {
                    return "";
                }
            }
        }
        IDocument document = viewer.getDocument();
        int instanceLineOffset = VlogAutoInstanceContentAssistProcessorCommon.getInstanceLineOffset(document, offset);
        StringBuilder alignBuilder = new StringBuilder(instanceLineOffset + 2);
        IEditorPart editor = viewer instanceof DVTProjectionViewer ? ((DVTProjectionViewer)viewer).getEditor() : DVTFileUtils.getInstance().getActiveEditor();
        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)editor);
        String portAlignment = alignBuilder.toString();
        String instanceAlignment = alignBuilder.toString();
        boolean bl = isDummyLibraryModule = candidate instanceof RfYVModuleDummy && ((RfYVModuleDummy)candidate).getLibrary() != null && !((RfYVModuleDummy)candidate).getLibrary().isEmpty();
        if (isDummyLibraryModule && !isApply) {
            File library = new File(((RfYVModuleDummy)candidate).getLibrary());
            String moduleName = ((RfYVModuleDummy)candidate).getName();
            StringBuilder replacementString = new StringBuilder();
            if (library.isFile()) {
                replacementString.append("Compile and instantiate module '" + moduleName + "' defined in libfile '-v " + library.getName() + "'").append(lineDelimiter);
            } else {
                replacementString.append("Compile and instantiate module '" + moduleName + "' defined in libdir '-y " + library.getName() + "'").append(lineDelimiter);
            }
            replacementString.append(lineDelimiter).append("File full path:").append(lineDelimiter);
            replacementString.append(library.getAbsolutePath());
            return replacementString.toString();
        }
        String designName = VlogContentAssistUtil.getEscName((IRfNamedElement)candidate).replace("$", "$$");
        String designVarName = VlogContentAssistUtil.getEscName((IRfNamedElement)candidate);
        StringBuilder headerWires = null;
        StringBuilder headerParameters = null;
        StringBuilder replacementString = new StringBuilder(designName);
        IPreferenceStore store = VlogPlugin.getDefault().getPreferenceStore();
        if (candidate instanceof RfNamedElement && PrefConst.isInsertParameterAssignments(store)) {
            headerParameters = new StringBuilder();
            NullProtectedList<RfField> parameters = new NullProtectedList<RfField>();
            parameters.addAll(((RfNamedElement)candidate).getParametersWithPrefix("", 128, 2, 1));
            parameters.addAll(((RfNamedElement)candidate).getParametersWithPrefix("", 256, 2, 1));
            Iterator paramIt = parameters.iterator();
            while (paramIt.hasNext()) {
                if (RfField.ParameterKind.PARAMETER == ((RfField)paramIt.next()).getParameterKind()) continue;
                paramIt.remove();
            }
            if (!parameters.isEmpty()) {
                replacementString.append(" #(");
                boolean first = true;
                for (RfField param : parameters) {
                    if (!first) {
                        replacementString.append(", ");
                    } else {
                        first = false;
                    }
                    String paramName = VlogContentAssistUtil.getEscName(param).replace("$", "$$");
                    String paramVarName = VlogContentAssistUtil.getEscName(param);
                    boolean paramAdded = false;
                    if (scope instanceof RfModuleDef var28_36 && moduleDef.getNamedElement() != null) {
                        RfNamedElement module = moduleDef.getNamedElement();
                        List<RfField> parametersWithPrefix = module.getParametersWithPrefix(paramVarName, 128, 1, 1);
                        boolean bl2 = paramAdded = parametersWithPrefix != null && !parametersWithPrefix.isEmpty();
                    }
                    if (!paramAdded) {
                        StringBuilder parameterDeclaration = new StringBuilder();
                        parameterDeclaration.append("parameter ${").append(paramVarName).append("}");
                        String parameterDefaultValue = param.getInitialValue(false);
                        if (parameterDefaultValue != null && !parameterDefaultValue.isEmpty()) {
                            parameterDeclaration.append(" = ").append(parameterDefaultValue);
                        }
                        parameterDeclaration.append(";");
                        headerParameters.append(parameterDeclaration.toString()).append(lineDelimiter);
                    }
                    replacementString.append(lineDelimiter).append(portAlignment);
                    replacementString.append(".").append(paramName).append("(${").append(paramVarName).append("})");
                }
                replacementString.append(lineDelimiter).append(instanceAlignment).append(")").append(lineDelimiter);
            }
        }
        replacementString.append(" ${").append(PrefConst.getAutoInstancePrefix(store)).append(designVarName).append("} (");
        List localPorts = candidate.getLocalPortsNoAliases();
        ArrayList ports = localPorts != null ? new ArrayList(localPorts) : new ArrayList();
        boolean hasUnknownsOrPortSelects = ports.stream().filter(port -> port.isNonANSIImplicitPort()).findFirst().isPresent();
        if (!ports.isEmpty()) {
            headerWires = new StringBuilder();
            boolean isAutoRangeEnabled = PrefConst.isAutoRangeEnabled(store);
            boolean useLogicInsteadOfWire = PrefConst.useLogicInsteadOfWire(store);
            boolean preserveComments = PrefConst.isPreserveComments(store);
            boolean groupByDirection = PrefConst.isGroupPortsByDirection(store);
            boolean sortAlphabetically = PrefConst.isSortPortAlphabetically(store);
            boolean bl3 = useNamedConnections = !(candidate instanceof RfPrimitive) && !hasUnknownsOrPortSelects;
            if (groupByDirection) {
                replacementString.append(VlogContentAssistUtil.getPortsGroupedByDirection(ports, instanceAlignment, portAlignment, isAutoRangeEnabled, sortAlphabetically, useLogicInsteadOfWire, preserveComments, lineDelimiter, candidate, scope, headerWires, dontExpandMacros));
            } else {
                headerWires.append(VlogContentAssistUtil.addSignals(ports, lineDelimiter, scope, dontExpandMacros, useLogicInsteadOfWire, new HashSet<String>()));
                replacementString.append(VlogContentAssistUtil.addPorts(useNamedConnections, ports, true, null, portAlignment, isAutoRangeEnabled, lineDelimiter, sortAlphabetically, preserveComments));
                replacementString.append(lineDelimiter).append(instanceAlignment);
            }
            if (!headerWires.toString().isEmpty()) {
                headerWires.insert(0, lineDelimiter).append(lineDelimiter).toString();
            } else {
                headerWires = null;
            }
        }
        if (headerParameters != null && !headerParameters.toString().isEmpty()) {
            headerParameters.insert(0, lineDelimiter);
            if (!PrefConst.isDeclareWiresEnabled(store) || headerWires == null) {
                headerParameters.append(lineDelimiter);
            }
        }
        replacementString.append(");");
        if (PrefConst.isDeclareWiresEnabled(store) && headerWires != null) {
            replacementString.insert(0, headerWires.toString());
        }
        if (PrefConst.isDeclareParametersEnabled(store) && headerParameters != null) {
            replacementString.insert(0, headerParameters.toString());
        }
        return replacementString.toString().trim();
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = TemplateEditorUI.getDefault().getContextTypeRegistry().getContextType(this.getProcessor().getContextType());
        if (contextType != null) {
            IDocument document = viewer.getDocument();
            return new DVTDocumentTemplateContext(contextType, document, region.getOffset(), region.getLength());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String lastWord(IDocument doc, int offset) {
        int state = 0;
        int endPoz = offset;
        try {
            int n = offset - 1;
            while (true) {
                if (n < 0) {
                    return "";
                }
                char c = doc.getChar(n);
                switch (state) {
                    case 0: {
                        if (!Character.isJavaIdentifierPart(c)) return "";
                        endPoz = n;
                        state = 1;
                        break;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(c)) break;
                        return doc.get(n + 1, endPoz - n);
                    }
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return "";
    }

    private static int getInstanceLineOffset(IDocument doc, int offset) {
        int state = 0;
        int startPoz = offset;
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                if (c == '\n') {
                    return startPoz - n - 1;
                }
                switch (state) {
                    case 0: {
                        if (Character.isJavaIdentifierPart(c)) {
                            state = 1;
                            startPoz = n;
                            break;
                        }
                        state = 2;
                        break;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(c)) {
                            startPoz = n;
                            break;
                        }
                        state = 2;
                        break;
                    }
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return 0;
    }

    private static int getInstanceDocumentOffset(IDocument doc, int offset) {
        int state = 0;
        int startPoz = offset;
        try {
            int n = offset - 1;
            while (n >= 0) {
                char c = doc.getChar(n);
                switch (state) {
                    case 0: {
                        if (Character.isJavaIdentifierPart(c)) {
                            state = 1;
                            startPoz = n;
                            break;
                        }
                        return startPoz;
                    }
                    case 1: {
                        if (Character.isJavaIdentifierPart(c)) {
                            startPoz = n;
                            break;
                        }
                        return startPoz;
                    }
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return startPoz;
    }

    protected abstract boolean shouldDisplayAutoInstance(String var1);
}

