/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTCompletionProposal;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTContentAssistConstants;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.r2lparser.R2LBusy;
import ro.amiq.vlogdt.r2lparser.R2LStructAssignmentPattern;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.contentassist.PositionalTooltipsNamedElementAndOffsetWrapper;
import ro.amiq.vlogdt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.RfLazyCompletionProposal;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogAutoInstanceContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistProcessorManagerCommon;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogKeywordContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogParameterHintsUtils;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogTemplateContentAssistProcessor;

public class VlogContentAssistProcessorManager
extends VlogContentAssistProcessorManagerCommon {
    protected int fLine;

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public VlogContentAssistProcessorManager(VlogEditor editor, ContentAssistant assistant) {
        this.fContentAssistant = assistant;
        this.fEditor = editor;
    }

    public ContentAssistant getContentAssistant() {
        return this.fContentAssistant;
    }

    public int getLine() {
        return this.fLine;
    }

    public int getNofProcessors() {
        return 4;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] nonUiComputeCompletionProposals(ITextViewer viewer, int offset) {
        try {
            if (this.fEditor == null) {
                return null;
            }
            if (!this.init(viewer, offset)) {
                return null;
            }
            this.setContextType();
            if (offset == this.getPrevOffset()) {
                int crtContentAssistPage = this.getCrtContentAssistPage();
                switch (IDVTContentAssistConstants.ContentAssistProposalsPage.from((int)crtContentAssistPage)) {
                    case DEFAULT: {
                        this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Template proposals");
                        break;
                    }
                    case TEMPLATES: {
                        this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Instance proposals");
                        for (IContentAssistProcessor processor : this.fProcessors) {
                            if (!(processor instanceof TemplateCompletionProcessor)) continue;
                            ICompletionProposal[] proposals = processor.computeCompletionProposals(viewer, offset);
                            if (proposals == null || proposals.length == 0) {
                                proposals = this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
                            }
                            return proposals;
                        }
                        return null;
                    }
                    case AUTO_INSTANCE: {
                        this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show AI Assistant proposals");
                        for (IContentAssistProcessor processor : this.fProcessors) {
                            if (!(processor instanceof VlogAutoInstanceContentAssistProcessor)) continue;
                            ICompletionProposal[] proposals = processor.computeCompletionProposals(viewer, offset);
                            if (proposals == null || proposals.length == 0) {
                                proposals = this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
                            }
                            return proposals;
                        }
                        return null;
                    }
                    case AI_ASSISTANT: {
                        this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Default proposals");
                        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
                        if (aiHostContributor == null) {
                            return null;
                        }
                        for (IContentAssistProcessor processor : this.fProcessors) {
                            if (!aiHostContributor.isAICodeCompletionProcessorAndListener(processor)) continue;
                            ICompletionProposal[] proposals = aiHostContributor.computeCompletionProposalsForAIAssistantPage(processor, viewer, offset);
                            if (proposals == null || proposals.length == 0) {
                                proposals = this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
                            }
                            return proposals;
                        }
                        return null;
                    }
                }
            } else {
                this.nonUiSetStatusMessage("Press 'Ctrl+Space' to show Template proposals");
            }
            if (this.fFile == null || this.fRfProject == null) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                for (IContentAssistProcessor processor : this.fProcessors) {
                    if (!(processor instanceof VlogTemplateContentAssistProcessor) && !(processor instanceof VlogKeywordContentAssistProcessor)) continue;
                    this.addProposalsToList(processor.computeCompletionProposals(viewer, offset), proposals);
                }
                if (proposals.isEmpty()) {
                    proposals.add(this.getNoProposal(viewer, offset));
                }
                return this.getProposalArray(proposals);
            }
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            for (IContentAssistProcessor processor : this.fProcessors) {
                if (processor instanceof VlogAutoInstanceContentAssistProcessor) continue;
                this.addProposalsToList(processor.computeCompletionProposals(viewer, offset), proposals);
                if (processor instanceof RfContentAssistProcessor && !((RfContentAssistProcessor)processor).fAllowProposals) break;
            }
            Iterator iterator = proposals.iterator();
            while (iterator.hasNext()) {
                ICompletionProposal proposal = (ICompletionProposal)iterator.next();
                if (!(proposal instanceof RfLazyCompletionProposal) || !((RfLazyCompletionProposal)proposal).isNoProposal()) continue;
                iterator.remove();
            }
            if (proposals.isEmpty()) {
                proposals.add(this.getNoProposal(viewer, offset));
            }
            return this.getProposalArray(proposals);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
        }
    }

    @Override
    public boolean init(ITextViewer viewer, int offset) {
        block5: {
            block4: {
                try {
                    this.fDocument = viewer.getDocument();
                    if (this.fDocument != null) break block4;
                    return false;
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            this.fLine = this.fDocument.getLineOfOffset(offset) + 1;
            if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) break block5;
            this.fFile = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
            if (this.fFile != null) break block5;
            return false;
        }
        return this.init(offset);
    }

    protected void addProposalsToList(ICompletionProposal[] proposals, List<ICompletionProposal> results) {
        if (proposals == null) {
            return;
        }
        int i = 0;
        while (i < proposals.length) {
            results.add(proposals[i]);
            ++i;
        }
    }

    protected ICompletionProposal[] getProposalArray(List<ICompletionProposal> proposals) {
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    public int getTabWidth() {
        return this.fEditor.getTabWidth();
    }

    protected RfProject computeRfProject() {
        if (this.fEditor == null) {
            return null;
        }
        if (!(this.fEditor.getEditorInput() instanceof FileEditorInput)) {
            return null;
        }
        this.fFile = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        if (this.fFile == null) {
            return null;
        }
        IProject project = this.fFile.getProject();
        if (project == null) {
            return null;
        }
        this.fRfProject = RfManager.getInstance().getRfProject(project);
        return this.fRfProject;
    }

    public ICompletionProposal testHelperComputeStructProposal(ITextViewer viewer, int offset) {
        block11: {
            block10: {
                if (DVTPlugin.getDefault().collect().c(this.computeRfProject().getProject(), "F7376")) break block10;
                return null;
            }
            this.setPrevOffset(offset);
            this.fContextType = "ro.amiq.vlogdt.templates.contextType.other";
            this.fDocument = viewer.getDocument();
            if (this.fDocument != null) break block11;
            return null;
        }
        try {
            this.fLine = this.fDocument.getLineOfOffset(offset) + 1;
            if (this.fRfProject != null) {
                RfFileDef fileDef = this.fRfProject.getFile((IResource)this.fFile);
                if (fileDef != null) {
                    this.fInitialScope = fileDef.getScope(offset, true, true, null);
                }
                this.fInstance = null;
                if (this.fInitialScope instanceof RfFieldDef && ((RfFieldDef)this.fInitialScope).getNamedElement() instanceof RfInstance) {
                    this.fInstance = (RfInstance)((RfFieldDef)this.fInitialScope).getNamedElement();
                    this.fInitialScope = ((RfFieldDef)this.fInitialScope).getNamedElement().getEnclosingScope();
                }
            }
            for (IContentAssistProcessor icap : this.fProcessors) {
                ICompletionProposal[] computeCompletionProposals;
                if (!(icap instanceof RfContentAssistProcessor)) continue;
                ICompletionProposal[] iCompletionProposalArray = computeCompletionProposals = icap.computeCompletionProposals(viewer, offset);
                int n = computeCompletionProposals.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompletionProposal proposal = iCompletionProposalArray[n2];
                    if (proposal instanceof IDVTCompletionProposal && ((IDVTCompletionProposal)proposal).getCandidate() instanceof R2LStructAssignmentPattern) {
                        return proposal;
                    }
                    ++n2;
                }
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public ICompletionProposal[] testHelperComputeTemplatesProposals(ITextViewer viewer, int offset, boolean autoInstance) {
        block9: {
            block8: {
                if (DVTPlugin.getDefault().collect().c(this.computeRfProject().getProject(), "F7376")) break block8;
                return null;
            }
            this.setPrevOffset(offset);
            this.fContextType = "ro.amiq.vlogdt.templates.contextType.other";
            this.fDocument = viewer.getDocument();
            if (this.fDocument != null) break block9;
            return null;
        }
        try {
            this.fLine = this.fDocument.getLineOfOffset(offset) + 1;
            if (this.fRfProject != null) {
                RfFileDef fileDef = this.fRfProject.getFile((IResource)this.fFile);
                if (fileDef != null) {
                    this.fInitialScope = fileDef.getScope(offset, true, true, null);
                }
                this.fInstance = null;
                if (this.fInitialScope instanceof RfFieldDef && ((RfFieldDef)this.fInitialScope).getNamedElement() instanceof RfInstance) {
                    this.fInstance = (RfInstance)((RfFieldDef)this.fInitialScope).getNamedElement();
                    this.fInitialScope = ((RfFieldDef)this.fInitialScope).getNamedElement().getEnclosingScope();
                }
            }
            for (IContentAssistProcessor icap : this.fProcessors) {
                if (!(autoInstance ? icap instanceof VlogAutoInstanceContentAssistProcessor : icap instanceof VlogTemplateContentAssistProcessor)) continue;
                return icap.computeCompletionProposals(viewer, offset);
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected ICompletionProposal getBusyProposal(ITextViewer viewer, int fOffset) {
        return new RfLazyCompletionProposal(RfTypesResolver.create((IRfScopeElement)this.fInitialScope, this.fRfProject, 14), viewer, viewer.getDocument(), this.fInitialScope, new R2LBusy(), "", fOffset, false, false, -1, false, true, null, 0, null);
    }

    @Override
    protected PositionalTooltipsNamedElementAndOffsetWrapper getNamedElementAndOffsetAtOffset(RfProject project, IFile file, VlogEditor editor, int offset, int startOffset) {
        return VlogParameterHintsUtils.getInstance().getNamedElementAndOffsetAtOffset(project, file, editor, offset, startOffset);
    }
}

