/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProposalContextInformation;
import ro.amiq.dvt.ui.editor.DvtContextInformationType;
import ro.amiq.dvt.ui.editor.contentasisst.DVTContentAssistProcessorManager;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.MethodSignatureUseCase;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPortDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.FormatSpecifiersUtils;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogMacroText;
import ro.amiq.vlogdt.r2lparser.R2LNoProposalElement;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.contentassist.PositionalTooltipsNamedElementAndOffsetWrapper;
import ro.amiq.vlogdt.ui.editor.contentassist.RfLazyCompletionProposal;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogParameterHintsUtils;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogParameterListValidator;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogPositionalTooltipUtils;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogSystemTaskAtOffsetVisitor;

public abstract class VlogContentAssistProcessorManagerCommon
extends DVTContentAssistProcessorManager {
    protected ArrayList<IContentAssistProcessor> fProcessors = new ArrayList();
    protected ContentAssistant fContentAssistant;
    protected IRfScope fInitialScope;
    protected RfProject fRfProject;
    protected VlogEditor fEditor;
    protected RfInstance fInstance;
    protected IFile fFile;
    protected IDocument fDocument;
    protected boolean fIsGlobalProposal = true;
    protected boolean fAlreadyComputed;
    protected String fContextType;

    public void addContentAssistProcessor(IContentAssistProcessor processor) {
        this.fProcessors.add(processor);
    }

    public RfInstance getInstanceScope() {
        return this.fInstance;
    }

    public IRfScope getInitialScope() {
        return this.fInitialScope;
    }

    public RfProject getRfProject() {
        return this.fRfProject;
    }

    public VlogEditor getEditor() {
        return this.fEditor;
    }

    public IDocument getDocument() {
        if (this.fEditor == null) {
            return null;
        }
        return this.fEditor.getDocument();
    }

    public IFile getFile() {
        return this.fFile;
    }

    public ArrayList<IContentAssistProcessor> getProcessors() {
        return this.fProcessors;
    }

    public String getContextType() {
        this.setContextType();
        return this.fContextType;
    }

    protected void setContextType() {
        this.fContextType = this.fInitialScope != null ? this.fInitialScope.getContextType() : "ro.amiq.vlogdt.templates.contextType.other";
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        PositionalTooltipsNamedElementAndOffsetWrapper namedElementAndOffset;
        if (!this.init(viewer, offset)) {
            return null;
        }
        IRfScope scope = this.fInitialScope;
        if (!(this.fInitialScope instanceof RfDefElement)) {
            if (this.fInitialScope instanceof RfNamedElement) {
                scope = ((RfNamedElement)this.fInitialScope).getDeclaration();
            }
            if (!(scope instanceof RfDefElement)) {
                return null;
            }
        }
        if ((namedElementAndOffset = this.getNamedElementAndOffsetAtOffset(this.fRfProject, this.fFile, this.fEditor, offset, ((RfDefElement)scope).getStartOffset())) == null) {
            return null;
        }
        RfNamedElement element = namedElementAndOffset.getNamedElement();
        int elementOffset = namedElementAndOffset.getOffset();
        RfTypesResolver resolver = RfTypesResolver.create((IRfScopeElement)element, element.getRfProject(), 14);
        String[] elementNameAndArgs = null;
        if (element instanceof RfFunction) {
            elementNameAndArgs = this.getContextInfoForMethod(resolver, (RfFunction)element);
        } else if (element instanceof VlogMacroInfo) {
            elementNameAndArgs = this.getContextInfoForMacro((VlogMacroInfo)element);
        } else if (element instanceof RfInstance) {
            boolean isInstanceParameterPosTooltip = namedElementAndOffset.isInstanceParameter();
            String[] stringArray = elementNameAndArgs = !isInstanceParameterPosTooltip ? this.getContextInfoForInstancePorts(element) : this.getContextInfoForInstanceParameters(element);
        }
        if (elementNameAndArgs == null || elementNameAndArgs.length != 2) {
            return null;
        }
        String elementName = elementNameAndArgs[0];
        String elementArguments = elementNameAndArgs[1];
        if (elementName == null || elementArguments == null) {
            return null;
        }
        return this.getContextInformationInternal(elementName, elementArguments, element, scope, elementOffset, offset);
    }

    public String[] getContextInfoForMethod(RfTypesResolver resolver, RfFunction method) {
        if (method == null) {
            return null;
        }
        Collection functionDeclarations = method.getDeclarations();
        if (functionDeclarations != null && functionDeclarations.contains(this.fInitialScope)) {
            return null;
        }
        String methodArguments = method.printArguments(resolver, true, null, false, true, MethodSignatureUseCase.CONTENT_ASSIST_PROPOSAL, false);
        if (methodArguments.isEmpty()) {
            return null;
        }
        String methodName = method.getName();
        if (methodName == null) {
            return null;
        }
        return new String[]{methodName, methodArguments};
    }

    public String[] getContextInfoForMacro(VlogMacroInfo macroInfo) {
        if (macroInfo == null) {
            return null;
        }
        VlogMacroText macroText = macroInfo.getMacroText();
        if (macroText == null) {
            return null;
        }
        Object[] macroArgumentsArray = macroText.getParameters();
        if (macroArgumentsArray == null || macroArgumentsArray.length == 0) {
            return null;
        }
        String macroArguments = DVTStringUtil.join((Object[])macroArgumentsArray, (String)", ");
        String macroName = macroInfo.getName();
        if (macroName == null) {
            return null;
        }
        return new String[]{macroName, macroArguments};
    }

    public String[] getContextInfoForInstancePorts(IRfNamedElement element) {
        if (!(element instanceof IRfInstanceElement) || !((RfInstance)element).hasOrderedConnections()) {
            return null;
        }
        IRfNamedElement genericDesign = ((RfInstance)element).getGenericDesign(null);
        if (!(genericDesign instanceof IRfDesignElement)) {
            return null;
        }
        IRfDesignElement designElement = (IRfDesignElement)genericDesign;
        List ports = designElement.getLocalPorts();
        if (ports == null || ports.isEmpty()) {
            return null;
        }
        ArrayList<String> portNames = new ArrayList<String>();
        for (IRfPortElement port : ports) {
            IRfDefElement portDecl = port.getDeclaration();
            if (portDecl instanceof RfPortDef && !((RfPortDef)portDecl).isInListOfPorts()) continue;
            portNames.add(port.getContextInformationSignature());
        }
        String elementArguments = DVTStringUtil.join(portNames, (String)", ");
        String elementName = element.getName();
        if (elementName == null) {
            return null;
        }
        return new String[]{elementName, elementArguments};
    }

    public String[] getContextInfoForInstanceParameters(IRfNamedElement element) {
        if (!(element instanceof IRfInstanceElement) || !VlogPositionalTooltipUtils.getOrderedParameterConnectionsInfo((IRfInstanceElement)element, false, null).hasOrderedParameterConnections()) {
            return null;
        }
        IRfNamedElement genericDesign = ((RfInstance)element).getGenericDesign(null);
        if (!(genericDesign instanceof IRfDesignElement)) {
            return null;
        }
        IRfDesignElement designElement = (IRfDesignElement)genericDesign;
        List parameters = designElement.getLocalParameters();
        if (parameters == null) {
            return null;
        }
        List elabParamValues = VlogPositionalTooltipUtils.computeElabParamValues((DVTEditor)this.fEditor, (ELManager)this.fRfProject.getELManager(), (IRfNamedElement)element, (List)parameters);
        ArrayList<String> parameterNames = new ArrayList<String>();
        int i = 0;
        while (i < parameters.size()) {
            String signature;
            String value = elabParamValues == null || i >= elabParamValues.size() ? null : (String)elabParamValues.get(i);
            String string = signature = parameters.get(i) instanceof IRfFieldElement ? VlogPositionalTooltipUtils.computeSignature((IRfFieldElement)((IRfFieldElement)parameters.get(i)), (String)value) : null;
            if (signature == null) {
                return null;
            }
            parameterNames.add(signature);
            ++i;
        }
        String elementArguments = DVTStringUtil.join(parameterNames, (String)", ");
        String elementName = element.getName();
        if (elementName == null) {
            return null;
        }
        return new String[]{elementName, elementArguments};
    }

    public IContextInformation[] getContextInformationInternal(String elementName, String elementArguments, IRfNamedElement element, IRfScope scope, int elementNameOffset, int cursorOffset) {
        RfNamedElement scopeNamedElement = ((RfDefElement)scope).getNamedElement();
        if (scopeNamedElement == null) {
            return null;
        }
        int elementOpenBracketOffset = VlogParameterHintsUtils.getInstance().getContextInformationOffset(this.getDocument(), elementNameOffset, scope, elementName, this.fEditor, false, false, true);
        if (elementOpenBracketOffset < 0) {
            return null;
        }
        int elementClosedBracketOffset = VlogParameterHintsUtils.getInstance().getContextInformationOffset(this.getDocument(), elementNameOffset, scope, elementName, this.fEditor, true, false, true) - 1;
        if (elementClosedBracketOffset < 0) {
            return null;
        }
        Region elementRegion = new Region(elementOpenBracketOffset, elementClosedBracketOffset - elementOpenBracketOffset);
        Object[] formatSpecifiersInfo = this.getFormatSpecifiersContextInfo(elementRegion, element, scopeNamedElement, cursorOffset);
        if (formatSpecifiersInfo != null) {
            Region formatSpecifierRegion = (Region)formatSpecifiersInfo[0];
            IContextInformation formatSpecifierValuesContextInfo = (IContextInformation)formatSpecifiersInfo[1];
            if (formatSpecifierValuesContextInfo != null) {
                return new IContextInformation[]{formatSpecifierValuesContextInfo};
            }
            if (formatSpecifierRegion != null) {
                elementClosedBracketOffset -= formatSpecifierRegion.getLength() + 1;
            }
        }
        if ((elementOpenBracketOffset = VlogParameterHintsUtils.getInstance().getContextInformationOffset(this.getDocument(), elementNameOffset, scope, elementName, this.fEditor, false, false, false)) < 0) {
            return null;
        }
        String wrapped = DVTStringUtil.textWrap((int)75, (String)elementArguments).toString();
        String tooltip = DVTStringUtil.breakLongNonWhitespaceSequences((String)wrapped, (int)75, (char)'\n');
        return new IContextInformation[]{new DVTProposalContextInformation(DvtContextInformationType.ARGUMENTS_OR_ORDERED_PORT_CONNECTIONS, tooltip, tooltip, elementOpenBracketOffset, elementClosedBracketOffset - elementOpenBracketOffset, "__vlog_partitioning")};
    }

    private Object[] getFormatSpecifiersContextInfo(Region methodCallRegion, IRfNamedElement element, IRfNamedElement scopeNamedElement, int offset) {
        Object[] result;
        block5: {
            Map<String, Region> allFormatSpecifiersWithRegions;
            block6: {
                result = new Object[2];
                String elementName = element.getName();
                if (!(element instanceof RfPredefinedFunction) || !elementName.startsWith("$") || !FormatSpecifiersUtils.ALL_FORMAT_STRING_SYSTEM_TASKS.contains(elementName)) break block5;
                VlogSystemTaskAtOffsetVisitor systemTaskVisitor = new VlogSystemTaskAtOffsetVisitor(methodCallRegion, element);
                scopeNamedElement.visitHidObject(null, (IHidVisitor)systemTaskVisitor);
                allFormatSpecifiersWithRegions = systemTaskVisitor.getFormatSpecifiersRegions();
                if (allFormatSpecifiersWithRegions != null && !allFormatSpecifiersWithRegions.isEmpty()) break block6;
                return null;
            }
            try {
                ArrayList<Region> allRegions = new ArrayList<Region>(allFormatSpecifiersWithRegions.values());
                Region firstRegion = (Region)allRegions.get(0);
                Region lastRegion = (Region)allRegions.get(allRegions.size() - 1);
                int formatSpecifiersStartOffset = firstRegion.getOffset();
                int formatSpecifiersEndOffset = lastRegion.getOffset() + lastRegion.getLength();
                boolean foundRegionAtOffset = false;
                String formatSpecifiersString = "";
                for (Map.Entry<String, Region> entry : allFormatSpecifiersWithRegions.entrySet()) {
                    String formatRegions = entry.getKey();
                    IRegion formatSpecifierValuesRegion = this.computeFormatSpecValuesRegion((IRegion)entry.getValue());
                    if (formatSpecifierValuesRegion == null || !DVTDocumentUtils.regionContains((IRegion)formatSpecifierValuesRegion, (int)offset)) continue;
                    formatSpecifiersStartOffset = formatSpecifierValuesRegion.getOffset();
                    formatSpecifiersEndOffset = formatSpecifiersStartOffset + formatSpecifierValuesRegion.getLength();
                    foundRegionAtOffset = true;
                    formatSpecifiersString = formatRegions;
                    break;
                }
                int formatSpecifierValuesRegionLength = formatSpecifiersEndOffset - formatSpecifiersStartOffset;
                Region formatSpecifierValuesRegion = new Region(formatSpecifiersStartOffset, formatSpecifierValuesRegionLength);
                result[0] = formatSpecifierValuesRegion;
                if (foundRegionAtOffset) {
                    result[1] = new DVTProposalContextInformation(DvtContextInformationType.FORMAT_SPECIFIERS, formatSpecifiersString, formatSpecifiersString, formatSpecifiersStartOffset, formatSpecifierValuesRegionLength, "__vlog_partitioning");
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        return result;
    }

    private IRegion computeFormatSpecValuesRegion(IRegion initialRegion) {
        Object[] nextCodeCharPair;
        if (initialRegion == null) {
            return null;
        }
        IRegion result = initialRegion;
        int regionStartOffset = -1;
        Object[] nextNWSCodeCharPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)this.getDocument(), (int)result.getOffset(), (boolean)true, (String)"__vlog_partitioning");
        if (nextNWSCodeCharPair != null && ((Character)nextNWSCodeCharPair[0]).charValue() == ',') {
            regionStartOffset = (Integer)nextNWSCodeCharPair[1];
        }
        int regionEndOffset = result.getOffset() + result.getLength();
        int completeRegionStartOffset = -1;
        int completeRegionEndOffset = -1;
        Object[] previousCodeCharPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)this.getDocument(), (int)regionStartOffset, (boolean)false, (String)"__vlog_partitioning");
        if (previousCodeCharPair != null && ((Character)previousCodeCharPair[0]).charValue() == ',') {
            completeRegionStartOffset = (Integer)previousCodeCharPair[1];
        }
        if ((nextCodeCharPair = DVTDocumentUtils.nextCodeCharOffsetPair((IDocument)this.getDocument(), (int)regionEndOffset, (boolean)true, (String)"__vlog_partitioning")) != null && (((Character)nextCodeCharPair[0]).charValue() == ',' || ((Character)nextCodeCharPair[0]).charValue() == ')')) {
            completeRegionEndOffset = (Integer)nextCodeCharPair[1];
        }
        if (completeRegionStartOffset > 0 && completeRegionEndOffset > 0 && completeRegionEndOffset > completeRegionStartOffset) {
            result = new Region(completeRegionStartOffset, completeRegionEndOffset - completeRegionStartOffset);
        }
        return result;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return new VlogParameterListValidator();
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IPreferenceStore getPreferenceStore() {
        return VlogPlugin.getDefault().getPreferenceStore();
    }

    protected boolean init(int offset) {
        if (this.fAlreadyComputed) {
            return true;
        }
        if (this.fDocument == null || this.fFile == null) {
            return false;
        }
        IProject project = this.fFile.getProject();
        if (project != null) {
            if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
                return false;
            }
            this.fRfProject = RfManager.getInstance().getRfProject(project);
            if (this.fRfProject != null) {
                RfFileDef fileDef = this.fRfProject.getFile((IResource)this.fFile);
                if (fileDef != null) {
                    this.fInitialScope = fileDef.getScope(offset, true, true, null);
                }
                this.fInstance = null;
                if (this.fInitialScope instanceof RfFieldDef && ((RfFieldDef)this.fInitialScope).getNamedElement() instanceof RfInstance) {
                    this.fInstance = (RfInstance)((RfFieldDef)this.fInitialScope).getNamedElement();
                    this.fInitialScope = ((RfFieldDef)this.fInitialScope).getNamedElement().getEnclosingScope();
                }
            }
        }
        return true;
    }

    public ICompletionProposal getNoProposal(ITextViewer viewer, int offset) {
        return new RfLazyCompletionProposal(RfTypesResolver.create((IRfScopeElement)this.fInitialScope, this.fRfProject, 6), viewer, viewer.getDocument(), this.fInitialScope, new R2LNoProposalElement(), "", offset, false, false, -1, false, true, null, 0, null);
    }

    public abstract boolean init(ITextViewer var1, int var2);

    protected abstract PositionalTooltipsNamedElementAndOffsetWrapper getNamedElementAndOffsetAtOffset(RfProject var1, IFile var2, VlogEditor var3, int var4, int var5);
}

