/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.jface.text.templates.TemplateVariable;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtilCommon;

public class VlogContentAssistUtil
extends VlogContentAssistUtilCommon {

    public static class LinkedPositionBuilder {
        private DVTEditor editor;
        private DVTLinkedPositionProvider provider;
        private int replacementOffset;
        private int replacementLength;
        private String replacementText;
        private boolean disableFormatting;
        private int positionShiftOffset;

        public LinkedPositionBuilder withEditor(DVTEditor editor) {
            this.editor = editor;
            return this;
        }

        public LinkedPositionBuilder withProvider(DVTLinkedPositionProvider provider) {
            this.provider = provider;
            return this;
        }

        public LinkedPositionBuilder withReplacementOffset(int replacementOffset) {
            this.replacementOffset = replacementOffset;
            return this;
        }

        public LinkedPositionBuilder withReplacementLength(int replacementLength) {
            this.replacementLength = replacementLength;
            return this;
        }

        public LinkedPositionBuilder withReplacementText(String replacementText) {
            this.replacementText = replacementText;
            return this;
        }

        public LinkedPositionBuilder withDisableFormatting(boolean disableFormatting) {
            this.disableFormatting = disableFormatting;
            return this;
        }

        public LinkedPositionBuilder withPositionShiftOffset(int positionShiftOffset) {
            this.positionShiftOffset = positionShiftOffset;
            return this;
        }

        public VlogContentAssistUtilCommon.LinkedPositionResult build() throws BadLocationException, TemplateException, BadPositionCategoryException {
            VlogContentAssistUtilCommon.LinkedPositionResult result = new VlogContentAssistUtilCommon.LinkedPositionResult();
            if (this.editor == null) {
                return result;
            }
            IDocument document = this.editor.getDocument();
            if (document == null) {
                return result;
            }
            if (this.provider == null) {
                return result;
            }
            Region region = new Region(this.replacementOffset, this.replacementText.length());
            TemplateContext context = VlogContentAssistUtil.createDummyContext(document, (IRegion)region, this.disableFormatting);
            Template template = new Template("", "", "ro.amiq.vlogdt.templates.contextType.unknown", this.replacementText, true);
            TemplateBuffer templateBuffer = context.evaluate(template);
            document.replace(this.replacementOffset, this.replacementLength, templateBuffer.getString());
            result.templateProposal = new TemplateProposal(template, context, (IRegion)region, null, 1);
            List<IRegion> linkedPositionRegions = LinkedPositionBuilder.computeLinkedPositionRegionsFromTemplate(templateBuffer);
            if (linkedPositionRegions == null || linkedPositionRegions.isEmpty() || this.provider == null) {
                return result;
            }
            this.provider.setHasPositions(true);
            IRegion firstRegion = null;
            for (IRegion linkedPosRegion : linkedPositionRegions) {
                if (firstRegion == null) {
                    firstRegion = linkedPosRegion;
                }
                this.provider.addSingleLinkedPosition(this.replacementOffset + linkedPosRegion.getOffset() + this.positionShiftOffset, linkedPosRegion.getLength(), document);
            }
            if (firstRegion != null) {
                Region offsetFirstRegion = new Region(this.replacementOffset + firstRegion.getOffset() + this.positionShiftOffset, firstRegion.getLength());
                this.editor.selectAndReveal(offsetFirstRegion.getOffset(), offsetFirstRegion.getLength());
                result.firstLinkedRegion = offsetFirstRegion;
                result.cursorPosition = this.editor.getCursor();
            }
            return result;
        }

        private static List<IRegion> computeLinkedPositionRegionsFromTemplate(TemplateBuffer templateBuffer) {
            ArrayList<IRegion> linkedPositionRegions = new ArrayList<IRegion>();
            TemplateVariable[] templateVariables = templateBuffer.getVariables();
            if (templateVariables == null) {
                return linkedPositionRegions;
            }
            TemplateVariable[] templateVariableArray = templateVariables;
            int n = templateVariables.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateVariable templateVariable = templateVariableArray[n2];
                int[] templateOffsets = templateVariable.getOffsets();
                if (templateOffsets != null) {
                    String templateVarName = templateVariable.getName();
                    int[] nArray = templateOffsets;
                    int n3 = templateOffsets.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int offset = nArray[n4];
                        linkedPositionRegions.add((IRegion)new Region(offset, templateVarName.length()));
                        ++n4;
                    }
                }
                ++n2;
            }
            return linkedPositionRegions;
        }
    }
}

