/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfComputedListType;
import ro.amiq.vlogdt.model.reflection.RfComputedStruct;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.ui.editor.contentassist.DVTDocumentTemplateContext;

public class VlogContentAssistUtilCommon {
    private static final String TO_RANGE_VHDL = "to";
    private static final String DOWNTO_RANGE_VHDL = "downto";

    public static String getPortsGroupedByDirection(Collection<? extends IRfPortElement> ports, String instanceAlignment, String portAlignment, boolean isAutoRangeEnabled, boolean sortAlphabetically, boolean useLogicInsteadOfWire, boolean preserveComments, String lineDelimiter, IRfDesignElement candidate, IRfScopeElement scope, StringBuilder headerWires, boolean dontExpandMacros) {
        ArrayList<IRfPortElement> inputs = new ArrayList<IRfPortElement>();
        ArrayList<IRfPortElement> inouts = new ArrayList<IRfPortElement>();
        ArrayList<IRfPortElement> outputs = new ArrayList<IRfPortElement>();
        ArrayList<? extends IRfPortElement> refs = new ArrayList<IRfPortElement>();
        StringBuilder replacementString = new StringBuilder();
        boolean hasUnknownsOrPortSelects = ports.stream().filter(port -> port.isNonANSIImplicitPort()).findFirst().isPresent();
        boolean useNamedConnections = !(candidate instanceof RfPrimitive) && !hasUnknownsOrPortSelects;
        Iterator<? extends IRfPortElement> it = ports.iterator();
        while (it.hasNext()) {
            IRfPortElement port2 = it.next();
            if (port2.isInput()) {
                inputs.add(port2);
                it.remove();
                continue;
            }
            if (port2.isInout()) {
                inouts.add(port2);
                it.remove();
                continue;
            }
            if (!port2.isOutput()) continue;
            outputs.add(port2);
            it.remove();
        }
        if (!ports.isEmpty()) {
            refs.addAll(ports);
        }
        boolean insertedPorts = false;
        HashSet<String> added = new HashSet<String>();
        if (candidate instanceof RfPrimitive) {
            if (!outputs.isEmpty()) {
                replacementString.append(VlogContentAssistUtilCommon.addPorts(useNamedConnections, outputs, inputs.isEmpty(), "// Outputs", portAlignment, isAutoRangeEnabled, lineDelimiter, sortAlphabetically, preserveComments));
                headerWires.append(VlogContentAssistUtilCommon.addSignals(outputs, lineDelimiter, scope, dontExpandMacros, useLogicInsteadOfWire, added));
                insertedPorts = true;
            }
            if (!inputs.isEmpty()) {
                replacementString.append(VlogContentAssistUtilCommon.addPorts(useNamedConnections, inputs, true, "// Inputs", portAlignment, isAutoRangeEnabled, lineDelimiter, sortAlphabetically, preserveComments));
                headerWires.append(VlogContentAssistUtilCommon.addSignals(inputs, lineDelimiter, scope, dontExpandMacros, useLogicInsteadOfWire, added));
                insertedPorts = true;
            }
        } else {
            if (!inputs.isEmpty()) {
                replacementString.append(VlogContentAssistUtilCommon.addPorts(useNamedConnections, inputs, inouts.isEmpty() && outputs.isEmpty() && refs.isEmpty(), "// Inputs", portAlignment, isAutoRangeEnabled, lineDelimiter, sortAlphabetically, preserveComments));
                headerWires.append(VlogContentAssistUtilCommon.addSignals(inputs, lineDelimiter, scope, dontExpandMacros, useLogicInsteadOfWire, added));
                insertedPorts = true;
            }
            if (!inouts.isEmpty()) {
                replacementString.lastIndexOf(",");
                replacementString.append(VlogContentAssistUtilCommon.addPorts(useNamedConnections, inouts, outputs.isEmpty() && refs.isEmpty(), "// Inouts", portAlignment, isAutoRangeEnabled, lineDelimiter, sortAlphabetically, preserveComments));
                headerWires.append(VlogContentAssistUtilCommon.addSignals(inouts, lineDelimiter, scope, dontExpandMacros, useLogicInsteadOfWire, added));
                insertedPorts = true;
            }
            if (!outputs.isEmpty()) {
                replacementString.append(VlogContentAssistUtilCommon.addPorts(useNamedConnections, outputs, refs.isEmpty(), "// Outputs", portAlignment, isAutoRangeEnabled, lineDelimiter, sortAlphabetically, preserveComments));
                headerWires.append(VlogContentAssistUtilCommon.addSignals(outputs, lineDelimiter, scope, dontExpandMacros, useLogicInsteadOfWire, added));
                insertedPorts = true;
            }
            if (!refs.isEmpty()) {
                replacementString.append(VlogContentAssistUtilCommon.addPorts(useNamedConnections, refs, true, "// Refs", portAlignment, isAutoRangeEnabled, lineDelimiter, sortAlphabetically, preserveComments));
                headerWires.append(VlogContentAssistUtilCommon.addSignals(refs, lineDelimiter, scope, dontExpandMacros, useLogicInsteadOfWire, added));
                insertedPorts = true;
            }
        }
        if (insertedPorts) {
            replacementString.append(lineDelimiter).append(instanceAlignment);
        }
        return replacementString.toString();
    }

    public static void addSignal(IRfPortElement port, String lineDelimiter, IRfScopeElement scope, boolean dontExpandMacros, StringBuilder builder, boolean useLogicInsteadOfWire, Set<String> added) {
        if (port == null || builder == null) {
            return;
        }
        String portName = port.getName();
        if (scope != null && (scope.getSignalWithPrefix(portName, 1) != null || scope.getInstanceWithPrefix(portName, 1) != null)) {
            added.add(portName);
            return;
        }
        portName = VlogContentAssistUtilCommon.getEscName((IRfNamedElement)port);
        if (added.contains(portName)) {
            return;
        }
        added.add(portName);
        String portPackedDim = VlogContentAssistUtilCommon.computePortDimension(port);
        String portUnpackedDim = "";
        if (portPackedDim == null) {
            portPackedDim = "";
        }
        if (port instanceof RfPort) {
            RfPort rfPort = (RfPort)port;
            if (dontExpandMacros) {
                portPackedDim = rfPort.getPackedDimensionWithMacros();
                portUnpackedDim = rfPort.getUnpackedDimensionWithMacros();
            } else {
                portUnpackedDim = rfPort.getUnpackedDimension();
            }
        } else if (!portPackedDim.isEmpty()) {
            portPackedDim = portPackedDim.replaceFirst("(.*)(\\s*downto\\s*)(.*)", "[$1:$3]");
        }
        if (!portPackedDim.isEmpty()) {
            portPackedDim = String.valueOf(portPackedDim) + " ";
        }
        if (!portUnpackedDim.isEmpty()) {
            portUnpackedDim = " " + portUnpackedDim;
        }
        String typeName = "";
        typeName = useLogicInsteadOfWire ? "logic " : "wire ";
        String interfaceInstancePorts = "";
        if (port instanceof RfPort) {
            RfTypesResolver typesResolver = RfTypesResolver.create(port.getEnclosingScope(), port.getRfProject(), 0);
            IRfNamedElement associatedType = ((RfPort)port).getAssociatedType(typesResolver);
            if (associatedType instanceof RfComputedListType) {
                associatedType = ((RfComputedListType)associatedType).getAssociatedBaseType(typesResolver);
            }
            if (associatedType instanceof RfTypeAlias || associatedType instanceof RfComputedStruct) {
                typeName = VlogContentAssistUtilCommon.computeStructTypeName(typeName, associatedType);
            } else if (associatedType instanceof RfInterface) {
                StringBuilder portConnections = new StringBuilder("(");
                typeName = VlogContentAssistUtilCommon.computeInterfaceTypeName((RfInterface)associatedType, portConnections, lineDelimiter, scope, dontExpandMacros, builder, useLogicInsteadOfWire, added);
                portConnections.append(")");
                interfaceInstancePorts = portConnections.toString();
            }
        }
        builder.append(typeName);
        builder.append(portPackedDim).append("${").append(portName).append("}").append(interfaceInstancePorts).append(portUnpackedDim).append(";").append(lineDelimiter);
    }

    private static String computeInterfaceTypeName(RfInterface interfaceType, StringBuilder portConnections, String lineDelimiter, IRfScopeElement scope, boolean dontExpandMacros, StringBuilder builder, boolean useLogicInsteadOfWire, Set<String> added) {
        String dataType = String.valueOf(interfaceType.getName()) + " ";
        List<IRfPortElement> localPorts = interfaceType.getLocalPorts();
        if (localPorts == null || localPorts.isEmpty()) {
            return dataType;
        }
        portConnections.append(lineDelimiter);
        int index = 0;
        for (IRfPortElement interfacePort : localPorts) {
            String interfacePortName = interfacePort.getName();
            portConnections.append(".").append(interfacePortName).append("(").append("${").append(interfacePortName).append("}").append(")").append(++index < localPorts.size() ? "," : "").append(lineDelimiter);
            VlogContentAssistUtilCommon.addSignal(interfacePort, lineDelimiter, scope, dontExpandMacros, builder, useLogicInsteadOfWire, added);
        }
        return dataType;
    }

    private static String computeStructTypeName(String dataType, IRfNamedElement associatedType) {
        if (associatedType instanceof RfComputedStruct) {
            return String.valueOf(((RfComputedStruct)associatedType).getAliasName()) + " ";
        }
        if (associatedType instanceof RfTypeAlias) {
            DataType translatedDataType = ((RfTypeAlias)associatedType).getDataType();
            if (translatedDataType == null) {
                return dataType;
            }
            String typeName = translatedDataType.getType();
            if (typeName.startsWith("enum/") || typeName.startsWith("struct/") || typeName.startsWith("union/")) {
                return String.valueOf(associatedType.getName()) + " ";
            }
        }
        return dataType;
    }

    public static String addSignals(Collection<? extends IRfPortElement> ports, String lineDelimiter, IRfScopeElement scope, boolean dontExpandMacrosInSignalDimensions, boolean useLogicInsteadOfWire, Set<String> added) {
        if (ports == null || ports.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (IRfPortElement iRfPortElement : ports) {
            VlogContentAssistUtilCommon.addSignal(iRfPortElement, lineDelimiter, scope, dontExpandMacrosInSignalDimensions, result, useLogicInsteadOfWire, added);
        }
        return result.toString();
    }

    public static String getEscName(IRfNamedElement element) {
        boolean isEscapedId = element.isEscaped();
        String name = element.getName();
        if (element instanceof IRfPortElement && ((IRfPortElement)element).isNonANSIImplicitPort()) {
            return name.substring(1, name.length() - 1);
        }
        return isEscapedId ? "\\" + name + " " : name;
    }

    public static String addPorts(boolean namedPorts, Collection<? extends IRfPortElement> categoryPorts, boolean last, String categoryComment, String portAlignment, boolean isAutoRangeEnabled, String lineDelimiter, boolean sortAlphabetically, boolean preserveComments) {
        StringBuilder replacementString = new StringBuilder();
        if (categoryPorts == null || categoryPorts.isEmpty()) {
            return replacementString.toString();
        }
        ArrayList<? extends IRfPortElement> categoryPortsList = new ArrayList<IRfPortElement>(categoryPorts);
        if (sortAlphabetically) {
            Collections.sort(categoryPortsList, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof IRfPortElement && o2 instanceof IRfPortElement) {
                        String name1 = VlogContentAssistUtilCommon.getEscName((IRfNamedElement)((IRfPortElement)o1));
                        String name2 = VlogContentAssistUtilCommon.getEscName((IRfNamedElement)((IRfPortElement)o2));
                        return name1.compareTo(name2);
                    }
                    return 0;
                }
            });
        }
        if (categoryComment != null) {
            replacementString.append(lineDelimiter).append(portAlignment).append(categoryComment);
        }
        int size = categoryPortsList.size();
        int i = 0;
        while (i < size) {
            String inlineComment;
            String aboveComment;
            CommentBlock commentBlock = null;
            IRfPortElement port = (IRfPortElement)categoryPortsList.get(i);
            if (preserveComments) {
                commentBlock = port.getCommentBlock();
            }
            if (commentBlock != null && (aboveComment = commentBlock.getAboveComment()) != null && !aboveComment.isEmpty()) {
                String[] tokens;
                String[] stringArray = tokens = aboveComment.split("(?:\\r\\n)|(?:[\\r\\n])");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String tok = stringArray[n2];
                    replacementString.append(lineDelimiter).append(portAlignment).append("// ").append(tok);
                    ++n2;
                }
            }
            replacementString.append(lineDelimiter).append(portAlignment);
            String portName = VlogContentAssistUtilCommon.getEscName((IRfNamedElement)port).replace("$", "$$");
            String portVarName = VlogContentAssistUtilCommon.getEscName((IRfNamedElement)port);
            if (namedPorts) {
                replacementString.append(".").append(portName).append("(${").append(portVarName).append("}").append(isAutoRangeEnabled ? port.getRange() : "").append(")");
            } else {
                replacementString.append("${").append(portVarName).append("}").append(isAutoRangeEnabled ? port.getRange() : "");
            }
            if (!last || i + 1 < size) {
                replacementString.append(",");
            }
            if (commentBlock != null && (inlineComment = commentBlock.getInlineComment()) != null && !inlineComment.isEmpty()) {
                replacementString.append(" //").append(inlineComment);
            }
            ++i;
        }
        return replacementString.toString();
    }

    public static TemplateContext createDummyContext(IDocument document, IRegion region) {
        return VlogContentAssistUtilCommon.createDummyContext(document, region, false);
    }

    public static TemplateContext createDummyContext(IDocument document, IRegion region, boolean disableFormatting) {
        TemplateContextType contextType = new TemplateContextType("ro.amiq.vlogdt.templates.contextType.unknown", "dummy");
        return new DVTDocumentTemplateContext(contextType, document, region.getOffset(), region.getLength(), disableFormatting);
    }

    private static String computePortDimension(IRfPortElement port) {
        if (port instanceof RfPort) {
            return port.getRange();
        }
        StringBuilder result = new StringBuilder();
        String range = port.getRange();
        if (range == null) {
            return null;
        }
        int indexOfTo = range.toLowerCase().indexOf(TO_RANGE_VHDL);
        int indexOfDownto = range.toLowerCase().indexOf(DOWNTO_RANGE_VHDL);
        if (indexOfDownto != -1) {
            result.append("[" + range.substring(0, indexOfDownto).trim());
            result.append(":");
            result.append(String.valueOf(range.substring(indexOfDownto + DOWNTO_RANGE_VHDL.length()).trim()) + "]");
        } else if (indexOfTo != -1) {
            result.append("[" + range.substring(0, indexOfTo).trim());
            result.append(":");
            result.append(String.valueOf(range.substring(indexOfTo + TO_RANGE_VHDL.length()).trim()) + "]");
        } else if (!range.isEmpty()) {
            result.append("[" + range + "]");
        }
        return result.toString();
    }

    public static int getLineOfOffset(IDocument document, int offset) {
        try {
            return document.getLineOfOffset(offset) + 1;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return 0;
        }
    }

    public static class LinkedPositionResult {
        public int cursorPosition;
        public IRegion firstLinkedRegion;
        public TemplateProposal templateProposal;

        public LinkedPositionResult() {
        }

        public LinkedPositionResult(int cursorPosition) {
            this.cursorPosition = cursorPosition;
        }
    }
}

