/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.r2lparser.R2LManager;
import ro.amiq.vlogdt.r2lparser.R2LProposalManager;
import ro.amiq.vlogdt.r2lparser.R2LResultContainer;
import ro.amiq.vlogdt.ui.editor.VlogPartitionScanner;
import ro.amiq.vlogdt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.RfDebugLazyCompletionProposal;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistProcessorManager;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistUtilCommon;

public class VlogDebugContentAssistProcessor
extends RfContentAssistProcessor {
    private int breakpointLineOffset;
    private IFile breakpointFile;

    public VlogDebugContentAssistProcessor(VlogContentAssistProcessorManager processor, IFile breakpointFile, int breakpointLineOffset) {
        super(processor);
        this.breakpointLineOffset = breakpointLineOffset;
        this.breakpointFile = breakpointFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ICompletionProposal[] getProposals(ITextViewer viewer, int offset) {
        try {
            VlogContentAssistProcessorManager caProcessor = this.getProcessor();
            if (caProcessor.isCanceled()) {
                return null;
            }
            IDocument conditionDocument = viewer.getDocument();
            if (conditionDocument == null) {
                return null;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)caProcessor.getFile());
            if (parserPath == null) {
                return null;
            }
            Document auxDocument = new Document();
            IPath fileLocation = this.breakpointFile.getLocation();
            if (fileLocation == null) {
                return null;
            }
            StringBuilder fileContent = new StringBuilder(new String(Files.readAllBytes(fileLocation.toFile().toPath())));
            fileContent.insert(this.breakpointLineOffset, conditionDocument.get());
            auxDocument.set(fileContent.toString());
            int[] caretOffset = new int[]{-1};
            Display.getDefault().syncExec(() -> {
                nArray[0] = ((SourceViewer)viewer).getTextWidget().getCaretOffset();
            });
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new VlogPartitionScanner(), new String[]{"__vlog_sl_comment", "__vlog_ml_comment", "__vlog_literal", "__vlog_escaped_id", "__dftl_partition_content_type"});
            auxDocument.setDocumentPartitioner("__vlog_partitioning", (IDocumentPartitioner)partitioner);
            partitioner.connect((IDocument)auxDocument);
            auxDocument.setDocumentPartitioner(conditionDocument.getDocumentPartitioner());
            R2LProposalManager manager = new R2LProposalManager(caProcessor.getEditor(), caProcessor.getRfProject(), caProcessor.getInitialScope(), caProcessor.getInstanceScope(), parserPath, (IDocument)auxDocument, this.breakpointLineOffset + caretOffset[0]);
            R2LResultContainer container = ((R2LManager)manager).getProposals();
            if (container == null) {
                return null;
            }
            if (caProcessor.isCanceled()) {
                return null;
            }
            IRfNamedElement[] allCandidates = container.candidates;
            File[] fileCandidates = container.fileCandidates;
            this.fAllowProposals = container.allowProposals();
            if (caProcessor.isCanceled()) {
                return null;
            }
            if (fileCandidates != null) {
                return this.getIncludeProposals(viewer, fileCandidates, offset, container.prefix, false, false);
            }
            if (allCandidates == null || allCandidates.length == 0) {
                return null;
            }
            ArrayList<IRfNamedElement> candidatesWithoutDuplicates = new ArrayList<IRfNamedElement>();
            candidatesWithoutDuplicates.add(allCandidates[0]);
            IRfNamedElement previousCandidate = allCandidates[0];
            int i = 1;
            while (true) {
                if (i >= allCandidates.length) {
                    if (!caProcessor.isCanceled()) break;
                    return null;
                }
                if (caProcessor.isCanceled()) {
                    return null;
                }
                IRfNamedElement currentCandidate = allCandidates[i];
                if (!currentCandidate.getName().equals(previousCandidate.getName()) || !currentCandidate.getSignature().equals(previousCandidate.getSignature())) {
                    candidatesWithoutDuplicates.add(currentCandidate);
                    previousCandidate = currentCandidate;
                }
                ++i;
            }
            return this.getCompletionProposals(container.resolver, viewer, conditionDocument, candidatesWithoutDuplicates, container.prefix, offset, container.isImport, container.isExtern, container.rule);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    @Override
    protected ICompletionProposal[] getCompletionProposals(RfTypesResolver resolver, ITextViewer viewer, IDocument document, ArrayList<IRfNamedElement> candidates, String prefix, int offset, boolean isImport, boolean isExtern, int rule) {
        if (candidates == null) {
            return null;
        }
        boolean typeCompatibleArgument = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.type_compatible_argument");
        boolean insertOptionalArguments = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.insert_optional_arguments");
        RfDebugLazyCompletionProposal[] result = new RfDebugLazyCompletionProposal[candidates.size()];
        IFile file = this.getProcessor().getFile();
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        int line = VlogContentAssistUtilCommon.getLineOfOffset(document, offset);
        int i = 0;
        while (i < candidates.size()) {
            RfDebugLazyCompletionProposal completionProposal = new RfDebugLazyCompletionProposal(resolver, viewer, document, this.getProcessor().getInitialScope(), candidates.get(i), prefix, offset, isImport, isExtern, rule, typeCompatibleArgument, insertOptionalArguments, null, line, parserPath);
            completionProposal.fEditor = null;
            result[i] = completionProposal;
            ++i;
        }
        return result;
    }
}

