/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.r2lparser.R2LBusy;
import ro.amiq.vlogdt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.RfLazyCompletionProposal;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogAutoInstanceContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistProcessorManager;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogKeywordContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogTemplateContentAssistProcessor;

public class VlogDebugContentAssistProcessorManager
extends VlogContentAssistProcessorManager {
    private LineBreakpoint breakpoint;
    private ISourceViewer viewer;

    @Override
    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public VlogDebugContentAssistProcessorManager(ContentAssistant assistant, LineBreakpoint breakpoint, ISourceViewer viewer) {
        super(null, assistant);
        this.breakpoint = breakpoint;
        this.viewer = viewer;
    }

    @Override
    public IDocument getDocument() {
        if (this.viewer == null) {
            return null;
        }
        return this.viewer.getDocument();
    }

    @Override
    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    @Override
    public ICompletionProposal[] nonUiComputeCompletionProposals(ITextViewer viewer, int offset) {
        block11: {
            block10: {
                if (viewer != null) break block10;
                return null;
            }
            if (this.init(viewer, offset)) break block11;
            return null;
        }
        try {
            this.setContextType();
            if (this.fFile == null || this.fRfProject == null) {
                ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                for (IContentAssistProcessor processor : this.fProcessors) {
                    if (!(processor instanceof VlogTemplateContentAssistProcessor) && !(processor instanceof VlogKeywordContentAssistProcessor)) continue;
                    this.addProposalsToList(processor.computeCompletionProposals(viewer, offset), proposals);
                }
                if (proposals.isEmpty()) {
                    proposals.add(this.getNoProposal(viewer, offset));
                }
                return this.getProposalArray(proposals);
            }
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            boolean isNoProposal = false;
            for (IContentAssistProcessor processor : this.fProcessors) {
                if (processor instanceof VlogAutoInstanceContentAssistProcessor) continue;
                this.addProposalsToList(processor.computeCompletionProposals(viewer, offset), proposals);
                if (!(processor instanceof RfContentAssistProcessor)) continue;
                if (!((RfContentAssistProcessor)processor).fAllowProposals) break;
                if (proposals.isEmpty() || !(proposals.get(0) instanceof RfLazyCompletionProposal) || !((RfLazyCompletionProposal)proposals.get(0)).isNoProposal()) continue;
                isNoProposal = true;
            }
            if (isNoProposal && proposals.size() > 1) {
                proposals.remove(0);
            }
            if (proposals.isEmpty()) {
                proposals.add(this.getNoProposal(viewer, offset));
            }
            return this.getProposalArray(proposals);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return this.getProposalArray(Arrays.asList(this.getNoProposal(viewer, offset)));
        }
    }

    @Override
    public boolean init(ITextViewer editorViewer, int conditionCaretOffset) {
        this.fDocument = editorViewer.getDocument();
        if (this.fDocument == null) {
            return false;
        }
        if (this.breakpoint == null) {
            return false;
        }
        this.fFile = (IFile)this.breakpoint.getMarker().getResource();
        int breakpointOffset = 0;
        try {
            this.fLine = this.breakpoint.getLineNumber();
            breakpointOffset = DVTFileUtils.getInstance().getLineOffset(this.fFile, this.fLine - 1);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return this.init(breakpointOffset);
    }

    @Override
    public int getTabWidth() {
        return this.viewer.getTextWidget().getTabs();
    }

    @Override
    protected RfProject computeRfProject() {
        if (this.breakpoint == null) {
            return null;
        }
        this.fFile = (IFile)this.breakpoint.getMarker().getResource();
        if (this.fFile == null) {
            return null;
        }
        IProject project = this.fFile.getProject();
        if (project == null) {
            return null;
        }
        this.fRfProject = RfManager.getInstance().getRfProject(project);
        return this.fRfProject;
    }

    @Override
    protected ICompletionProposal getBusyProposal(ITextViewer viewer, int fOffset) {
        RfLazyCompletionProposal completionProposal = new RfLazyCompletionProposal(RfTypesResolver.create((IRfScopeElement)this.fInitialScope, this.fRfProject, 14), viewer, viewer.getDocument(), this.fInitialScope, new R2LBusy(), "", fOffset, false, false, -1, false, true, null, 0, null);
        completionProposal.fEditor = null;
        return completionProposal;
    }
}

