/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfPropertySequence;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.contentassist.KeywordProposal;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistProcessorManager;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class VlogKeywordContentAssistProcessor
implements IContentAssistProcessor {
    private VlogContentAssistProcessorManager fProcessor;
    private static final Comparator<ICompletionProposal> ORDER_COMPARATOR = new Comparator<ICompletionProposal>(){

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            String icp1 = o1.getDisplayString();
            String icp2 = o2.getDisplayString();
            return icp1.compareTo(icp2);
        }
    };

    public VlogKeywordContentAssistProcessor(VlogContentAssistProcessorManager processor) {
        this.fProcessor = processor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String currentWord;
        ArrayList<ICompletionProposal> proposals;
        block6: {
            if (this.fProcessor.getCrtContentAssistPage() == 0 && !this.fProcessor.fIsGlobalProposal) {
                return null;
            }
            IDocument document = viewer.getDocument();
            VlogEditor vlogEditor = this.fProcessor.getEditor();
            if (vlogEditor == null) {
                return null;
            }
            try {
                proposals = new ArrayList<ICompletionProposal>();
                currentWord = this.lastWord(document, offset);
                if (currentWord != null && currentWord.length() != 0) break block6;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        this.fillProposals(offset, currentWord, proposals);
        Collections.sort(proposals, ORDER_COMPARATOR);
        ICompletionProposal verboseEndProposal = this.computeVerboseEndProposal(offset, currentWord);
        if (verboseEndProposal != null) {
            proposals.add(0, verboseEndProposal);
        }
        ICompletionProposal[] complProposals = proposals.toArray(new ICompletionProposal[proposals.size()]);
        return complProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String lastWord(IDocument doc, int offset) {
        try {
            int n = offset - 1;
            while (true) {
                if (n < -1) {
                    return "";
                }
                if (n == -1) {
                    return doc.get(n + 1, offset - n - 1);
                }
                char ch = doc.getChar(n);
                if (ch == '.') {
                    return null;
                }
                if (!Character.isJavaIdentifierPart(ch)) {
                    return doc.get(n + 1, offset - n - 1);
                }
                --n;
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return "";
    }

    private void fillProposals(int offset, String currentWord, ArrayList<ICompletionProposal> list) {
        String[] keywords = PrefConst.getKeywordsPreference();
        HashSet<String> keywordsSet = new HashSet<String>();
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            keywordsSet.add(keyword);
            ++n2;
        }
        for (String keyword : keywordsSet) {
            if (!keyword.startsWith(currentWord) || keyword.equals(currentWord)) continue;
            list.add(new KeywordProposal(this.fProcessor.getEditor(), offset - currentWord.length(), currentWord.length(), keyword));
        }
    }

    private ICompletionProposal computeVerboseEndProposal(int offset, String currentWord) {
        boolean appendContextInformation = VlogPlugin.getDefault().getPreferenceStore().getBoolean("ca.context_end_block");
        if (!appendContextInformation) {
            return null;
        }
        RfProject rfProject = this.fProcessor.getRfProject();
        if (rfProject == null) {
            return null;
        }
        IFile file = this.fProcessor.getFile();
        if (file == null) {
            return null;
        }
        RfFileDef fileDef = rfProject.getFile((IResource)file);
        if (fileDef == null) {
            return null;
        }
        RfDefElement cursorElement = fileDef.getScope(offset, true);
        if (cursorElement == null) {
            return null;
        }
        RfNamedElement namedElement = this.removeBeginEndFromFor(cursorElement.getNamedElement());
        String endBlock = this.getEndBlockKeyword(namedElement);
        if (endBlock == null) {
            return null;
        }
        if (!endBlock.startsWith(currentWord)) {
            return null;
        }
        KeywordProposal result = new KeywordProposal(this.fProcessor.getEditor(), offset - currentWord.length(), currentWord.length(), endBlock, namedElement);
        return result.getSemanticContextInformation() == null ? null : result;
    }

    private RfNamedElement removeBeginEndFromFor(RfNamedElement selectedScope) {
        if (!(selectedScope instanceof RfActionBlock)) {
            return selectedScope;
        }
        RfNamedElement enclosingScope = selectedScope.getEnclosingScope();
        boolean isInsideFor = enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isForOrForeach();
        boolean hasBeginEnd = ((RfActionBlock)selectedScope).hasBeginEnd() && selectedScope.isAnonymous();
        return isInsideFor && hasBeginEnd ? selectedScope.getEnclosingScope() : selectedScope;
    }

    private String getEndBlockKeyword(RfNamedElement namedElement) {
        if (namedElement instanceof RfChecker) {
            return "endchecker";
        }
        if (namedElement instanceof RfClass) {
            return "endclass";
        }
        if (namedElement instanceof RfClockingBlock) {
            return "endclocking";
        }
        if (namedElement instanceof RfConfiguration) {
            return "endconfig";
        }
        if (namedElement instanceof RfFunction) {
            if (((RfFunction)namedElement).isTask()) {
                return "endtask";
            }
            if (((RfFunction)namedElement).isFunction()) {
                return "endfunction";
            }
        }
        if (namedElement instanceof RfCovergroup) {
            return "endgroup";
        }
        if (namedElement instanceof RfInterface) {
            return "endinterface";
        }
        if (namedElement instanceof RfModule) {
            return "endmodule";
        }
        if (namedElement instanceof RfPackage) {
            return "endpackage";
        }
        if (namedElement instanceof RfPrimitive) {
            return "endprimitive";
        }
        if (namedElement instanceof RfProgram) {
            return "endprogram";
        }
        if (namedElement instanceof RfPropertySequence) {
            if (((RfPropertySequence)namedElement).getKind() == 1) {
                return "endproperty";
            }
            if (((RfPropertySequence)namedElement).getKind() == 2) {
                return "endsequence";
            }
        }
        if (namedElement instanceof RfActionBlock) {
            if (((RfActionBlock)namedElement).isCase()) {
                return "endcase";
            }
            return "end";
        }
        return null;
    }
}

