/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.ArrayDeque;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceDef;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;
import ro.amiq.vlogdt.ui.editor.contentassist.PositionalTooltipsNamedElementAndOffsetWrapper;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public abstract class VlogParameterHintsUtilsCommon {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getContextInformationOffset(IDocument document, int triggerOffset, IRfScope initialScope, String functionName, DVTEditor editor, boolean endOffset, boolean isApplyProposal, boolean isComputeFunctionCallStartOffset) {
        int rightBracketOffset;
        block15: {
            int leftBracketOffset;
            int scopeEndOffset;
            block14: {
                int functionNameStartOffset;
                int functionNameOffset;
                int scopeStartOffset;
                block13: {
                    char nextChar;
                    block12: {
                        if (functionName.isEmpty()) {
                            return triggerOffset;
                        }
                        scopeStartOffset = ((RfDefElement)initialScope).getStartOffset();
                        scopeStartOffset = scopeStartOffset >= 0 ? scopeStartOffset : (initialScope.getNamedElement() != null ? 0 : scopeStartOffset);
                        scopeEndOffset = ((RfDefElement)initialScope).getEndOffset();
                        scopeEndOffset = scopeEndOffset >= 0 ? scopeEndOffset : (initialScope.getNamedElement() != null ? document.getLength() : scopeEndOffset);
                        functionNameOffset = -1;
                        char chr = document.getChar(triggerOffset);
                        if (chr == '#') {
                            int leftBracket = DVTDocumentUtils.getCharOffset((char)'(', (int)triggerOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning");
                            if (endOffset) return DVTDocumentUtils.getMatchingRightBracketOffset((int)leftBracket, (DVTEditor)editor, (IDocument)document);
                            return leftBracket + 1;
                        }
                        VlogWordFinder vlogWordFinder = new VlogWordFinder();
                        IRegion wordAtOffsetRegion = vlogWordFinder.getWordAtOffset(document, triggerOffset);
                        functionNameStartOffset = -1;
                        if (wordAtOffsetRegion != null) {
                            String wordAtOffset = document.get(wordAtOffsetRegion.getOffset(), wordAtOffsetRegion.getLength());
                            if (wordAtOffset.startsWith("`")) {
                                wordAtOffset = wordAtOffset.replaceFirst("`", "");
                            }
                            if (wordAtOffset.equals(functionName)) {
                                functionNameOffset = wordAtOffsetRegion.getOffset() + wordAtOffsetRegion.getLength();
                                functionNameStartOffset = wordAtOffsetRegion.getOffset();
                            }
                        }
                        if (functionNameOffset < 0) {
                            functionNameOffset = VlogQuickFixUtil.getInstance().getBackwardOffsetFor(document, functionName, scopeStartOffset, triggerOffset, false) + functionName.length();
                        }
                        if (functionNameOffset > scopeStartOffset) break block12;
                        return -1;
                    }
                    if (isApplyProposal || (nextChar = DVTDocumentUtils.nextCodeChar((IDocument)document, (int)functionNameOffset, (String)"__vlog_partitioning", (boolean)true)) == '(') break block13;
                    return -1;
                }
                int n = leftBracketOffset = functionNameStartOffset >= 0 && !endOffset && isComputeFunctionCallStartOffset ? functionNameStartOffset : DVTDocumentUtils.getCharOffset((char)'(', (int)functionNameOffset, (boolean)true, (int)100, (IDocument)document, (String)"__vlog_partitioning") + 1;
                if (leftBracketOffset <= scopeEndOffset && leftBracketOffset >= scopeStartOffset) break block14;
                return -1;
            }
            if (!endOffset) return leftBracketOffset;
            rightBracketOffset = DVTDocumentUtils.getMatchingRightBracketOffset((int)leftBracketOffset, (DVTEditor)editor, (IDocument)document);
            if (rightBracketOffset >= 0 && rightBracketOffset - 1 <= scopeEndOffset) break block15;
            return -1;
        }
        try {
            return rightBracketOffset;
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PositionalTooltipsNamedElementAndOffsetWrapper getNamedElementAndOffsetAtOffset(IDocument document, RfProject rfProject, IFile file, DVTEditor editor, int offset, int minLimit) {
        try {
            if (document == null || offset < 0 || offset >= document.getLength()) {
                return null;
            }
            boolean parameterTooltipCheck = false;
            char character = document.getChar(offset);
            if (character == ')') {
                if ((offset = DVTDocumentUtils.getMatchingLeftBracketOffset((int)offset, (DVTEditor)editor, (IDocument)document) - 1) < 0) {
                    return null;
                }
                char nextCode = DVTDocumentUtils.nextCodeChar((IDocument)document, (int)offset, (String)"__vlog_partitioning", (boolean)false);
                if (nextCode == '#') {
                    parameterTooltipCheck = true;
                }
            } else {
                ArrayDeque<Character> closedBracketsStack = new ArrayDeque<Character>();
                while (offset >= minLimit && offset >= 0 && document.getLength() > offset) {
                    if (!"__dftl_partition_content_type".equals(((IDocumentExtension3)document).getContentType("__vlog_partitioning", offset, false))) {
                        --offset;
                        continue;
                    }
                    char chr = document.getChar(offset);
                    if (chr == ')') {
                        closedBracketsStack.push(Character.valueOf(chr));
                    } else if (chr == '(') {
                        if (closedBracketsStack.isEmpty()) {
                            char nextCode = DVTDocumentUtils.nextCodeChar((IDocument)document, (int)(offset - 1), (String)"__vlog_partitioning", (boolean)false);
                            if (Character.isJavaIdentifierPart(nextCode)) {
                                --offset;
                                break;
                            }
                            if (nextCode == '#') {
                                parameterTooltipCheck = true;
                                --offset;
                                break;
                            }
                        } else {
                            closedBracketsStack.pop();
                        }
                    }
                    --offset;
                }
            }
            if (offset <= minLimit) {
                return null;
            }
            int elementNameEndOffset = DVTDocumentUtils.nextCodeCharOffset((IDocument)document, (int)offset, (boolean)false, (String)"__vlog_partitioning");
            if (elementNameEndOffset < 0) {
                return null;
            }
            RfNamedElement element = null;
            RfWNamedElementAndScope rfElementAndScope = RfUtils.getRfElement(rfProject, file, document, elementNameEndOffset, editor);
            if (rfElementAndScope != null && rfElementAndScope.getNamedElement() != null) {
                element = rfElementAndScope.getNamedElement();
            } else {
                IRfScope rfScope = RfUtils.getInstance().getRfScope((ITextEditor)editor, document, offset, true, true, null);
                if (rfScope instanceof RfInstanceDef) {
                    element = rfScope.getNamedElement();
                }
            }
            if (element == null || !(element instanceof RfFunction) && !(element instanceof VlogMacroInfo) && !(element instanceof RfInstance) && !(element instanceof RfModule)) {
                return null;
            }
            return new PositionalTooltipsNamedElementAndOffsetWrapper(element, elementNameEndOffset, parameterTooltipCheck);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected abstract PositionalTooltipsNamedElementAndOffsetWrapper getNamedElementAndOffsetAtOffset(RfProject var1, IFile var2, DVTEditor var3, int var4, int var5);
}

