/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.contentasisst.DVTContentAssistProcessorManager;
import ro.amiq.dvt.ui.editor.contentasisst.DVTStringContentAssistProcessor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.r2lparser.R2LManager;
import ro.amiq.vlogdt.r2lparser.R2LProposalManager;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistProcessorManager;
import ro.amiq.vlogdt.ui.editor.quickfix.util.VlogQuickFixUtil;

public class VlogStringContentAssistProcessor
extends DVTStringContentAssistProcessor {
    private static final String QUOTES = "\"";
    private VlogContentAssistProcessorManager fProcessor;

    public VlogStringContentAssistProcessor(VlogContentAssistProcessorManager processor) {
        super((DVTContentAssistProcessorManager)processor);
        this.fProcessor = processor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (viewer == null || viewer.getDocument() == null) {
            return null;
        }
        VlogEditor vlogEditor = this.fProcessor.getEditor();
        if (vlogEditor == null) {
            return null;
        }
        VlogSourceViewerConfiguration sourceViewerConfiguration = (VlogSourceViewerConfiguration)vlogEditor.getSourceViewerConfigurationForEditor();
        IDocument document = viewer.getDocument();
        if (document == null) {
            return null;
        }
        try {
            char prevChar = document.getChar(offset - 1);
            if (prevChar == '%') {
                return this.getFormattedPrintPoposals(viewer, offset);
            }
            IRegion lineInfo = document.getLineInformationOfOffset(offset);
            int endOfLineOffset = lineInfo.getOffset() + lineInfo.getLength();
            int includeOffset = VlogQuickFixUtil.getInstance().getForwardOffsetFor(document, "`include", lineInfo.getOffset(), endOfLineOffset, false);
            if (includeOffset < endOfLineOffset) {
                return this.getIncludeProposals((SourceViewerConfiguration)sourceViewerConfiguration, viewer, document, offset);
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private ICompletionProposal[] getIncludeProposals(SourceViewerConfiguration sourceViewerConfiguration, ITextViewer viewer, IDocument document, int offset) {
        List processors;
        File[] candidates;
        String stringLiteralEnd;
        String includeText;
        block23: {
            VlogContentAssistProcessorManager sourceProcessorManager;
            block22: {
                block21: {
                    block20: {
                        block19: {
                            ParserPath parserPath;
                            block18: {
                                block17: {
                                    int startOffsetOfStringLiteral;
                                    block16: {
                                        block15: {
                                            block14: {
                                                if (!this.fProcessor.isCanceled()) break block14;
                                                return null;
                                            }
                                            if (document != null) break block15;
                                            return null;
                                        }
                                        startOffsetOfStringLiteral = this.getStartOffsetOfStringLiteral(document, offset);
                                        if (startOffsetOfStringLiteral >= 0) break block16;
                                        return null;
                                    }
                                    int endOffsetOfStringLiteral = this.getEndOffsetOfStringLiteral(document, offset);
                                    if (endOffsetOfStringLiteral < 0) {
                                        endOffsetOfStringLiteral = startOffsetOfStringLiteral;
                                    }
                                    int replacementLength = offset - startOffsetOfStringLiteral;
                                    includeText = document.get(startOffsetOfStringLiteral, replacementLength).trim();
                                    stringLiteralEnd = document.get(endOffsetOfStringLiteral, 1);
                                    if (!this.fProcessor.isCanceled()) break block17;
                                    return null;
                                }
                                parserPath = DVTFileUtils.getInstance().resource2parser((IResource)this.fProcessor.getFile());
                                if (parserPath != null) break block18;
                                return null;
                            }
                            R2LProposalManager manager = new R2LProposalManager(this.fProcessor.getEditor(), this.fProcessor.getRfProject(), this.fProcessor.getInitialScope(), this.fProcessor.getInstanceScope(), parserPath, document, offset);
                            candidates = ((R2LManager)manager).getIncludeCandidates(includeText);
                            if (candidates != null) break block19;
                            return null;
                        }
                        if (!this.fProcessor.isCanceled()) break block20;
                        return null;
                    }
                    if (sourceViewerConfiguration != null) break block21;
                    return null;
                }
                sourceProcessorManager = (VlogContentAssistProcessorManager)((VlogSourceViewerConfiguration)sourceViewerConfiguration).getSourceProcessorManager();
                if (sourceProcessorManager != null) break block22;
                return null;
            }
            processors = sourceProcessorManager.getProcessors();
            if (processors != null && !((ArrayList)processors).isEmpty()) break block23;
            return null;
        }
        try {
            for (IContentAssistProcessor processor : processors) {
                if (!(processor instanceof RfContentAssistProcessor)) continue;
                return ((RfContentAssistProcessor)processor).getStringIncludeProposals(viewer, candidates, offset, includeText, !QUOTES.equals(stringLiteralEnd));
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    private int getStartOffsetOfStringLiteral(IDocument document, int offset) {
        try {
            while (offset > 1) {
                String contentType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", offset - 1, false);
                if (!"__vlog_literal".equals(contentType)) break;
                --offset;
            }
            if (QUOTES.equals(document.get(offset, 1))) {
                ++offset;
            }
            return offset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    private int getEndOffsetOfStringLiteral(IDocument document, int offset) {
        try {
            while (offset < document.getLength()) {
                String contentType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", offset, false);
                if (!"__vlog_literal".equals(contentType)) break;
                ++offset;
            }
            int line = document.getLineOfOffset(offset);
            String newLine = document.getLineDelimiter(line);
            if (QUOTES.equals(document.get(offset - 1, 1)) || newLine != null && newLine.equals(document.get(offset - 1, 1))) {
                --offset;
            }
            return offset;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    protected Map<String, String> initializeProposalInfo() {
        return new ImmutableMap.Builder().put((Object)"b", (Object)"in binary format").put((Object)"c", (Object)"in ASCII character format").put((Object)"d", (Object)"in decimal format").put((Object)"e", (Object)"real numbers in an exponential format").put((Object)"f", (Object)"real numbers in a decimal format").put((Object)"g", (Object)"real numbers in exponential or decimal format, whichever format results in the shorter printed output").put((Object)"h", (Object)"in hexadecimal format").put((Object)"l", (Object)"library binding information").put((Object)"m", (Object)"hierarchical name").put((Object)"o", (Object)"in octal format").put((Object)"p", (Object)"as an assignment pattern").put((Object)"s", (Object)"as a string").put((Object)"t", (Object)"in current time format").put((Object)"u", (Object)"unformatted 2 value data").put((Object)"v", (Object)"net signal strength").put((Object)"x", (Object)"in hexadecimal format").put((Object)"z", (Object)"unformatted 4 value data").build();
    }
}

