/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.contentassist;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.FormatSpecifiersUtils;
import ro.amiq.vlogdt.model.reflection.semantic.extension.FormatStringInfo;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessVisitor;

public class VlogSystemTaskAtOffsetVisitor
extends RfHidAccessVisitor {
    private Region methodCallRegion;
    private Map<String, Region> formatSpecifiersRegions;
    private IRfNamedElement element;

    public VlogSystemTaskAtOffsetVisitor(Region methodCallRegion, IRfNamedElement element) {
        this.methodCallRegion = methodCallRegion;
        this.setFormatSpecifiersRegions(new LinkedHashMap<String, Region>());
        this.element = element;
    }

    public boolean visit(RfHidAccess access) {
        if (!(access instanceof RfHidAccessArgs)) {
            return true;
        }
        RfHidAccessArgs accessArg = (RfHidAccessArgs)access;
        HidOccurrence occurrence = accessArg.getOccurrence();
        Hid parentHid = accessArg.getParentHid();
        if (occurrence == null || parentHid == null || !this.element.equals(parentHid.getElement())) {
            return true;
        }
        List<? extends IHidObject> argumentValues = accessArg.getArgumentValues();
        if (argumentValues == null || argumentValues.isEmpty()) {
            return true;
        }
        IHidObject firstArgument = argumentValues.get(0);
        if (firstArgument == null) {
            return true;
        }
        if (MethodCallUtils.getVirtualOffset((IHidObject)firstArgument) >= 0) {
            return true;
        }
        int startOffset = HidUtils.getStartOffset((HidOccurrence)parentHid.getOccurrence());
        int formatSpecifierOffset = MethodCallUtils.getOffset((IHidObject)firstArgument);
        if (startOffset != this.methodCallRegion.getOffset() || !DVTDocumentUtils.regionContains((IRegion)this.methodCallRegion, (int)formatSpecifierOffset)) {
            return true;
        }
        String elementName = this.element.getName();
        List<FormatStringInfo> allFormatStringInfos = FormatSpecifiersUtils.getAllFormatStringInfos(argumentValues, elementName);
        if (allFormatStringInfos == null || allFormatStringInfos.isEmpty()) {
            return false;
        }
        String formatSpecifiersString = "";
        for (FormatStringInfo formatStringInfo : allFormatStringInfos) {
            IHidObject specifierHid = formatStringInfo.getFormatHid();
            List<IHidObject> specifierValues = formatStringInfo.getSpecifierValues();
            if (specifierValues == null || specifierValues.isEmpty()) continue;
            formatSpecifiersString = HidUtils.toNiceString((IHidObject)specifierHid);
            formatSpecifierOffset = MethodCallUtils.getOffset((IHidObject)specifierHid);
            int regionStartOffset = formatSpecifierOffset + formatSpecifiersString.length();
            IHidObject lastSpecifierValueHid = specifierValues.get(specifierValues.size() - 1);
            int lastSpecifierValueOffset = MethodCallUtils.getClosedBoundary((IHidObject)lastSpecifierValueHid);
            if (regionStartOffset < 0 || lastSpecifierValueOffset < 0 || lastSpecifierValueOffset < regionStartOffset) continue;
            int regionLength = lastSpecifierValueOffset - regionStartOffset;
            Region region = new Region(regionStartOffset, regionLength);
            this.formatSpecifiersRegions.put(formatSpecifiersString, region);
        }
        return true;
    }

    public Map<String, Region> getFormatSpecifiersRegions() {
        return this.formatSpecifiersRegions;
    }

    public void setFormatSpecifiersRegions(Map<String, Region> formatSpecifiersRegions) {
        this.formatSpecifiersRegions = formatSpecifiersRegions;
    }
}

