/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.vlogdt.ui.editor.edit.strategy.AutoEditProgressMonitor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.DocumentLineAccessor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditOldEngineRefLineFinder;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditAdvancedUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditOldEngineStrategy;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeTokenProcessor;

public class VlogAutoEditAdvancedRefLineFinder
extends VlogAutoEditOldEngineRefLineFinder {
    private static VlogAutoEditAdvancedRefLineFinder INSTANCE;
    private static final Object LOCK;
    private int unmatchedClosingTokens;

    static {
        LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogAutoEditAdvancedRefLineFinder getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new VlogAutoEditAdvancedRefLineFinder();
            }
        }
        return INSTANCE;
    }

    public void resetUnmatchedClosingTokens() {
        this.unmatchedClosingTokens = 0;
    }

    public int getAnchorForOpenDelimiter(IDocument document, int line, VlogCodeTokenProcessor.Token delimiter, ICharacterPairMatcher pairMatcher, AutoEditProgressMonitor monitor) {
        if (line <= 0) {
            return -1;
        }
        this.fFODCallCounter = 0;
        this.unmatchedClosingTokens = 0;
        int delimiterOffset = this.findEnclosingDelimiterOffset(document, new DocumentLineAccessor(document, delimiter.getStartOffset(), this.fLinesLookback), null, pairMatcher, monitor);
        return delimiterOffset == -1 ? -1 : VlogAutoEditUtils.getInstance().getLineOfOffset(document, delimiterOffset);
    }

    private int findEnclosingDelimiterOffset(IDocument document, DocumentLineAccessor acc, VlogCodeTokenProcessor.Token peekScope, ICharacterPairMatcher pairMatcher, AutoEditProgressMonitor monitor) {
        try {
            VlogCodeTokenProcessor.Token token;
            this.checkFODCallLimit();
            boolean hasSemicolon = false;
            while ((token = acc.nextToken()) != null) {
                DocumentLineAccessor accClone;
                if (monitor.isCanceled()) {
                    DVTLogger.INSTANCE.logError("Auto-indent timed out while searching for an enclosing delimiter!");
                    return -1;
                }
                if (!VlogCodeAutoEditAdvancedUtils.getInstance().isWordOrBracket(token)) {
                    if (token.getType() == 3) continue;
                    hasSemicolon = ";".equals(token.getValue());
                    continue;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isClosedBracket(token)) {
                    IRegion region = pairMatcher.match(document, token.getStartOffset());
                    if (region == null) continue;
                    acc.consumeRegion(document, region.getOffset());
                    continue;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isConstraintKeyword(token) || VlogCodeAutoEditAdvancedUtils.getInstance().isStructKeyword(token)) {
                    int n = token.getStartOffset();
                    return n;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isElseKeyword(token) || VlogCodeAutoEditAdvancedUtils.getInstance().isOneLineIndentKeyword(token)) {
                    accClone = acc.clone();
                    int enclosingDelimiterOffset = this.findEnclosingDelimiterOffset(document, accClone, peekScope, pairMatcher, monitor);
                    if (enclosingDelimiterOffset == -1) {
                        return -1;
                    }
                    acc.consumeRegion(document, enclosingDelimiterOffset);
                    int n = enclosingDelimiterOffset;
                    return n;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isClosedKeywordSemi(token)) {
                    ++this.unmatchedClosingTokens;
                    int openDelimiterOffset = this.findMatchingOpenDelimiterOffset(document, acc.clone(), token, pairMatcher, monitor);
                    if (openDelimiterOffset == -1) {
                        return -1;
                    }
                    acc.consumeRegion(document, openDelimiterOffset);
                    if (this.unmatchedClosingTokens > 0) {
                        --this.unmatchedClosingTokens;
                    }
                    VlogCodeTokenProcessor.Token tokenAtOffset = VlogCodeAutoEditAdvancedUtils.getInstance().getTokenAtOffset(document, openDelimiterOffset);
                    if (VlogCodeAutoEditAdvancedUtils.getInstance().isValidBlock(tokenAtOffset, token)) continue;
                    int n = openDelimiterOffset;
                    return n;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isClosedKeywordNoSemi(token, hasSemicolon) || VlogCodeAutoEditAdvancedUtils.getInstance().isClosedPreproc(token)) {
                    if (VlogCodeAutoEditAdvancedUtils.getInstance().isPrecededByOneLineIndentKeyword(acc.clone()) || VlogCodeAutoEditAdvancedUtils.getInstance().isPrecededByRandomQulifier(acc.clone())) continue;
                    int openDelimiterOffset = this.findMatchingOpenDelimiterOffset(document, acc.clone(), token, pairMatcher, monitor);
                    if (openDelimiterOffset == -1) {
                        return -1;
                    }
                    acc.consumeRegion(document, openDelimiterOffset);
                    if (this.unmatchedClosingTokens != 0) continue;
                    int n = openDelimiterOffset;
                    return n;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isOpenKeywordWithSemi(token)) {
                    VlogCodeTokenProcessor.Token prevNWSToken = VlogCodeAutoEditAdvancedUtils.getInstance().getPrevNWSToken(acc.clone());
                    if (VlogCodeAutoEditAdvancedUtils.getInstance().isOneLineIndentKeyword(prevNWSToken)) continue;
                    if (VlogCodeAutoEditAdvancedUtils.getInstance().isValidBlock(token, peekScope)) {
                        int n = token.getStartOffset() + token.getValue().length();
                        return n;
                    }
                    int n = token.getStartOffset();
                    return n;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isOpenKeywordWithoutSemi(token) || VlogCodeAutoEditAdvancedUtils.getInstance().isOpenPreproc(token)) {
                    accClone = acc.clone();
                    int enclosingDelimiterOffset = this.findEnclosingDelimiterOffset(document, accClone, peekScope, pairMatcher, monitor);
                    if (enclosingDelimiterOffset == -1) {
                        return -1;
                    }
                    acc.consumeRegion(document, enclosingDelimiterOffset);
                    int n = enclosingDelimiterOffset;
                    return n;
                }
                hasSemicolon = false;
            }
            int n = acc.getLine() == 0 ? 0 : -1;
            return n;
        }
        catch (VlogCodeAutoEditOldEngineStrategy.FODCallLimitExceeded e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
        finally {
            this.fFODCallCounter = 0;
        }
    }

    private int findMatchingOpenDelimiterOffset(IDocument document, DocumentLineAccessor acc, VlogCodeTokenProcessor.Token endDelimiter, ICharacterPairMatcher pairMatcher, AutoEditProgressMonitor monitor) {
        try {
            VlogCodeTokenProcessor.Token token;
            this.checkFODCallLimit();
            if (!BLOCKS.containsKey(endDelimiter.getValue())) {
                int n = endDelimiter.getStartOffset();
                return n;
            }
            boolean hasSemicolon = false;
            while ((token = acc.nextToken()) != null) {
                int enclosingDelimiterOffset;
                DocumentLineAccessor accClone;
                if (monitor.isCanceled()) {
                    DVTLogger.INSTANCE.logError("Auto-indent timed out while searching for a matching open delimiter!");
                    return -1;
                }
                if (!VlogCodeAutoEditAdvancedUtils.getInstance().isWordOrBracket(token)) {
                    if (token.getType() == 3 || hasSemicolon) continue;
                    hasSemicolon = ";".equals(token.getValue());
                    continue;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isClosedBracket(token)) {
                    IRegion region = pairMatcher.match(document, token.getStartOffset());
                    if (region == null) {
                        hasSemicolon = false;
                        continue;
                    }
                    acc.consumeRegion(document, region.getOffset());
                    continue;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isClosedPreproc(token)) {
                    if (VlogCodeAutoEditAdvancedUtils.getInstance().isMiddlePreproc(token) && VlogCodeAutoEditAdvancedUtils.getInstance().isClosedPreproc(endDelimiter)) continue;
                    accClone = acc.clone();
                    int openDelimiterOffset = this.findMatchingOpenDelimiterOffset(document, accClone, token, pairMatcher, monitor);
                    if (openDelimiterOffset == -1) {
                        hasSemicolon = false;
                        return -1;
                    }
                    acc.consumeRegion(document, openDelimiterOffset);
                    continue;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isElseKeyword(token)) {
                    accClone = acc.clone();
                    int enclosingDelimiterOffset2 = this.findEnclosingDelimiterOffset(document, accClone, endDelimiter, pairMatcher, monitor);
                    if (enclosingDelimiterOffset2 == -1) {
                        return -1;
                    }
                    acc.consumeRegion(document, enclosingDelimiterOffset2);
                    int n = enclosingDelimiterOffset2;
                    return n;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isClosedKeywordSemi(token)) {
                    accClone = acc.clone();
                    ++this.unmatchedClosingTokens;
                    int openDelimiterOffset = this.findMatchingOpenDelimiterOffset(document, accClone, token, pairMatcher, monitor);
                    if (openDelimiterOffset == -1) {
                        hasSemicolon = false;
                        return -1;
                    }
                    acc.consumeRegion(document, openDelimiterOffset);
                    if (openDelimiterOffset != 0) continue;
                    int n = openDelimiterOffset;
                    return n;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isClosedKeywordNoSemi(token, hasSemicolon)) {
                    VlogCodeTokenProcessor.Token prevNWSToken = VlogCodeAutoEditAdvancedUtils.getInstance().getPrevNWSToken(acc.clone());
                    if (VlogCodeAutoEditAdvancedUtils.getInstance().isOneLineIndentKeyword(prevNWSToken)) continue;
                    DocumentLineAccessor accClone2 = acc.clone();
                    enclosingDelimiterOffset = this.findEnclosingDelimiterOffset(document, accClone2, endDelimiter, pairMatcher, monitor);
                    if (enclosingDelimiterOffset == -1) {
                        hasSemicolon = false;
                        return -1;
                    }
                    acc.consumeRegion(document, enclosingDelimiterOffset);
                    if (enclosingDelimiterOffset != 0) continue;
                    int n = enclosingDelimiterOffset;
                    return n;
                }
                boolean isValidBlock = VlogCodeAutoEditAdvancedUtils.getInstance().isValidBlock(token, endDelimiter);
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isOpenBracket(token) && isValidBlock) {
                    int n = token.getStartOffset();
                    return n;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isOpenPreproc(token) && isValidBlock) {
                    DocumentLineAccessor accClone3 = acc.clone();
                    enclosingDelimiterOffset = this.findEnclosingDelimiterOffset(document, accClone3, endDelimiter, pairMatcher, monitor);
                    if (enclosingDelimiterOffset == -1) {
                        return -1;
                    }
                    acc.consumeRegion(document, enclosingDelimiterOffset);
                    int n = enclosingDelimiterOffset;
                    return n;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isOpenKeywordWithSemi(token) && !VlogCodeAutoEditAdvancedUtils.getInstance().isException(acc.clone(), token) && isValidBlock) {
                    VlogCodeTokenProcessor.Token prevNWSToken = VlogCodeAutoEditAdvancedUtils.getInstance().getPrevNWSToken(acc.clone());
                    if (VlogCodeAutoEditAdvancedUtils.getInstance().isOneLineIndentKeyword(prevNWSToken)) continue;
                    if (this.unmatchedClosingTokens > 0 && isValidBlock) {
                        --this.unmatchedClosingTokens;
                    }
                    int n = token.getStartOffset();
                    return n;
                }
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isOpenKeywordWithoutSemi(token)) {
                    if (!isValidBlock) continue;
                    DocumentLineAccessor accClone4 = acc.clone();
                    enclosingDelimiterOffset = this.findEnclosingDelimiterOffset(document, accClone4, endDelimiter, pairMatcher, monitor);
                    if (enclosingDelimiterOffset == -1) {
                        return -1;
                    }
                    acc.consumeRegion(document, enclosingDelimiterOffset);
                    int n = enclosingDelimiterOffset;
                    return n;
                }
                hasSemicolon = false;
            }
            int n = acc.getLine() == 0 ? 0 : -1;
            return n;
        }
        catch (VlogCodeAutoEditOldEngineStrategy.FODCallLimitExceeded e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
        finally {
            this.fFODCallCounter = 0;
        }
    }

    public int getAnchorForCloseDelimiter(IDocument document, int line, VlogCodeTokenProcessor.Token delimiter, ICharacterPairMatcher pairMatcher, AutoEditProgressMonitor monitor) {
        int delimiterOffset;
        this.fFODCallCounter = 0;
        this.unmatchedClosingTokens = 0;
        if (line <= 0) {
            return line;
        }
        DocumentLineAccessor acc = new DocumentLineAccessor(document, delimiter.getStartOffset(), this.fLinesLookback);
        if (delimiter.getType() == 4) {
            IRegion region = pairMatcher.match(document, delimiter.getStartOffset());
            if (region == null) {
                return line;
            }
            if ("}".equals(delimiter.getValue())) {
                int delimiterOffset2 = this.findEnclosingDelimiterOffset(document, acc, null, pairMatcher, monitor);
                if (delimiterOffset2 == -1) {
                    return -1;
                }
                return VlogAutoEditUtils.getInstance().getLineOfOffset(document, delimiterOffset2);
            }
        }
        if (VlogCodeAutoEditAdvancedUtils.getInstance().isClosedKeywordSemi(delimiter)) {
            ++this.unmatchedClosingTokens;
            delimiterOffset = this.findMatchingOpenDelimiterOffset(document, acc, delimiter, pairMatcher, monitor);
        } else {
            delimiterOffset = this.findEnclosingDelimiterOffset(document, acc, null, pairMatcher, monitor);
        }
        return delimiterOffset == -1 ? -1 : VlogAutoEditUtils.getInstance().getLineOfOffset(document, delimiterOffset);
    }

    public int getAnchorForNewLine(IDocument document, int line, int lineOffset, ISourceViewer fSourceViewer, ICharacterPairMatcher pairMatcher, AutoEditProgressMonitor monitor) {
        VlogCodeTokenProcessor.Token token;
        this.fFODCallCounter = 0;
        DocumentLineAccessor acc = new DocumentLineAccessor(document, lineOffset, this.fLinesLookback);
        while ((token = acc.nextToken()) != null && token.getType() == 3) {
        }
        if (token == null) {
            return line;
        }
        CFPreferences formatPreferences = VlogCodeAutoEditAdvancedUtils.getInstance().getFormatPreferences(fSourceViewer, document, token.getStartOffset());
        do {
            if (monitor.isCanceled()) {
                DVTLogger.INSTANCE.logError("Auto-indent timed out while searching for an anchor for new line!");
                return -1;
            }
            if (!VlogCodeAutoEditAdvancedUtils.getInstance().isWordOrBracket(token)) continue;
            if (VlogCodeAutoEditAdvancedUtils.getInstance().isClosedBracket(token)) {
                IRegion region = pairMatcher.match(document, token.getStartOffset());
                if (region == null) continue;
                acc.consumeRegion(document, region.getOffset());
                continue;
            }
            if (VlogCodeAutoEditAdvancedUtils.getInstance().shouldIgnoreLine(document, acc.getLine(), formatPreferences)) {
                acc.consumeRegion(document, VlogAutoEditUtils.getInstance().getLineOffset(document, acc.getLine()));
                continue;
            }
            if (VlogCodeAutoEditAdvancedUtils.getInstance().isConstraintKeyword(token) || VlogCodeAutoEditAdvancedUtils.getInstance().isStructKeyword(token)) {
                return acc.getLine();
            }
            if (VlogCodeAutoEditAdvancedUtils.getInstance().isOpenKeywordWithSemi(token)) {
                VlogCodeTokenProcessor.Token prevNWSToken = VlogCodeAutoEditAdvancedUtils.getInstance().getPrevNWSToken(acc.clone());
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isOneLineIndentKeyword(prevNWSToken)) continue;
                return acc.getLine();
            }
            if (VlogCodeAutoEditAdvancedUtils.getInstance().isOpenKeywordWithoutSemi(token) || VlogCodeAutoEditAdvancedUtils.getInstance().isOneLineIndentKeyword(token) || VlogCodeAutoEditAdvancedUtils.getInstance().isOpenPreproc(token)) {
                int anchorOffset = this.findEnclosingDelimiterOffset(document, acc.clone(), null, pairMatcher, monitor);
                return anchorOffset == -1 ? -1 : VlogAutoEditUtils.getInstance().getLineOfOffset(document, anchorOffset);
            }
            if (VlogCodeAutoEditAdvancedUtils.getInstance().isElseKeyword(token) || VlogCodeAutoEditAdvancedUtils.getInstance().isClosedKeywordNoSemi(token, true) || VlogCodeAutoEditAdvancedUtils.getInstance().isClosedPreproc(token)) {
                int anchorOffset = this.findEnclosingDelimiterOffset(document, acc.clone(), null, pairMatcher, monitor);
                return anchorOffset == -1 ? -1 : VlogAutoEditUtils.getInstance().getLineOfOffset(document, anchorOffset);
            }
            if (!VlogCodeAutoEditAdvancedUtils.getInstance().isClosedKeywordSemi(token)) continue;
            ++this.unmatchedClosingTokens;
            int openDelimiterOffset = this.findMatchingOpenDelimiterOffset(document, acc.clone(), token, pairMatcher, monitor);
            if (openDelimiterOffset == -1) {
                return -1;
            }
            acc.consumeRegion(document, openDelimiterOffset);
            if (this.unmatchedClosingTokens > 0) {
                --this.unmatchedClosingTokens;
            }
            VlogCodeTokenProcessor.Token tokenAtOffset = VlogCodeAutoEditAdvancedUtils.getInstance().getTokenAtOffset(document, openDelimiterOffset);
            if (VlogCodeAutoEditAdvancedUtils.getInstance().isValidBlock(tokenAtOffset, token)) continue;
            return VlogAutoEditUtils.getInstance().getLineOfOffset(document, openDelimiterOffset);
        } while ((token = acc.nextToken()) != null);
        return acc.getLine() == 0 ? 0 : -1;
    }

    public int getAnchorLine(IDocument document, DocumentCommand command, ISourceViewer fSourceViewer, ICharacterPairMatcher pairMatcher, AutoEditProgressMonitor monitor) {
        int anchorForNewLine;
        block4: {
            try {
                int line = document.getLineOfOffset(command.offset);
                if (line == 0) {
                    return line;
                }
                anchorForNewLine = this.getAnchorForNewLine(document, line, document.getLineOffset(line), fSourceViewer, pairMatcher, monitor);
                if (anchorForNewLine != -1) break block4;
                return 0;
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return 0;
            }
        }
        return anchorForNewLine;
    }
}

