/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public interface VlogAutoEditBaseKeywordSets {
    public static final String[] OPEN_BRACKETS = new String[]{"{", "[", "("};
    public static final String[] CLOSED_BRACKETS = new String[]{"}", "]", ")"};
    public static final Set<String> PSEUDO_CLOSED = new HashSet<String>(Arrays.asList("end", "while", "else", "join", "}", "]", ")"));
    public static final Set<String> CLOSED_KEYWORDS_SEMI = new HashSet<String>(Arrays.asList("while"));
    public static final Map<String, IgnoreRule[]> IGNORED_MAPPINGS = new HashMap<String, IgnoreRule[]>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("function", new IgnoreRule[]{new IgnoreRule(new String[]{"pure"}, new String[]{"virtual", "static", "protected", "local"}, 0), new IgnoreRule(new String[]{"extern"}, new String[]{"virtual", "static", "protected", "local"}, 0), new IgnoreRule(new String[]{"import"}, new String[]{"=", "context", "pure"}, 1), new IgnoreRule(new String[]{"export"}, new String[]{"=", "context", "pure"}, 1), new IgnoreRule("with")});
            this.put("task", new IgnoreRule[]{new IgnoreRule(new String[]{"pure"}, new String[]{"virtual", "static", "protected", "local"}, 0), new IgnoreRule(new String[]{"extern"}, new String[]{"virtual", "static", "protected", "local"}, 0), new IgnoreRule(new String[]{"import"}, new String[]{"=", "context", "pure"}, 1), new IgnoreRule(new String[]{"export"}, new String[]{"=", "context", "pure"}, 1), new IgnoreRule("forkjoin")});
            this.put("module", new IgnoreRule[]{new IgnoreRule("extern")});
            this.put("macromodule", new IgnoreRule[]{new IgnoreRule("extern")});
            this.put("connectmodule", new IgnoreRule[]{new IgnoreRule("extern")});
            this.put("program", new IgnoreRule[]{new IgnoreRule("extern")});
            this.put("primitive", new IgnoreRule[]{new IgnoreRule("extern")});
            this.put("interface", new IgnoreRule[]{new IgnoreRule("extern"), new IgnoreRule("virtual")});
            this.put("class", new IgnoreRule[]{new IgnoreRule("typedef")});
            this.put("clocking", new IgnoreRule[]{new IgnoreRule("modport")});
            this.put("sequence", new IgnoreRule[]{new IgnoreRule("input"), new IgnoreRule("inout"), new IgnoreRule("output"), new IgnoreRule("cover"), new IgnoreRule("default")});
            this.put("property", new IgnoreRule[]{new IgnoreRule("assert"), new IgnoreRule("assume"), new IgnoreRule("cover"), new IgnoreRule("restrict")});
            this.put("checker", new IgnoreRule[]{new IgnoreRule("int")});
            this.put("config", new IgnoreRule[]{new IgnoreRule("int"), new IgnoreRule(":")});
            this.put("table", new IgnoreRule[]{new IgnoreRule("int")});
            this.put("fork", new IgnoreRule[]{new IgnoreRule("disable"), new IgnoreRule("wait")});
            this.put("join", new IgnoreRule[]{new IgnoreRule("rand")});
        }
    };
    public static final Map<String, String[]> BLOCKS = new HashMap<String, String[]>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("end", new String[]{"begin"});
            this.put("endclass", new String[]{"class"});
            this.put("endmodule", new String[]{"module", "macromodule", "connectmodule"});
            this.put("endconnectmodule", new String[]{"connectmodule"});
            this.put("endinterface", new String[]{"interface"});
            this.put("endprogram", new String[]{"program"});
            this.put("endchecker", new String[]{"checker"});
            this.put("endclocking", new String[]{"clocking"});
            this.put("endconfig", new String[]{"config"});
            this.put("endfunction", new String[]{"function"});
            this.put("endtask", new String[]{"task"});
            this.put("endgenerate", new String[]{"generate"});
            this.put("endgroup", new String[]{"covergroup"});
            this.put("endpackage", new String[]{"package"});
            this.put("endprimitive", new String[]{"primitive"});
            this.put("endspecify", new String[]{"specify"});
            this.put("endtable", new String[]{"table"});
            this.put("endcase", new String[]{"case", "casex", "casez", "randcase"});
            this.put("endsequence", new String[]{"sequence", "randsequence"});
            this.put("endproperty", new String[]{"property"});
            this.put("while", new String[]{"do"});
            this.put("else", new String[]{"if", "assert", "assume", "expect", "wait_order"});
            this.put("join", new String[]{"fork"});
            this.put("join_any", new String[]{"fork"});
            this.put("join_none", new String[]{"fork"});
            this.put("`ovm_field_utils_end", new String[]{"`ovm_field_utils_begin"});
            this.put("`ovm_object_utils_end", new String[]{"`ovm_object_utils_begin", "`ovm_object_param_utils_begin"});
            this.put("`ovm_component_utils_end", new String[]{"`ovm_component_utils_begin", "`ovm_component_param_utils_begin"});
            this.put("`ovm_sequence_utils_end", new String[]{"`ovm_sequence_utils_begin"});
            this.put("`ovm_sequencer_utils_end", new String[]{"`ovm_sequencer_utils_begin", "`ovm_sequencer_param_utils_begin"});
            this.put("`uvm_field_utils_end", new String[]{"`uvm_field_utils_begin"});
            this.put("`uvm_object_utils_end", new String[]{"`uvm_object_utils_begin", "`uvm_object_param_utils_begin"});
            this.put("`uvm_component_utils_end", new String[]{"`uvm_component_utils_begin", "`uvm_component_param_utils_begin"});
            this.put("}", new String[]{"{"});
            this.put(")", new String[]{"("});
            this.put("]", new String[]{"["});
            this.put("`endif", new String[]{"`ifdef", "`ifndef"});
            this.put("`else", new String[]{"`ifdef", "`ifndef"});
        }
    };

    public static class IgnoreRule {
        public String[] strictMapping;
        public HashSet<String> tolerance;
        public int max_skips;

        public IgnoreRule(String[] strictMapping, String[] tolerance, int max_skips) {
            this.strictMapping = strictMapping;
            this.tolerance = new HashSet<String>(Arrays.asList(tolerance));
            this.max_skips = max_skips;
        }

        public IgnoreRule(String element) {
            this.strictMapping = new String[]{element};
        }

        public IgnoreRule(String[] strictMapping) {
            this.strictMapping = strictMapping;
        }

        public boolean isStrictTo(String value) {
            return value.equals(this.strictMapping[0]);
        }

        public boolean isTolerantTo(String value) {
            return this.tolerance != null && this.tolerance.contains(value);
        }

        public boolean canSkip(int nr_skips) {
            return this.max_skips > nr_skips;
        }
    }
}

