/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.ui.editor.edit.strategy.DocumentLineAccessor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.IndentBundle;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditOldEngineKeywordSets;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditOldEngineStrategy;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditOldEngineUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeTokenProcessor;

public class VlogAutoEditOldEngineRefLineFinder
implements VlogAutoEditOldEngineKeywordSets {
    protected int fFODCallCounter;
    protected int fLinesLookback;
    private static VlogAutoEditOldEngineRefLineFinder INSTANCE;
    private static final Object LOCK;

    static {
        LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogAutoEditOldEngineRefLineFinder getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new VlogAutoEditOldEngineRefLineFinder();
            }
        }
        return INSTANCE;
    }

    public void setLinesLookback(int linesLookback) {
        this.fLinesLookback = linesLookback;
    }

    protected void checkFODCallLimit() throws VlogCodeAutoEditOldEngineStrategy.FODCallLimitExceeded {
        if (this.fFODCallCounter++ > this.fLinesLookback) {
            throw new VlogCodeAutoEditOldEngineStrategy.FODCallLimitExceeded();
        }
    }

    public IndentBundle endDelimiterIndent(IDocument d, int line, VlogCodeTokenProcessor.Token delimiter, ICharacterPairMatcher pairMatcher) {
        try {
            int indLine;
            block10: {
                if (delimiter.getType() == 4) {
                    IRegion region = pairMatcher.match(d, delimiter.getStartOffset());
                    if (region == null) {
                        return new IndentBundle(line);
                    }
                    return new IndentBundle(d.getLineOfOffset(region.getOffset()), this.bracketIndentCondition(delimiter));
                }
                int startLine = line - 1;
                IRegion startLineInfo = d.getLineInformation(startLine);
                int startOffset = startLineInfo.getOffset() + startLineInfo.getLength();
                indLine = -1;
                try {
                    try {
                        this.fFODCallCounter = 0;
                        indLine = this.findMatchingOpenDelimiter(d, new DocumentLineAccessor(d, startOffset, this.fLinesLookback), delimiter, true, pairMatcher);
                    }
                    catch (VlogCodeAutoEditOldEngineStrategy.FODCallLimitExceeded fODCallLimitExceeded) {
                        DVTLogger.INSTANCE.logError("Location 1: Auto-identation FOD call " + this.fLinesLookback + " limit reached.");
                        this.fFODCallCounter = 0;
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.fFODCallCounter = 0;
                    throw throwable;
                }
                this.fFODCallCounter = 0;
            }
            if (indLine == -1) {
                indLine = line;
            }
            return new IndentBundle(indLine);
        }
        catch (BadLocationException badLocationException) {
            return new IndentBundle(line);
        }
    }

    private boolean bracketIndentCondition(VlogCodeTokenProcessor.Token delimiter) {
        return ")".equals(delimiter.getValue());
    }

    private int findMatchingOpenDelimiter(IDocument d, DocumentLineAccessor acc, VlogCodeTokenProcessor.Token endDelimiter, boolean fastMode, ICharacterPairMatcher pairMatcher) throws VlogCodeAutoEditOldEngineStrategy.FODCallLimitExceeded {
        VlogCodeTokenProcessor.Token token;
        this.checkFODCallLimit();
        if (!BLOCKS.containsKey(endDelimiter.getValue())) {
            return -1;
        }
        boolean hasSemicolon = false;
        while ((token = acc.nextToken()) != null) {
            boolean isEndDelimiter;
            if (!VlogCodeAutoEditOldEngineUtils.getInstance().isWordOrBracket(token)) {
                if (token.getType() == 3) continue;
                hasSemicolon = ";".equals(token.getValue());
                continue;
            }
            boolean bl = isEndDelimiter = fastMode ? this.fastModeEndDelimiter(endDelimiter, token, hasSemicolon) : VlogCodeAutoEditOldEngineUtils.getInstance().isClosedKeyword(token, hasSemicolon);
            if (VlogCodeAutoEditOldEngineUtils.getInstance().isClosedBracket(token)) {
                IRegion region = pairMatcher.match(d, token.getStartOffset());
                if (region == null) {
                    hasSemicolon = false;
                    continue;
                }
                acc.consumeRegion(d, region.getOffset());
                continue;
            }
            if (isEndDelimiter && !VlogCodeAutoEditOldEngineUtils.getInstance().isException(acc.clone(), token)) {
                DocumentLineAccessor accClone = acc.clone();
                if (this.findMatchingOpenDelimiter(d, accClone, token, fastMode, pairMatcher) == -1) {
                    hasSemicolon = false;
                    continue;
                }
                acc.resetTo(accClone);
            } else if (VlogCodeAutoEditOldEngineUtils.getInstance().isOpenBracket(token) || VlogCodeAutoEditOldEngineUtils.getInstance().isOpenKeyword(token) && !VlogCodeAutoEditOldEngineUtils.getInstance().isException(acc.clone(), token)) {
                String[] stringArray = (String[])BLOCKS.get(endDelimiter.getValue());
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String candidate = stringArray[n2];
                    if (candidate.equals(token.getValue())) {
                        return acc.getLine();
                    }
                    ++n2;
                }
            }
            hasSemicolon = false;
        }
        return -1;
    }

    private boolean fastModeEndDelimiter(VlogCodeTokenProcessor.Token endDelimiter, VlogCodeTokenProcessor.Token token, boolean hasSemicolon) {
        boolean fastEndDelimiter;
        if (endDelimiter == null || token == null) {
            return false;
        }
        if (endDelimiter.getType() != 2 || token.getType() != 2) {
            return false;
        }
        String value = token.getValue();
        boolean bl = fastEndDelimiter = endDelimiter.getValue().equals(value) || "end".equals(value);
        if (fastEndDelimiter && !hasSemicolon && CLOSED_KEYWORDS_SEMI.contains(value)) {
            return false;
        }
        return fastEndDelimiter;
    }

    public IndentBundle newLineIndent(IDocument d, int line, int offset, ICharacterPairMatcher pairMatcher) {
        VlogCodeTokenProcessor.Token token;
        DocumentLineAccessor acc = new DocumentLineAccessor(d, offset, this.fLinesLookback);
        acc.setNrIgnoredEmptyLines(0);
        acc.setMaxNrLines(1);
        while ((token = acc.nextToken()) != null && token.getType() == 3) {
        }
        if (token == null) {
            return new IndentBundle(line);
        }
        boolean hasSemicolon = token.getValue().endsWith(";");
        if (hasSemicolon) {
            acc.setMaxNrLines(this.fLinesLookback);
        }
        do {
            if (!VlogCodeAutoEditOldEngineUtils.getInstance().isWordOrBracket(token)) continue;
            if (VlogCodeAutoEditOldEngineUtils.getInstance().isClosedBracket(token)) {
                IRegion region = pairMatcher.match(d, token.getStartOffset());
                if (region == null) continue;
                acc.consumeRegion(d, region.getOffset());
                if (hasSemicolon || line <= acc.getLine()) continue;
                return new IndentBundle(acc.getLine(), this.bracketIndentCondition(token));
            }
            if (VlogCodeAutoEditOldEngineUtils.getInstance().isOpenBracket(token)) {
                return new IndentBundle(hasSemicolon ? acc.getLine() : line, true);
            }
            if (VlogCodeAutoEditOldEngineUtils.getInstance().isOpenKeyword(token) && !VlogCodeAutoEditOldEngineUtils.getInstance().isException(acc.clone(), token) && !VlogCodeAutoEditOldEngineUtils.getInstance().isOneLineIndentKeyword(token)) {
                return new IndentBundle(hasSemicolon ? acc.getLine() : line, true);
            }
            if (VlogCodeAutoEditOldEngineUtils.getInstance().isClosedKeyword(token, true) && !VlogCodeAutoEditOldEngineUtils.getInstance().isException(acc.clone(), token)) {
                DocumentLineAccessor accClone = acc.clone();
                try {
                    this.fFODCallCounter = 0;
                    if (this.findMatchingOpenDelimiter(d, accClone, token, true, pairMatcher) == -1) {
                        if (!VlogCodeAutoEditOldEngineUtils.getInstance().isOneLineIndentKeyword(token)) continue;
                        IndentBundle indentBundle = new IndentBundle(hasSemicolon ? acc.getLine() : line, !hasSemicolon);
                        return indentBundle;
                    }
                }
                catch (VlogCodeAutoEditOldEngineStrategy.FODCallLimitExceeded fODCallLimitExceeded) {
                    DVTLogger.INSTANCE.logError("Location 2: Auto-identation FOD call " + this.fLinesLookback + " limit reached.");
                    IndentBundle indentBundle = new IndentBundle(line, !hasSemicolon);
                    return indentBundle;
                }
                finally {
                    this.fFODCallCounter = 0;
                }
                acc.resetTo(accClone);
                if (line <= acc.getLine()) continue;
                return new IndentBundle(hasSemicolon ? acc.getLine() : line, false);
            }
            if (!VlogCodeAutoEditOldEngineUtils.getInstance().isOneLineIndentKeyword(token)) continue;
            return new IndentBundle(hasSemicolon ? acc.getLine() : line, !hasSemicolon);
        } while ((token = acc.nextToken()) != null);
        return new IndentBundle(line);
    }
}

