/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import java.util.List;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.VlogEditor;

public enum VlogAutoEditStrategyManager implements IWorkbenchListener
{
    INSTANCE;

    private IPropertyChangeListener fAutoEditStrategyPreferenceListener;

    public void init() {
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
        this.installAutoEditStrategyPreferenceListener();
    }

    private void installAutoEditStrategyPreferenceListener() {
        try {
            this.fAutoEditStrategyPreferenceListener = event -> {
                if (!"autoindent".equals(event.getProperty())) {
                    return;
                }
                Object oldValue = event.getOldValue();
                Object newValue = event.getNewValue();
                if (!(oldValue instanceof String) || !(newValue instanceof String)) {
                    return;
                }
                if (oldValue.equals(newValue)) {
                    return;
                }
                String autoIndentStrategyMapping = AutoEditStrategiesMapping.computeAutoEditStrategyMapping((String)newValue);
                if (!newValue.equals(autoIndentStrategyMapping)) {
                    VlogPlugin.getDefault().getPreferenceStore().setValue("autoindent", autoIndentStrategyMapping);
                    return;
                }
                List currentlyOpenEditors = Utils.getCurrentlyOpenEditors();
                for (IEditorPart editor : currentlyOpenEditors) {
                    if (!(editor instanceof VlogEditor)) continue;
                    ((VlogEditor)editor).setDirtyAutoEditStrategy(true);
                }
                IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
                if (activeEditor instanceof VlogEditor) {
                    ((VlogEditor)activeEditor).resetAutoEditStrategies();
                }
            };
            VlogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fAutoEditStrategyPreferenceListener);
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        List currentlyOpenEditors = Utils.getCurrentlyOpenEditors();
        for (IEditorPart editor : currentlyOpenEditors) {
            if (!(editor instanceof VlogEditor)) continue;
            ((VlogEditor)editor).setDirtyAutoEditStrategy(false);
        }
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
    }

    public void dispose() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        workbench.removeWorkbenchListener((IWorkbenchListener)this);
        VlogPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fAutoEditStrategyPreferenceListener);
    }

    private static enum AutoEditStrategiesMapping {
        ADVANCED("Advanced (new engine)", "Advanced"),
        DEFAULT("Default", "Old Engine"),
        DISABLED("Disabled", "Disable");

        private final String key;
        private final String value;

        private AutoEditStrategiesMapping(String key, String value) {
            this.key = key;
            this.value = value;
        }

        private static String computeAutoEditStrategyMapping(String autoEditStrategy) {
            if (AutoEditStrategiesMapping.ADVANCED.key.equals(autoEditStrategy)) {
                return AutoEditStrategiesMapping.ADVANCED.value;
            }
            if (AutoEditStrategiesMapping.DEFAULT.key.equals(autoEditStrategy)) {
                return AutoEditStrategiesMapping.DEFAULT.value;
            }
            if (AutoEditStrategiesMapping.DISABLED.key.equals(autoEditStrategy)) {
                return AutoEditStrategiesMapping.DISABLED.value;
            }
            return autoEditStrategy;
        }
    }
}

