/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.utils.DVTDocumentCommon;

public class VlogAutoEditUtils {
    private static VlogAutoEditUtils INSTANCE;
    private static final Object LOCK;

    static {
        LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogAutoEditUtils getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new VlogAutoEditUtils();
            }
        }
        return INSTANCE;
    }

    public int getLineOfOffset(IDocument document, int offset) {
        try {
            return document.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public int getLineOffsetOfOffset(IDocument document, int offset) {
        try {
            return document.getLineOffset(document.getLineOfOffset(offset));
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public int getLineOffset(IDocument document, int lineNumber) {
        try {
            return document.getLineOffset(lineNumber);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public int getLineLength(IDocument document, int lineNumber) {
        try {
            return document.getLineLength(lineNumber);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return -1;
        }
    }

    public String getDocumentSubstring(IDocument document, int offset, int length) {
        try {
            return document.get(offset, length);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public IRegion getLineInformation(IDocument document, int lineNumber) {
        try {
            return document.getLineInformation(lineNumber);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public IRegion getLineInformationOfOffset(IDocument document, int offset) {
        try {
            return document.getLineInformationOfOffset(offset);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public String computeIndent(IRegion lineInfo, int endOffset, String additionalText, ISourceViewer sourceViewer) {
        if (lineInfo == null) {
            return "";
        }
        if (!(sourceViewer instanceof DVTProjectionViewer)) {
            return "";
        }
        DVTEditor editor = ((DVTProjectionViewer)sourceViewer).getEditor();
        if (editor == null) {
            return "";
        }
        SourceViewerConfiguration svc = editor.getSourceViewerConfigurationForEditor();
        if (!(svc instanceof DVTSourceViewerConfiguration)) {
            return "";
        }
        DVTSourceViewerConfiguration dvtSVC = (DVTSourceViewerConfiguration)svc;
        DVTContentFormatter formatter = (DVTContentFormatter)dvtSVC.getContentFormatter(null);
        if (formatter == null) {
            return "";
        }
        formatter.setDoNotShowFormatFailedPopup(true);
        formatter.setContentFormatterMaxLines(0);
        IDocument document = editor.getDocument();
        if (document == null) {
            return "";
        }
        int lineOffset = lineInfo.getOffset();
        String documentSubstr = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, lineOffset, endOffset - lineOffset);
        if (documentSubstr == null) {
            return "";
        }
        IDocument insertDoc = Utils.createDocument((DVTSourceViewerConfiguration)dvtSVC, (String)(String.valueOf(documentSubstr) + additionalText));
        if (insertDoc == null) {
            return "";
        }
        String indentOfLine = TextUtils.replaceTabsWithSpacesVisual((String)DVTDocumentCommon.getIndentOfLine((IDocument)insertDoc, (int)0, (int)-1), (int)dvtSVC.getTabWidth());
        formatter.format(insertDoc, (IRegion)new Region(0, insertDoc.getLength()), indentOfLine, false, dvtSVC.getLanguageKind(), true);
        return DVTDocumentCommon.getIndentOfLine((IDocument)insertDoc, (int)(insertDoc.getNumberOfLines() - 1), (int)-1);
    }
}

