/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoInsertBracketsStrategyCommon;

public class VlogAutoInsertBracketsStrategy
extends VlogAutoInsertBracketsStrategyCommon {
    private static final int PAREN_OFFSET = 0;
    private static final int BRACK_OFFSET = 1;
    private static final int CURLY_OFFSET = 2;
    private static final int QUOTE_OFFSET = 3;
    private static final int NR_AUTOINSERT_CHARACTERS = 4;
    private int[] fFirstInsertedOffsets = new int[4];
    private int[] fLastInsertedOffsets = new int[4];
    private int[] fCountOpen = new int[4];
    protected VlogSourceViewerConfiguration configuration;

    public VlogAutoInsertBracketsStrategy(VlogSourceViewerConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void initAutoInsert(char beforeChar, char afterChar, DocumentCommand command) {
        if (beforeChar == '(' && afterChar == ')') {
            this.fLastInsertedOffsets[0] = command.offset;
        }
        if (beforeChar == '[' && afterChar == ']') {
            this.fLastInsertedOffsets[1] = command.offset;
        }
        if (beforeChar == '{' && afterChar == '}') {
            this.fLastInsertedOffsets[2] = command.offset;
        }
        if (beforeChar == '\"' && afterChar == '\"') {
            this.fLastInsertedOffsets[3] = command.offset;
        }
        int i = 0;
        while (i < 4) {
            int n = i++;
            this.fLastInsertedOffsets[n] = this.fLastInsertedOffsets[n] + command.text.length();
        }
    }

    protected boolean autoInsertPair(char ch, IDocument document, DocumentCommand command, DocumentCommand initialCommand) {
        boolean isEnabledAutoInsert = this.getPreferenceForAutoInsert(initialCommand.text);
        if (!isEnabledAutoInsert) {
            return false;
        }
        boolean result = true;
        if (this.conditionCloseAutoInsertBracket(')', ch, initialCommand)) {
            this.commandShiftCaret(command);
            command.text = command.text.substring(0, command.text.length() - 1);
            this.fCountOpen[0] = this.fCountOpen[0] - 1;
        } else if (this.conditionOpenAutoInsertBracket('(', document, initialCommand)) {
            this.commandShiftCaret(command);
            command.text = String.valueOf(command.text) + ")";
            this.fCountOpen[0] = this.fCountOpen[0] + 1;
            this.fFirstInsertedOffsets[0] = initialCommand.offset;
        } else if (this.conditionCloseAutoInsertBracket(']', ch, initialCommand)) {
            this.commandShiftCaret(command);
            command.text = command.text.substring(0, command.text.length() - 1);
            this.fCountOpen[1] = this.fCountOpen[1] - 1;
        } else if (this.conditionOpenAutoInsertBracket('[', document, initialCommand)) {
            this.commandShiftCaret(command);
            command.text = String.valueOf(command.text) + "]";
            this.fCountOpen[1] = this.fCountOpen[1] + 1;
            this.fFirstInsertedOffsets[1] = initialCommand.offset;
        } else if (this.conditionCloseAutoInsertBracket('}', ch, initialCommand)) {
            this.commandShiftCaret(command);
            command.text = command.text.substring(0, command.text.length() - 1);
            this.fCountOpen[2] = this.fCountOpen[2] - 1;
        } else if (this.conditionOpenAutoInsertBracket('{', document, initialCommand)) {
            this.commandShiftCaret(command);
            command.text = String.valueOf(command.text) + "}";
            this.fCountOpen[2] = this.fCountOpen[2] + 1;
            this.fFirstInsertedOffsets[2] = initialCommand.offset;
        } else if (this.conditionCloseAutoInsertBracket('\"', ch, initialCommand)) {
            this.commandShiftCaret(command);
            command.text = command.text.substring(0, command.text.length() - 1);
            this.fCountOpen[3] = this.fCountOpen[3] - 1;
        } else if (this.conditionOpenAutoInsertBracket('\"', document, initialCommand)) {
            this.commandShiftCaret(command);
            command.text = String.valueOf(command.text) + "\"";
            this.fCountOpen[3] = this.fCountOpen[3] + 1;
            this.fFirstInsertedOffsets[3] = initialCommand.offset;
        } else {
            result = false;
        }
        return result;
    }

    protected boolean getPreferenceForAutoInsert(String commandText) {
        if (commandText == null || commandText.length() <= 0) {
            return false;
        }
        switch (commandText.charAt(0)) {
            case '(': {
                return VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.paran_case");
            }
            case '[': {
                return VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.brack_case");
            }
            case '{': {
                return VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.curly_case");
            }
            case '\"': {
                return VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.quote_case");
            }
        }
        return true;
    }

    private boolean conditionCloseAutoInsertBracket(char bracket, char afterChar, DocumentCommand command) {
        if (command == null || command.text == null) {
            return false;
        }
        int type = this.getBracketType(bracket);
        if (type == -1) {
            return false;
        }
        return command.text.equals(Character.toString(bracket)) && this.fLastInsertedOffsets[type] == command.offset + 1 && afterChar == bracket && this.fCountOpen[type] > 0;
    }

    private void commandShiftCaret(DocumentCommand command) {
        command.shiftsCaret = false;
        command.caretOffset = command.offset + command.text.length();
    }

    private boolean conditionOpenAutoInsertBracket(char bracket, IDocument d, DocumentCommand command) {
        if (command == null || command.text == null || d == null) {
            return false;
        }
        boolean isFollowedByWhitespace = DVTDocumentCommon.isNotFollowedByIdentifier((IDocument)d, (int)command.offset);
        return command.text.equals(Character.toString(bracket)) && isFollowedByWhitespace && !this.isLiteralPartition(d, command.offset);
    }

    private int getBracketType(char bracket) {
        switch (bracket) {
            case '(': 
            case ')': {
                return 0;
            }
            case '[': 
            case ']': {
                return 1;
            }
            case '{': 
            case '}': {
                return 2;
            }
            case '\"': {
                return 3;
            }
        }
        return -1;
    }

    protected boolean isLiteralPartition(IDocument d, int offset) {
        String currentContentType;
        block3: {
            try {
                currentContentType = ((IDocumentExtension3)d).getContentType("__vlog_partitioning", offset, false);
                if (currentContentType != null) break block3;
                return false;
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
                return false;
            }
        }
        return currentContentType.equals("__vlog_literal");
    }

    public void autoInsertAndEncloseBrackets(IDocument document, DocumentCommand command, DocumentCommand initialCommand) {
        if (document == null || command == null) {
            return;
        }
        char ch = TextUtils.getChar((IDocument)document, (int)initialCommand.offset);
        char beforeCh = TextUtils.getChar((IDocument)document, (int)(initialCommand.offset - 1));
        char afterCh = TextUtils.getChar((IDocument)document, (int)(initialCommand.offset + 1));
        this.initAutoInsert(beforeCh, ch, initialCommand);
        if (!(initialCommand.length == 0 && this.autoInsertPair(ch, document, command, initialCommand) || initialCommand.length > 0 && this.autoEncloseWithBrackets(document, command))) {
            if (DVTDocumentCommon.isTextNewLine((IDocument)document, (String)initialCommand.text)) {
                this.autoAddNewLine(ch, beforeCh, afterCh, document, command, initialCommand);
            } else {
                this.smartResetCountOpen(initialCommand.offset);
            }
        }
    }

    private void smartResetCountOpen(int offset) {
        int i = 0;
        while (i < 4) {
            if (offset < this.fFirstInsertedOffsets[i] || offset > this.fLastInsertedOffsets[i]) {
                this.fCountOpen[i] = 0;
            }
            ++i;
        }
    }

    private boolean autoEncloseWithBrackets(IDocument document, DocumentCommand command) {
        boolean isEnabledEncloseText = this.getPreferenceForAutoEnclose(command.text);
        if (!isEnabledEncloseText || "".equals(this.encloseWithBracket(command.text, "", document, command))) {
            return false;
        }
        command.text = this.computeEnclosedText(command.text, document, command);
        return true;
    }

    protected boolean getPreferenceForAutoEnclose(String commandText) {
        if (commandText == null || commandText.length() <= 0) {
            return false;
        }
        switch (commandText.charAt(0)) {
            case '(': {
                return VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.paran_case");
            }
            case '[': {
                return VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.brack_case");
            }
            case '{': {
                return VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.curly_case");
            }
            case '\"': {
                return VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.quote_case");
            }
            case 'b': {
                return VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.enclose.begin_case");
            }
        }
        return true;
    }

    private String encloseWithBracket(String bracket, String text, IDocument document, DocumentCommand command) {
        if ("(".equals(bracket)) {
            text = String.valueOf(text) + ")";
        } else if ("[".equals(bracket)) {
            text = String.valueOf(text) + "]";
        } else if ("{".equals(bracket)) {
            text = String.valueOf(text) + "}";
        } else if ("\"".equals(bracket)) {
            text = String.valueOf(text) + "\"";
        } else if ("b".equals(bracket)) {
            String lineSeparator = DVTDocumentCommon.getLineDelimiter((IEditorPart)(this.configuration != null ? this.configuration.getEditor() : DVTFileUtils.getInstance().getActiveEditor()));
            text = TextUtils.isFollowedByWhitespaces((IDocument)document, (int)(command.offset + command.length)) ? String.valueOf(text) + lineSeparator + "end" : String.valueOf(text) + lineSeparator + "end" + lineSeparator;
        }
        return text;
    }

    private String computeEnclosedText(String bracket, IDocument d, DocumentCommand command) {
        String enclosedTextResult = "";
        String enclosedTextIndented = "";
        String lineSeparator = DVTDocumentCommon.getLineDelimiter((IEditorPart)(this.configuration != null ? this.configuration.getEditor() : DVTFileUtils.getInstance().getActiveEditor()));
        enclosedTextResult = bracket.equals("b") ? (TextUtils.isPrecededByWhitespaces((IDocument)d, (int)command.offset) ? String.valueOf(enclosedTextResult) + "begin" + lineSeparator : String.valueOf(enclosedTextResult) + lineSeparator + "begin" + lineSeparator) : bracket;
        if (bracket.equals("\"")) {
            enclosedTextResult = String.valueOf(enclosedTextResult) + this.encloseWithQuote(d, command);
        } else {
            String commandText = this.getCommandText(d, command);
            if (bracket.equals("b")) {
                commandText = VlogAutoInsertBracketsStrategy.trimFirstAndLastLineDelimiters(commandText);
            }
            enclosedTextResult = String.valueOf(enclosedTextResult) + commandText;
        }
        enclosedTextResult = this.encloseWithBracket(bracket, enclosedTextResult, d, command);
        String indentText = "";
        try {
            int commandLine = d.getLineOfOffset(command.offset);
            int start = d.getLineOffset(commandLine);
            int lineLength = d.getLineLength(commandLine);
            String text = d.get(d.getLineOffset(commandLine), lineLength);
            indentText = TemplatesViewUtils.determineOffsetIndentExclusive((String)text);
            enclosedTextIndented = Utils.formatString(() -> new VlogSourceViewerConfiguration(null, false), (String)enclosedTextResult, (IDocument)d, (String)indentText, (start != command.offset ? 1 : 0) != 0);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (enclosedTextIndented == null) {
            return enclosedTextResult;
        }
        return enclosedTextIndented;
    }

    private String encloseWithQuote(IDocument d, DocumentCommand command) {
        StringBuilder enclosedTextResult = new StringBuilder();
        int escapeNumber = 0;
        String lineSeparator = DVTDocumentCommon.getLineDelimiter((IEditorPart)(this.configuration != null ? this.configuration.getEditor() : DVTFileUtils.getInstance().getActiveEditor()));
        if (this.isLiteralPartition(d, command.offset) && TextUtils.getChar((IDocument)d, (int)command.offset) != '\"') {
            enclosedTextResult.append("\"");
        }
        int i = 0;
        while (i < command.length) {
            char currentChar = TextUtils.getChar((IDocument)d, (int)(command.offset + i));
            if (currentChar == '\"') {
                escapeNumber = this.countEscapeNumber(d, command, i);
                if (escapeNumber == 0 || escapeNumber % 2 == 0) {
                    enclosedTextResult.append("\\");
                }
                enclosedTextResult.append(currentChar);
            } else if (Character.toString(currentChar).equals("\r") || Character.toString(currentChar).equals("\n")) {
                char nextChar = TextUtils.getChar((IDocument)d, (int)(command.offset + i + 1));
                if (!Character.toString(currentChar).equals("\r") || !Character.toString(nextChar).equals("\n")) {
                    enclosedTextResult.append(" \\" + lineSeparator);
                }
            } else {
                enclosedTextResult.append(currentChar);
            }
            ++i;
        }
        if (this.isLiteralPartition(d, command.offset + command.length - 1) && TextUtils.getChar((IDocument)d, (int)(command.offset + command.length - 1)) != '\"') {
            enclosedTextResult.append("\"");
        }
        return enclosedTextResult.toString();
    }

    public static String trimFirstAndLastLineDelimiters(String text) {
        String trimmedText = text;
        if (trimmedText.length() > 0) {
            switch (trimmedText.charAt(0)) {
                case '\n': {
                    trimmedText = trimmedText.substring(1, trimmedText.length());
                    break;
                }
                case '\r': {
                    if (trimmedText.charAt(1) == '\n') {
                        trimmedText = trimmedText.substring(2, trimmedText.length());
                        break;
                    }
                    trimmedText = trimmedText.substring(1, trimmedText.length());
                    break;
                }
            }
        }
        if (trimmedText.length() > 1) {
            switch (trimmedText.charAt(trimmedText.length() - 1)) {
                case '\n': {
                    if (trimmedText.charAt(trimmedText.length() - 2) == '\r') {
                        trimmedText = trimmedText.substring(0, trimmedText.length() - 2);
                        break;
                    }
                    trimmedText = trimmedText.substring(0, trimmedText.length() - 1);
                    break;
                }
                case '\r': {
                    trimmedText = trimmedText.substring(0, trimmedText.length() - 1);
                    break;
                }
            }
        }
        return trimmedText;
    }

    protected String getCommandText(IDocument d, DocumentCommand command) {
        StringBuilder commandText = new StringBuilder("");
        int i = 0;
        while (i < command.length) {
            commandText.append(TextUtils.getChar((IDocument)d, (int)(command.offset + i)));
            ++i;
        }
        return commandText.toString();
    }

    protected int countEscapeNumber(IDocument d, DocumentCommand command, int index) {
        int count = 0;
        int i = index - 1;
        while (i >= 0) {
            if (TextUtils.getChar((IDocument)d, (int)(command.offset + i)) != '\\') break;
            ++count;
            --i;
        }
        return count;
    }

    private void autoAddNewLine(char ch, char beforeCh, char afterCh, IDocument document, DocumentCommand command, DocumentCommand initialCommand) {
        boolean isEnabledAutoInsert = this.getPreferenceForAutoInsert(initialCommand.text);
        if (!isEnabledAutoInsert) {
            return;
        }
        if (ch == '}' && beforeCh == '{' && this.getPreferenceForAutoInsert("{") && afterCh != '}') {
            try {
                int commandLine = document.getLineOfOffset(initialCommand.offset);
                String text = command.text.startsWith(initialCommand.text) ? document.get(document.getLineOffset(commandLine), initialCommand.offset - document.getLineOffset(commandLine)) : command.text;
                String indentText = TemplatesViewUtils.determineOffsetIndentExclusive((String)text);
                String lineSeparator = DVTDocumentCommon.getLineDelimiter((IEditorPart)(this.configuration != null ? this.configuration.getEditor() : DVTFileUtils.getInstance().getActiveEditor()));
                String replaceString = String.valueOf(command.text) + lineSeparator + indentText;
                command.shiftsCaret = false;
                command.caretOffset = command.offset + command.text.length();
                command.text = replaceString;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        } else if (this.isLiteralPartition(document, initialCommand.offset) && initialCommand.offset > 0 && this.isLiteralPartition(document, initialCommand.offset - 1)) {
            try {
                int commandLine = document.getLineOfOffset(command.offset);
                int relativeOffset = command.offset - document.getLineOffset(commandLine);
                String text = document.get(command.offset, document.getLineLength(commandLine) - relativeOffset);
                int length = text.length();
                int count = 0;
                while (beforeCh == '\\') {
                    beforeCh = TextUtils.getChar((IDocument)document, (int)(command.offset - ++count - 1));
                }
                if (length >= 1 && count % 2 == 0) {
                    text = text.substring(0, length - 1);
                    String lineSeparator = DVTDocumentCommon.getLineDelimiter((IEditorPart)(this.configuration != null ? this.configuration.getEditor() : DVTFileUtils.getInstance().getActiveEditor()));
                    document.replace(command.offset, text.length(), "\\" + lineSeparator + text);
                    command.shiftsCaret = false;
                    command.caretOffset = command.offset + 1 + lineSeparator.length();
                    command.text = "";
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }
}

