/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import ro.amiq.vlogdt.core.VlogPlugin;

public class VlogAutoInsertBracketsStrategyCommon {
    private static final long TIME_THRESHOLD = 250L;
    private Map<String, List<Long>> fCharTimestampMap = new HashMap<String, List<Long>>();
    private char fPreviousChar;
    private char fPrePreviousChar;

    public void transformText(IDocument document, DocumentCommand command) {
        if (document == null || command == null) {
            return;
        }
        char ch = '\u0000';
        if (command.text.length() == 1) {
            ch = command.text.charAt(0);
        }
        long currentTimestamp = System.currentTimeMillis();
        boolean useWhitespace = VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.transform_whitespace");
        switch (ch) {
            case '.': {
                if (!VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.transform_dot_dot_to_assign")) break;
                if (this.fPreviousChar == '.' && currentTimestamp - this.fCharTimestampMap.get(String.valueOf(ch)).get(0) < 250L) {
                    --command.offset;
                    command.text = useWhitespace ? " => " : "=>";
                    command.length = 1;
                    this.fCharTimestampMap.put(".", Arrays.asList(0L));
                    break;
                }
                this.fCharTimestampMap.put(".", Arrays.asList(currentTimestamp));
                break;
            }
            case ',': {
                if (!VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.transform_comma_comma_to_assign")) break;
                if (this.fPreviousChar == ',' && currentTimestamp - this.fCharTimestampMap.get(String.valueOf(ch)).get(0) < 250L) {
                    --command.offset;
                    command.text = useWhitespace ? " <= " : "<=";
                    command.length = 1;
                    this.fCharTimestampMap.put(",", Arrays.asList(0L));
                    break;
                }
                this.fCharTimestampMap.put(",", Arrays.asList(currentTimestamp));
                break;
            }
            case ';': {
                if (!VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.transform_semicolon_to_assign")) break;
                if (this.fPreviousChar == ';' && this.fPrePreviousChar == ';' && currentTimestamp - this.fCharTimestampMap.get(String.valueOf(ch)).get(0) + (this.fCharTimestampMap.get(String.valueOf(ch)).get(0) - this.fCharTimestampMap.get(String.valueOf(ch)).get(1)) < 500L) {
                    command.offset -= 2;
                    command.text = useWhitespace ? " := " : ":=";
                    command.length = 2;
                    this.fCharTimestampMap.put(";", Arrays.asList(0L, 0L));
                    break;
                }
                if (this.fPreviousChar == ';') {
                    Long previousTimestamp = this.fCharTimestampMap.get(String.valueOf(ch)).get(0);
                    this.fCharTimestampMap.put(";", Arrays.asList(currentTimestamp, previousTimestamp));
                    break;
                }
                this.fCharTimestampMap.put(";", Arrays.asList(currentTimestamp));
                break;
            }
        }
        this.fPrePreviousChar = this.fPreviousChar;
        this.fPreviousChar = ch;
    }
}

