/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import java.util.Deque;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.edit.strategy.AutoEditProgressMonitor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditAdvancedRefLineFinder;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditAdvancedUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditCommandBuilder;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditOldEngineStrategy;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditStrategy;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeTokenProcessor;

public class VlogCodeAutoEditAdvancedStrategy
extends VlogCodeAutoEditOldEngineStrategy {
    private static final int DUMMY_TOKEN_FOR_NEW_LINE_INDENTATION = "[DUMMY_TOKEN_FOR_NEW_LINE]".hashCode();
    private static final int ADVANCED_LINES_LOOKBACK = 5000;
    private AutoEditProgressMonitor monitor = new AutoEditProgressMonitor();

    public VlogCodeAutoEditAdvancedStrategy(ISourceViewer sourceViewer, VlogSourceViewerConfiguration configuration, ICharacterPairMatcher matcher) {
        super(sourceViewer, configuration, matcher);
        VlogAutoEditAdvancedRefLineFinder.getInstance().resetUnmatchedClosingTokens();
    }

    @Override
    protected void setLinesLookback() {
        VlogAutoEditAdvancedRefLineFinder.getInstance().setLinesLookback(5000);
    }

    @Override
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        this.autoInsertBracketsStrategy.transformText(document, command);
        this.monitor.resetTimeout();
        DocumentCommand initialCommand = this.autoIndent(document, command, this.monitor);
        this.autoInsertBracketsStrategy.autoInsertAndEncloseBrackets(document, command, initialCommand);
    }

    @Override
    protected boolean autoIndentToken(IDocument document, DocumentCommand command, boolean entireLine, AutoEditProgressMonitor monitor) {
        int offset = command.offset;
        if (offset < 0 || offset > document.getLength()) {
            return false;
        }
        return this.indentTokensInLine(document, command, monitor);
    }

    @Override
    protected void smartIndentAfterNewLine(IDocument document, DocumentCommand command, boolean commandModified, int offset, int length, AutoEditProgressMonitor monitor) throws BadLocationException {
        int additionalLength;
        int line = document.getLineOfOffset(offset);
        if (this.preserveCommentIndentation(document, offset, length)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(command.text);
        buffer.append(this.computeIndentForNewLine(document, command, commandModified, offset, length, line, monitor));
        command.text = buffer.toString();
        IRegion lineInfo = document.getLineInformation(line);
        if (lineInfo == null) {
            return;
        }
        if (length == 1) {
            int endOfSelectionOffset = offset + length;
            int endOfSelectionLine = document.getLineOfOffset(endOfSelectionOffset);
            int endOfSelectionLineOffset = document.getLineOffset(endOfSelectionLine);
            int endOfSelectionLineLength = document.getLineLength(endOfSelectionLine);
            additionalLength = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)endOfSelectionOffset, (int)(endOfSelectionLineOffset + endOfSelectionLineLength)) - endOfSelectionOffset;
        } else {
            additionalLength = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)offset, (int)(lineInfo.getOffset() + lineInfo.getLength())) - offset;
        }
        command.length += Math.max(0, additionalLength);
    }

    private boolean indentTokensInLine(IDocument document, DocumentCommand command, AutoEditProgressMonitor monitor) {
        VlogCodeTokenProcessor.Token firstToken = VlogCodeAutoEditAdvancedUtils.getInstance().getFirstTokenInLine(document, command);
        if (firstToken == null) {
            return false;
        }
        VlogCodeTokenProcessor.Token tokenAtCursor = VlogCodeAutoEditAdvancedUtils.getInstance().getTokenAtCursor(document, command);
        if (tokenAtCursor == null) {
            return false;
        }
        boolean hasGoodDelimiterBeforeCursor = this.hasGoodDelimiterBeforeCursor(document, command);
        boolean shouldMoveKeyword = VlogCodeAutoEditAdvancedUtils.getInstance().shouldMoveKeyword(tokenAtCursor, this.fSourceViewer, document, this.fPairMatcher, 5000, monitor);
        boolean shouldAddNewline = VlogCodeAutoEditAdvancedUtils.getInstance().shouldAddNewLine(tokenAtCursor, this.fSourceViewer, document, command.offset);
        if (hasGoodDelimiterBeforeCursor && (shouldMoveKeyword || shouldAddNewline)) {
            return this.processKeywordPreferences(document, command, monitor, firstToken, tokenAtCursor, shouldMoveKeyword);
        }
        if (VlogCodeAutoEditAdvancedUtils.getInstance().onlyOneTokenInLine(firstToken, tokenAtCursor)) {
            return this.autoIndentTokenAtCursor(document, command, tokenAtCursor, monitor, hasGoodDelimiterBeforeCursor);
        }
        return this.autoIndentFirstTokenInLine(document, command, firstToken, monitor);
    }

    private boolean applyAutoIndentEdit(IDocument document, DocumentCommand command, StringBuilder buffer) {
        int lineNumber = VlogAutoEditUtils.getInstance().getLineOfOffset(document, command.offset);
        if (lineNumber == -1) {
            return false;
        }
        int lineOffset = VlogAutoEditUtils.getInstance().getLineOffset(document, lineNumber);
        if (lineOffset == -1) {
            return false;
        }
        int length = command.offset - lineOffset;
        command.length = command.length != 0 ? length + command.length : length;
        command.offset = lineOffset;
        command.text = buffer.toString();
        return true;
    }

    private boolean processKeywordPreferences(IDocument document, DocumentCommand command, AutoEditProgressMonitor monitor, VlogCodeTokenProcessor.Token firstToken, VlogCodeTokenProcessor.Token tokenAtCursor, boolean shouldMoveKeyword) {
        if (command.text.trim().length() != 0) {
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        this.autoIndentLineBeforeMovingKeyword(document, command, firstToken, tokenAtCursor, buffer, monitor);
        String indent = this.computeIndentForTokenAtCursor(document, command, tokenAtCursor, monitor, shouldMoveKeyword);
        if (shouldMoveKeyword) {
            if (VlogCodeAutoEditCommandBuilder.INSTANCE.moveKeyword(document, tokenAtCursor, command, buffer, indent, this.fSourceViewer)) {
                return this.applyAutoIndentEdit(document, command, buffer);
            }
            return false;
        }
        if (VlogCodeAutoEditCommandBuilder.INSTANCE.addNewLine(document, tokenAtCursor, command, buffer, indent, this.fSourceViewer)) {
            return this.applyAutoIndentEdit(document, command, buffer);
        }
        return false;
    }

    private void autoIndentLineBeforeMovingKeyword(IDocument document, DocumentCommand command, VlogCodeTokenProcessor.Token firstToken, VlogCodeTokenProcessor.Token tokenAtCursor, StringBuilder buffer, AutoEditProgressMonitor monitor) {
        if (firstToken == null || tokenAtCursor == null) {
            return;
        }
        int firstTokenOffset = firstToken.getStartOffset();
        int tokenAtCursorOffset = tokenAtCursor.getStartOffset();
        boolean isGoodDelimiter = VlogCodeAutoEditAdvancedUtils.getInstance().isGoodDelimiter(firstToken);
        if (!isGoodDelimiter || !TextUtils.isPrecededByWhitespaces((IDocument)document, (int)firstTokenOffset)) {
            int lineNumber = VlogAutoEditUtils.getInstance().getLineOfOffset(document, command.offset);
            if (lineNumber == -1) {
                return;
            }
            int lineOffset = VlogAutoEditUtils.getInstance().getLineOffset(document, lineNumber);
            if (lineOffset == -1) {
                return;
            }
            String restOfLine = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, lineOffset, tokenAtCursorOffset - lineOffset);
            if (restOfLine == null) {
                return;
            }
            buffer.append(restOfLine);
            return;
        }
        if (VlogCodeAutoEditAdvancedUtils.getInstance().onlyOneTokenInLine(firstToken, tokenAtCursor)) {
            return;
        }
        String indent = this.computeIndentForFirstTokenInLine(document, command, firstToken, monitor);
        if (indent == null) {
            return;
        }
        buffer.append(indent);
        String restOfLine = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, firstTokenOffset, tokenAtCursorOffset - firstTokenOffset);
        if (restOfLine == null) {
            return;
        }
        buffer.append(restOfLine);
    }

    private boolean autoIndentFirstTokenInLine(IDocument document, DocumentCommand command, VlogCodeTokenProcessor.Token firstToken, AutoEditProgressMonitor monitor) {
        if (firstToken == null) {
            return false;
        }
        boolean isGoodDelimiter = VlogCodeAutoEditAdvancedUtils.getInstance().isGoodDelimiter(firstToken);
        if (!isGoodDelimiter) {
            return false;
        }
        if (!TextUtils.isPrecededByWhitespaces((IDocument)document, (int)firstToken.getStartOffset())) {
            return false;
        }
        if (!VlogCodeAutoEditAdvancedUtils.getInstance().checkCommandText(document, command, firstToken)) {
            return false;
        }
        String indent = this.computeIndentForFirstTokenInLine(document, command, firstToken, monitor);
        if (indent == null) {
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(indent);
        int firstTokenOffset = firstToken.getStartOffset();
        String restOfLine = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, firstTokenOffset, command.offset - firstTokenOffset);
        if (restOfLine == null) {
            return false;
        }
        buffer.append(restOfLine);
        buffer.append(command.text);
        return this.applyAutoIndentEdit(document, command, buffer);
    }

    private String computeIndentForFirstTokenInLine(IDocument document, DocumentCommand command, VlogCodeTokenProcessor.Token firstToken, AutoEditProgressMonitor monitor) {
        if (firstToken == null) {
            return null;
        }
        int lineNumber = VlogAutoEditUtils.getInstance().getLineOfOffset(document, command.offset);
        if (lineNumber == -1) {
            return null;
        }
        boolean isGoodDelimiter = VlogCodeAutoEditAdvancedUtils.getInstance().isGoodDelimiter(firstToken);
        if (!isGoodDelimiter) {
            return DVTDocumentCommon.getIndentOfLine((IDocument)document, (int)lineNumber, (int)command.offset);
        }
        return this.computeIndentForToken(document, command, firstToken, lineNumber, monitor);
    }

    private boolean autoIndentTokenAtCursor(IDocument document, DocumentCommand command, VlogCodeTokenProcessor.Token tokenAtCursor, AutoEditProgressMonitor monitor, boolean hasGoodDelimiterBeforeCursor) {
        if (tokenAtCursor == null) {
            return false;
        }
        if (!TextUtils.isPrecededByWhitespaces((IDocument)document, (int)tokenAtCursor.getStartOffset())) {
            return false;
        }
        if (!hasGoodDelimiterBeforeCursor) {
            return false;
        }
        String indent = this.computeIndentForFirstTokenInLine(document, command, tokenAtCursor, monitor);
        if (indent == null) {
            return false;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(indent);
        int tokenAtCursorOffset = tokenAtCursor.getStartOffset();
        String restOfLine = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, tokenAtCursorOffset, command.offset - tokenAtCursorOffset);
        if (restOfLine == null) {
            return false;
        }
        buffer.append(restOfLine);
        buffer.append(command.text);
        return this.applyAutoIndentEdit(document, command, buffer);
    }

    private String computeIndentForTokenAtCursor(IDocument document, DocumentCommand command, VlogCodeTokenProcessor.Token tokenAtCursor, AutoEditProgressMonitor monitor, boolean shouldMoveKeyword) {
        if (shouldMoveKeyword && VlogCodeAutoEditAdvancedUtils.getInstance().isMoveKeywordOnSameLinePref(tokenAtCursor, this.fSourceViewer, document)) {
            return "";
        }
        int lineNumber = VlogAutoEditUtils.getInstance().getLineOfOffset(document, command.offset);
        if (lineNumber == -1) {
            return "";
        }
        return this.computeIndentForToken(document, command, tokenAtCursor, lineNumber, monitor);
    }

    @Override
    protected String computeIndentForToken(IDocument document, DocumentCommand command, VlogCodeTokenProcessor.Token delimiter, int line, AutoEditProgressMonitor monitor) {
        int anchorLine = VlogCodeAutoEditAdvancedUtils.getInstance().isOpenDelimiter(delimiter) ? VlogAutoEditAdvancedRefLineFinder.getInstance().getAnchorForOpenDelimiter(document, line, delimiter, this.fPairMatcher, monitor) : VlogAutoEditAdvancedRefLineFinder.getInstance().getAnchorForCloseDelimiter(document, line, delimiter, this.fPairMatcher, monitor);
        if (anchorLine == -1) {
            return super.computeIndentForToken(document, command, delimiter, line, monitor);
        }
        IRegion lineInformation = VlogAutoEditUtils.getInstance().getLineInformation(document, anchorLine);
        int endOffset = VlogCodeAutoEditAdvancedUtils.getInstance().getEndOffsetForFormatting(command, delimiter);
        String additionalText = VlogCodeAutoEditAdvancedUtils.getInstance().getAdditionalTextForFormatting(command, delimiter);
        return VlogCodeAutoEditAdvancedUtils.getInstance().computeIndent(lineInformation, endOffset, additionalText, this.fSourceViewer);
    }

    @Override
    protected String computeIndentForNewLine(IDocument document, DocumentCommand command, boolean commandModified, int offset, int length, int line, AutoEditProgressMonitor monitor) throws BadLocationException {
        VlogAutoEditAdvancedRefLineFinder.getInstance().resetUnmatchedClosingTokens();
        int anchorLine = VlogAutoEditAdvancedRefLineFinder.getInstance().getAnchorForNewLine(document, line, offset, this.fSourceViewer, this.fPairMatcher, monitor);
        if (anchorLine == -1) {
            return super.computeIndentForNewLine(document, command, commandModified, offset, length, line, monitor);
        }
        IRegion lineInfo = document.getLineInformation(anchorLine);
        int endOffset = command.offset;
        String additionalText = String.valueOf(command.text) + DUMMY_TOKEN_FOR_NEW_LINE_INDENTATION;
        String endTokenAfterCursor = this.getEndTokenAfterCursor(document, length == 1 ? offset + length : offset);
        if (endTokenAfterCursor != null) {
            additionalText = String.valueOf(additionalText) + endTokenAfterCursor;
        }
        return VlogCodeAutoEditAdvancedUtils.getInstance().computeIndent(lineInfo, endOffset, additionalText, this.fSourceViewer);
    }

    @Override
    protected String computeIndentForTab(IDocument document, DocumentCommand command, int line, AutoEditProgressMonitor monitor) {
        VlogAutoEditAdvancedRefLineFinder.getInstance().resetUnmatchedClosingTokens();
        int anchorLine = -1;
        String dummyToken = "";
        IRegion lineInfo = VlogAutoEditUtils.getInstance().getLineInformationOfOffset(document, command.offset);
        if (lineInfo == null) {
            return "";
        }
        int lineOffset = lineInfo.getOffset();
        int lineLength = lineInfo.getLength();
        VlogCodeTokenProcessor.Token openDelimiter = this.hasGoodOpenDelimiter(document, command, true, false);
        VlogCodeTokenProcessor.Token endDelimiter = this.hasGoodEndDelimiter(document, command, true, false);
        if (openDelimiter != null || endDelimiter != null) {
            anchorLine = openDelimiter != null ? VlogAutoEditAdvancedRefLineFinder.getInstance().getAnchorForOpenDelimiter(document, line, openDelimiter, this.fPairMatcher, monitor) : VlogAutoEditAdvancedRefLineFinder.getInstance().getAnchorForCloseDelimiter(document, line, endDelimiter, this.fPairMatcher, monitor);
        } else {
            int prevLine = VlogCodeAutoEditAdvancedUtils.getInstance().getPreviousLineForIndent(document, line);
            if (prevLine != line) {
                IRegion prevLineInfo = VlogAutoEditUtils.getInstance().getLineInformation(document, prevLine);
                int prevLineOffset = prevLineInfo.getOffset() + prevLineInfo.getLength();
                anchorLine = VlogAutoEditAdvancedRefLineFinder.getInstance().getAnchorForNewLine(document, prevLine, prevLineOffset, this.fSourceViewer, this.fPairMatcher, monitor);
                String currentLineContent = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, lineOffset, lineLength);
                if (currentLineContent == null) {
                    return "";
                }
                dummyToken = String.valueOf(dummyToken) + (currentLineContent.trim().isEmpty() ? Integer.valueOf(DUMMY_TOKEN_FOR_NEW_LINE_INDENTATION) : "");
            }
        }
        if (anchorLine == -1) {
            return super.computeIndentForTab(document, command, line, monitor);
        }
        IRegion anchorLineInfo = VlogAutoEditUtils.getInstance().getLineInformation(document, anchorLine);
        if (anchorLineInfo == null) {
            return "";
        }
        return VlogCodeAutoEditAdvancedUtils.getInstance().computeIndent(anchorLineInfo, lineOffset + lineLength, dummyToken, this.fSourceViewer);
    }

    private boolean hasGoodDelimiterBeforeCursor(IDocument document, DocumentCommand command) {
        return this.hasGoodOpenDelimiter(document, command, false, true) != null || this.hasGoodEndDelimiter(document, command, false, true) != null;
    }

    private VlogCodeTokenProcessor.Token hasGoodOpenDelimiter(IDocument document, DocumentCommand command, boolean entireLine, boolean rightToLeft) {
        int line = VlogAutoEditUtils.getInstance().getLineOfOffset(document, command.offset);
        if (line == -1) {
            return null;
        }
        int start = VlogAutoEditUtils.getInstance().getLineOffset(document, line);
        if (start == -1) {
            return null;
        }
        int lineLength = VlogAutoEditUtils.getInstance().getLineLength(document, line);
        if (lineLength == -1) {
            return null;
        }
        int end = entireLine ? start + lineLength : Math.min(start + lineLength, command.offset);
        String strLine = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, start, end - start);
        if (strLine == null) {
            return null;
        }
        return this.getDelimiter(document, start, strLine, VlogCodeAutoEditStrategy.DelimiterType.OPEN_DELIMITER, rightToLeft);
    }

    @Override
    protected VlogCodeTokenProcessor.Token hasGoodEndDelimiter(IDocument document, DocumentCommand command, boolean entireLine, boolean rightToLeft) {
        int line = VlogAutoEditUtils.getInstance().getLineOfOffset(document, command.offset);
        if (line == -1) {
            return null;
        }
        int start = VlogAutoEditUtils.getInstance().getLineOffset(document, line);
        if (start == -1) {
            return null;
        }
        int lineLength = VlogAutoEditUtils.getInstance().getLineLength(document, line);
        if (lineLength == -1) {
            return null;
        }
        int end = entireLine ? start + lineLength : Math.min(start + lineLength, command.offset);
        String strLine = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, start, end - start);
        if (strLine == null) {
            return null;
        }
        return this.getDelimiter(document, start, String.valueOf(strLine) + command.text, VlogCodeAutoEditStrategy.DelimiterType.END_DELIMITER, rightToLeft);
    }

    @Override
    protected VlogCodeTokenProcessor.Token getDelimiter(IDocument document, int startOffset, String strLine, VlogCodeAutoEditStrategy.DelimiterType type, boolean rightToLeft) {
        if (strLine == null || type == null) {
            return null;
        }
        Deque<VlogCodeTokenProcessor.Token> delimiters = VlogCodeTokenProcessor.getTokensFromString(document, startOffset, strLine);
        if (delimiters == null) {
            return null;
        }
        Iterator<VlogCodeTokenProcessor.Token> it = rightToLeft ? delimiters.descendingIterator() : delimiters.iterator();
        VlogCodeTokenProcessor.Token token = null;
        while (it.hasNext()) {
            token = it.next();
            if (token.getType() != 3) break;
        }
        if (token == null) {
            return null;
        }
        switch (type) {
            case OPEN_DELIMITER: {
                if (!VlogCodeAutoEditAdvancedUtils.getInstance().isOpenDelimiter(token)) break;
                return token;
            }
            case END_DELIMITER: {
                boolean isEndDelimiter = VlogCodeAutoEditAdvancedUtils.getInstance().isEndDelimiter(token);
                if (!isEndDelimiter) break;
                if (VlogCodeAutoEditAdvancedUtils.getInstance().isEndKeyword(token)) {
                    int indexOfToken = strLine.lastIndexOf(token.getValue());
                    int followingCharIndex = indexOfToken + token.getValue().length();
                    if (strLine.length() <= followingCharIndex) {
                        return null;
                    }
                    char followingChar = strLine.charAt(followingCharIndex);
                    if (Character.isWhitespace(followingChar)) {
                        return token;
                    }
                    return null;
                }
                return token;
            }
        }
        return null;
    }

    @Override
    protected DocumentCommand formatOnPaste(IDocument document, DocumentCommand command) {
        try {
            String formattedText;
            if (!this.isAutoEditOnPasteEnabled()) {
                return command;
            }
            boolean cursorPrecededByWS = TextUtils.isPrecededByWhitespaces((IDocument)document, (int)command.offset);
            if (!cursorPrecededByWS && !VlogCodeAutoEditAdvancedUtils.getInstance().containsNewLine(document, command.text)) {
                return command;
            }
            int anchorLine = VlogAutoEditAdvancedRefLineFinder.getInstance().getAnchorLine(document, command, this.fSourceViewer, this.fPairMatcher, this.monitor);
            if (anchorLine == -1) {
                return command;
            }
            int anchorLineOffset = document.getLineOffset(anchorLine);
            String contentBetweenAnchorAndCursor = document.get(anchorLineOffset, command.offset - anchorLineOffset);
            String endTokenAfterCursor = null;
            if (VlogCodeAutoEditAdvancedUtils.getInstance().endsWithNewLine(document, command.text)) {
                int commandEndOffset = command.length > 0 ? command.offset + command.length : command.offset;
                endTokenAfterCursor = this.getEndTokenAfterCursor(document, commandEndOffset);
            }
            if ((formattedText = this.computeFormattedText(document, command, contentBetweenAnchorAndCursor, endTokenAfterCursor, cursorPrecededByWS, this.isIndentOnPasteEnabled())) == null) {
                return command;
            }
            command.length = this.computeNewCommandLength(document, command.text, command.offset, command.length);
            command.offset = this.computeNewCommandOffset(document, command, cursorPrecededByWS);
            command.text = formattedText;
            return command;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return command;
        }
    }

    private String getEndTokenAfterCursor(IDocument document, int offset) throws BadLocationException {
        String endTokenAfterCursor = null;
        int currentLine = document.getLineOfOffset(offset);
        int currentLineOffset = document.getLineOffset(currentLine);
        int currentLineLength = document.getLineLength(currentLine);
        int endOfWhiteSpace = this.findEndOfWhiteSpace(document, offset, currentLineOffset + currentLineLength);
        VlogCodeTokenProcessor.Token tokenAtOffset = VlogCodeAutoEditAdvancedUtils.getInstance().getTokenAtOffset(document, endOfWhiteSpace);
        if (VlogCodeAutoEditAdvancedUtils.getInstance().isEndDelimiter(tokenAtOffset)) {
            endTokenAfterCursor = String.valueOf(System.lineSeparator()) + tokenAtOffset.getValue();
        }
        return endTokenAfterCursor;
    }

    @Override
    protected String getIndent(IDocument initDocument, IDocument docToFormat, DocumentCommand command) {
        return DVTDocumentCommon.getIndentOfLine((IDocument)docToFormat, (int)0, (int)-1);
    }

    @Override
    protected boolean isValidCommandLength(DocumentCommand command) {
        if (command.length > 1 || command.text == null) {
            return false;
        }
        return command.text.length() != 0;
    }

    @Override
    protected void setIndentationValues() {
        boolean detectIndentationEnabled = PrefConst.isDetectIndentationEnabled();
        this.fTabSize = detectIndentationEnabled ? this.fConfiguration.getTabWidth() : this.fConfiguration.getTabWidth(this.fSourceViewer);
        this.fUseSpacesNotTabs = detectIndentationEnabled ? this.fConfiguration.getInsertSpaces() : TextUtils.getEditorSpacesForTabs((IPreferenceStore)VlogPlugin.getDefault().getCombinedPreferenceStore());
    }
}

