/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.ui.editor.formatter.preferences.CFPreferences;
import ro.amiq.dvt.ui.editor.formatter.strategies.IDVTFormattingStrategy;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.ui.editor.edit.strategy.AutoEditProgressMonitor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.DocumentLineAccessor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditAdvancedKeywordSets;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeTokenProcessor;

public class VlogCodeAutoEditAdvancedUtils
extends VlogCodeAutoEditUtils
implements VlogAutoEditAdvancedKeywordSets {
    private static VlogCodeAutoEditAdvancedUtils INSTANCE;
    private static final Object LOCK;

    static {
        LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogCodeAutoEditAdvancedUtils getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new VlogCodeAutoEditAdvancedUtils();
            }
        }
        return INSTANCE;
    }

    private Deque<VlogCodeTokenProcessor.Token> getTokensFromLine(IDocument document, DocumentCommand command) {
        int line = this.getLineOfOffset(document, command.offset);
        if (line == -1) {
            return null;
        }
        int start = this.getLineOffset(document, line);
        if (start == -1) {
            return null;
        }
        int lineLength = this.getLineLength(document, line);
        if (lineLength == -1) {
            return null;
        }
        int end = Math.min(start + lineLength, command.offset);
        String strLine = String.valueOf(this.getDocumentSubstring(document, start, end - start)) + command.text;
        return VlogCodeTokenProcessor.getTokensFromString(document, start, strLine);
    }

    public VlogCodeTokenProcessor.Token getTokenAtCursor(IDocument document, DocumentCommand command) {
        Deque<VlogCodeTokenProcessor.Token> delimiters = this.getTokensFromLine(document, command);
        if (delimiters == null) {
            return null;
        }
        Iterator<VlogCodeTokenProcessor.Token> it = delimiters.descendingIterator();
        VlogCodeTokenProcessor.Token token = null;
        while (it.hasNext()) {
            token = it.next();
            int tokenType = token.getType();
            if (tokenType != 3 || tokenType == 3 && token.getStartOffset() < command.offset) break;
        }
        return token;
    }

    public VlogCodeTokenProcessor.Token getFirstTokenInLine(IDocument document, DocumentCommand command) {
        Deque<VlogCodeTokenProcessor.Token> delimiters = this.getTokensFromLine(document, command);
        if (delimiters == null) {
            return null;
        }
        Iterator<VlogCodeTokenProcessor.Token> it = delimiters.iterator();
        VlogCodeTokenProcessor.Token token = null;
        while (it.hasNext()) {
            token = it.next();
            if (token.getType() != 3) break;
        }
        return token;
    }

    public VlogCodeTokenProcessor.Token getTokenAtOffset(IDocument document, int offset) {
        int line = this.getLineOfOffset(document, offset);
        if (line == -1) {
            return null;
        }
        int start = this.getLineOffset(document, line);
        if (start == -1) {
            return null;
        }
        int end = start + this.getLineLength(document, line);
        String strLine = this.getDocumentSubstring(document, start, end - start);
        if (strLine == null) {
            return null;
        }
        Deque<VlogCodeTokenProcessor.Token> delimiters = VlogCodeTokenProcessor.getTokensFromString(document, start, strLine);
        if (delimiters == null) {
            return null;
        }
        Iterator<VlogCodeTokenProcessor.Token> it = delimiters.iterator();
        VlogCodeTokenProcessor.Token token = null;
        while (it.hasNext()) {
            int tokenStartOffset;
            token = it.next();
            if (token == null || (tokenStartOffset = token.getStartOffset()) != offset) continue;
            return token;
        }
        return null;
    }

    public VlogCodeTokenProcessor.Token getPrevNWSToken(DocumentLineAccessor acc) {
        VlogCodeTokenProcessor.Token token;
        while ((token = acc.nextToken()) != null) {
            if (token.getType() != 3) break;
        }
        return token;
    }

    public VlogCodeTokenProcessor.Token getLastCodeTokenFromPrevLine(IDocument document, int prevLineNo) {
        int prevLineOffset = this.getLineOffset(document, prevLineNo);
        if (prevLineOffset == -1) {
            return null;
        }
        int prevLineLength = this.getLineLength(document, prevLineNo);
        if (prevLineLength == -1) {
            return null;
        }
        String prevLineContent = this.getDocumentSubstring(document, prevLineOffset, prevLineLength);
        Deque<VlogCodeTokenProcessor.Token> prevLineDelimiters = VlogCodeTokenProcessor.getTokensFromString(document, prevLineOffset, prevLineContent);
        Iterator<VlogCodeTokenProcessor.Token> it = prevLineDelimiters.descendingIterator();
        VlogCodeTokenProcessor.Token token = null;
        while (it.hasNext()) {
            token = it.next();
            if (token.getType() != 3) break;
        }
        return token;
    }

    public boolean isGoodDelimiter(VlogCodeTokenProcessor.Token token) {
        return this.isOpenDelimiter(token) || this.isEndDelimiter(token);
    }

    public boolean isOpenDelimiter(VlogCodeTokenProcessor.Token token) {
        if (this.isOpenBracket(token)) {
            return true;
        }
        if (this.isOpenKeyword(token)) {
            return true;
        }
        if (this.isOneLineIndentKeyword(token)) {
            return true;
        }
        return this.isOpenPreproc(token);
    }

    public boolean isOpenKeyword(VlogCodeTokenProcessor.Token token) {
        return this.isOpenKeywordWithSemi(token) || this.isOpenKeywordWithoutSemi(token);
    }

    public boolean isOpenKeywordWithSemi(VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 2) {
            return false;
        }
        return OPEN_KEYWORDS_WITH_SEMI.contains(token.getValue());
    }

    public boolean isOpenKeywordWithoutSemi(VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 2) {
            return false;
        }
        return OPEN_KEYWORDS_WITHOUT_SEMI.contains(token.getValue());
    }

    public boolean isOneLineIndentKeyword(VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 2) {
            return false;
        }
        return ONE_LINE_INDENT_KEYWORDS.contains(token.getValue());
    }

    public boolean isOpenPreproc(VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 2) {
            return false;
        }
        return OPEN_PREPROCS.contains(token.getValue());
    }

    public boolean isEndDelimiter(VlogCodeTokenProcessor.Token token) {
        if (this.isClosedBracket(token)) {
            return true;
        }
        if (this.isClosedKeywordSemi(token)) {
            return true;
        }
        if (this.isClosedKeywordNoSemi(token, true)) {
            return true;
        }
        return this.isClosedPreproc(token);
    }

    public boolean isClosedKeywordSemi(VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 2) {
            return false;
        }
        return CLOSED_KEYWORDS_OF_SEMI.contains(token.getValue());
    }

    public boolean isClosedKeywordNoSemi(VlogCodeTokenProcessor.Token token, boolean hasSemicolon) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 2) {
            return false;
        }
        String value = token.getValue();
        return hasSemicolon && CLOSED_KEYWORDS_SEMI.contains(value) || CLOSED_KEYWORDS_OF_NO_SEMI.contains(token.getValue());
    }

    public boolean isClosedPreproc(VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 2) {
            return false;
        }
        return CLOSE_PREPROCS.contains(token.getValue());
    }

    public boolean isMiddlePreproc(VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 2) {
            return false;
        }
        return MIDDLE_PREPROCS.contains(token.getValue());
    }

    public boolean isDefine(VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 2) {
            return false;
        }
        return "`define".equals(token.getValue());
    }

    public boolean isPreproc(VlogCodeTokenProcessor.Token token) {
        return this.isOpenPreproc(token) || this.isMiddlePreproc(token) || this.isClosedPreproc(token) || this.isDefine(token);
    }

    public boolean isConstraintKeyword(VlogCodeTokenProcessor.Token token) {
        return token != null && "constraint".equals(token.getValue());
    }

    public boolean isStructKeyword(VlogCodeTokenProcessor.Token token) {
        return token != null && "struct".equals(token.getValue());
    }

    public boolean isSemicolon(VlogCodeTokenProcessor.Token token) {
        return token != null && ";".equals(token.getValue());
    }

    public boolean isColon(VlogCodeTokenProcessor.Token token) {
        return token != null && ":".equals(token.getValue());
    }

    private boolean isRandomQulifier(VlogCodeTokenProcessor.Token token) {
        return token != null && RANDOM_QULIFIERS.contains(token.getValue());
    }

    public CFPreferences getFormatPreferences(ISourceViewer sourceViewer, IDocument document, int offset) {
        IFormattingStrategy formattingStrategy;
        block15: {
            String currentContentType;
            IContentFormatter formatter;
            block14: {
                block13: {
                    block12: {
                        SourceViewerConfiguration svc;
                        block11: {
                            DVTEditor editor;
                            block10: {
                                block9: {
                                    if (sourceViewer instanceof DVTProjectionViewer) break block9;
                                    return null;
                                }
                                editor = ((DVTProjectionViewer)sourceViewer).getEditor();
                                if (editor != null) break block10;
                                return null;
                            }
                            svc = editor.getSourceViewerConfigurationForEditor();
                            if (svc instanceof DVTSourceViewerConfiguration) break block11;
                            return null;
                        }
                        DVTSourceViewerConfiguration dvtSVC = (DVTSourceViewerConfiguration)svc;
                        formatter = dvtSVC.getContentFormatter(null);
                        if (formatter instanceof DVTContentFormatter) break block12;
                        return null;
                    }
                    if (document instanceof IDocumentExtension3) break block13;
                    return null;
                }
                currentContentType = ((IDocumentExtension3)document).getContentType("__vlog_partitioning", offset, false);
                if (currentContentType != null) break block14;
                return null;
            }
            formattingStrategy = formatter.getFormattingStrategy(currentContentType);
            if (formattingStrategy instanceof IDVTFormattingStrategy) break block15;
            return null;
        }
        try {
            return ((IDVTFormattingStrategy)formattingStrategy).getFormatPreferences();
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
    }

    public boolean shouldIgnoreLine(IDocument document, int line, CFPreferences formatPreferences) {
        if (formatPreferences == null) {
            return false;
        }
        IRegion lineInfo = this.getLineInformation(document, line);
        if (lineInfo == null) {
            return false;
        }
        String lineContent = this.getDocumentSubstring(document, lineInfo.getOffset(), lineInfo.getLength());
        if (lineContent == null) {
            return false;
        }
        String ignoreLinesStartingWith = formatPreferences.getIgnoreLinesStartingWith();
        if (ignoreLinesStartingWith == null || ignoreLinesStartingWith.isEmpty()) {
            return false;
        }
        String[] stringArray = ignoreLinesStartingWith.split(" ");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (keyword != null && lineContent.trim().startsWith(keyword)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isAddNewLineAfterBeginAndBeforeEnd(ISourceViewer sourceViewer, IDocument document, VlogCodeTokenProcessor.Token delimiter) {
        if (!this.isBeginKeyword(delimiter) && !this.isEndKeyword(delimiter)) {
            return false;
        }
        CFPreferences formatPreferences = this.getFormatPreferences(sourceViewer, document, delimiter.getStartOffset());
        if (formatPreferences == null) {
            return false;
        }
        return formatPreferences.getBooleanProperty("format.indent.add_new_line_after_begin_and_before_end");
    }

    public boolean isAddNewLineAfterEnd(ISourceViewer sourceViewer, IDocument document, VlogCodeTokenProcessor.Token delimiter) {
        if (!this.isEndKeyword(delimiter)) {
            return false;
        }
        CFPreferences formatPreferences = this.getFormatPreferences(sourceViewer, document, delimiter.getStartOffset());
        if (formatPreferences == null) {
            return false;
        }
        return formatPreferences.getBooleanProperty("format.indent.add_new_line_after_end");
    }

    public boolean shouldMoveKeyword(VlogCodeTokenProcessor.Token token, ISourceViewer sourceViewer, IDocument document, ICharacterPairMatcher pairMatcher, int linesLookback, AutoEditProgressMonitor monitor) {
        if (this.isBeginKeyword(token)) {
            return this.shouldMoveBeginKeyword(sourceViewer, document, token, pairMatcher, linesLookback, monitor);
        }
        if (this.isElseKeyword(token)) {
            return this.shouldMoveElseKeyword(sourceViewer, document, token, pairMatcher, linesLookback, monitor);
        }
        return false;
    }

    public boolean shouldAddNewLine(VlogCodeTokenProcessor.Token token, ISourceViewer sourceViewer, IDocument document, int commandOffset) {
        if (this.isBeginKeyword(token)) {
            return this.isAddNewLineAfterBeginAndBeforeEnd(sourceViewer, document, token) && !this.isFollowedByNL(document, commandOffset);
        }
        if (this.isEndKeyword(token)) {
            return this.shouldAddNewLineForEndKeyword(sourceViewer, document, token, commandOffset);
        }
        return false;
    }

    public boolean isMoveKeywordOnSameLinePref(VlogCodeTokenProcessor.Token token, ISourceViewer sourceViewer, IDocument document) {
        if (this.isBeginKeyword(token)) {
            return this.getBeginIndentationPref(sourceViewer, document, token.getStartOffset()) == 3;
        }
        if (this.isElseKeyword(token)) {
            return this.getElseIndentationPref(sourceViewer, document, token.getStartOffset()) == 3;
        }
        return false;
    }

    public boolean isBeginKeyword(VlogCodeTokenProcessor.Token token) {
        return token != null && "begin".equals(token.getValue());
    }

    public int getBeginIndentationPref(ISourceViewer sourceViewer, IDocument document, int offset) {
        CFPreferences formatPreferences = this.getFormatPreferences(sourceViewer, document, offset);
        if (formatPreferences == null) {
            return -1;
        }
        return formatPreferences.getIntegerProperty("format.indent.begin");
    }

    public boolean shouldMoveBeginKeyword(ISourceViewer sourceViewer, IDocument document, VlogCodeTokenProcessor.Token token, ICharacterPairMatcher pairMatcher, int linesLookback, AutoEditProgressMonitor monitor) {
        if (token == null) {
            return false;
        }
        int tokenStartOffset = token.getStartOffset();
        boolean isPrecededByWhitespaces = TextUtils.isPrecededByWhitespaces((IDocument)document, (int)tokenStartOffset);
        int beginPref = this.getBeginIndentationPref(sourceViewer, document, tokenStartOffset);
        switch (beginPref) {
            case 2: 
            case 4: {
                if (isPrecededByWhitespaces) break;
                return true;
            }
            case 3: {
                int prevLineNo = this.getPreviousLineForIndent(document, this.getLineOfOffset(document, tokenStartOffset));
                if (!isPrecededByWhitespaces || !this.appendBeginToValidLine(document, prevLineNo, pairMatcher, linesLookback, monitor)) break;
                return true;
            }
        }
        return false;
    }

    public boolean appendBeginToValidLine(IDocument document, int lineNo, ICharacterPairMatcher pairMatcher, int linesLookback, AutoEditProgressMonitor monitor) {
        VlogCodeTokenProcessor.Token token;
        int lineOffset = this.getLineOffset(document, lineNo);
        if (lineOffset == -1) {
            return false;
        }
        int lineLength = this.getLineLength(document, lineNo);
        if (lineLength == -1) {
            return false;
        }
        DocumentLineAccessor acc = new DocumentLineAccessor(document, lineOffset + lineLength, linesLookback);
        while ((token = acc.nextToken()) != null) {
            if (monitor.isCanceled()) {
                DVTLogger.INSTANCE.logError("Auto-indent timed out while validating the line to append keyword to!");
                return false;
            }
            if (this.isClosedBracket(token)) {
                IRegion region = pairMatcher.match(document, token.getStartOffset());
                if (region == null) continue;
                acc.consumeRegion(document, region.getOffset());
                continue;
            }
            if (this.isSemicolon(token)) {
                return false;
            }
            if (this.isBeginKeyword(token)) {
                return false;
            }
            if (this.isPreproc(token)) {
                return false;
            }
            if (this.isOpenKeywordWithoutSemi(token)) {
                return !"fork".equals(token.getValue());
            }
            if (this.isColon(token)) {
                return true;
            }
            if (!this.isOneLineIndentKeyword(token)) continue;
            return true;
        }
        return false;
    }

    public boolean isElseKeyword(VlogCodeTokenProcessor.Token token) {
        return token != null && "else".equals(token.getValue());
    }

    public int getElseIndentationPref(ISourceViewer sourceViewer, IDocument document, int offset) {
        CFPreferences formatPreferences = this.getFormatPreferences(sourceViewer, document, offset);
        if (formatPreferences == null) {
            return -1;
        }
        return formatPreferences.getIntegerProperty("format.indent.else");
    }

    public boolean shouldMoveElseKeyword(ISourceViewer sourceViewer, IDocument document, VlogCodeTokenProcessor.Token token, ICharacterPairMatcher pairMatcher, int linesLookback, AutoEditProgressMonitor monitor) {
        if (token == null) {
            return false;
        }
        int tokenStartOffset = token.getStartOffset();
        boolean isPrecededByWhitespaces = TextUtils.isPrecededByWhitespaces((IDocument)document, (int)tokenStartOffset);
        int elsePref = this.getElseIndentationPref(sourceViewer, document, tokenStartOffset);
        switch (elsePref) {
            case 2: {
                if (isPrecededByWhitespaces) break;
                return true;
            }
            case 3: {
                int prevLineNo = this.getPreviousLineForIndent(document, this.getLineOfOffset(document, tokenStartOffset));
                if (!isPrecededByWhitespaces || !this.appendElseToValidLine(document, prevLineNo, pairMatcher, linesLookback, monitor)) break;
                return true;
            }
        }
        return false;
    }

    public boolean appendElseToValidLine(IDocument document, int lineNo, ICharacterPairMatcher pairMatcher, int linesLookback, AutoEditProgressMonitor monitor) {
        VlogCodeTokenProcessor.Token token;
        if (this.lineEndsWithComment(document, lineNo)) {
            return false;
        }
        int lineOffset = this.getLineOffset(document, lineNo);
        if (lineOffset == -1) {
            return false;
        }
        int lineLength = this.getLineLength(document, lineNo);
        if (lineLength == -1) {
            return false;
        }
        DocumentLineAccessor acc = new DocumentLineAccessor(document, lineOffset + lineLength, linesLookback);
        while ((token = acc.nextToken()) != null) {
            if (monitor.isCanceled()) {
                DVTLogger.INSTANCE.logError("Auto-indent timed out while validating the line to append keyword to!");
                return false;
            }
            if (this.isClosedBracket(token)) {
                IRegion region = pairMatcher.match(document, token.getStartOffset());
                if (region == null) continue;
                acc.consumeRegion(document, region.getOffset());
                continue;
            }
            return this.isEndKeyword(token);
        }
        return false;
    }

    public boolean isEndKeyword(VlogCodeTokenProcessor.Token token) {
        return token != null && "end".equals(token.getValue());
    }

    public boolean shouldAddNewLineForEndKeyword(ISourceViewer sourceViewer, IDocument document, VlogCodeTokenProcessor.Token token, int commandOffset) {
        boolean isAddNLAfterEnd = this.isAddNewLineAfterEnd(sourceViewer, document, token);
        boolean isAddNLAfterBeginAndBeforeEnd = this.isAddNewLineAfterBeginAndBeforeEnd(sourceViewer, document, token);
        if (!isAddNLAfterEnd && !isAddNLAfterBeginAndBeforeEnd) {
            return false;
        }
        boolean isFollowedByNL = this.isFollowedByNL(document, commandOffset);
        boolean isPrecededByWhitespaces = TextUtils.isPrecededByWhitespaces((IDocument)document, (int)token.getStartOffset());
        return !isPrecededByWhitespaces || !isFollowedByNL;
    }

    public String getAdditionalTextForFormatting(DocumentCommand command, VlogCodeTokenProcessor.Token token) {
        if (command == null || token == null) {
            return "";
        }
        String tokenValue = token.getValue();
        int tokenOffset = token.getStartOffset();
        if (command.offset >= tokenOffset && command.offset <= tokenOffset + tokenValue.length()) {
            return command.text.trim().isEmpty() ? "" : command.text;
        }
        return "";
    }

    public int getEndOffsetForFormatting(DocumentCommand command, VlogCodeTokenProcessor.Token token) {
        if (command == null || token == null) {
            return -1;
        }
        String tokenValue = token.getValue();
        int tokenOffset = token.getStartOffset();
        if (command.offset >= tokenOffset && command.offset <= tokenOffset + tokenValue.length()) {
            return command.offset;
        }
        return tokenOffset + tokenValue.length();
    }

    public String getLineDelimiter(ISourceViewer sourceViewer) {
        if (!(sourceViewer instanceof DVTProjectionViewer)) {
            return "";
        }
        DVTEditor editor = ((DVTProjectionViewer)sourceViewer).getEditor();
        if (editor == null) {
            return "";
        }
        SourceViewerConfiguration svc = editor.getSourceViewerConfigurationForEditor();
        if (!(svc instanceof DVTSourceViewerConfiguration)) {
            return "";
        }
        return ((DVTSourceViewerConfiguration)svc).getLineDelimiter();
    }

    public boolean isValidBlock(VlogCodeTokenProcessor.Token openToken, VlogCodeTokenProcessor.Token closeToken) {
        if (openToken == null || closeToken == null) {
            return false;
        }
        String openKeyword = openToken.getValue();
        String closeKeyword = closeToken.getValue();
        for (Map.Entry block : BLOCKS.entrySet()) {
            String[] openKeywords = (String[])block.getValue();
            if (openKeywords.length == 0) continue;
            String[] stringArray = openKeywords;
            int n = openKeywords.length;
            int n2 = 0;
            while (n2 < n) {
                String endKeyword;
                String keyword = stringArray[n2];
                if (keyword.equals(openKeyword) && (endKeyword = (String)block.getKey()).equals(closeKeyword)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean lineEndsWithSemicolon(IDocument document, int lineNo) {
        int lineLength;
        int lineOffset = this.getLineOffset(document, lineNo);
        String strLine = this.getDocumentSubstring(document, lineOffset, lineLength = this.getLineLength(document, lineNo));
        if (strLine == null) {
            return false;
        }
        Deque<VlogCodeTokenProcessor.Token> delimiters = VlogCodeTokenProcessor.getTokensFromString(document, lineOffset, strLine);
        if (delimiters == null) {
            return false;
        }
        Iterator<VlogCodeTokenProcessor.Token> it = delimiters.descendingIterator();
        VlogCodeTokenProcessor.Token token = null;
        while (it.hasNext()) {
            token = it.next();
            if (token.getType() == 3) continue;
            return ";".equals(token.getValue());
        }
        return false;
    }

    public boolean lineEndsWithComment(IDocument document, int lineNo) {
        int lineLength;
        int lineOffset;
        block6: {
            block5: {
                lineOffset = VlogAutoEditUtils.getInstance().getLineOffset(document, lineNo);
                if (lineOffset != -1) break block5;
                return false;
            }
            lineLength = VlogAutoEditUtils.getInstance().getLineLength(document, lineNo);
            if (lineLength != -1) break block6;
            return false;
        }
        try {
            String lineContent = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, lineOffset, lineLength);
            lineContent = DVTStringUtil.replaceFirst((Pattern)DVTStringUtil.TRAILING_WS, (CharSequence)lineContent, (String)"");
            String partitioning = DVTFileUtils.getInstance().getPartitioning((IDocumentExtension3)document);
            String contentType = ((IDocumentExtension3)document).getContentType(partitioning, lineOffset + lineContent.length() - 1, false);
            if (contentType.equals("__vlog_ml_comment") || contentType.equals("__vlog_sl_comment")) {
                return true;
            }
        }
        catch (BadLocationException | BadPartitioningException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        return false;
    }

    public boolean isPrecededByRandomQulifier(DocumentLineAccessor acc) {
        VlogCodeTokenProcessor.Token prevNWSToken = this.getPrevNWSToken(acc);
        return this.isRandomQulifier(prevNWSToken);
    }

    public boolean isPrecededByOneLineIndentKeyword(DocumentLineAccessor acc) {
        VlogCodeTokenProcessor.Token prevNWSToken = this.getPrevNWSToken(acc);
        return this.isOneLineIndentKeyword(prevNWSToken);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isFollowedByNL(IDocument document, int offset) {
        if (document == null || offset < 0 || offset > document.getLength()) {
            return false;
        }
        try {
            int line = document.getLineOfOffset(offset);
            int start = document.getLineOffset(line);
            int end = Math.max(start + document.getLineLength(line), offset);
            int i = offset;
            while (true) {
                if (i >= end) {
                    return false;
                }
                char c = document.getChar(i);
                if (c == '\n' || c == '\r') {
                    return true;
                }
                if (!Character.isWhitespace(c)) {
                    return false;
                }
                ++i;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public boolean checkCommandText(IDocument document, DocumentCommand command, VlogCodeTokenProcessor.Token firstToken) {
        boolean checkCommandChar;
        if (this.endsWithNewLine(document, command.text)) {
            return true;
        }
        char commandChar = command.text.charAt(0);
        boolean bl = checkCommandChar = Character.isWhitespace(commandChar) || !Character.isJavaIdentifierPart(commandChar);
        if (!checkCommandChar) {
            return false;
        }
        if (firstToken == null) {
            return false;
        }
        int firstTokenOffset = firstToken.getStartOffset();
        String fromFirstTokenToCursor = this.getDocumentSubstring(document, firstTokenOffset, command.offset - firstTokenOffset);
        if (fromFirstTokenToCursor == null) {
            return false;
        }
        return fromFirstTokenToCursor.trim().equals(firstToken.getValue());
    }

    public boolean onlyOneTokenInLine(VlogCodeTokenProcessor.Token firstToken, VlogCodeTokenProcessor.Token tokenAtCursor) {
        if (firstToken == null || tokenAtCursor == null) {
            return false;
        }
        return firstToken.getStartOffset() == tokenAtCursor.getStartOffset() && firstToken.getValue().equals(tokenAtCursor.getValue());
    }
}

