/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import java.util.regex.Pattern;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditAdvancedUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeTokenProcessor;

public enum VlogCodeAutoEditCommandBuilder {
    INSTANCE;


    public boolean moveKeyword(IDocument document, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, String indent, ISourceViewer sourceViewer) {
        if (VlogCodeAutoEditAdvancedUtils.getInstance().isBeginKeyword(delimiter)) {
            return this.moveBeginKeyword(document, delimiter, command, buffer, indent, sourceViewer);
        }
        if (VlogCodeAutoEditAdvancedUtils.getInstance().isElseKeyword(delimiter)) {
            return this.moveElseKeyword(document, delimiter, command, buffer, indent, sourceViewer);
        }
        return false;
    }

    private boolean moveBeginKeyword(IDocument document, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, String indent, ISourceViewer sourceViewer) {
        DocumentCommandWrapper documentCommand = null;
        int beginPref = VlogCodeAutoEditAdvancedUtils.getInstance().getBeginIndentationPref(sourceViewer, document, delimiter.getStartOffset());
        switch (beginPref) {
            case 2: 
            case 4: {
                documentCommand = this.moveKeywordOnNewLine(document, buffer, delimiter, command, indent, sourceViewer);
                break;
            }
            case 3: {
                documentCommand = this.moveKeywordOnSameLine(document, delimiter, command, buffer, sourceViewer);
                break;
            }
        }
        if (documentCommand == null) {
            return false;
        }
        if (!this.noCodeLoss(document, command, buffer, sourceViewer, documentCommand.getOffset())) {
            return false;
        }
        command.offset = documentCommand.getOffset();
        command.length = documentCommand.getLength();
        command.text = documentCommand.getText();
        return true;
    }

    private boolean moveElseKeyword(IDocument document, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, String indent, ISourceViewer sourceViewer) {
        DocumentCommandWrapper documentCommand = null;
        int elsePref = VlogCodeAutoEditAdvancedUtils.getInstance().getElseIndentationPref(sourceViewer, document, delimiter.getStartOffset());
        switch (elsePref) {
            case 2: {
                documentCommand = this.moveKeywordOnNewLine(document, buffer, delimiter, command, indent, sourceViewer);
                break;
            }
            case 3: {
                documentCommand = this.moveKeywordOnSameLine(document, delimiter, command, buffer, sourceViewer);
                break;
            }
        }
        if (documentCommand == null) {
            return false;
        }
        if (!this.noCodeLoss(document, command, buffer, sourceViewer, documentCommand.getOffset())) {
            return false;
        }
        command.offset = documentCommand.getOffset();
        command.length = documentCommand.getLength();
        command.text = documentCommand.getText();
        return true;
    }

    private DocumentCommandWrapper moveKeywordOnNewLine(IDocument document, StringBuilder buffer, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, String indent, ISourceViewer sourceViewer) {
        String lineDelimiter = VlogCodeAutoEditAdvancedUtils.getInstance().getLineDelimiter(sourceViewer);
        buffer.append(lineDelimiter);
        buffer.append(indent);
        buffer.append(delimiter);
        if (VlogCodeAutoEditAdvancedUtils.getInstance().isAddNewLineAfterBeginAndBeforeEnd(sourceViewer, document, delimiter)) {
            buffer.append(lineDelimiter);
        } else {
            buffer.append(command.text);
        }
        int lineOffset = VlogAutoEditUtils.getInstance().getLineOffsetOfOffset(document, command.offset);
        if (lineOffset == -1) {
            return null;
        }
        return new DocumentCommandWrapper(lineOffset, command.offset - lineOffset, buffer.toString());
    }

    private DocumentCommandWrapper moveKeywordOnSameLine(IDocument document, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, ISourceViewer sourceViewer) {
        int currLineNo = VlogCodeAutoEditAdvancedUtils.getInstance().getLineOfOffset(document, command.offset);
        int prevLineNo = VlogCodeAutoEditAdvancedUtils.getInstance().getPreviousLineForIndent(document, currLineNo);
        if (VlogCodeAutoEditAdvancedUtils.getInstance().lineEndsWithComment(document, prevLineNo)) {
            return this.moveKeywordOnSameLineEndingWithComment(document, delimiter, command, buffer, prevLineNo);
        }
        return this.moveKeywordOnSameLineNotEndingWithComment(document, delimiter, command, buffer, prevLineNo, sourceViewer);
    }

    private DocumentCommandWrapper moveKeywordOnSameLineEndingWithComment(IDocument document, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, int prevLineNumber) {
        VlogCodeTokenProcessor.Token lastCodeTokenFromPrevLine = VlogCodeAutoEditAdvancedUtils.getInstance().getLastCodeTokenFromPrevLine(document, prevLineNumber);
        if (lastCodeTokenFromPrevLine == null) {
            return null;
        }
        int prevLineOffset = VlogAutoEditUtils.getInstance().getLineOffset(document, prevLineNumber);
        if (prevLineOffset == -1) {
            return null;
        }
        int lastCodeTokenStartOffset = lastCodeTokenFromPrevLine.getStartOffset();
        String lastCodeTokenFromPrevLineValue = lastCodeTokenFromPrevLine.getValue();
        int lastCodeTokenEndOffset = lastCodeTokenStartOffset + lastCodeTokenFromPrevLineValue.length();
        String prevLineContentUntilComment = document.get().substring(prevLineOffset, lastCodeTokenEndOffset);
        buffer.append(String.valueOf(prevLineContentUntilComment) + " ");
        buffer.append(delimiter);
        int currLineOffset = VlogAutoEditUtils.getInstance().getLineOffsetOfOffset(document, command.offset);
        if (currLineOffset == -1) {
            return null;
        }
        String prevLineComment = document.get().substring(lastCodeTokenEndOffset, currLineOffset);
        int nofLeadingWS = DVTStringUtil.countLeadingWhitespaces((String)prevLineComment);
        prevLineComment = prevLineComment.substring(nofLeadingWS - 1);
        buffer.append(prevLineComment);
        return new DocumentCommandWrapper(prevLineOffset, command.offset - prevLineOffset, buffer.toString());
    }

    private DocumentCommandWrapper moveKeywordOnSameLineNotEndingWithComment(IDocument document, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, int prevLineNumber, ISourceViewer sourceViewer) {
        int prevLineOffset = VlogAutoEditUtils.getInstance().getLineOffset(document, prevLineNumber);
        if (prevLineOffset == -1) {
            return null;
        }
        int prevLineLength = VlogAutoEditUtils.getInstance().getLineLength(document, prevLineNumber);
        if (prevLineLength == -1) {
            return null;
        }
        String prevLineContent = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, prevLineOffset, prevLineLength);
        if (prevLineContent == null) {
            return null;
        }
        prevLineContent = DVTStringUtil.replaceFirst((Pattern)DVTStringUtil.TRAILING_WS, (CharSequence)prevLineContent, (String)" ");
        buffer.append(prevLineContent);
        buffer.append(delimiter);
        if (VlogCodeAutoEditAdvancedUtils.getInstance().isAddNewLineAfterBeginAndBeforeEnd(sourceViewer, document, delimiter)) {
            buffer.append(VlogCodeAutoEditAdvancedUtils.getInstance().getLineDelimiter(sourceViewer));
        } else {
            buffer.append(command.text);
        }
        int currentLine = VlogAutoEditUtils.getInstance().getLineOfOffset(document, command.offset);
        if (currentLine == -1) {
            return null;
        }
        if (currentLine - prevLineNumber > 1) {
            int currentLineOffset = VlogAutoEditUtils.getInstance().getLineOffset(document, currentLine);
            if (currentLineOffset == -1) {
                return null;
            }
            int nextLineOffset = VlogAutoEditUtils.getInstance().getLineOffset(document, prevLineNumber + 1);
            if (nextLineOffset == -1) {
                return null;
            }
            String linesBetween = document.get().substring(nextLineOffset, currentLineOffset);
            buffer.append(linesBetween);
        }
        return new DocumentCommandWrapper(prevLineOffset, command.offset - prevLineOffset, buffer.toString());
    }

    public boolean addNewLine(IDocument document, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, String indent, ISourceViewer sourceViewer) {
        if (VlogCodeAutoEditAdvancedUtils.getInstance().isBeginKeyword(delimiter)) {
            return this.addNewLineBegin(document, delimiter, command, buffer, indent, sourceViewer);
        }
        if (VlogCodeAutoEditAdvancedUtils.getInstance().isEndKeyword(delimiter)) {
            return this.addNewLineEnd(document, delimiter, command, buffer, indent, sourceViewer);
        }
        return false;
    }

    private boolean addNewLineBegin(IDocument document, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, String indent, ISourceViewer sourceViewer) {
        DocumentCommandWrapper documentCommand = this.addNewLineAfterBegin(document, delimiter, command, buffer, indent, sourceViewer);
        if (documentCommand == null) {
            return false;
        }
        if (!this.noCodeLoss(document, command, buffer, sourceViewer, documentCommand.getOffset())) {
            return false;
        }
        command.offset = documentCommand.getOffset();
        command.length = documentCommand.getLength();
        command.text = documentCommand.getText();
        return true;
    }

    private DocumentCommandWrapper addNewLineAfterBegin(IDocument document, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, String indent, ISourceViewer sourceViewer) {
        if (TextUtils.isPrecededByWhitespaces((IDocument)document, (int)delimiter.getStartOffset())) {
            buffer.append(indent);
        }
        buffer.append(delimiter.getValue());
        buffer.append(VlogCodeAutoEditAdvancedUtils.getInstance().getLineDelimiter(sourceViewer));
        int lineOffset = VlogAutoEditUtils.getInstance().getLineOffsetOfOffset(document, command.offset);
        if (lineOffset == -1) {
            return null;
        }
        return new DocumentCommandWrapper(lineOffset, command.offset - lineOffset, buffer.toString());
    }

    private boolean addNewLineEnd(IDocument document, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, String indent, ISourceViewer sourceViewer) {
        DocumentCommandWrapper documentCommand = this.addNewLineBeforeAndAfterEnd(document, indent, delimiter, command, buffer, sourceViewer);
        if (documentCommand == null) {
            return false;
        }
        if (!this.noCodeLoss(document, command, buffer, sourceViewer, documentCommand.getOffset())) {
            return false;
        }
        command.offset = documentCommand.getOffset();
        command.length = documentCommand.getLength();
        command.text = documentCommand.getText();
        return true;
    }

    private DocumentCommandWrapper addNewLineBeforeAndAfterEnd(IDocument document, String indent, VlogCodeTokenProcessor.Token delimiter, DocumentCommand command, StringBuilder buffer, ISourceViewer sourceViewer) {
        boolean precededByWhitespaces = TextUtils.isPrecededByWhitespaces((IDocument)document, (int)delimiter.getStartOffset());
        boolean isAddNLAfterEnd = VlogCodeAutoEditAdvancedUtils.getInstance().isAddNewLineAfterEnd(sourceViewer, document, delimiter);
        boolean isAddNLAfterBeginAndBeforeEnd = VlogCodeAutoEditAdvancedUtils.getInstance().isAddNewLineAfterBeginAndBeforeEnd(sourceViewer, document, delimiter);
        String lineDelimiter = VlogCodeAutoEditAdvancedUtils.getInstance().getLineDelimiter(sourceViewer);
        if (isAddNLAfterBeginAndBeforeEnd && !precededByWhitespaces) {
            buffer.append(lineDelimiter);
        }
        if (precededByWhitespaces || isAddNLAfterBeginAndBeforeEnd && !precededByWhitespaces) {
            buffer.append(indent);
        }
        buffer.append(delimiter.getValue());
        buffer.append(isAddNLAfterEnd ? lineDelimiter : command.text);
        int lineOffset = VlogAutoEditUtils.getInstance().getLineOffsetOfOffset(document, command.offset);
        if (lineOffset == -1) {
            return null;
        }
        return new DocumentCommandWrapper(lineOffset, command.offset - lineOffset, buffer.toString());
    }

    private boolean noCodeLoss(IDocument document, DocumentCommand command, StringBuilder buffer, ISourceViewer sourceViewer, int startOffset) {
        String actualContent;
        String actualTransf;
        if (!(sourceViewer instanceof DVTProjectionViewer)) {
            return false;
        }
        DVTEditor editor = ((DVTProjectionViewer)sourceViewer).getEditor();
        if (editor == null) {
            return false;
        }
        SourceViewerConfiguration svc = editor.getSourceViewerConfigurationForEditor();
        if (!(svc instanceof DVTSourceViewerConfiguration)) {
            return false;
        }
        DVTSourceViewerConfiguration dvtSVC = (DVTSourceViewerConfiguration)svc;
        DVTContentFormatter formatter = (DVTContentFormatter)dvtSVC.getContentFormatter(null);
        if (formatter == null) {
            return false;
        }
        boolean isBeginSameLine = VlogCodeAutoEditAdvancedUtils.getInstance().getBeginIndentationPref(sourceViewer, document, command.offset) == 3;
        String originalContent = VlogAutoEditUtils.getInstance().getDocumentSubstring(document, startOffset, command.offset - startOffset);
        if (originalContent == null) {
            return false;
        }
        String originalTransf = DVTContentFormatter.transform((DVTContentFormatter.TRANSFORM_STATE)DVTContentFormatter.TRANSFORM_STATE.CODE, (String)originalContent, (boolean)true, (boolean)false, (boolean)true, (boolean)isBeginSameLine, (LanguageKind)LanguageKind.VLOG);
        return originalTransf.equals(actualTransf = DVTContentFormatter.transform((DVTContentFormatter.TRANSFORM_STATE)DVTContentFormatter.TRANSFORM_STATE.CODE, (String)(actualContent = buffer.toString()), (boolean)true, (boolean)false, (boolean)true, (boolean)isBeginSameLine, (LanguageKind)LanguageKind.VLOG));
    }

    public class DocumentCommandWrapper {
        private int offset;
        private int length;
        private String text;

        public DocumentCommandWrapper(int offset, int length, String text) {
            this.offset = offset;
            this.length = length;
            this.text = text;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getText() {
            return this.text;
        }
    }
}

