/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import java.util.Deque;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.edit.strategy.AutoEditProgressMonitor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.IndentBundle;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditOldEngineKeywordSets;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditOldEngineRefLineFinder;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoInsertBracketsStrategy;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditOldEngineUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditStrategy;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeTokenProcessor;

public class VlogCodeAutoEditOldEngineStrategy
extends VlogCodeAutoEditStrategy
implements VlogAutoEditOldEngineKeywordSets {
    private static final int NR_AUTOINSERT_CHARACTERS = 4;
    private int[] fLastInsertedOffsets = new int[4];
    private int[] fFirstInsertedOffsets = new int[4];
    private int[] fCountOpen = new int[4];

    public VlogCodeAutoEditOldEngineStrategy(ISourceViewer sourceViewer, VlogSourceViewerConfiguration configuration, ICharacterPairMatcher matcher) {
        this.fSourceViewer = sourceViewer;
        this.fConfiguration = configuration;
        this.fPairMatcher = matcher;
        this.resetInsertedOffsets();
        this.resetCountOpen();
        this.autoInsertBracketsStrategy = new VlogAutoInsertBracketsStrategy(configuration);
    }

    @Override
    protected void setLinesLookback() {
        VlogAutoEditOldEngineRefLineFinder.getInstance().setLinesLookback(VlogPlugin.getDefault().getPreferenceStore().getInt("autoindent.lines.lookback"));
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        this.autoInsertBracketsStrategy.transformText(document, command);
        DocumentCommand initialCommand = this.autoIndent(document, command, null);
        this.autoInsertBracketsStrategy.autoInsertAndEncloseBrackets(document, command, initialCommand);
    }

    @Override
    protected boolean autoIndentToken(IDocument document, DocumentCommand command, boolean entireLine, AutoEditProgressMonitor monitor) {
        int offset;
        block4: {
            try {
                offset = command.offset;
                if (offset >= 0 && offset <= document.getLength()) break block4;
                return false;
            }
            catch (BadLocationException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        boolean endsWithNewLine = VlogCodeAutoEditUtils.getInstance().endsWithNewLine(document, command.text);
        boolean followedByWhitespaces = TextUtils.isFollowedByWhitespaces((IDocument)document, (int)offset);
        VlogCodeTokenProcessor.Token endDelimiter = this.hasGoodEndDelimiter(document, command, false, false);
        if (endDelimiter != null && (followedByWhitespaces || endsWithNewLine)) {
            return this.smartIndentAfterToken(document, command, endDelimiter, monitor);
        }
        return false;
    }

    @Override
    protected void smartIndentAfterNewLine(IDocument document, DocumentCommand command, boolean commandModified, int offset, int length, AutoEditProgressMonitor monitor) throws BadLocationException {
        int line = document.getLineOfOffset(offset);
        StringBuilder buffer = new StringBuilder(command.text);
        buffer.append(this.computeIndentForNewLine(document, command, commandModified, offset, length, line, monitor));
        command.text = buffer.toString();
        IRegion lineInfo = document.getLineInformation(line);
        if (lineInfo == null) {
            return;
        }
        if (TextUtils.isPrecededByWhitespaces((IDocument)document, (int)offset) && !TextUtils.isFollowedByWhitespaces((IDocument)document, (int)offset)) {
            return;
        }
        command.length += Math.max(0, DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)offset, (int)(lineInfo.getOffset() + lineInfo.getLength())) - offset);
    }

    protected VlogCodeTokenProcessor.Token hasGoodEndDelimiter(IDocument document, DocumentCommand command, boolean entireLine, boolean rightToLeft) throws BadLocationException {
        int end;
        int line = document.getLineOfOffset(command.offset);
        int start = document.getLineOffset(line);
        String strLine = document.get(start, (end = entireLine ? start + document.getLineLength(line) : Math.min(start + document.getLineLength(line), command.offset)) - start);
        if (this.pseudoDelimiter(PSEUDO_CLOSED, strLine) == -1) {
            return null;
        }
        return this.getDelimiter(document, start, String.valueOf(strLine) + command.text, VlogCodeAutoEditStrategy.DelimiterType.END_DELIMITER, rightToLeft);
    }

    private int pseudoDelimiter(Set<String> delimiters, String buffer) {
        for (String delimiter : delimiters) {
            int index;
            if (delimiter.length() > buffer.length() || (index = buffer.indexOf(delimiter)) == -1) continue;
            return index;
        }
        return -1;
    }

    @Override
    protected VlogCodeTokenProcessor.Token getDelimiter(IDocument document, int startOffset, String strLine, VlogCodeAutoEditStrategy.DelimiterType type, boolean rightToLeft) {
        if (strLine == null) {
            return null;
        }
        Deque<VlogCodeTokenProcessor.Token> delimiters = VlogCodeTokenProcessor.getTokensFromString(document, startOffset, strLine);
        if (delimiters == null) {
            return null;
        }
        Iterator<VlogCodeTokenProcessor.Token> it = rightToLeft ? delimiters.descendingIterator() : delimiters.iterator();
        VlogCodeTokenProcessor.Token token = null;
        while (it.hasNext()) {
            token = it.next();
            if (token.getType() != 3) break;
        }
        if (token == null) {
            return null;
        }
        boolean isClosedBracket = VlogCodeAutoEditOldEngineUtils.getInstance().isClosedBracket(token);
        boolean isClosedKeyword = VlogCodeAutoEditOldEngineUtils.getInstance().isClosedKeyword(token, true);
        if (isClosedBracket || isClosedKeyword) {
            return token;
        }
        return null;
    }

    private void resetInsertedOffsets() {
        int i = 0;
        while (i < 4) {
            this.fLastInsertedOffsets[i] = -1;
            this.fFirstInsertedOffsets[i] = Integer.MAX_VALUE;
            ++i;
        }
    }

    private void resetCountOpen() {
        int i = 0;
        while (i < 4) {
            this.fCountOpen[i] = 0;
            ++i;
        }
    }

    @Override
    protected String computeIndentForToken(IDocument document, DocumentCommand command, VlogCodeTokenProcessor.Token delimiter, int line, AutoEditProgressMonitor monitor) {
        String indent = "";
        IndentBundle bundle = VlogAutoEditOldEngineRefLineFinder.getInstance().endDelimiterIndent(document, line, delimiter, this.fPairMatcher);
        if (bundle.shouldIndent()) {
            indent = TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.fTabSize);
        }
        int indLine = bundle.getLine();
        indent = indent.concat(DVTDocumentCommon.getIndentOfLine((IDocument)document, (int)indLine, (int)-1));
        if (this.fUseSpacesNotTabs) {
            indent = TextUtils.replaceTabsWithSpaces((String)indent, (int)this.fTabSize);
        }
        return indent;
    }

    @Override
    protected String computeIndentForNewLine(IDocument document, DocumentCommand command, boolean commandModified, int offset, int length, int line, AutoEditProgressMonitor monitor) throws BadLocationException {
        int indLine;
        String indent = "";
        IndentBundle bundle = VlogAutoEditOldEngineRefLineFinder.getInstance().newLineIndent(document, line, offset, this.fPairMatcher);
        if (bundle.shouldIndent()) {
            indent = TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.fTabSize);
        }
        indent = (indLine = bundle.getLine()) == line && commandModified ? indent.concat(TemplatesViewUtils.determineOffsetIndentExclusive((String)command.text)) : indent.concat(DVTDocumentCommon.getIndentOfLine((IDocument)document, (int)indLine, (int)offset));
        if (this.fUseSpacesNotTabs) {
            indent = TextUtils.replaceTabsWithSpaces((String)indent, (int)this.fTabSize);
        }
        return indent;
    }

    @Override
    protected String computeIndentForTab(IDocument document, DocumentCommand command, int line, AutoEditProgressMonitor monitor) {
        String indent = "";
        try {
            VlogCodeTokenProcessor.Token endDelimiter = this.hasGoodEndDelimiter(document, command, true, false);
            if (endDelimiter != null) {
                IndentBundle bundle = VlogAutoEditOldEngineRefLineFinder.getInstance().endDelimiterIndent(document, line, endDelimiter, this.fPairMatcher);
                if (bundle.shouldIndent()) {
                    indent = TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.fTabSize);
                }
                int indLine = bundle.getLine();
                indent = indent.concat(DVTDocumentCommon.getIndentOfLine((IDocument)document, (int)indLine, (int)-1));
                if (this.fUseSpacesNotTabs) {
                    indent = TextUtils.replaceTabsWithSpaces((String)indent, (int)this.fTabSize);
                }
            } else {
                int indLine = line;
                int prevLine = VlogCodeAutoEditOldEngineUtils.getInstance().getPreviousLineForIndent(document, line);
                if (prevLine != line) {
                    IRegion prevLineInfo = document.getLineInformation(prevLine);
                    int prevLineOffset = prevLineInfo.getOffset() + prevLineInfo.getLength();
                    IndentBundle bundle = VlogAutoEditOldEngineRefLineFinder.getInstance().newLineIndent(document, prevLine, prevLineOffset, this.fPairMatcher);
                    if (bundle.shouldIndent()) {
                        indent = TextUtils.getIndentTab((boolean)this.fUseSpacesNotTabs, (int)this.fTabSize);
                    }
                    indLine = bundle.getLine();
                }
                indent = indent.concat(DVTDocumentCommon.getIndentOfLine((IDocument)document, (int)indLine, (int)-1));
                if (this.fUseSpacesNotTabs) {
                    indent = TextUtils.replaceTabsWithSpaces((String)indent, (int)this.fTabSize);
                }
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return indent;
    }

    @Override
    protected boolean isValidCommandLength(DocumentCommand command) {
        return command.length == 0 && command.text != null;
    }

    @Override
    protected String getIndent(IDocument initDocument, IDocument docToFormat, DocumentCommand command) {
        try {
            int currLine = initDocument.getLineOfOffset(command.offset);
            return this.computeIndentForTab(initDocument, command, currLine, null);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    @Override
    protected DocumentCommand formatOnPaste(IDocument document, DocumentCommand command) {
        if (!this.isAutoEditOnPasteEnabled()) {
            return command;
        }
        String formattedText = this.computeFormattedText(document, command, null, null, TextUtils.isPrecededByWhitespaces((IDocument)document, (int)command.offset), this.isIndentOnPasteEnabled());
        if (formattedText == null) {
            return command;
        }
        command.length = this.computeNewCommandLength(document, command.text, command.offset, command.length);
        command.offset = this.computeNewCommandOffset(document, command, TextUtils.isPrecededByWhitespaces((IDocument)document, (int)command.offset));
        command.text = formattedText;
        return command;
    }

    protected static class FODCallLimitExceeded
    extends Throwable {
        private static final long serialVersionUID = 1L;

        protected FODCallLimitExceeded() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

