/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.edit.strategy.AutoEditProgressMonitor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoInsertBracketsStrategy;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeAutoEditUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeTokenProcessor;
import ro.amiq.vlogdt.ui.editor.formatter.VlogFormattingPreferences;

public abstract class VlogCodeAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    protected VlogAutoInsertBracketsStrategy autoInsertBracketsStrategy;
    protected int fTabSize = 4;
    protected boolean fUseSpacesNotTabs;
    protected VlogSourceViewerConfiguration fConfiguration;
    protected ISourceViewer fSourceViewer;
    protected ICharacterPairMatcher fPairMatcher;
    private static final String DUMMY_TOKEN_FOR_INDENT_ON_PASTE_START = Integer.toString("[DUMMY_TOKEN_FOR_INDENT_ON_PASTE_START]".hashCode());
    private static final String DUMMY_TOKEN_FOR_INDENT_ON_PASTE_END = Integer.toString("[DUMMY_TOKEN_FOR_INDENT_ON_PASTE_END]".hashCode());

    protected DocumentCommand autoIndent(IDocument document, DocumentCommand command, AutoEditProgressMonitor monitor) {
        if (document == null || command == null) {
            return null;
        }
        DVTDocumentCommon.RecoveryCommand rc = new DVTDocumentCommon.RecoveryCommand();
        rc.loadFrom(command);
        if (!this.isValidContext()) {
            return rc;
        }
        if (this.insideLinkedPosition(document, command)) {
            return rc;
        }
        this.setLinesLookback();
        if (command.text != null && command.text.length() > 1) {
            return this.formatOnPaste(document, command);
        }
        if (VlogCodeAutoEditUtils.getInstance().isAutoindentDisabled()) {
            super.customizeDocumentCommand(document, command);
            return rc;
        }
        if (!this.isValidCommandLength(command)) {
            return rc;
        }
        if (VlogCodeAutoEditUtils.getInstance().isLiteralPartition(document, command.offset) && command.offset > 0 && VlogCodeAutoEditUtils.getInstance().isLiteralPartition(document, command.offset - 1)) {
            return rc;
        }
        this.setIndentationValues();
        boolean insertTabChar = "\t".equals(command.text);
        boolean commandModified = false;
        long start = System.currentTimeMillis();
        try {
            int offset = command.offset;
            if (offset < 0 || offset > document.getLength()) {
                return rc;
            }
            if (document.getLineInformation(document.getLineOfOffset(offset)).getLength() == 0 && !insertTabChar) {
                return rc;
            }
            int length = command.length;
            commandModified = this.autoIndentToken(document, command, false, monitor);
            if (VlogCodeAutoEditUtils.getInstance().endsWithNewLine(document, command.text)) {
                this.smartIndentAfterNewLine(document, command, commandModified, offset, length, monitor);
            } else if (insertTabChar && !commandModified) {
                boolean precededByWhitespaces = TextUtils.isPrecededByWhitespaces((IDocument)document, (int)offset);
                char ch = TextUtils.getChar((IDocument)document, (int)offset);
                if (precededByWhitespaces && (Character.isWhitespace(ch) || ch == '\uffff')) {
                    this.smartIndentAfterTab(document, command, monitor);
                }
            }
            TestHelper.getInstance().fAutoIndentTime = (double)System.currentTimeMillis() - (double)start;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            rc.saveIn(command);
        }
        return rc;
    }

    private boolean isValidContext() {
        return this.fSourceViewer instanceof DVTProjectionViewer && this.fPairMatcher != null;
    }

    private boolean insideLinkedPosition(IDocument document, DocumentCommand command) {
        LinkedModeModel model = LinkedModeModel.getModel((IDocument)document, (int)command.offset);
        return model != null && model.anyPositionContains(command.offset);
    }

    protected void setIndentationValues() {
        this.fTabSize = this.fConfiguration.getTabWidth(this.fSourceViewer);
        this.fUseSpacesNotTabs = TextUtils.getEditorSpacesForTabs((IPreferenceStore)VlogPlugin.getDefault().getCombinedPreferenceStore());
    }

    protected boolean smartIndentAfterToken(IDocument document, DocumentCommand command, VlogCodeTokenProcessor.Token delimiter, AutoEditProgressMonitor monitor) {
        try {
            int line = document.getLineOfOffset(command.offset);
            int start = document.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(document, start, command.offset);
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.computeIndentForToken(document, command, delimiter, line, monitor));
            String rest = document.get(whiteend, command.offset - whiteend);
            if (this.fUseSpacesNotTabs) {
                rest = TextUtils.replaceTabsWithSpaces((String)rest, (int)this.fTabSize);
            }
            buffer.append(rest);
            buffer.append(command.text);
            command.length = command.offset - start;
            command.offset = start;
            command.text = buffer.toString();
            return true;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError("AutoIndent.error.bad_location_1", (Throwable)e);
            return false;
        }
    }

    protected void smartIndentAfterNewLine(IDocument document, DocumentCommand command, boolean commandModified, int offset, AutoEditProgressMonitor monitor) throws BadLocationException {
        int line = document.getLineOfOffset(offset);
        StringBuilder buffer = new StringBuilder(command.text);
        buffer.append(this.computeIndentForNewLine(document, command, commandModified, offset, command.length, line, monitor));
        command.text = buffer.toString();
        IRegion lineInfo = document.getLineInformation(line);
        if (lineInfo == null) {
            return;
        }
        if (TextUtils.isPrecededByWhitespaces((IDocument)document, (int)offset) && !TextUtils.isFollowedByWhitespaces((IDocument)document, (int)offset)) {
            return;
        }
        command.length += Math.max(0, DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)offset, (int)(lineInfo.getOffset() + lineInfo.getLength())) - offset);
    }

    private void smartIndentAfterTab(IDocument document, DocumentCommand command, AutoEditProgressMonitor monitor) {
        try {
            int line = document.getLineOfOffset(command.offset);
            int start = document.getLineOffset(line);
            int whiteend = this.findEndOfWhiteSpace(document, command.offset, start + document.getLineLength(line));
            StringBuilder buffer = new StringBuilder();
            String indent = this.computeIndentForTab(document, command, line, monitor);
            buffer.append(indent);
            if (TextUtils.emptyTabLineIndent((IDocument)document, (int)command.offset, (String)indent, (String)document.get(start, Math.max(command.offset - start, 0)), (int)this.fTabSize)) {
                return;
            }
            command.text = buffer.toString();
            command.length = whiteend - start;
            command.offset = start;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError("AutoIndent.error.bad_location_3", (Throwable)e);
        }
    }

    protected IDocument createDocumentToFormat(DocumentCommand command, String textBeforeDummyStart, String textAfterDummyEnd, boolean cursorPrecededByWS, boolean textStartsWithNL, boolean textEndsWithNL) {
        IDocument docToFormat = Utils.createDocument((DVTSourceViewerConfiguration)this.fConfiguration, (String)(String.valueOf(textBeforeDummyStart == null ? "" : textBeforeDummyStart) + DUMMY_TOKEN_FOR_INDENT_ON_PASTE_START + (cursorPrecededByWS ? System.lineSeparator() : (!textStartsWithNL ? " " : "")) + command.text + (!textEndsWithNL ? " " : "") + DUMMY_TOKEN_FOR_INDENT_ON_PASTE_END + (textAfterDummyEnd == null ? "" : textAfterDummyEnd)));
        return docToFormat;
    }

    protected String computeFormattedText(IDocument document, DocumentCommand command, String textBeforeDummyStart, String textAfterDummyEnd, boolean cursorPrecededByWS, boolean onlyIndent) {
        int indentOnPasteEndPos;
        int pastedCodeStartPos;
        String formattedDocumentContent;
        IDocument docToFormat;
        boolean textEndsWithNL;
        block15: {
            int indentOnPasteStartPos;
            boolean textStartsWithNL;
            block14: {
                String indent;
                DVTContentFormatter formatter;
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                try {
                                    if (command != null) break block10;
                                    return null;
                                }
                                catch (BadLocationException e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                    return null;
                                }
                            }
                            formatter = (DVTContentFormatter)this.fConfiguration.getContentFormatter(null);
                            if (formatter != null) break block11;
                            return null;
                        }
                        formatter.setContentFormatterMaxLines(0);
                        formatter.setDoNotShowFormatFailedPopup(true);
                        textStartsWithNL = VlogCodeAutoEditUtils.getInstance().startsWithNewLine(document, command.text);
                        textEndsWithNL = VlogCodeAutoEditUtils.getInstance().endsWithNewLine(document, command.text);
                        docToFormat = this.createDocumentToFormat(command, textBeforeDummyStart, textAfterDummyEnd, cursorPrecededByWS, textStartsWithNL, textEndsWithNL);
                        if (docToFormat != null) break block12;
                        return null;
                    }
                    indent = this.getIndent(document, docToFormat, command);
                    if (indent != null) break block13;
                    return null;
                }
                String processedIndent = TextUtils.replaceTabsWithSpacesVisual((String)indent, (int)this.fConfiguration.getTabWidth());
                formatter.format(docToFormat, (IRegion)new Region(0, docToFormat.getLength()), processedIndent, false, this.fConfiguration.getLanguageKind(), onlyIndent);
                formattedDocumentContent = docToFormat.get();
                indentOnPasteStartPos = formattedDocumentContent.indexOf(DUMMY_TOKEN_FOR_INDENT_ON_PASTE_START);
                if (indentOnPasteStartPos != -1) break block14;
                return null;
            }
            int i = indentOnPasteStartPos + DUMMY_TOKEN_FOR_INDENT_ON_PASTE_START.length();
            pastedCodeStartPos = i + (cursorPrecededByWS ? 1 : (textStartsWithNL ? 0 : 1));
            indentOnPasteEndPos = formattedDocumentContent.indexOf(DUMMY_TOKEN_FOR_INDENT_ON_PASTE_END);
            if (indentOnPasteEndPos != -1) break block15;
            return null;
        }
        int pastedCodeEndPos = TextUtils.isPrecededByWhitespaces((IDocument)docToFormat, (int)indentOnPasteEndPos) ? indentOnPasteEndPos : indentOnPasteEndPos - 1;
        int dummyEndTokenLine = docToFormat.getLineOfOffset(indentOnPasteEndPos);
        if (docToFormat.getNumberOfLines() - 1 == dummyEndTokenLine + 1) {
            int dummyEndTokenLineOffset = docToFormat.getLineOffset(dummyEndTokenLine);
            return String.valueOf(formattedDocumentContent.substring(pastedCodeStartPos, dummyEndTokenLineOffset)) + DVTDocumentCommon.getIndentOfLine((IDocument)docToFormat, (int)(dummyEndTokenLine + 1), (int)-1);
        }
        if (textEndsWithNL && this.preserveCommentIndentation(document, command.offset, command.length)) {
            int dummyEndTokenLineOffset = docToFormat.getLineOffset(dummyEndTokenLine);
            return this.formattedTextPreserveCommentIndent(document, command, formattedDocumentContent, pastedCodeStartPos, dummyEndTokenLineOffset);
        }
        return formattedDocumentContent.substring(pastedCodeStartPos, pastedCodeEndPos);
    }

    private String formattedTextPreserveCommentIndent(IDocument document, DocumentCommand command, String formattedDocumentContent, int pastedCodeStartPos, int dummyEndTokenLineOffset) throws BadLocationException {
        int selectionEndOffset = command.length > 0 ? command.offset + command.length : command.offset;
        int selectionEndLine = document.getLineOfOffset(selectionEndOffset);
        int selectionEndLineOffset = document.getLineOffset(selectionEndLine);
        int selectionEndLineLength = document.getLineLength(selectionEndLine);
        int whiteend = this.findEndOfWhiteSpace(document, selectionEndOffset, selectionEndLineOffset + selectionEndLineLength);
        return String.valueOf(formattedDocumentContent.substring(pastedCodeStartPos, dummyEndTokenLineOffset)) + document.get(selectionEndOffset, whiteend - selectionEndOffset);
    }

    private boolean preserveSLCommentAtColumnZero(IDocument document, int offset, int lineOffset) {
        if (offset == lineOffset && VlogCodeAutoEditUtils.getInstance().isSLCommentPartition(document, lineOffset)) {
            return VlogFormattingPreferences.getInstance().isPreserveSLCommentAtColumnZeroEnabled();
        }
        return false;
    }

    private boolean preserveMLCommentIndentation(IDocument document, int offset, int lineEndOffset) throws BadLocationException {
        if (!TextUtils.isPrecededByWhitespaces((IDocument)document, (int)offset)) {
            return false;
        }
        int endOfWhiteSpace = this.findEndOfWhiteSpace(document, offset, lineEndOffset);
        if (VlogCodeAutoEditUtils.getInstance().isMLCommentPartition(document, endOfWhiteSpace)) {
            return !VlogFormattingPreferences.getInstance().isIndentMLCommentsEnabled();
        }
        return false;
    }

    protected boolean preserveCommentIndentation(IDocument document, int offset, int length) throws BadLocationException {
        int endOfSelectionLine;
        IRegion endOfSelectionEndLineInfo;
        int endOfSelectionOffset = length != 0 ? offset + length : offset;
        if (this.preserveSLCommentAtColumnZero(document, endOfSelectionOffset, (endOfSelectionEndLineInfo = document.getLineInformation(endOfSelectionLine = document.getLineOfOffset(endOfSelectionOffset))).getOffset())) {
            return true;
        }
        return this.preserveMLCommentIndentation(document, endOfSelectionOffset, endOfSelectionEndLineInfo.getOffset() + endOfSelectionEndLineInfo.getLength());
    }

    protected String getAutoformatOnPastePref() {
        IPreferenceStore store = DVTPlugin.getDefault().getPreferenceStore();
        if (store == null) {
            return null;
        }
        return store.getString("format.format_on_paste");
    }

    protected boolean isAutoEditOnPasteEnabled() {
        String autoformatOnPastePref = this.getAutoformatOnPastePref();
        if (autoformatOnPastePref == null || autoformatOnPastePref.isEmpty()) {
            return false;
        }
        return !"Disabled".equals(autoformatOnPastePref);
    }

    protected boolean isIndentOnPasteEnabled() {
        String autoformatOnPastePref = this.getAutoformatOnPastePref();
        if (autoformatOnPastePref == null || autoformatOnPastePref.isEmpty()) {
            return false;
        }
        return "Only indent".equals(autoformatOnPastePref);
    }

    protected boolean isFullFormatOnPasteEnabled() {
        String autoformatOnPastePref = this.getAutoformatOnPastePref();
        if (autoformatOnPastePref == null || autoformatOnPastePref.isEmpty()) {
            return false;
        }
        return "Full formatting".equals(autoformatOnPastePref);
    }

    protected int computeNewCommandLength(IDocument document, String text, int offset, int length) {
        boolean endOffsetPrecededByWS;
        boolean startOffsetPrecededByWS;
        int selectionStartLineOffset;
        block6: {
            block7: {
                int selectionStartLineLength;
                block8: {
                    try {
                        int selectionStartLine = document.getLineOfOffset(offset);
                        selectionStartLineOffset = document.getLineOffset(selectionStartLine);
                        selectionStartLineLength = document.getLineLength(selectionStartLine);
                        startOffsetPrecededByWS = TextUtils.isPrecededByWhitespaces((IDocument)document, (int)offset);
                        if (length != 0) break block6;
                        if (!startOffsetPrecededByWS) break block7;
                        if (offset != selectionStartLineOffset || VlogCodeAutoEditUtils.getInstance().endsWithNewLine(document, text)) break block8;
                        return 0;
                    }
                    catch (BadLocationException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return length;
                    }
                }
                int whiteend = this.findEndOfWhiteSpace(document, selectionStartLineOffset, selectionStartLineOffset + selectionStartLineLength);
                return whiteend - selectionStartLineOffset;
            }
            return 0;
        }
        int finalLength = length;
        int selectionEndLine = document.getLineOfOffset(offset + length);
        int selectionEndLineOffset = document.getLineOffset(selectionEndLine);
        int selectionEndLineLength = document.getLineLength(selectionEndLine);
        if (startOffsetPrecededByWS) {
            finalLength += offset - selectionStartLineOffset;
        }
        if (endOffsetPrecededByWS = TextUtils.isPrecededByWhitespaces((IDocument)document, (int)(offset + length))) {
            int whiteend = this.findEndOfWhiteSpace(document, selectionEndLineOffset, selectionEndLineOffset + selectionEndLineLength);
            finalLength += whiteend - (offset + length);
        }
        return finalLength;
    }

    protected int computeNewCommandOffset(IDocument document, DocumentCommand command, boolean cursorPrecededByWS) {
        int initOffset = command.offset;
        try {
            int line = document.getLineOfOffset(initOffset);
            if (line == -1) {
                return initOffset;
            }
            int start = document.getLineOffset(line);
            return cursorPrecededByWS ? start : initOffset;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return initOffset;
        }
    }

    protected abstract boolean isValidCommandLength(DocumentCommand var1);

    protected abstract boolean autoIndentToken(IDocument var1, DocumentCommand var2, boolean var3, AutoEditProgressMonitor var4);

    protected abstract String getIndent(IDocument var1, IDocument var2, DocumentCommand var3);

    protected abstract String computeIndentForToken(IDocument var1, DocumentCommand var2, VlogCodeTokenProcessor.Token var3, int var4, AutoEditProgressMonitor var5);

    protected abstract String computeIndentForNewLine(IDocument var1, DocumentCommand var2, boolean var3, int var4, int var5, int var6, AutoEditProgressMonitor var7) throws BadLocationException;

    protected abstract String computeIndentForTab(IDocument var1, DocumentCommand var2, int var3, AutoEditProgressMonitor var4);

    protected abstract void setLinesLookback();

    protected abstract void smartIndentAfterNewLine(IDocument var1, DocumentCommand var2, boolean var3, int var4, int var5, AutoEditProgressMonitor var6) throws BadLocationException;

    protected abstract VlogCodeTokenProcessor.Token getDelimiter(IDocument var1, int var2, String var3, DelimiterType var4, boolean var5);

    protected abstract DocumentCommand formatOnPaste(IDocument var1, DocumentCommand var2);

    protected static enum DelimiterType {
        OPEN_DELIMITER,
        END_DELIMITER;

    }
}

