/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.edit.strategy.DocumentLineAccessor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditBaseKeywordSets;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditUtils;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogCodeTokenProcessor;

public class VlogCodeAutoEditUtils
extends VlogAutoEditUtils
implements VlogAutoEditBaseKeywordSets {
    private static VlogCodeAutoEditUtils INSTANCE;
    private static final Object LOCK;

    static {
        LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogCodeAutoEditUtils getInstance() {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                INSTANCE = new VlogCodeAutoEditUtils();
            }
        }
        return INSTANCE;
    }

    public boolean isAutoindentDisabled() {
        String autoindentStrategy = VlogPlugin.getDefault().getPreferenceStore().getString("autoindent");
        return "Disable".equals(autoindentStrategy);
    }

    public boolean isOpenBracket(VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 4) {
            return false;
        }
        String value = token.getValue();
        String[] stringArray = OPEN_BRACKETS;
        int n = OPEN_BRACKETS.length;
        int n2 = 0;
        while (n2 < n) {
            String bracket = stringArray[n2];
            if (bracket.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isWordOrBracket(VlogCodeTokenProcessor.Token token) {
        return token.getType() == 2 || token.getType() == 4;
    }

    public boolean isException(DocumentLineAccessor acc, VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        VlogAutoEditBaseKeywordSets.IgnoreRule[] rules = (VlogAutoEditBaseKeywordSets.IgnoreRule[])IGNORED_MAPPINGS.get(token.getValue());
        if (rules == null) {
            return false;
        }
        acc.setMaxNrLines(VlogPlugin.getDefault().getPreferenceStore().getInt("autoindent.lines.lookback"));
        VlogAutoEditBaseKeywordSets.IgnoreRule[] ignoreRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            VlogCodeTokenProcessor.Token other;
            VlogAutoEditBaseKeywordSets.IgnoreRule rule = ignoreRuleArray[n2];
            DocumentLineAccessor clone = acc.clone();
            int nr_skips = 0;
            while ((other = clone.nextToken()) != null) {
                if (!this.isWordOrBracket(other) && other.getType() != 1) continue;
                if (rule.isStrictTo(other.getValue())) {
                    return true;
                }
                if (rule.isTolerantTo(other.getValue())) continue;
                if (!rule.canSkip(nr_skips)) break;
                ++nr_skips;
            }
            ++n2;
        }
        return false;
    }

    public boolean isClosedBracket(VlogCodeTokenProcessor.Token token) {
        if (token == null) {
            return false;
        }
        if (token.getType() != 4) {
            return false;
        }
        String value = token.getValue();
        String[] stringArray = CLOSED_BRACKETS;
        int n = CLOSED_BRACKETS.length;
        int n2 = 0;
        while (n2 < n) {
            String bracket = stringArray[n2];
            if (bracket.equals(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isCodePartition(IDocument d, int offset) throws BadLocationException, BadPartitioningException {
        if (d == null || offset < 0 || offset >= d.getLength()) {
            return false;
        }
        String currentContentType = ((IDocumentExtension3)d).getContentType("__vlog_partitioning", offset, false);
        return currentContentType.equals("__dftl_partition_content_type") || currentContentType.equals("__vlog_escaped_id");
    }

    public boolean isLiteralPartition(IDocument d, int offset) {
        String currentContentType;
        block3: {
            try {
                currentContentType = ((IDocumentExtension3)d).getContentType("__vlog_partitioning", offset, false);
                if (currentContentType != null) break block3;
                return false;
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
                return false;
            }
        }
        return currentContentType.equals("__vlog_literal");
    }

    public boolean isSLCommentPartition(IDocument d, int offset) {
        String currentContentType;
        block3: {
            try {
                currentContentType = ((IDocumentExtension3)d).getContentType("__vlog_partitioning", offset, false);
                if (currentContentType != null) break block3;
                return false;
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
                return false;
            }
        }
        return currentContentType.equals("__vlog_sl_comment");
    }

    public boolean isMLCommentPartition(IDocument d, int offset) {
        String currentContentType;
        block3: {
            try {
                currentContentType = ((IDocumentExtension3)d).getContentType("__vlog_partitioning", offset, false);
                if (currentContentType != null) break block3;
                return false;
            }
            catch (Exception ex) {
                DVTLogger.INSTANCE.logError((Throwable)ex);
                return false;
            }
        }
        return currentContentType.equals("__vlog_ml_comment");
    }

    public boolean startsWithNewLine(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (text.startsWith(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean endsWithNewLine(IDocument d, String txt) {
        String[] delimiters = d.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (txt.endsWith(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsNewLine(IDocument document, String text) {
        String[] delimiters = document.getLegalLineDelimiters();
        int i = 0;
        while (i < delimiters.length) {
            if (text.contains(delimiters[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int getPreviousLineForIndent(IDocument document, int currentLine) {
        int prevLine = currentLine;
        try {
            while (--prevLine >= 0) {
                int startPrev = document.getLineOffset(prevLine);
                int endIndentPrev = DVTDocumentCommon.findEndOfWhiteSpace((IDocument)document, (int)startPrev, (int)(startPrev + document.getLineLength(prevLine)));
                if (TextUtils.isFollowedByWhitespaces((IDocument)document, (int)startPrev) || !this.isCodePartition(document, endIndentPrev)) continue;
                break;
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return prevLine >= 0 ? prevLine : currentLine;
    }
}

