/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;

public class VlogCodeTokenProcessor {
    private State currentState;
    private final Deque<Token> tokens = new ArrayDeque<Token>();
    private static final Deque<Token> EMPTY_DEQUE = new ArrayDeque<Token>(0);

    public Deque<Token> getTokens() {
        this.addCurrentToken();
        return this.tokens;
    }

    private VlogCodeTokenProcessor(int startOffset) {
        this.currentState = new WhitespacesState(this, startOffset);
    }

    public void addCurrentToken() {
        Token token = this.currentState.getToken();
        if (token != null && !token.getValue().isEmpty()) {
            this.tokens.add(token);
        }
        this.currentState.clearToken();
    }

    public void setNextState(int type, int startOffset) {
        this.addCurrentToken();
        switch (type) {
            case 3: {
                this.setWordState(startOffset);
                break;
            }
            case 2: {
                this.setCharGroupState(startOffset);
                break;
            }
            case 4: {
                this.setBracketState(startOffset);
                break;
            }
            case 1: {
                this.setWhiteSpacesState(startOffset);
            }
        }
    }

    public void setWordState(int offset) {
        this.currentState = new WordState(this, offset);
    }

    public void setCharGroupState(int offset) {
        this.currentState = new CharGroupState(this, offset);
    }

    public void setBracketState(int offset) {
        this.currentState = new BracketState(this, offset);
    }

    public void setWhiteSpacesState(int offset) {
        this.currentState = new WhitespacesState(this, offset);
    }

    public void processChar(char c, int offset) {
        this.currentState.processChar(c, offset);
    }

    public void appendChar(char c) {
        this.currentState.appendChar(c);
    }

    protected boolean isWordPart(char c) {
        return Character.isJavaIdentifierPart(c) || c == '`';
    }

    protected boolean isBracket(char c) {
        return c == '{' || c == '}' || c == '(' || c == ')' || c == '[' || c == ']';
    }

    public static Deque<Token> getTokensFromString(IDocument document, int beginOffset, String line) {
        VlogCodeTokenProcessor processor;
        block9: {
            if (document == null || line == null || line.isEmpty()) {
                return EMPTY_DEQUE;
            }
            processor = new VlogCodeTokenProcessor(beginOffset);
            try {
                char[] chars = line.toCharArray();
                ITypedRegion region = null;
                int regionEndOffset = -1;
                String regionContent = null;
                int i = 0;
                while (i < chars.length) {
                    block11: {
                        int currentOffset;
                        block10: {
                            currentOffset = beginOffset + i;
                            if (region != null && currentOffset < regionEndOffset) break block10;
                            region = ((IDocumentExtension3)document).getPartition("__vlog_partitioning", currentOffset, false);
                            if (region == null) break block11;
                            regionEndOffset = region.getOffset() + region.getLength();
                            regionContent = region.getType();
                        }
                        if ("__dftl_partition_content_type".equals(regionContent)) {
                            processor.processChar(chars[i], currentOffset);
                        } else {
                            if ("__vlog_sl_comment".equals(regionContent)) break block9;
                            processor.processChar(' ', currentOffset);
                            i += Math.max(regionEndOffset - currentOffset - 1, 0);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                return EMPTY_DEQUE;
            }
        }
        return processor.getTokens();
    }

    private class BracketState
    extends State {
        public BracketState(VlogCodeTokenProcessor proc, int startOffset) {
            super(proc);
            this.token = new Token(4, startOffset);
        }

        @Override
        protected void processChar(char c, int offset) {
            if (Character.isWhitespace(c)) {
                this.processor.setNextState(1, offset);
                this.processor.appendChar(c);
            } else if (VlogCodeTokenProcessor.this.isWordPart(c)) {
                this.processor.setNextState(3, offset);
                this.processor.appendChar(c);
            } else if (VlogCodeTokenProcessor.this.isBracket(c)) {
                this.processor.setNextState(4, offset);
                this.processor.appendChar(c);
            } else {
                this.processor.setNextState(2, offset);
                this.processor.appendChar(c);
            }
        }
    }

    private class CharGroupState
    extends State {
        public CharGroupState(VlogCodeTokenProcessor proc, int startOffset) {
            super(proc);
            this.token = new Token(1, startOffset);
        }

        @Override
        protected void processChar(char c, int startOffset) {
            if (Character.isWhitespace(c)) {
                this.processor.setNextState(1, startOffset);
                this.processor.appendChar(c);
            } else if (VlogCodeTokenProcessor.this.isBracket(c)) {
                this.processor.setNextState(4, startOffset);
                this.processor.appendChar(c);
            } else if (VlogCodeTokenProcessor.this.isWordPart(c)) {
                this.processor.setNextState(3, startOffset);
                this.processor.appendChar(c);
            } else {
                this.appendChar(c);
            }
        }
    }

    private abstract class State {
        public static final int WS_STATE = 1;
        public static final int CHAR_GROUP_STATE = 2;
        public static final int WORD_STATE = 3;
        public static final int BRACKET_STATE = 4;
        protected Token token;
        protected final VlogCodeTokenProcessor processor;

        public State(VlogCodeTokenProcessor proc) {
            this.processor = proc;
        }

        public void clearToken() {
            this.token = null;
        }

        public Token getToken() {
            return this.token;
        }

        protected void appendChar(char c) {
            this.token.value.append(c);
        }

        protected abstract void processChar(char var1, int var2);
    }

    public static class Token {
        public static final int CHAR_GROUP_TOKEN = 1;
        public static final int WORD_TOKEN = 2;
        public static final int WS_TOKEN = 3;
        public static final int BRACKET_TOKEN = 4;
        private final StringBuilder value = new StringBuilder("");
        private final int startOffset;
        private final int type;

        public Token(int type, int offset) {
            this.type = type;
            this.startOffset = offset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public String getValue() {
            return this.value.toString();
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private class WhitespacesState
    extends State {
        public WhitespacesState(VlogCodeTokenProcessor proc, int startOffset) {
            super(proc);
            this.token = new Token(3, startOffset);
        }

        @Override
        protected void processChar(char c, int startOffset) {
            if (Character.isWhitespace(c)) {
                this.appendChar(c);
            } else if (VlogCodeTokenProcessor.this.isWordPart(c)) {
                this.processor.setNextState(3, startOffset);
                this.processor.appendChar(c);
            } else if (VlogCodeTokenProcessor.this.isBracket(c)) {
                this.processor.setNextState(4, startOffset);
                this.processor.appendChar(c);
            } else {
                this.processor.setNextState(2, startOffset);
                this.processor.appendChar(c);
            }
        }
    }

    private class WordState
    extends State {
        public WordState(VlogCodeTokenProcessor proc, int offset) {
            super(proc);
            this.token = new Token(2, offset);
        }

        @Override
        protected void processChar(char c, int offset) {
            if (Character.isWhitespace(c)) {
                this.processor.setNextState(1, offset);
                this.processor.appendChar(c);
            } else if (VlogCodeTokenProcessor.this.isWordPart(c)) {
                this.appendChar(c);
            } else if (VlogCodeTokenProcessor.this.isBracket(c)) {
                this.processor.setNextState(4, offset);
                this.processor.appendChar(c);
            } else {
                this.processor.setNextState(2, offset);
                this.processor.appendChar(c);
            }
        }
    }
}

