/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.templates.TemplateEditorUI;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.utils.VlogTemplateContextWithResolversFactory;

public class VlogCommentAutoEditStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final int MAX_CONSECUTIVE_LINES = 250;
    private VlogEditor fEditor;
    private RfNamedElement fNamedElement;

    public VlogCommentAutoEditStrategy(VlogEditor editor) {
        this.fEditor = editor;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!VlogPlugin.getDefault().getPreferenceStore().getBoolean("typing.comments_case")) {
            super.customizeDocumentCommand(document, command);
            return;
        }
        if (TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1 && this.hasJavaDocStartComment(document, command)) {
            this.customizeVlogDocCommand(document, command);
        } else {
            this.autoInsertInComments(document, command);
        }
    }

    private void customizeVlogDocCommand(IDocument document, DocumentCommand command) {
        if (document == null || command == null) {
            return;
        }
        String indent = this.computeIndent(document, command);
        try {
            String lineDelimiter;
            RfDefElement closestDefElement = this.getClosestDefElementAfterOffset(document, command.offset, document.getNumberOfLines());
            if (closestDefElement == null || closestDefElement.getReparseInfo() != null) {
                this.autoInsertInComments(document, command);
                return;
            }
            this.fNamedElement = closestDefElement.getNamedElement();
            RfClass enclosingClass = this.fNamedElement instanceof RfFunction ? ((RfFunction)this.fNamedElement).getEnclosingScope(RfClass.class) : null;
            VlogTemplateContextWithResolversFactory resolver = new VlogTemplateContextWithResolversFactory(enclosingClass, this.fNamedElement, (IEditorPart)this.fEditor, "", this.fNamedElement.getClass());
            DocumentTemplateContext context = resolver.getTemplateContextWithResolvers(String.valueOf(indent) + " ", document, command.offset);
            Template[] templates = TemplateEditorUI.getDefault().getTemplateStore().getTemplates("ro.amiq.vlogdt.templates.contextType.javadoc_comment");
            HashMap<String, Template> templatesMap = new HashMap<String, Template>();
            Template[] templateArray = templates;
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                Template template = templateArray[n2];
                if (template != null) {
                    String[] tnameArr = template.getName().split("_");
                    templatesMap.put(tnameArr[tnameArr.length - 1], template);
                }
                ++n2;
            }
            String category = "any";
            if (this.fNamedElement instanceof RfClass) {
                category = "class";
            } else if (this.fNamedElement instanceof RfFunction) {
                category = ((RfFunction)this.fNamedElement).isTask() ? "task" : "function";
            } else if (this.fNamedElement instanceof RfModule) {
                category = "module";
            } else if (this.fNamedElement instanceof RfInterface) {
                category = "interface";
            } else if (this.fNamedElement instanceof RfCovergroup) {
                category = "covergroup";
            } else if (this.fNamedElement instanceof VlogMacroInfo) {
                category = "macro";
            }
            if (templatesMap.get(category) == null || !this.validToCloseComment(document, command.offset)) {
                this.autoInsertInComments(document, command);
                return;
            }
            TemplateBuffer templateBuffer = context.evaluate((Template)templatesMap.get(category));
            String pattern = "[ \\t\\x0B]*\\*?[ \\t\\x0B]*javadoc_dvt_no_param[ \\t\\x0B]*(\\r\\n|\\r|\\n)";
            String resolvedText = templateBuffer.getString().replaceAll(pattern, "");
            if (resolvedText.contains("javadoc_dvt_no_param")) {
                resolvedText = resolvedText.replace("javadoc_dvt_no_param", "");
            }
            if ((resolvedText = resolvedText.replace(String.valueOf(lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)this.fEditor)) + "*", String.valueOf(lineDelimiter) + indent + " *")).startsWith("*")) {
                resolvedText = resolvedText.replaceFirst("\\*", String.valueOf(lineDelimiter) + indent + " *");
            }
            resolvedText = String.valueOf(lineDelimiter) + indent + " * " + resolvedText;
            int newLineTextLength = command.text.length();
            command.text = resolvedText;
            command.shiftsCaret = false;
            command.caretOffset = command.offset + newLineTextLength + indent.length() + " * ".length();
        }
        catch (Exception exception) {
            super.customizeDocumentCommand(document, command);
        }
    }

    private void autoInsertInComments(IDocument d, DocumentCommand command) {
        if (d == null || command == null) {
            return;
        }
        if (!DVTDocumentCommon.isTextNewLine((IDocument)d, (String)command.text)) {
            return;
        }
        try {
            String currentContentType = ((IDocumentExtension3)d).getContentType("__vlog_partitioning", command.offset, false);
            if ("__vlog_ml_comment".equals(currentContentType)) {
                int offset = command.offset;
                String indent = this.computeIndent(d, command);
                int line = d.getLineOfOffset(offset);
                int start = d.getLineOffset(line);
                int sOffset = DVTDocumentCommon.isNextCharacter((IDocument)d, (int)start, (char)'/');
                int stOffset = DVTDocumentCommon.isNextCharacter((IDocument)d, (int)start, (char)'*');
                if (sOffset == -1 && stOffset != -1) {
                    if (stOffset < offset) {
                        command.text = String.valueOf(command.text) + indent + "* ";
                    } else {
                        super.customizeDocumentCommand(d, command);
                    }
                    return;
                }
                int asOffset = DVTDocumentCommon.isNextCharacter((IDocument)d, (int)(sOffset + 1), (char)'*');
                if (sOffset != -1 && asOffset != -1) {
                    if (this.validToCloseComment(d, offset)) {
                        int newLineTextLength = command.text.length();
                        String lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)this.fEditor);
                        command.text = String.valueOf(command.text) + indent + " * " + lineDelimiter + indent + " */";
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + newLineTextLength + indent.length() + " * ".length();
                    } else {
                        command.text = String.valueOf(command.text) + indent + " * ";
                    }
                } else {
                    super.customizeDocumentCommand(d, command);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            super.customizeDocumentCommand(d, command);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RfDefElement getClosestDefElementAfterOffset(IDocument document, int offset, int nofLines) {
        try {
            IFile file = (IFile)this.fEditor.getAdapter(IResource.class);
            if (file == null) {
                return null;
            }
            RfProject rfProject = this.fEditor.getRfProject();
            if (rfProject == null) {
                return null;
            }
            int line = document.getLineOfOffset(offset) + 1;
            RfFileDef fileDef = rfProject.getFile((IResource)file);
            RfDefElement initialScope = fileDef.getScope(offset, false);
            int lineOffset = 0;
            while (true) {
                if (!(lineOffset < 250 & lineOffset + line < nofLines)) {
                    return null;
                }
                int offsetOfLine = document.getLineOffset(line + lineOffset - 1);
                RfDefElement scope = fileDef.getScope(offsetOfLine, false);
                if (scope != null && scope != initialScope && !(scope instanceof RfFileDef)) {
                    if (scope.getStartLine() >= initialScope.getStartLine()) return scope;
                    return null;
                }
                ++lineOffset;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private String computeIndent(IDocument document, DocumentCommand command) {
        if (document == null || command == null) {
            return "";
        }
        String result = "";
        try {
            int line = document.getLineOfOffset(command.offset);
            result = DVTDocumentCommon.getIndentOfLine((IDocument)document, (int)line, (int)command.offset);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return result;
    }

    public boolean validToCloseComment(IDocument d, int offset) throws BadLocationException, BadPartitioningException {
        if (d == null || offset < 0 || offset > d.getLength()) {
            throw new BadLocationException();
        }
        ITypedRegion region = ((IDocumentExtension3)d).getPartition("__vlog_partitioning", offset, false);
        if (!"__vlog_ml_comment".equals(region.getType())) {
            throw new BadPartitioningException();
        }
        int regionEnd = region.getOffset() + region.getLength();
        while (regionEnd < d.getLength()) {
            region = ((IDocumentExtension3)d).getPartition("__vlog_partitioning", regionEnd + 1, false);
            if (!"__vlog_ml_comment".equals(region.getType())) break;
            regionEnd = region.getOffset() + region.getLength();
        }
        String mlCommentRegion = d.get(offset, Math.max(regionEnd - offset, 0));
        int sindex = mlCommentRegion.indexOf("/*");
        int eindex = mlCommentRegion.indexOf("*/");
        if (sindex == -1) {
            return eindex == -1;
        }
        if (eindex == -1) {
            return true;
        }
        return eindex > sindex;
    }

    private boolean hasJavaDocStartComment(IDocument d, DocumentCommand command) {
        int sOffset;
        block4: {
            if (d == null || command == null) {
                return false;
            }
            try {
                sOffset = DVTDocumentCommon.isNextCharacter((IDocument)d, (int)d.getLineOffset(d.getLineOfOffset(command.offset)), (char)'/');
                if (sOffset != -1) break block4;
                return false;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return false;
            }
        }
        int asOffset = DVTDocumentCommon.isNextCharacter((IDocument)d, (int)(sOffset + 1), (char)'*');
        int aasOffset = DVTDocumentCommon.isNextCharacter((IDocument)d, (int)(sOffset + 2), (char)'*');
        return asOffset != -1 && aasOffset != -1;
    }
}

