/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.edit.strategy;

import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.edit.strategy.AutoEditProgressMonitor;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditAdvancedRefLineFinder;
import ro.amiq.vlogdt.ui.editor.edit.strategy.VlogAutoEditUtils;

public class VlogSLAutoEditAdvancedStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final int DUMMY_TOKEN_FOR_NEW_LINE_INDENTATION = "[DUMMY_TOKEN_FOR_NEW_LINE]".hashCode();
    private AutoEditProgressMonitor monitor = new AutoEditProgressMonitor();
    private static final int ADVANCED_LINES_LOOKBACK = 5000;
    private ISourceViewer sourceViewer;
    private ICharacterPairMatcher pairMatcher;

    public VlogSLAutoEditAdvancedStrategy(ISourceViewer sourceViewer, ICharacterPairMatcher pairMatcher) {
        this.sourceViewer = sourceViewer;
        this.pairMatcher = pairMatcher;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.isValidContext()) {
            return;
        }
        String autoindentStrategy = VlogPlugin.getDefault().getPreferenceStore().getString("autoindent");
        if (!"Advanced".equals(autoindentStrategy)) {
            super.customizeDocumentCommand(document, command);
            return;
        }
        VlogAutoEditAdvancedRefLineFinder.getInstance().setLinesLookback(5000);
        this.monitor.resetTimeout();
        if (command.length == 0 && command.text != null && TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1) {
            this.newLineIndent(document, command);
        }
    }

    private void newLineIndent(IDocument document, DocumentCommand command) {
        if (command.offset == -1 || document.getLength() == 0) {
            return;
        }
        int line = VlogAutoEditUtils.getInstance().getLineOfOffset(document, command.offset);
        if (line == -1) {
            super.customizeDocumentCommand(document, command);
            return;
        }
        int lineOffset = VlogAutoEditUtils.getInstance().getLineOffset(document, line);
        if (line == -1) {
            super.customizeDocumentCommand(document, command);
            return;
        }
        VlogAutoEditAdvancedRefLineFinder.getInstance().resetUnmatchedClosingTokens();
        int anchorLine = VlogAutoEditAdvancedRefLineFinder.getInstance().getAnchorForNewLine(document, line, lineOffset, this.sourceViewer, this.pairMatcher, this.monitor);
        if (anchorLine == -1) {
            super.customizeDocumentCommand(document, command);
            return;
        }
        IRegion anchorLineInfo = VlogAutoEditUtils.getInstance().getLineInformation(document, anchorLine);
        if (anchorLineInfo == null) {
            super.customizeDocumentCommand(document, command);
            return;
        }
        String additionalText = String.valueOf(command.text) + DUMMY_TOKEN_FOR_NEW_LINE_INDENTATION;
        String indent = VlogAutoEditUtils.getInstance().computeIndent(anchorLineInfo, command.offset, additionalText, this.sourceViewer);
        StringBuilder buff = new StringBuilder(command.text);
        buff.append(indent);
        command.text = buff.toString();
    }

    private boolean isValidContext() {
        return this.sourceViewer instanceof DVTProjectionViewer && this.pairMatcher != null;
    }
}

