/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFScope;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFTokenScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.CFIndentScanner;
import ro.amiq.dvt.ui.editor.formatter.scanner.indent.ICFIndentScannerImpl;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFScopeScanner;

public class VlogCFIndentScanner
extends VlogCFScopeScanner
implements ICFIndentScannerImpl {
    private CFIndentScanner fCFIndentScanner;
    private CFToken fPrevToken;

    public VlogCFIndentScanner(CFModel model) {
        super(model);
    }

    @Override
    public void setCFTokenScanner(CFTokenScanner cfTokenScanner) {
        super.setCFTokenScanner(cfTokenScanner);
        this.fCFIndentScanner = (CFIndentScanner)cfTokenScanner;
    }

    @Override
    public void analyzeToken(CFToken token) {
        super.analyzeToken(token);
        if (this.isBeginIndentation()) {
            return;
        }
        if (!this.isInPreproc()) {
            if (this.fFormatPreferences.isIndentSkipAssignsEnabled()) {
                this.skipAssigns(token);
            }
            if (this.fFormatPreferences.isIndentSkipMLMacroDefsEnabled() && !this.fFormatPreferences.isPreprocPrefLeaveAsIs()) {
                this.skipMLMacroDefinitions(token);
            }
            if (!this.preprocsStack.isEmpty()) {
                this.skipDisabledPreprocBlocks(token);
            }
            if (this.fStrategy.getPreprocType(token.getValue()) != 0) {
                this.updatePreprocTokenInfo(token, this.fCFIndentScanner);
            }
            this.fCFIndentScanner.indent(token);
        }
    }

    private void skipDisabledPreprocBlocks(CFToken token) {
        if (token == null) {
            return;
        }
        if (this.isEnclosingPreprocFormattingOn()) {
            return;
        }
        CFChunk tokenEnclosingChunk = token.getEnclosingChunk();
        if (tokenEnclosingChunk == null) {
            return;
        }
        CFLineInfo tokenEnclosingLineInfo = tokenEnclosingChunk.getEnclosingLineInfo();
        if (tokenEnclosingLineInfo == null) {
            return;
        }
        tokenEnclosingLineInfo.setFormatterOn(false);
    }

    private void skipAssigns(CFToken token) {
        if (token == null) {
            return;
        }
        if (token.getTokenType() == 3) {
            return;
        }
        CFScope assignScope = this.fCFIndentScanner.getScope("assign");
        if (assignScope == null) {
            return;
        }
        CFToken assignToken = assignScope.getToken();
        if (assignToken.getLineNo() < token.getLineNo()) {
            CFChunk chunk = token.getEnclosingChunk();
            if (chunk == null) {
                return;
            }
            CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
            if (lineInfo == null) {
                return;
            }
            lineInfo.setFormatterOn(false);
        }
    }

    private void skipMLMacroDefinitions(CFToken token) {
        if (token == null) {
            return;
        }
        if (token.getTokenType() == 3) {
            return;
        }
        String tokenValue = token.getValue();
        if (!"`define".equals(tokenValue)) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFLineInfo lineInfo = chunk.getEnclosingLineInfo();
        if (lineInfo == null) {
            return;
        }
        String chunksContent = lineInfo.getChunksContent();
        if (chunksContent == null) {
            return;
        }
        if (chunksContent.endsWith("\\\n")) {
            lineInfo.setFormatterOn(false);
        }
    }

    @Override
    public void endToken(CFToken token) {
        super.endToken(token);
        this.fPrevToken = token;
    }

    @Override
    protected void updateOnPreprocWord(CFToken token) {
        if (token == null) {
            return;
        }
        CFLineInfo lineInfo = this.fModel.getLineInfo(token.getLineNo());
        if (lineInfo == null) {
            return;
        }
        if (token.isFirstNWSTokenOnLine()) {
            if (this.fFormatPreferences.isPreprocPrefResetIndent() && !this.fFormatPreferences.isIndentSkipMLMacroDefsEnabled()) {
                this.fCFIndentScanner.setStrictIndent(0);
            } else if (this.fFormatPreferences.isPreprocPrefLeaveAsIs()) {
                this.fCFIndentScanner.setStrictIndent(lineInfo.getLineStartWSLength());
            }
        }
        super.updateOnPreprocWord(token);
        super.updatePrepocStack(token, this.fCFIndentScanner.getPeekScope(), this.fCFIndentScanner.getCurrLineIndent());
    }

    public CFToken getTokenForLineBreakBeforeParenOpen(CFToken token) {
        if (token == null) {
            return null;
        }
        if (!"(".equals(token.getValue())) {
            return token;
        }
        if (this.fPrevToken != null && "#".equals(this.fPrevToken.getValue())) {
            return this.fPrevToken;
        }
        return token;
    }

    public boolean allowLineBreak(CFToken token) {
        if (token == null) {
            return true;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return true;
        }
        if (chunk.getType() != 1) {
            return true;
        }
        String tokenValue = token.getValue();
        if (tokenValue == null || tokenValue.length() == 0) {
            return true;
        }
        char tokenChar = tokenValue.charAt(0);
        if (tokenChar != '*' && tokenChar != ')') {
            return true;
        }
        int tokenStartOffsetInChunk = token.getStartOffsetInChunk();
        String chunkValue = chunk.getValue();
        if (chunkValue == null) {
            return true;
        }
        int prevChar = 0;
        if (tokenStartOffsetInChunk - 1 >= 0) {
            prevChar = chunkValue.charAt(tokenStartOffsetInChunk - 1);
        }
        if (40 == prevChar && '*' == tokenChar) {
            return false;
        }
        if (46 == prevChar && '*' == tokenChar) {
            return false;
        }
        return 42 != prevChar || ')' != tokenChar;
    }

    public boolean forceLineBreak(CFToken token) {
        return false;
    }

    public boolean tryElsePrefs(CFToken token) {
        return this.fCFIndentScanner.tryElsePrefsDefaultImpl(token);
    }

    public boolean allowElseOnSameLine(CFToken token) {
        String prevKeyword = this.getPrevKeyword();
        return "end".equals(prevKeyword);
    }

    public boolean allowParamPrefs() {
        String prevKeyword = this.getPrevKeyword();
        if ("module".equals(prevKeyword) || "macromodule".equals(prevKeyword) || "connectmodule".equals(prevKeyword)) {
            return true;
        }
        if ("interface".equals(prevKeyword)) {
            return true;
        }
        if ("function".equals(prevKeyword) || "task".equals(prevKeyword)) {
            return true;
        }
        return "class".equals(prevKeyword);
    }

    public boolean tryAddWhitespaceBefore(CFToken token) {
        return this.fCFIndentScanner.tryAddWhitespaceBefore(token);
    }

    public boolean tryAddWhitespaceAfter(CFToken token) {
        return this.fCFIndentScanner.tryAddWhitespaceAfter(token);
    }

    public void updateOnLineBreakBeforeOperator(CFToken token) {
        if (token == null) {
            return;
        }
        if (!this.isAssignmentOperator(token)) {
            return;
        }
        CFScope peekScope = this.fCFIndentScanner.getPeekScope();
        if (peekScope == null) {
            return;
        }
        CFToken peekToken = peekScope.getToken();
        if (peekToken == null) {
            return;
        }
        if (peekToken != token) {
            return;
        }
        this.fCFIndentScanner.popScopeAndUpdate(token.isFirstNWSTokenOnLine());
        token.setIsFirstNWSTokenOnLine(true);
        super.startToken(token);
        super.analyzeToken(token);
        super.endToken(token);
    }
}

