/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.formatter;

import ro.amiq.dvt.ui.editor.formatter.model.CFAction;
import ro.amiq.dvt.ui.editor.formatter.model.CFChunk;
import ro.amiq.dvt.ui.editor.formatter.model.CFLineInfo;
import ro.amiq.dvt.ui.editor.formatter.model.CFModel;
import ro.amiq.dvt.ui.editor.formatter.scanner.CFToken;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCFIndentScanner;

public class VlogCFNLAfterTokenScanner
extends VlogCFIndentScanner {
    public VlogCFNLAfterTokenScanner(CFModel model) {
        super(model);
    }

    @Override
    public void analyzeToken(CFToken token) {
        if (!this.isInPreproc()) {
            String tokenValue = token.getValue();
            if (tokenValue == null) {
                return;
            }
            if (this.fFormatPreferences.isAddNewLineAfterBeginAndBeforeEnd()) {
                if (this.fStrategy.getKeywordType(tokenValue) == 4) {
                    this.addNewLineAfterBegin(token);
                }
                if ("end".equals(tokenValue) && !token.isFirstNWSTokenOnLine()) {
                    this.addNewLineBeforeEnd(token);
                }
            }
            if (this.fFormatPreferences.isAddNewLineAfterEnd() && "end".equals(tokenValue)) {
                this.addNewLineAfterEnd(token);
            }
        }
    }

    private void addNewLineAfterBegin(CFToken token) {
        if (token == null) {
            return;
        }
        CFChunk enclosingChunk = token.getEnclosingChunk();
        if (enclosingChunk == null) {
            return;
        }
        CFLineInfo enclosingLineInfo = enclosingChunk.getEnclosingLineInfo();
        if (enclosingLineInfo == null) {
            return;
        }
        CFChunk nextChunk = enclosingLineInfo.getChunkAfter(enclosingChunk);
        CFToken firstNWSTokenInChunkAfterCurrToken = this.getFirstNWSTokenInChunkAfterCurrToken();
        if (firstNWSTokenInChunkAfterCurrToken == null && nextChunk == null) {
            return;
        }
        if (firstNWSTokenInChunkAfterCurrToken != null) {
            CFToken secondNWSTokenInChunkAfterCurrToken = this.getSecondNWSTokenInChunkAfterCurrToken();
            if (":".equals(firstNWSTokenInChunkAfterCurrToken.getValue()) && secondNWSTokenInChunkAfterCurrToken != null) {
                if (this.getThirdNWSTokenInChunkAfterCurrToken() != null) {
                    this.createActionsForLineBreakAfterToken(secondNWSTokenInChunkAfterCurrToken, "add new line after begin and before end");
                }
                return;
            }
            if ("end".equals(firstNWSTokenInChunkAfterCurrToken.getValue())) {
                return;
            }
            this.createActionsForLineBreakAfterToken(token, "add new line after begin and before end");
            return;
        }
        if (nextChunk != null) {
            CFChunk nextCodeChunkInLine = this.getNextCodeChunkInLine(enclosingLineInfo, nextChunk);
            if (nextCodeChunkInLine != null) {
                this.createActionsForLineBreakAtBeginningOfChunk(nextCodeChunkInLine, "add new line after begin and before end");
            }
            return;
        }
    }

    private CFChunk getNextCodeChunkInLine(CFLineInfo lineInfo, CFChunk refChunk) {
        CFChunk chunkAfter = lineInfo.getChunkAfter(refChunk);
        while (chunkAfter != null) {
            String noWSChunkValue;
            if (chunkAfter.getType() == 1 && (noWSChunkValue = chunkAfter.getValue().replaceAll("[\\n\\t ]", "")).length() > 0) {
                return chunkAfter;
            }
            chunkAfter = lineInfo.getChunkAfter(chunkAfter);
        }
        return null;
    }

    private void createActionsForLineBreakAtBeginningOfChunk(CFChunk chunk, String causedBy) {
        if (chunk.isFirstOnLine()) {
            return;
        }
        int offset = VlogCFNLAfterTokenScanner.getIndexOfFirstNWSChar(chunk.getValue());
        if (offset == -1) {
            return;
        }
        chunk.addAction(new CFAction(1, offset, 0, this.fStrategy.getSourceViewerConfiguration().getLineDelimiter(), causedBy));
    }

    public static int getIndexOfFirstNWSChar(String string) {
        char[] characters = string.toCharArray();
        int i = 0;
        while (i < string.length()) {
            if (!Character.isWhitespace(characters[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createActionsForLineBreakAfterToken(CFToken token, String causedBy) {
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        CFToken firstNWSTokenInChunkAfterCurrToken = this.getFirstNWSTokenInChunkAfterCurrToken();
        int offset = firstNWSTokenInChunkAfterCurrToken != null && !":".equals(firstNWSTokenInChunkAfterCurrToken.getValue()) ? firstNWSTokenInChunkAfterCurrToken.getStartOffsetInChunk() : token.getEndOffsetInChunk() + 1;
        chunk.addAction(new CFAction(1, offset, 0, this.fStrategy.getSourceViewerConfiguration().getLineDelimiter(), causedBy));
    }

    private void addNewLineBeforeEnd(CFToken token) {
        if (token == null) {
            return;
        }
        CFChunk chunk = token.getEnclosingChunk();
        if (chunk == null) {
            return;
        }
        chunk.addAction(new CFAction(1, token.getStartOffsetInChunk(), 0, this.fStrategy.getSourceViewerConfiguration().getLineDelimiter(), "add new line after begin and before end"));
    }

    private void addNewLineAfterEnd(CFToken token) {
        CFChunk enclosingChunk = token.getEnclosingChunk();
        CFLineInfo enclosingLineInfo = enclosingChunk.getEnclosingLineInfo();
        CFChunk nextChunk = enclosingLineInfo.getChunkAfter(enclosingChunk);
        CFToken firstNWSTokenInChunkAfterCurrToken = this.getFirstNWSTokenInChunkAfterCurrToken();
        if (nextChunk == null && firstNWSTokenInChunkAfterCurrToken == null) {
            return;
        }
        if (firstNWSTokenInChunkAfterCurrToken != null && "end".equals(firstNWSTokenInChunkAfterCurrToken.getValue()) && this.fFormatPreferences.isAddNewLineAfterBeginAndBeforeEnd()) {
            return;
        }
        CFToken secondNWSTokenInChunkAfterCurrToken = this.getSecondNWSTokenInChunkAfterCurrToken();
        if (firstNWSTokenInChunkAfterCurrToken != null && ":".equals(firstNWSTokenInChunkAfterCurrToken.getValue()) && secondNWSTokenInChunkAfterCurrToken != null) {
            if (this.getThirdNWSTokenInChunkAfterCurrToken() != null) {
                this.createActionsForLineBreakAfterToken(secondNWSTokenInChunkAfterCurrToken, "add new line after end");
            }
            return;
        }
        if (firstNWSTokenInChunkAfterCurrToken == null && nextChunk != null && (nextChunk.getType() == 3 || nextChunk.getType() == 4)) {
            CFChunk nextCodeChunkInLine = this.getNextCodeChunkInLine(enclosingLineInfo, nextChunk);
            if (nextCodeChunkInLine != null) {
                this.createActionsForLineBreakAtBeginningOfChunk(nextCodeChunkInLine, "add new line after end");
            }
            return;
        }
        this.createActionsForLineBreakAfterToken(token, "add new line after end");
    }
}

